/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.usermodel;

import java.util.Iterator;
import org.apache.poi.hssf.record.formula.eval.BoolEval;
import org.apache.poi.hssf.record.formula.eval.ErrorEval;
import org.apache.poi.hssf.record.formula.eval.NumberEval;
import org.apache.poi.hssf.record.formula.eval.StringEval;
import org.apache.poi.hssf.record.formula.eval.ValueEval;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFEvaluationCell;
import org.apache.poi.hssf.usermodel.HSSFEvaluationWorkbook;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.formula.CollaboratingWorkbooksEnvironment;
import org.apache.poi.ss.formula.WorkbookEvaluator;

public class HSSFFormulaEvaluator {
    private WorkbookEvaluator _bookEvaluator;

    public HSSFFormulaEvaluator(HSSFSheet sheet, HSSFWorkbook workbook) {
        this(workbook);
    }

    public HSSFFormulaEvaluator(HSSFWorkbook workbook) {
        this._bookEvaluator = new WorkbookEvaluator(HSSFEvaluationWorkbook.create(workbook));
    }

    public static void setupEnvironment(String[] workbookNames, HSSFFormulaEvaluator[] evaluators) {
        WorkbookEvaluator[] wbEvals = new WorkbookEvaluator[evaluators.length];
        int i = 0;
        while (i < wbEvals.length) {
            wbEvals[i] = evaluators[i]._bookEvaluator;
            ++i;
        }
        CollaboratingWorkbooksEnvironment.setup(workbookNames, wbEvals);
    }

    public void setCurrentRow(HSSFRow row) {
    }

    public void clearAllCachedResultValues() {
        this._bookEvaluator.clearAllCachedResultValues();
    }

    public void notifyUpdateCell(HSSFCell cell) {
        this._bookEvaluator.notifyUpdateCell(new HSSFEvaluationCell(cell));
    }

    public void notifyDeleteCell(HSSFCell cell) {
        this._bookEvaluator.notifyDeleteCell(new HSSFEvaluationCell(cell));
    }

    public CellValue evaluate(HSSFCell cell) {
        if (cell == null) {
            return null;
        }
        switch (cell.getCellType()) {
            case 4: {
                return CellValue.valueOf(cell.getBooleanCellValue());
            }
            case 5: {
                return CellValue.getError(cell.getErrorCellValue());
            }
            case 2: {
                return this.evaluateFormulaCellValue(cell);
            }
            case 0: {
                return new CellValue(cell.getNumericCellValue());
            }
            case 1: {
                return new CellValue(cell.getRichStringCellValue().getString());
            }
            case 3: {
                return null;
            }
        }
        throw new IllegalStateException("Bad cell type (" + cell.getCellType() + ")");
    }

    public int evaluateFormulaCell(HSSFCell cell) {
        if (cell == null || cell.getCellType() != 2) {
            return -1;
        }
        CellValue cv = this.evaluateFormulaCellValue(cell);
        HSSFFormulaEvaluator.setCellValue(cell, cv);
        return cv.getCellType();
    }

    public HSSFCell evaluateInCell(HSSFCell cell) {
        if (cell == null) {
            return null;
        }
        if (cell.getCellType() == 2) {
            CellValue cv = this.evaluateFormulaCellValue(cell);
            HSSFFormulaEvaluator.setCellType(cell, cv);
            HSSFFormulaEvaluator.setCellValue(cell, cv);
        }
        return cell;
    }

    private static void setCellType(HSSFCell cell, CellValue cv) {
        int cellType = cv.getCellType();
        switch (cellType) {
            case 0: 
            case 1: 
            case 4: 
            case 5: {
                cell.setCellType(cellType);
                return;
            }
        }
        throw new IllegalStateException("Unexpected cell value type (" + cellType + ")");
    }

    private static void setCellValue(HSSFCell cell, CellValue cv) {
        int cellType = cv.getCellType();
        switch (cellType) {
            case 4: {
                cell.setCellValue(cv.getBooleanValue());
                break;
            }
            case 5: {
                cell.setCellErrorValue(cv.getErrorValue());
                break;
            }
            case 0: {
                cell.setCellValue(cv.getNumberValue());
                break;
            }
            case 1: {
                cell.setCellValue(cv.getRichTextStringValue());
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected cell value type (" + cellType + ")");
            }
        }
    }

    public static void evaluateAllFormulaCells(HSSFWorkbook wb) {
        HSSFFormulaEvaluator evaluator = new HSSFFormulaEvaluator(wb);
        int i = 0;
        while (i < wb.getNumberOfSheets()) {
            HSSFSheet sheet = wb.getSheetAt(i);
            Iterator rit = sheet.rowIterator();
            while (rit.hasNext()) {
                HSSFRow r = (HSSFRow)rit.next();
                Iterator cit = r.cellIterator();
                while (cit.hasNext()) {
                    HSSFCell c = (HSSFCell)cit.next();
                    if (c.getCellType() != 2) continue;
                    evaluator.evaluateFormulaCell(c);
                }
            }
            ++i;
        }
    }

    private CellValue evaluateFormulaCellValue(HSSFCell cell) {
        ValueEval eval = this._bookEvaluator.evaluate(new HSSFEvaluationCell(cell));
        if (eval instanceof NumberEval) {
            NumberEval ne = (NumberEval)eval;
            return new CellValue(ne.getNumberValue());
        }
        if (eval instanceof BoolEval) {
            BoolEval be = (BoolEval)eval;
            return CellValue.valueOf(be.getBooleanValue());
        }
        if (eval instanceof StringEval) {
            StringEval ne = (StringEval)eval;
            return new CellValue(ne.getStringValue());
        }
        if (eval instanceof ErrorEval) {
            return CellValue.getError(((ErrorEval)eval).getErrorCode());
        }
        throw new RuntimeException("Unexpected eval class (" + eval.getClass().getName() + ")");
    }

    public static final class CellValue {
        public static final CellValue TRUE = new CellValue(4, 0.0, true, null, 0);
        public static final CellValue FALSE = new CellValue(4, 0.0, false, null, 0);
        private final int _cellType;
        private final double _numberValue;
        private final boolean _booleanValue;
        private final String _textValue;
        private final int _errorCode;

        private CellValue(int cellType, double numberValue, boolean booleanValue, String textValue, int errorCode) {
            this._cellType = cellType;
            this._numberValue = numberValue;
            this._booleanValue = booleanValue;
            this._textValue = textValue;
            this._errorCode = errorCode;
        }

        CellValue(double numberValue) {
            this(0, numberValue, false, null, 0);
        }

        static CellValue valueOf(boolean booleanValue) {
            return booleanValue ? TRUE : FALSE;
        }

        CellValue(String stringValue) {
            this(1, 0.0, false, stringValue, 0);
        }

        static CellValue getError(int errorCode) {
            return new CellValue(5, 0.0, false, null, errorCode);
        }

        public boolean getBooleanValue() {
            return this._booleanValue;
        }

        public double getNumberValue() {
            return this._numberValue;
        }

        public String getStringValue() {
            return this._textValue;
        }

        public int getCellType() {
            return this._cellType;
        }

        public byte getErrorValue() {
            return (byte)this._errorCode;
        }

        public HSSFRichTextString getRichTextStringValue() {
            return new HSSFRichTextString(this._textValue);
        }

        public String toString() {
            StringBuffer sb = new StringBuffer(64);
            sb.append(this.getClass().getName()).append(" [");
            sb.append(this.formatAsString());
            sb.append("]");
            return sb.toString();
        }

        public String formatAsString() {
            switch (this._cellType) {
                case 0: {
                    return String.valueOf(this._numberValue);
                }
                case 1: {
                    return String.valueOf('\"') + this._textValue + '\"';
                }
                case 4: {
                    return this._booleanValue ? "TRUE" : "FALSE";
                }
                case 5: {
                    return ErrorEval.getText(this._errorCode);
                }
            }
            return "<error unexpected cell type " + this._cellType + ">";
        }
    }
}

