/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl.document;

import java.util.Collection;
import java.util.List;
import org.eclipse.birt.core.data.DataType;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.DataEngineContext;
import org.eclipse.birt.data.engine.api.IBaseQueryDefinition;
import org.eclipse.birt.data.engine.api.IBaseQueryResults;
import org.eclipse.birt.data.engine.api.IBaseResultIterator;
import org.eclipse.birt.data.engine.api.IGroupInstanceInfo;
import org.eclipse.birt.data.engine.api.IPreparedQuery;
import org.eclipse.birt.data.engine.api.IQueryDefinition;
import org.eclipse.birt.data.engine.api.IQueryResults;
import org.eclipse.birt.data.engine.api.IResultIterator;
import org.eclipse.birt.data.engine.api.IResultMetaData;
import org.eclipse.birt.data.engine.api.ISubqueryDefinition;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.i18n.DataResourceHandle;
import org.eclipse.birt.data.engine.impl.DataSetRuntime;
import org.eclipse.birt.data.engine.impl.ExecutorHelper;
import org.eclipse.birt.data.engine.impl.IExecutorHelper;
import org.eclipse.birt.data.engine.impl.IQueryService;
import org.eclipse.birt.data.engine.impl.document.PLSEnabledResultIterator;
import org.eclipse.birt.data.engine.impl.document.QueryResultIDUtil;
import org.eclipse.birt.data.engine.impl.document.QueryResultInfo;
import org.eclipse.birt.data.engine.impl.document.RDLoad;
import org.eclipse.birt.data.engine.impl.document.RDUtil;
import org.eclipse.birt.data.engine.impl.document.ResultIterator;
import org.eclipse.birt.data.engine.impl.document.ResultIterator2;
import org.eclipse.birt.data.engine.impl.document.viewing.ExprMetaInfo;
import org.eclipse.birt.data.engine.impl.document.viewing.ExprMetaUtil;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryResults
implements IQueryResults,
IQueryService {
    private DataEngineContext context;
    private String queryResultID;
    private String baseQueryResultID;
    private IResultIterator resultIterator;
    private IResultMetaData resultMetaData;
    private IResultMetaData bindingMetaData;
    private String subQueryName;
    private int currParentIndex;
    private IPreparedQuery dummyPreparedQuery;
    private String tempDir;
    private IBaseQueryResults outer;
    private ExecutorHelper executorHelper;
    private String name;
    private List<IGroupInstanceInfo> targetGroups;

    public QueryResults(String tempDir, DataEngineContext context, String queryResultID, IBaseQueryResults outer, List<IGroupInstanceInfo> targetGroups) {
        this(tempDir, context, null, queryResultID, null, null, -1, outer, targetGroups);
    }

    public QueryResults(String tempDir, DataEngineContext context, String queryResultID) {
        this(tempDir, context, null, queryResultID, null, null, -1, null, null);
    }

    QueryResults(String tempDir, DataEngineContext context, String baseResultID, String queryResultID, IResultMetaData resultMetaData, String subQueryName, int currParentIndex, IBaseQueryResults parentQueryResults, List<IGroupInstanceInfo> targetGroups) {
        assert (tempDir != null);
        assert (context != null);
        assert (queryResultID != null);
        if (subQueryName != null) assert (resultMetaData != null);
        this.tempDir = tempDir;
        this.context = context;
        this.queryResultID = queryResultID;
        this.baseQueryResultID = baseResultID;
        this.outer = parentQueryResults;
        this.resultMetaData = resultMetaData;
        this.subQueryName = subQueryName;
        this.currParentIndex = currParentIndex;
        this.targetGroups = targetGroups;
    }

    private IPreparedQuery populateDummyPreparedQuery() {
        DummyPreparedQuery result = null;
        try {
            QueryResultInfo queryResultInfo;
            RDLoad rdLoad;
            IBaseQueryDefinition qd;
            String rootQueryResultID = QueryResultIDUtil.get1PartID(this.queryResultID);
            String parentQueryResultID = null;
            if (rootQueryResultID != null) {
                parentQueryResultID = QueryResultIDUtil.get2PartID(this.queryResultID);
            } else {
                rootQueryResultID = this.queryResultID;
            }
            if (this.subQueryName != null) {
                rootQueryResultID = this.baseQueryResultID;
            }
            if ((qd = (rdLoad = RDUtil.newLoad(this.tempDir, this.context, queryResultInfo = new QueryResultInfo(rootQueryResultID, parentQueryResultID, null, null, -1))).loadQueryDefn(0, 0)) instanceof IQueryDefinition) {
                result = new DummyPreparedQuery((IQueryDefinition)qd, this);
            }
        }
        catch (DataException dataException) {}
        return result;
    }

    @Override
    public IPreparedQuery getPreparedQuery() {
        if (this.dummyPreparedQuery == null) {
            this.dummyPreparedQuery = this.populateDummyPreparedQuery();
        }
        return this.dummyPreparedQuery;
    }

    @Override
    public IResultMetaData getResultMetaData() throws BirtException {
        if (this.resultMetaData == null) {
            this.resultMetaData = this.getRDLoad(this.subQueryName, this.queryResultID).loadResultMetaData();
        }
        return this.resultMetaData;
    }

    public IResultMetaData getBindingMetaData() throws DataException {
        if (this.bindingMetaData == null) {
            ExprMetaInfo[] metaInfo = this.getRDLoad(this.subQueryName, this.queryResultID).loadExprMetaInfo();
            if (ExprMetaUtil.isBasedOnRD(metaInfo)) {
                ExprMetaInfo[] infos = new ExprMetaInfo[metaInfo.length - 1];
                int i = 0;
                int k = 0;
                while (i < infos.length) {
                    if (QueryResults.isInternalMetaInfo(metaInfo[k])) {
                        --i;
                    } else {
                        infos[i] = metaInfo[k];
                    }
                    ++i;
                    ++k;
                }
                this.bindingMetaData = new BindingMetaData(infos);
            } else {
                this.bindingMetaData = new BindingMetaData(metaInfo);
            }
        }
        return this.bindingMetaData;
    }

    private static boolean isInternalMetaInfo(ExprMetaInfo exprMeta) {
        return "_$$_dte_inner_row_id_$$_".equals(exprMeta.getName());
    }

    @Override
    public IResultIterator getResultIterator() throws BirtException {
        if (this.resultIterator == null) {
            if (this.subQueryName == null) {
                IBaseQueryDefinition queryDefn = this.getRDLoad(null, this.queryResultID).loadQueryDefn(0, 2);
                this.resultIterator = ((IQueryDefinition)queryDefn).isSummaryQuery() ? new ResultIterator2(this.tempDir, this.context, (IQueryResults)this, this.queryResultID, queryDefn.getGroups().size(), true, queryDefn) : (queryDefn.usesDetails() || queryDefn.cacheQueryResults() ? (this.targetGroups != null && this.targetGroups.size() > 0 ? new PLSEnabledResultIterator(this.targetGroups, new ResultIterator(this.tempDir, this.context, this, this.queryResultID, queryDefn)) : new ResultIterator(this.tempDir, this.context, this, this.queryResultID, queryDefn)) : (this.targetGroups != null && this.targetGroups.size() > 0 ? new PLSEnabledResultIterator(this.targetGroups, new ResultIterator2(this.tempDir, this.context, (IQueryResults)this, this.queryResultID, queryDefn.getGroups().size(), false, queryDefn)) : new ResultIterator2(this.tempDir, this.context, (IQueryResults)this, this.queryResultID, queryDefn.getGroups().size(), false, queryDefn)));
            } else {
                ISubqueryDefinition subQuery = this.getRDLoad(null, this.baseQueryResultID).loadSubQueryDefn(0, 2, this.subQueryName);
                if (subQuery == null) {
                    throw new DataException("data.engine.NoSubQueryName", this.subQueryName);
                }
                this.resultIterator = subQuery.usesDetails() ? new ResultIterator(this.tempDir, this.context, this, this.queryResultID, this.subQueryName, this.currParentIndex, subQuery) : new ResultIterator2(this.tempDir, this.context, this, this.queryResultID, this.subQueryName, this.currParentIndex, subQuery.getGroups().size(), subQuery);
            }
        }
        return this.resultIterator;
    }

    private RDLoad getRDLoad(String subQueryName, String queryResultID) throws DataException {
        String baseID = QueryResultIDUtil.get1PartID(queryResultID);
        if (baseID == null) {
            baseID = queryResultID;
        }
        RDLoad rdLoad = RDUtil.newLoad(this.tempDir, this.context, new QueryResultInfo(baseID, subQueryName, this.currParentIndex));
        return rdLoad;
    }

    @Override
    public void close() throws BirtException {
        if (this.resultIterator != null) {
            this.resultIterator.close();
        }
    }

    @Override
    public String getID() {
        return this.queryResultID;
    }

    @Override
    public void cancel() {
    }

    @Override
    public DataSetRuntime[] getDataSetRuntime(int nestedCount) {
        return new DataSetRuntime[0];
    }

    @Override
    public IExecutorHelper getExecutorHelper() throws DataException {
        if (this.executorHelper != null) {
            return this.executorHelper;
        }
        IExecutorHelper parent = null;
        if (this.outer != null && this.outer instanceof IQueryService) {
            parent = ((IQueryService)((Object)this.outer)).getExecutorHelper();
        }
        this.executorHelper = new ExecutorHelper(parent);
        this.executorHelper.setScriptable((Scriptable)new DummyJSResultSetRow(parent, this.resultIterator));
        return this.executorHelper;
    }

    @Override
    public int getNestedLevel() {
        return 0;
    }

    @Override
    public Scriptable getQueryScope() {
        return null;
    }

    @Override
    public boolean isClosed() {
        return false;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    private static class BindingMetaData
    implements IResultMetaData {
        private ExprMetaInfo[] metaInfo;

        BindingMetaData(ExprMetaInfo[] metaInfo) {
            assert (metaInfo != null);
            this.metaInfo = metaInfo;
        }

        public String getColumnAlias(int index) throws BirtException {
            return null;
        }

        public int getColumnCount() {
            return this.metaInfo.length;
        }

        public String getColumnLabel(int index) throws BirtException {
            return null;
        }

        public String getColumnName(int index) throws BirtException {
            return this.metaInfo[index - 1].getName();
        }

        public String getColumnNativeTypeName(int index) throws BirtException {
            return null;
        }

        public int getColumnType(int index) throws BirtException {
            return this.metaInfo[index - 1].getDataType();
        }

        public String getColumnTypeName(int index) throws BirtException {
            return DataType.getName((int)this.getColumnType(index));
        }

        public boolean isComputedColumn(int index) throws BirtException {
            return false;
        }
    }

    private static class DummyJSResultSetRow
    extends ScriptableObject {
        private IExecutorHelper parentHelper;
        private IBaseResultIterator currentIterator;

        DummyJSResultSetRow(IExecutorHelper parentHelper, IBaseResultIterator currentIterator) {
            this.parentHelper = parentHelper;
            this.currentIterator = currentIterator;
        }

        public Object get(String name, Scriptable scope) {
            if ("_outer".equalsIgnoreCase(name)) {
                if (this.parentHelper == null) {
                    throw Context.reportRuntimeError((String)DataResourceHandle.getInstance().getMessage("data.engine.NoOuterResultsExist"));
                }
                return this.parentHelper.getScriptable();
            }
            try {
                return this.currentIterator.getValue(name);
            }
            catch (BirtException e) {
                return e;
            }
        }

        public String getClassName() {
            return "DummyJSResultSetRow";
        }
    }

    private static class DummyPreparedQuery
    implements IPreparedQuery {
        private IQueryDefinition queryDefn;
        private IQueryResults results;

        public DummyPreparedQuery(IQueryDefinition queryDefn, IQueryResults queryResults) {
            this.queryDefn = queryDefn;
            this.results = queryResults;
        }

        public IQueryResults execute(Scriptable queryScope) throws BirtException {
            return this.results;
        }

        public IQueryResults execute(IQueryResults outerResults, Scriptable queryScope) throws BirtException {
            throw new UnsupportedOperationException();
        }

        public Collection getParameterMetaData() throws BirtException {
            return null;
        }

        public IQueryDefinition getReportQueryDefn() {
            return this.queryDefn;
        }

        public IQueryResults execute(IBaseQueryResults outerResults, Scriptable scope) throws DataException {
            throw new UnsupportedOperationException();
        }
    }
}

