/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.data.impl.aggregation.function;

import com.ibm.icu.util.Calendar;
import com.ibm.icu.util.GregorianCalendar;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.data.engine.api.timefunction.IPeriodsFunction;
import org.eclipse.birt.data.engine.api.timefunction.TimeMember;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.function.AbstractMDX;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.function.TimeMemberUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TrailingFunction
extends AbstractMDX
implements IPeriodsFunction {
    private String levelType = "";
    private int offset = 0;

    public TrailingFunction(String levelType, int offset) {
        this.levelType = levelType;
        this.offset = offset;
    }

    @Override
    public List<TimeMember> getResult(TimeMember member) {
        ArrayList<TimeMember> timeMembers = new ArrayList<TimeMember>();
        String[] levelTypes = member.getLevelType();
        int[] values = member.getMemberValue();
        GregorianCalendar cal1 = new GregorianCalendar(TimeMemberUtil.getTimeZone(), TimeMemberUtil.getDefaultLocale());
        cal1.clear();
        String calculateUnit = this.translateToCal((Calendar)cal1, levelTypes, values);
        Calendar cal2 = (Calendar)cal1.clone();
        int year = 1;
        int year_woy = 1;
        if (this.levelType.equals("year")) {
            cal1.add(1, this.offset);
        } else if (this.levelType.equals("month")) {
            cal1.add(2, this.offset);
        } else if (this.levelType.equals("quarter")) {
            cal1.add(2, this.offset * 3);
        } else if (this.levelType.equals("week-of-month")) {
            if (!calculateUnit.equals("day")) {
                year_woy = cal1.get(17);
                if (year_woy < (year = cal1.get(1))) {
                    cal1.set(7, 7);
                } else if (year_woy > year) {
                    cal1.set(7, 1);
                }
            }
            cal1.add(3, this.offset);
        } else if (this.levelType.equals("week-of-year")) {
            if (!calculateUnit.equals("day")) {
                year_woy = cal1.get(17);
                if (year_woy < (year = cal1.get(1))) {
                    cal1.set(7, 7);
                } else if (year_woy > year) {
                    cal1.set(7, 1);
                }
            }
            cal1.add(3, this.offset);
        } else if (this.levelType.equals("day-of-month")) {
            cal1.add(5, this.offset);
        } else if (this.levelType.equals("day-of-week")) {
            cal1.add(5, this.offset);
        } else if (this.levelType.equals("day-of-year")) {
            cal1.add(5, this.offset);
        }
        timeMembers.add(member);
        if (calculateUnit.equals("year")) {
            if (this.levelType.equals("year")) {
                cal1.add(1, -Math.abs(this.offset) / this.offset);
            }
        } else if (calculateUnit.equals("quarter")) {
            cal1.add(2, -Math.abs(this.offset) / this.offset * 3);
        } else if (calculateUnit.equals("week")) {
            cal1.add(3, -Math.abs(this.offset) / this.offset);
            cal1.set(7, 1);
        } else if (calculateUnit.equals("month")) {
            cal1.add(2, -Math.abs(this.offset) / this.offset);
        } else if (calculateUnit.equals("day")) {
            cal1.add(5, -Math.abs(this.offset) / this.offset);
        }
        int step = Math.abs(this.offset) / this.offset;
        int[] cal1Value = this.getValueFromCal((Calendar)cal1, levelTypes);
        int[] cal2Value = this.getValueFromCal(cal2, levelTypes);
        while (!this.compareIntArray(cal1Value, cal2Value)) {
            if (calculateUnit.equals("week")) {
                this.addExtraWeek(timeMembers, cal2, new TimeMember(cal2Value, levelTypes), levelTypes);
            }
            if (calculateUnit.equals("year")) {
                cal2.add(1, step);
            }
            if (calculateUnit.equals("quarter")) {
                cal2.add(2, step * 3);
            } else if (calculateUnit.equals("month")) {
                cal2.add(2, step);
            } else if (calculateUnit.equals("week")) {
                cal2.add(3, step);
                cal2.set(7, 1);
            } else if (calculateUnit.equals("day")) {
                cal2.add(5, step);
            }
            int[] fillDateTmp = this.getValueFromCal(cal2, levelTypes);
            TimeMember timeMember = new TimeMember(fillDateTmp, levelTypes);
            timeMembers.add(timeMember);
            cal2Value = this.getValueFromCal(cal2, levelTypes);
        }
        return timeMembers;
    }

    private boolean compareIntArray(int[] tmp1, int[] tmp2) {
        if (tmp1.length != tmp2.length) {
            return false;
        }
        int i = 0;
        while (i < tmp1.length) {
            if (tmp1[i] != tmp2[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

