/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.editor.script;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.birt.core.preference.IPreferences;
import org.eclipse.birt.report.designer.internal.ui.editors.script.IScriptEditor;
import org.eclipse.birt.report.designer.internal.ui.script.JSEditorInput;
import org.eclipse.birt.report.designer.internal.ui.script.JSSyntaxContext;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.ReportPlugin;
import org.eclipse.birt.report.designer.ui.editor.script.ScriptDocumentProvider;
import org.eclipse.birt.report.designer.ui.editor.script.ScriptProjectionAnnotation;
import org.eclipse.birt.report.designer.ui.editor.script.ScriptSourceViewerConfiguration;
import org.eclipse.birt.report.designer.ui.editors.schematic.action.TextSaveAction;
import org.eclipse.birt.report.designer.ui.preferences.PreferenceFactory;
import org.eclipse.birt.report.designer.ui.preferences.PreferenceWrapper;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.IUndoManager;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.text.source.projection.ProjectionAnnotationModel;
import org.eclipse.jface.text.source.projection.ProjectionSupport;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.ISaveablePart;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.texteditor.AbstractDecoratedTextEditor;
import org.eclipse.ui.texteditor.AbstractMarkerAnnotationModel;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.ITextEditorActionConstants;
import org.eclipse.ui.texteditor.IUpdate;
import org.eclipse.ui.texteditor.ResourceAction;
import org.eclipse.ui.texteditor.TextOperationAction;

public class DecoratedScriptEditor
extends AbstractDecoratedTextEditor
implements IScriptEditor {
    private final JSSyntaxContext context = new JSSyntaxContext();
    private IEditorInput input = this.createScriptInput(null);
    private ActionRegistry actionRegistry = null;
    private final IEditorPart parent;
    private ScriptSourceViewerConfiguration sourceViewerConfiguration;

    public DecoratedScriptEditor(IEditorPart parent) {
        this(parent, null);
    }

    public DecoratedScriptEditor(IEditorPart parent, String script) {
        IPreferenceStore store;
        this.parent = parent;
        this.sourceViewerConfiguration = new ScriptSourceViewerConfiguration(this.context);
        this.setSourceViewerConfiguration((SourceViewerConfiguration)this.sourceViewerConfiguration);
        this.setDocumentProvider((IDocumentProvider)new ScriptDocumentProvider((ISaveablePart)parent));
        this.setScript(script);
        IPreferences preferences = PreferenceFactory.getInstance().getPreferences((AbstractUIPlugin)ReportPlugin.getDefault());
        if (preferences instanceof PreferenceWrapper && (store = ((PreferenceWrapper)preferences).getPrefsStore()) != null) {
            this.setPreferenceStore(store);
        }
    }

    public void createPartControl(Composite parent) {
        if (this.input != null) {
            this.setInput(this.input);
        }
        super.createPartControl(parent);
        ISourceViewer viewer = this.getViewer();
        if (viewer instanceof ProjectionViewer) {
            ((ProjectionViewer)viewer).doOperation(19);
        }
        this.getSourceViewer().getTextWidget().setOrientation(0x2000000);
    }

    protected void editorContextMenuAboutToShow(IMenuManager menu) {
        menu.add((IContributionItem)new Separator("group.undo"));
        menu.add((IContributionItem)new Separator("group.copy"));
        menu.add((IContributionItem)new Separator("additions"));
        if (this.isEditable()) {
            this.addAction(menu, "group.undo", ITextEditorActionConstants.UNDO);
            this.addAction(menu, "group.copy", ITextEditorActionConstants.CUT);
            this.addAction(menu, "group.copy", ITextEditorActionConstants.COPY);
            this.addAction(menu, "group.copy", ITextEditorActionConstants.PASTE);
        } else {
            this.addAction(menu, "group.copy", ITextEditorActionConstants.COPY);
        }
    }

    protected boolean isEditorInputIncludedInContextMenu() {
        return false;
    }

    protected IEditorInput createScriptInput(String script) {
        return new JSEditorInput(script);
    }

    protected void createActions() {
        super.createActions();
        TextOperationAction contentAssistAction = new TextOperationAction(Messages.getReportResourceBundle(), "ContentAssistProposal_", (ITextEditor)this, 13, true);
        TextOperationAction expandAll = new TextOperationAction(Messages.getReportResourceBundle(), "JSEditor.Folding.ExpandAll.", (ITextEditor)this, 20, true);
        TextOperationAction collapseAll = new TextOperationAction(Messages.getReportResourceBundle(), "JSEditor.Folding.CollapseAll.", (ITextEditor)this, 21, true);
        ResourceAction collapseComments = new ResourceAction(Messages.getReportResourceBundle(), "JSEditor.Folding.CollapseComments."){

            public void run() {
                DecoratedScriptEditor.this.collapseStyle(1);
            }
        };
        ResourceAction collapseMethods = new ResourceAction(Messages.getReportResourceBundle(), "JSEditor.Folding.CollapseMethods."){

            public void run() {
                DecoratedScriptEditor.this.collapseStyle(2);
            }
        };
        contentAssistAction.setActionDefinitionId("org.eclipse.ui.edit.text.contentAssist.proposals");
        expandAll.setActionDefinitionId("org.eclipse.ui.edit.text.folding.expand_all");
        collapseAll.setActionDefinitionId("org.eclipse.ui.edit.text.folding.collapse_all");
        this.setAction("ContentAssistProposal", (IAction)contentAssistAction);
        this.setAction("FoldingExpandAll", (IAction)expandAll);
        this.setAction("FoldingCollapseAll", (IAction)collapseAll);
        this.setAction("FoldingCollapseComments", (IAction)collapseComments);
        this.setAction("FoldingCollapseMethods", (IAction)collapseMethods);
        this.setAction(ITextEditorActionConstants.SAVE, (IAction)new TextSaveAction((ITextEditor)this));
    }

    public void setAction(String actionID, IAction action) {
        super.setAction(actionID, action);
        if (action != null && action.getId() == null) {
            action.setId(actionID);
        }
        if (action != null) {
            this.getActionRegistry().registerAction(action);
        }
    }

    public ActionRegistry getActionRegistry() {
        if (this.actionRegistry == null) {
            this.actionRegistry = new ActionRegistry();
        }
        return this.actionRegistry;
    }

    public ISourceViewer getViewer() {
        return this.getSourceViewer();
    }

    public String getScript() {
        IDocument document;
        IDocumentProvider provider = this.getDocumentProvider();
        String script = "";
        if (provider != null && (document = provider.getDocument((Object)this.getEditorInput())) != null) {
            script = document.get();
        }
        return script;
    }

    public void setScript(String script) {
        try {
            IDocument document;
            IDocumentProvider provider = this.getDocumentProvider();
            if (provider != null && (document = provider.getDocument((Object)this.getEditorInput())) != null) {
                document.set(script == null ? "" : script);
                return;
            }
            this.input = this.createScriptInput(script);
        }
        finally {
            IUndoManager undoManager;
            ISourceViewer viewer = this.getSourceViewer();
            if (viewer instanceof SourceViewer && (undoManager = ((SourceViewer)viewer).getUndoManager()) != null) {
                undoManager.reset();
            }
        }
    }

    public JSSyntaxContext getContext() {
        return this.context;
    }

    public void saveDocument() {
        ScriptDocumentProvider provider = (ScriptDocumentProvider)this.getDocumentProvider();
        try {
            ((AbstractMarkerAnnotationModel)provider.getAnnotationModel(this.getEditorInput())).commit(provider.getDocument(this.getEditorInput()));
        }
        catch (CoreException coreException) {}
    }

    protected ISourceViewer createSourceViewer(Composite parent, IVerticalRuler ruler, int styles) {
        this.fAnnotationAccess = this.getAnnotationAccess();
        this.fOverviewRuler = this.createOverviewRuler(this.getSharedColors());
        ProjectionViewer viewer = new ProjectionViewer(parent, ruler, this.getOverviewRuler(), this.isOverviewRulerVisible(), styles);
        ProjectionSupport fProjectionSupport = new ProjectionSupport(viewer, this.getAnnotationAccess(), this.getSharedColors());
        fProjectionSupport.addSummarizableAnnotationType("org.eclipse.ui.workbench.texteditor.error");
        fProjectionSupport.addSummarizableAnnotationType("org.eclipse.ui.workbench.texteditor.warning");
        fProjectionSupport.install();
        this.getSourceViewerDecorationSupport((ISourceViewer)viewer);
        return viewer;
    }

    protected void rulerContextMenuAboutToShow(IMenuManager menu) {
        super.rulerContextMenuAboutToShow(menu);
        MenuManager foldingMenu = new MenuManager(Messages.getString((String)"JSEditor.Folding.Group"));
        menu.appendToGroup("rulers", (IContributionItem)foldingMenu);
        IAction expandAll = this.getAction("FoldingExpandAll");
        IAction collapseAll = this.getAction("FoldingCollapseAll");
        IAction collapseComments = this.getAction("FoldingCollapseComments");
        IAction collapseMethods = this.getAction("FoldingCollapseMethods");
        this.enableAction(expandAll);
        this.enableAction(collapseAll);
        this.enableAction(collapseComments);
        this.enableAction(collapseMethods);
        foldingMenu.add(expandAll);
        foldingMenu.add(collapseAll);
        foldingMenu.add(collapseComments);
        foldingMenu.add(collapseMethods);
    }

    private void enableAction(IAction action) {
        if (action instanceof IUpdate) {
            ((IUpdate)action).update();
        } else {
            ISourceViewer viewer = this.getViewer();
            action.setEnabled(viewer instanceof ProjectionViewer ? ((ProjectionViewer)viewer).isProjectionMode() : true);
        }
    }

    private void collapseStyle(int style) {
        ISourceViewer viewer = this.getViewer();
        if (!(viewer instanceof ProjectionViewer)) {
            return;
        }
        ProjectionAnnotationModel model = ((ProjectionViewer)viewer).getProjectionAnnotationModel();
        if (model == null) {
            return;
        }
        ArrayList<ScriptProjectionAnnotation> modified = new ArrayList<ScriptProjectionAnnotation>();
        Iterator iter = model.getAnnotationIterator();
        while (iter.hasNext()) {
            ScriptProjectionAnnotation scriptAnnotation;
            Object annotation = iter.next();
            if (!(annotation instanceof ScriptProjectionAnnotation) || (scriptAnnotation = (ScriptProjectionAnnotation)((Object)annotation)).isCollapsed() || !scriptAnnotation.isStyle(style)) continue;
            scriptAnnotation.markCollapsed();
            modified.add(scriptAnnotation);
        }
        model.modifyAnnotations(null, null, modified.toArray(new Annotation[modified.size()]));
    }

    protected IEditorPart getParent() {
        return this.parent;
    }

    protected void handlePreferenceStoreChanged(PropertyChangeEvent event) {
        if (this.getSourceViewer() != null) {
            this.sourceViewerConfiguration.resetScannerColor();
            this.getSourceViewer().getTextWidget().setText(this.getSourceViewer().getTextWidget().getText());
            this.sourceViewerConfiguration.getPresentationReconciler(this.getSourceViewer()).install((ITextViewer)this.getSourceViewer());
        }
        super.handlePreferenceStoreChanged(event);
    }
}

