/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.attributes.widget;

import org.eclipse.birt.report.designer.core.model.views.property.GroupPropertyHandleWrapper;
import org.eclipse.birt.report.designer.internal.ui.dialogs.expression.ExpressionCellEditor;
import org.eclipse.birt.report.designer.internal.ui.util.AlphabeticallyViewSorter;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.page.WidgetUtil;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.provider.AdvancePropertyDescriptorProvider;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.provider.IDescriptorProvider;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.widget.PropertyDescriptor;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.widget.PropertyEditorFactory;
import org.eclipse.birt.report.designer.internal.ui.views.memento.Memento;
import org.eclipse.birt.report.designer.internal.ui.views.memento.MementoBuilder;
import org.eclipse.birt.report.designer.internal.ui.views.memento.MementoElement;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.dialogs.ExpressionProvider;
import org.eclipse.birt.report.designer.ui.dialogs.IExpressionProvider;
import org.eclipse.birt.report.designer.ui.preferences.PreferenceFactory;
import org.eclipse.birt.report.designer.ui.util.ExceptionUtil;
import org.eclipse.birt.report.designer.ui.views.ReportViewsPlugin;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.GroupPropertyHandle;
import org.eclipse.birt.report.model.api.activity.NotificationEvent;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.ICellEditorListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.custom.TreeEditor;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TreeEvent;
import org.eclipse.swt.events.TreeListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class AdvancePropertyDescriptor
extends PropertyDescriptor {
    private boolean isFormStyle;
    private static final String COLUMN_TITLE_PROPERTY = Messages.getString((String)"ReportPropertySheetPage.Column.Title.Property");
    private static final String COLUMN_TITLE_VALUE = Messages.getString((String)"ReportPropertySheetPage.Column.Title.Value");
    private CustomTreeViewer viewer;
    private CellEditor cellEditor;
    private Tree tableTree;
    private TreeEditor tableTreeEditor;
    private int columnToEdit = 1;
    private ICellEditorListener editorListener;
    private Object model;
    private Composite container;
    private IMemento propertySheetMemento;
    private IMemento viewerMemento;
    protected String propertyViewerID = "Report_Property_Sheet_Page_Viewer_ID";
    private static final String SORTING_PREFERENCE_KEY = "AdvancePropertyDescriptor.preference.sorting.type";
    private boolean execMemento = false;
    private int oldViewMode = -1;
    private AdvancePropertyDescriptorProvider provider;
    private boolean changed = false;
    private TreeListener treeListener;
    boolean updateSorting = false;

    public AdvancePropertyDescriptor(boolean formStyle) {
        this.isFormStyle = formStyle;
    }

    public Control createControl(Composite parent) {
        this.container = new Composite(parent, 0);
        GridLayout layout = UIUtil.createGridLayoutWithoutMargin((int)1, (boolean)false);
        layout.marginTop = 2;
        layout.marginBottom = 1;
        layout.marginWidth = 1;
        this.container.setLayout((Layout)layout);
        this.container.setLayoutData((Object)new GridData(1808));
        this.initSortingType();
        this.viewer = new CustomTreeViewer(this.container, 65536);
        this.tableTree = this.viewer.getTree();
        GridData gd = new GridData(1808);
        this.tableTree.setLayoutData((Object)gd);
        this.tableTree.setHeaderVisible(true);
        this.tableTree.setLinesVisible(true);
        this.viewer.setContentProvider((IContentProvider)this.provider.getContentProvier());
        TreeViewerColumn tvc1 = new TreeViewerColumn((TreeViewer)this.viewer, 0);
        tvc1.getColumn().setText(COLUMN_TITLE_PROPERTY);
        tvc1.getColumn().setWidth(300);
        tvc1.setLabelProvider((CellLabelProvider)new DelegatingStyledCellLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)this.provider.getNameLabelProvier()));
        TreeViewerColumn tvc2 = new TreeViewerColumn((TreeViewer)this.viewer, 0);
        tvc2.getColumn().setText(COLUMN_TITLE_VALUE);
        tvc2.getColumn().setWidth(400);
        tvc2.setLabelProvider((CellLabelProvider)new DelegatingStyledCellLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)this.provider.getValueLabelProvier()));
        AlphabeticallyViewSorter sorter = new AlphabeticallyViewSorter();
        sorter.setAscending(true);
        this.viewer.setSorter((ViewerSorter)sorter);
        this.hookControl();
        this.tableTreeEditor = new TreeEditor(this.tableTree);
        this.createEditorListener();
        MementoBuilder builder = new MementoBuilder();
        this.propertySheetMemento = builder.getRootMemento().getChild("org.eclipse.ui.views.PropertySheet");
        if (this.propertySheetMemento == null) {
            this.propertySheetMemento = builder.getRootMemento().createChild("org.eclipse.ui.views.PropertySheet", "View");
        }
        if ((this.viewerMemento = this.propertySheetMemento.getChild(this.propertyViewerID)) == null) {
            this.viewerMemento = this.propertySheetMemento.createChild(this.propertyViewerID, "Viewer");
        }
        return this.container;
    }

    public void setInput(Object input) {
        this.input = input;
        this.getDescriptorProvider().setInput(input);
    }

    private void expandToDefaultLevel() {
        this.viewer.expandToLevel(2);
    }

    private void createEditorListener() {
        this.editorListener = new ICellEditorListener(){

            public void cancelEditor() {
                AdvancePropertyDescriptor.this.deactivateCellEditor();
            }

            public void editorValueChanged(boolean oldValidState, boolean newValidState) {
            }

            public void applyEditorValue() {
                AdvancePropertyDescriptor.this.applyValue();
                if (AdvancePropertyDescriptor.this.changed) {
                    AdvancePropertyDescriptor.this.refresh();
                }
            }
        };
    }

    private void hookControl() {
        this.tableTree.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                AdvancePropertyDescriptor.this.handleSelect((TreeItem)e.item);
            }
        });
        this.tableTree.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent event) {
                Point pt = new Point(event.x, event.y);
                TreeItem item = AdvancePropertyDescriptor.this.tableTree.getItem(pt);
                if (item != null) {
                    if (AdvancePropertyDescriptor.this.tableTree.getColumn(0).getWidth() < event.x) {
                        AdvancePropertyDescriptor.this.handleSelect(item);
                    } else {
                        AdvancePropertyDescriptor.this.saveSelection(item);
                    }
                }
            }
        });
        this.tableTree.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (AdvancePropertyDescriptor.this.tableTree.getSelectionCount() > 0) {
                    AdvancePropertyDescriptor.this.saveSelection(AdvancePropertyDescriptor.this.tableTree.getSelection()[0]);
                }
                if (e.character == '\u001b') {
                    AdvancePropertyDescriptor.this.deactivateCellEditor();
                } else if (e.keyCode == 0x100000E) {
                    AdvancePropertyDescriptor.this.viewer.setInput(AdvancePropertyDescriptor.this.input);
                    IMemento memento = AdvancePropertyDescriptor.this.viewerMemento.getChild(AdvancePropertyDescriptor.this.provider.getElementType());
                    if (memento != null && memento instanceof Memento) {
                        AdvancePropertyDescriptor.this.expandToDefaultLevel();
                        AdvancePropertyDescriptor.this.expandTreeFromMemento((Memento)memento);
                    }
                }
            }
        });
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                Object element = selection.getFirstElement();
                if (AdvancePropertyDescriptor.this.viewer.isExpandable(element)) {
                    AdvancePropertyDescriptor.this.viewer.setExpandedState(element, !AdvancePropertyDescriptor.this.viewer.getExpandedState(element));
                    int style = 17;
                    if (!AdvancePropertyDescriptor.this.viewer.getExpandedState(element)) {
                        style = 18;
                    }
                    Event e = new Event();
                    e.widget = AdvancePropertyDescriptor.this.tableTree;
                    if (AdvancePropertyDescriptor.this.tableTree.getSelectionCount() > 0) {
                        e.item = AdvancePropertyDescriptor.this.tableTree.getSelection()[0];
                    }
                    AdvancePropertyDescriptor.this.tableTree.notifyListeners(style, e);
                }
            }
        });
        this.treeListener = new TreeListener(){

            public void treeCollapsed(TreeEvent e) {
                if (e.item instanceof TreeItem) {
                    Memento element;
                    Object obj;
                    TreeItem item = (TreeItem)e.item;
                    if (AdvancePropertyDescriptor.this.input != null && (obj = DEUtil.getInputFirstElement((Object)AdvancePropertyDescriptor.this.input)) instanceof DesignElementHandle && (element = (Memento)AdvancePropertyDescriptor.this.viewerMemento.getChild(AdvancePropertyDescriptor.this.provider.getElementType())) != null) {
                        MementoElement[] path = AdvancePropertyDescriptor.this.createItemPath(item);
                        AdvancePropertyDescriptor.this.provider.removeNode(element, path);
                    }
                    AdvancePropertyDescriptor.this.viewer.getTree().setSelection(item);
                    AdvancePropertyDescriptor.this.saveSelection(item);
                }
            }

            public void treeExpanded(TreeEvent e) {
                if (e.item instanceof TreeItem) {
                    Memento element;
                    Object obj;
                    TreeItem item = (TreeItem)e.item;
                    if (AdvancePropertyDescriptor.this.input != null && (obj = DEUtil.getInputFirstElement((Object)AdvancePropertyDescriptor.this.input)) instanceof DesignElementHandle && (element = (Memento)AdvancePropertyDescriptor.this.viewerMemento.getChild(AdvancePropertyDescriptor.this.provider.getElementType())) != null) {
                        MementoElement[] path = AdvancePropertyDescriptor.this.createItemPath(item);
                        AdvancePropertyDescriptor.this.provider.addNode(element, path);
                    }
                    AdvancePropertyDescriptor.this.viewer.getTree().setSelection(item);
                    AdvancePropertyDescriptor.this.saveSelection(item);
                }
            }
        };
        this.tableTree.addTreeListener(this.treeListener);
    }

    protected MementoElement[] createItemPath(TreeItem item) {
        MementoElement tempMemento = null;
        block0: while (item.getParentItem() != null) {
            TreeItem parent = item.getParentItem();
            int i = 0;
            while (i < parent.getItemCount()) {
                if (parent.getItem(i) == item) {
                    MementoElement memento = new MementoElement(item.getText(), (Object)i, "Element");
                    if (tempMemento != null) {
                        memento.addChild(tempMemento);
                    }
                    tempMemento = memento;
                    item = parent;
                    continue block0;
                }
                ++i;
            }
        }
        MementoElement memento = new MementoElement(item.getText(), (Object)0, "Element");
        if (tempMemento != null) {
            memento.addChild(tempMemento);
        }
        return this.provider.getNodePath(memento);
    }

    private void deactivateCellEditor() {
        this.tableTreeEditor.setEditor(null, null, this.columnToEdit);
        if (this.cellEditor != null) {
            this.cellEditor.deactivate();
            this.cellEditor.removeListener(this.editorListener);
            this.cellEditor = null;
        }
    }

    protected void handleSelect(TreeItem selection) {
        TreeItem[] sel;
        if (this.cellEditor != null) {
            this.deactivateCellEditor();
        }
        if ((sel = new TreeItem[]{selection}).length != 0) {
            this.activateCellEditor(sel[0]);
        }
        this.saveSelection(selection);
    }

    protected void saveSelection(TreeItem selection) {
        Memento element;
        Object obj;
        MementoElement[] selectPath = this.createItemPath(selection);
        if (this.input != null && (obj = DEUtil.getInputFirstElement((Object)this.input)) instanceof DesignElementHandle && (element = (Memento)this.viewerMemento.getChild(this.provider.getElementType())) != null) {
            element.getMementoElement().setAttribute("Selected", (Object)selectPath);
        }
    }

    private void applyValue() {
        block5: {
            if (this.cellEditor == null || !this.cellEditor.isDirty()) {
                return;
            }
            if (this.model instanceof GroupPropertyHandleWrapper) {
                try {
                    GroupPropertyHandle handle = ((GroupPropertyHandleWrapper)this.model).getModel();
                    if (this.cellEditor.getValue() instanceof String ? handle.getStringValue() != null && handle.getStringValue().equals(this.cellEditor.getValue()) : handle.getValue() != null && handle.getValue().equals(this.cellEditor.getValue())) {
                        return;
                    }
                    handle.setValue(this.cellEditor.getValue());
                }
                catch (SemanticException e) {
                    ExceptionUtil.handle((Throwable)e);
                    TreeItem[] sel = this.viewer.getTree().getSelection();
                    if (sel.length == 0) break block5;
                    this.activateCellEditor(sel[0]);
                }
            }
        }
    }

    private void activateCellEditor(TreeItem sel) {
        if (sel.isDisposed()) {
            return;
        }
        this.model = sel.getData();
        this.tableTree.showSelection();
        this.cellEditor = this.createCellEditor(this.model);
        if (this.cellEditor == null) {
            return;
        }
        this.tableTreeEditor.setEditor(this.cellEditor.getControl());
        this.cellEditor.activate();
        Control control = this.cellEditor.getControl();
        if (control == null) {
            this.cellEditor.deactivate();
            this.cellEditor = null;
            return;
        }
        this.cellEditor.addListener(this.editorListener);
        CellEditor.LayoutData layout = this.cellEditor.getLayoutData();
        this.tableTreeEditor.horizontalAlignment = layout.horizontalAlignment;
        this.tableTreeEditor.grabHorizontal = layout.grabHorizontal;
        this.tableTreeEditor.minimumWidth = layout.minimumWidth;
        this.tableTreeEditor.setEditor(control, sel, this.columnToEdit);
        this.cellEditor.setFocus();
    }

    private CellEditor createCellEditor(Object data) {
        CellEditor editor = null;
        if (data instanceof GroupPropertyHandleWrapper && ((GroupPropertyHandleWrapper)data).getModel().isVisible() && (editor = PropertyEditorFactory.getInstance().createPropertyEditor((Composite)this.tableTree, ((GroupPropertyHandleWrapper)data).getModel())) instanceof ExpressionCellEditor && DEUtil.getInputSize((Object)this.input) > 0) {
            ((ExpressionCellEditor)editor).setExpressionInput((IExpressionProvider)new ExpressionProvider((DesignElementHandle)DEUtil.getInputFirstElement((Object)this.input)), DEUtil.getInputFirstElement((Object)this.input));
        }
        return editor;
    }

    public Control getControl() {
        if (this.container == null) {
            return null;
        }
        return this.container;
    }

    public void setFocus() {
        this.getControl().setFocus();
        if (this.changed) {
            this.refresh();
        }
    }

    protected void refresh() {
        Object obj;
        this.viewer.getTree().deselectAll();
        this.viewer.refresh(true);
        this.deactivateCellEditor();
        if (this.input != null && (obj = DEUtil.getInputFirstElement((Object)this.input)) instanceof DesignElementHandle) {
            this.execMemento();
        }
        this.changed = false;
    }

    private void expandTreeFromMemento(Memento memento) {
        if (this.viewer.getTree().getItemCount() == 0) {
            return;
        }
        TreeItem root = this.viewer.getTree().getItem(0);
        if (memento.getMementoElement().getKey().equals(root.getText())) {
            this.restoreExpandedMemento(root, memento.getMementoElement());
            Object obj = memento.getMementoElement().getAttribute("Selected");
            if (obj != null) {
                this.restoreSelectedMemento(root, (MementoElement[])obj);
            }
        }
    }

    private void restoreSelectedMemento(TreeItem root, MementoElement[] selectedPath) {
        if (selectedPath.length <= 1) {
            return;
        }
        int i = 1;
        while (i < selectedPath.length) {
            MementoElement element = selectedPath[i];
            if (!root.getExpanded()) {
                this.viewer.createChildren((Widget)root);
                root.setExpanded(true);
            }
            if (root.getItemCount() <= (Integer)element.getValue()) {
                return;
            }
            root = root.getItem(((Integer)element.getValue()).intValue());
            ++i;
        }
        this.viewer.getTree().setSelection(root);
    }

    private void restoreExpandedMemento(TreeItem root, MementoElement memento) {
        if (memento.getKey().equals(root.getText())) {
            if (!root.getExpanded()) {
                this.viewer.createChildren((Widget)root);
            }
            if (root.getItemCount() > 0) {
                if (!root.getExpanded()) {
                    root.setExpanded(true);
                }
                MementoElement[] children = memento.getChildren();
                int i = 0;
                while (i < children.length) {
                    MementoElement child = children[i];
                    int index = (Integer)child.getValue();
                    if (index >= 0 && index < root.getItemCount()) {
                        TreeItem item = root.getItem(index);
                        this.restoreExpandedMemento(item, child);
                    }
                    ++i;
                }
            }
        }
    }

    public void load() {
        if (this.viewer.getTree() != null && !this.viewer.getTree().isDisposed()) {
            this.viewer.getTree().deselectAll();
            if (this.updateSorting) {
                this.viewer.getTree().removeAll();
            }
            this.viewer.refresh(true);
        }
        if (!this.provider.isEnable()) {
            this.viewer.setInput(null);
            return;
        }
        if (this.input == null || this.viewer.getInput() == null) {
            this.viewer.setInput(this.input);
        } else if (this.input.equals(this.viewer.getInput())) {
            this.viewer.refresh();
        } else {
            this.viewer.setInput(this.input);
        }
        this.execMemento();
    }

    private void execMemento() {
        if (!this.execMemento) {
            this.execMemento = true;
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    if (!AdvancePropertyDescriptor.this.viewer.getTree().isDisposed()) {
                        IMemento memento = AdvancePropertyDescriptor.this.viewerMemento.getChild(AdvancePropertyDescriptor.this.provider.getElementType());
                        if (memento == null) {
                            AdvancePropertyDescriptor.this.provider.setInput(AdvancePropertyDescriptor.this.input);
                            AdvancePropertyDescriptor.this.viewer.getTree().removeAll();
                            AdvancePropertyDescriptor.this.viewer.refresh();
                            AdvancePropertyDescriptor.this.expandToDefaultLevel();
                            if (AdvancePropertyDescriptor.this.viewer.getTree().getItemCount() > 0) {
                                Memento elementMemento = (Memento)AdvancePropertyDescriptor.this.viewerMemento.createChild(AdvancePropertyDescriptor.this.provider.getElementType(), "Element");
                                elementMemento.getMementoElement().setValue((Object)0);
                            }
                        } else if (memento instanceof Memento) {
                            Object obj;
                            if (AdvancePropertyDescriptor.this.treeListener != null) {
                                AdvancePropertyDescriptor.this.viewer.getTree().removeTreeListener(AdvancePropertyDescriptor.this.treeListener);
                            }
                            if (AdvancePropertyDescriptor.this.provider.getViewMode() != AdvancePropertyDescriptor.this.oldViewMode) {
                                AdvancePropertyDescriptor.this.viewer.getTree().removeAll();
                                AdvancePropertyDescriptor.this.oldViewMode = AdvancePropertyDescriptor.this.provider.getViewMode();
                            }
                            AdvancePropertyDescriptor.this.expandToDefaultLevel();
                            if (AdvancePropertyDescriptor.this.treeListener != null) {
                                AdvancePropertyDescriptor.this.viewer.getTree().addTreeListener(AdvancePropertyDescriptor.this.treeListener);
                            }
                            if (AdvancePropertyDescriptor.this.provider.getViewMode() == 0) {
                                AdvancePropertyDescriptor.this.expandTreeFromMemento((Memento)memento);
                            }
                            if ((obj = ((Memento)memento).getMementoElement().getAttribute("Selected")) != null) {
                                AdvancePropertyDescriptor.this.restoreSelectedMemento(AdvancePropertyDescriptor.this.viewer.getTree().getItem(0), (MementoElement[])obj);
                            }
                        }
                    }
                    AdvancePropertyDescriptor.this.execMemento = false;
                }
            });
        }
    }

    private void initSortingType() {
        PreferenceFactory.getInstance().getPreferences((AbstractUIPlugin)ReportViewsPlugin.getDefault()).setDefault(SORTING_PREFERENCE_KEY, 0);
        this.provider.selectViewMode(PreferenceFactory.getInstance().getPreferences((AbstractUIPlugin)ReportViewsPlugin.getDefault()).getInt(SORTING_PREFERENCE_KEY));
    }

    private void saveSortingType() {
        PreferenceFactory.getInstance().getPreferences((AbstractUIPlugin)ReportViewsPlugin.getDefault()).setValue(SORTING_PREFERENCE_KEY, this.provider.getViewMode());
    }

    public void save(Object obj) throws SemanticException {
    }

    public void setDescriptorProvider(IDescriptorProvider provider) {
        super.setDescriptorProvider(provider);
        if (this.getDescriptorProvider() instanceof AdvancePropertyDescriptorProvider) {
            this.provider = (AdvancePropertyDescriptorProvider)this.getDescriptorProvider();
        }
    }

    public void setVisible(boolean isVisible) {
        this.getControl().setVisible(isVisible);
    }

    public void setHidden(boolean isHidden) {
        WidgetUtil.setExcludeGridData((Control)this.getControl(), (boolean)isHidden);
    }

    public void addElementEvent(DesignElementHandle focus, NotificationEvent ev) {
    }

    public void clear() {
    }

    public boolean isOverdued() {
        return this.viewer.getTree() == null || this.viewer.getTree().isDisposed();
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    public void updateSorting(int sortingType) {
        this.updateSorting = true;
        if (this.cellEditor != null) {
            this.cellEditor.deactivate();
            this.applyValue();
        }
        this.deactivateCellEditor();
        Memento memento = (Memento)this.viewerMemento.getChild(this.provider.getElementType());
        if (memento != null) {
            this.saveSortingType();
            Object obj = memento.getMementoElement().getAttribute("Selected");
            if (obj != null) {
                memento.getMementoElement().setAttribute("Selected", null);
            }
        }
        this.deactivateCellEditor();
        this.execMemento();
        this.updateSorting = false;
    }

    private static class CustomTreeViewer
    extends TreeViewer {
        public CustomTreeViewer(Composite parent, int style) {
            super(parent, style);
        }

        public void createChildren(Widget widget) {
            super.createChildren(widget);
        }
    }
}

