/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.attributes.widget;

import org.eclipse.birt.report.designer.internal.ui.swt.custom.FormWidgetFactory;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.page.WidgetUtil;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.widget.PropertyDescriptor;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.ReportPlatformUIImages;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class FontAlignPropertyDescriptor
extends PropertyDescriptor {
    protected Button right;
    protected Button left;
    protected Button justify;
    protected Button center;
    protected Composite container;
    protected SelectionListener listener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            if (e.widget != FontAlignPropertyDescriptor.this.right) {
                FontAlignPropertyDescriptor.this.right.setSelection(false);
            }
            if (e.widget != FontAlignPropertyDescriptor.this.left) {
                FontAlignPropertyDescriptor.this.left.setSelection(false);
            }
            if (e.widget != FontAlignPropertyDescriptor.this.center) {
                FontAlignPropertyDescriptor.this.center.setSelection(false);
            }
            if (e.widget != FontAlignPropertyDescriptor.this.justify) {
                FontAlignPropertyDescriptor.this.justify.setSelection(false);
            }
            try {
                if (!(FontAlignPropertyDescriptor.this.right.getSelection() || FontAlignPropertyDescriptor.this.left.getSelection() || FontAlignPropertyDescriptor.this.center.getSelection() || FontAlignPropertyDescriptor.this.justify.getSelection())) {
                    FontAlignPropertyDescriptor.this.save(null);
                    return;
                }
                String value = (String)e.widget.getData();
                FontAlignPropertyDescriptor.this.save(value);
            }
            catch (SemanticException e1) {
                WidgetUtil.processError((Shell)FontAlignPropertyDescriptor.this.right.getShell(), (Exception)((Object)e1));
            }
        }
    };

    public void setInput(Object handle) {
        this.input = handle;
        this.getDescriptorProvider().setInput(this.input);
    }

    public void load() {
        String value = this.getDescriptorProvider().load().toString();
        Button[] btns = new Button[]{this.left, this.right, this.center, this.justify};
        boolean stateFlag = value == null == btns[0].getEnabled();
        int i = 0;
        while (i < btns.length) {
            if (btns[i].getData().equals(value)) {
                btns[i].setSelection(true);
            } else {
                btns[i].setSelection(false);
            }
            if (stateFlag) {
                btns[i].setEnabled(value != null);
            }
            ++i;
        }
        String[] values = new String[]{"left", "right", "center", "justify"};
        int i2 = 0;
        while (i2 < values.length) {
            String imageName = values[i2];
            if (!btns[i2].isEnabled()) {
                imageName = String.valueOf(imageName) + "DIS";
            }
            if (btns[i2].getImage() == null) {
                btns[i2].setImage(ReportPlatformUIImages.getImage((String)imageName));
            }
            ++i2;
        }
    }

    public Control getControl() {
        return this.container;
    }

    public Control createControl(Composite parent) {
        this.container = new Composite(parent, 0);
        RowLayout layout = new RowLayout(256);
        layout.marginBottom = 0;
        layout.marginHeight = 0;
        layout.marginLeft = 0;
        layout.marginRight = 0;
        layout.marginTop = 0;
        layout.marginWidth = 0;
        layout.spacing = 0;
        this.container.setLayout((Layout)layout);
        this.left = FormWidgetFactory.getInstance().createButton(this.container, 2, false);
        this.left.setToolTipText(Messages.getString((String)"TextAlignPropertyDescriptor.0"));
        this.center = FormWidgetFactory.getInstance().createButton(this.container, 2, false);
        this.center.setToolTipText(Messages.getString((String)"TextAlignPropertyDescriptor.1"));
        this.right = FormWidgetFactory.getInstance().createButton(this.container, 2, false);
        this.right.setToolTipText(Messages.getString((String)"TextAlignPropertyDescriptor.2"));
        this.justify = FormWidgetFactory.getInstance().createButton(this.container, 2, false);
        this.justify.setToolTipText(Messages.getString((String)"TextAlignPropertyDescriptor.3"));
        Button[] btns = new Button[]{this.left, this.center, this.right, this.justify};
        String[] values = new String[]{"left", "center", "right", "justify"};
        int i = 0;
        while (i < btns.length) {
            btns[i].setData((Object)values[i]);
            btns[i].addSelectionListener(this.listener);
            ++i;
        }
        return this.container;
    }

    public void save(Object obj) throws SemanticException {
        this.getDescriptorProvider().save(obj);
    }
}

