/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.attributes.widget;

import org.eclipse.birt.report.designer.internal.ui.swt.custom.FormWidgetFactory;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.page.WidgetUtil;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.views.attributes.providers.ChoiceSetFactory;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.model.api.metadata.IChoice;
import org.eclipse.birt.report.model.api.metadata.IChoiceSet;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class FontSizeBuilder
extends Composite {
    protected CCombo valueCombo;
    protected CCombo unitCombo;
    private IChoiceSet units;
    private IChoiceSet preValues;
    private String fontSizeValue;
    private static final String[] PRE_INT_TABLE = new String[]{"9", "10", "12", "14", "16", "18", "24", "36"};
    private static final String DEFAULT_CHOICE = Messages.getString((String)"FontSizeBuilder.displayname.Auto");
    private String defaultUnit = null;
    private boolean isProcessing = false;

    public FontSizeBuilder(Composite parent, int style) {
        super(parent, style);
        this.initFontSizeBuilder(parent, style, false);
    }

    public FontSizeBuilder(Composite parent, int style, boolean isFormStyle) {
        super(parent, style);
        this.initFontSizeBuilder(parent, style, isFormStyle);
    }

    private void initFontSizeBuilder(Composite parent, int style, boolean isFormStyle) {
        this.setLayout((Layout)WidgetUtil.createSpaceGridLayout((int)2, (int)0, (boolean)isFormStyle));
        if (isFormStyle) {
            ((GridLayout)this.getLayout()).horizontalSpacing = 4;
        }
        if (isFormStyle) {
            this.valueCombo = FormWidgetFactory.getInstance().createCCombo((Composite)this, false);
        } else {
            this.valueCombo = new CCombo((Composite)this, 4);
            this.valueCombo.setVisibleItemCount(30);
        }
        if (isFormStyle) {
            this.unitCombo = FormWidgetFactory.getInstance().createCCombo((Composite)this);
        } else {
            this.unitCombo = new CCombo((Composite)this, 4);
            this.unitCombo.setVisibleItemCount(30);
        }
        this.valueCombo.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
            }

            public void focusLost(FocusEvent e) {
                if (!FontSizeBuilder.this.isProcessing) {
                    FontSizeBuilder.this.processAction();
                }
            }
        });
        this.valueCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                FontSizeBuilder.this.processAction();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                FontSizeBuilder.this.isProcessing = true;
                FontSizeBuilder.this.processAction();
                FontSizeBuilder.this.isProcessing = false;
            }
        });
        this.valueCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                boolean enabled;
                String val = FontSizeBuilder.this.valueCombo.getText();
                boolean bl = enabled = (FontSizeBuilder.this.isInPreIntTable(val) || !FontSizeBuilder.this.isPredefinedValue(val)) && DEUtil.isValidNumber((String)val);
                if (FontSizeBuilder.this.unitCombo.getEnabled() != enabled) {
                    FontSizeBuilder.this.unitCombo.setEnabled(enabled);
                }
                if (!FontSizeBuilder.this.unitCombo.isEnabled()) {
                    FontSizeBuilder.this.unitCombo.deselectAll();
                } else if (FontSizeBuilder.this.unitCombo.getSelectionIndex() < 0) {
                    String unit = FontSizeBuilder.this.getDefaultUnit();
                    if (unit != null) {
                        if (!StringUtil.isBlank((String)unit)) {
                            unit = FontSizeBuilder.this.units.findChoice(unit).getDisplayName();
                        }
                        FontSizeBuilder.this.unitCombo.setText(unit);
                    } else {
                        FontSizeBuilder.this.unitCombo.setText(FontSizeBuilder.this.unitCombo.getItem(0));
                    }
                }
            }
        });
        this.unitCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                FontSizeBuilder.this.processAction();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                FontSizeBuilder.this.isProcessing = true;
                FontSizeBuilder.this.processAction();
                FontSizeBuilder.this.isProcessing = false;
            }
        });
        this.unitCombo.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
            }

            public void focusLost(FocusEvent e) {
                if (!FontSizeBuilder.this.isProcessing) {
                    FontSizeBuilder.this.processAction();
                }
            }
        });
        this.initChoice();
        GridData data = new GridData(768);
        this.valueCombo.setLayoutData((Object)data);
        this.unitCombo.setVisibleItemCount(30);
        data = new GridData();
        this.unitCombo.setLayoutData((Object)data);
    }

    public void setDefaultUnit(String defaultUnit) {
        this.defaultUnit = defaultUnit;
    }

    private String getDefaultUnit() {
        return this.defaultUnit;
    }

    protected void initChoice() {
        this.preValues = ChoiceSetFactory.getElementChoiceSet((String)"Style", (String)"fontSize");
        this.valueCombo.add(DEFAULT_CHOICE);
        int i = 0;
        while (i < PRE_INT_TABLE.length) {
            this.valueCombo.add(PRE_INT_TABLE[i]);
            ++i;
        }
        String[] cvs = ChoiceSetFactory.getDisplayNamefromChoiceSet((IChoiceSet)this.preValues);
        int i2 = 0;
        while (i2 < cvs.length) {
            this.valueCombo.add(cvs[i2]);
            ++i2;
        }
        this.units = ChoiceSetFactory.getDimensionChoiceSet((String)"Style", (String)"fontSize");
        cvs = ChoiceSetFactory.getDisplayNamefromChoiceSet((IChoiceSet)this.units);
        i2 = 0;
        while (i2 < cvs.length) {
            this.unitCombo.add(cvs[i2]);
            ++i2;
        }
    }

    private boolean isPredefinedValue(String val) {
        if (DEFAULT_CHOICE.equals(val)) {
            return true;
        }
        if (this.isInPreIntTable(val)) {
            return true;
        }
        return this.preValues.findChoiceByDisplayName(val) != null;
    }

    private boolean isPredefinedNameValue(String val) {
        if (DEFAULT_CHOICE.equals(val)) {
            return true;
        }
        if (this.isInPreIntTable(val)) {
            return true;
        }
        return this.preValues.contains(val);
    }

    private boolean isInPreIntTable(String val) {
        if (val == null) {
            return false;
        }
        int i = 0;
        while (i < PRE_INT_TABLE.length) {
            if (PRE_INT_TABLE[i].equals(val)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private String getUnitsValue(String val) {
        IChoice ci = this.units.findChoiceByDisplayName(val);
        if (ci != null) {
            return ci.getName();
        }
        return null;
    }

    protected void processAction() {
        this.computerFontSizeValue();
        this.notifyListeners(24, null);
    }

    private void computerFontSizeValue() {
        String val = this.valueCombo.getText();
        this.fontSizeValue = val == null || val.length() == 0 || DEFAULT_CHOICE.equals(val) ? null : (this.isPredefinedValue(val) ? (this.isInPreIntTable(val) ? String.valueOf(val) + DEUtil.resolveNull((String)this.getUnitsValue(this.unitCombo.getText())) : this.preValues.findChoiceByDisplayName(val).getName()) : String.valueOf(val) + DEUtil.resolveNull((String)this.getUnitsValue(this.unitCombo.getText())));
    }

    public void setFontSizeValue(String size) {
        if (size == null || size.equals(DEFAULT_CHOICE)) {
            this.valueCombo.setText(DEFAULT_CHOICE);
            return;
        }
        String[] sp = DEUtil.splitString((String)size);
        if (sp[0] == null && sp[1] == null) {
            this.valueCombo.setText(DEFAULT_CHOICE);
            return;
        }
        if (sp[0] == null) {
            if (this.isPredefinedNameValue(sp[1])) {
                if (this.preValues.contains(sp[1])) {
                    this.valueCombo.setText(this.preValues.findChoice(sp[1]).getDisplayName());
                } else {
                    this.valueCombo.setText(sp[1]);
                }
            } else {
                this.valueCombo.setText("");
            }
        } else {
            this.valueCombo.setText(sp[0]);
            if (this.units.contains(sp[1])) {
                this.unitCombo.setText(this.units.findChoice(sp[1]).getDisplayName());
            }
        }
    }

    public String getFontSizeValue() {
        return this.fontSizeValue;
    }

    public void setEnabled(boolean enabled) {
        this.valueCombo.setEnabled(enabled);
        if (enabled) {
            String val = this.valueCombo.getText();
            this.unitCombo.setEnabled((this.isInPreIntTable(val) || !this.isPredefinedValue(val)) && DEUtil.isValidNumber((String)val));
        } else {
            this.unitCombo.setEnabled(enabled);
        }
        super.setEnabled(enabled);
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        Point pt = super.computeSize(wHint, hHint, changed);
        if (pt.x < 150) {
            pt.x = 150;
        }
        return pt;
    }
}

