/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.attributes.widget;

import java.util.Arrays;
import org.eclipse.birt.report.designer.internal.ui.swt.custom.FormWidgetFactory;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.page.WidgetUtil;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.provider.PropertyDescriptorProvider;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.provider.SimpleComboPropertyDescriptorProvider;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.widget.PropertyDescriptor;
import org.eclipse.birt.report.designer.ui.views.attributes.providers.ChoiceSetFactory;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class SimpleComboPropertyDescriptor
extends PropertyDescriptor {
    protected CCombo combo;
    protected String oldValue;
    private int style = 2048;
    private FocusAdapter focusListener;

    public SimpleComboPropertyDescriptor(boolean formStyle) {
        this.setFormStyle(formStyle);
    }

    public void setInput(Object handle) {
        this.input = handle;
        this.getDescriptorProvider().setInput(this.input);
    }

    public Control getControl() {
        return this.combo;
    }

    public Control createControl(Composite parent) {
        if (this.isFormStyle()) {
            this.combo = FormWidgetFactory.getInstance().createCCombo(parent, false);
        } else {
            this.combo = new CCombo(parent, this.style);
            this.combo.setVisibleItemCount(30);
        }
        this.addListeners();
        return this.combo;
    }

    protected void addListeners() {
        this.combo.addControlListener(new ControlListener(){

            public void controlMoved(ControlEvent e) {
                SimpleComboPropertyDescriptor.this.combo.clearSelection();
            }

            public void controlResized(ControlEvent e) {
                SimpleComboPropertyDescriptor.this.combo.clearSelection();
            }
        });
        this.combo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                SimpleComboPropertyDescriptor.this.handleComboSelectEvent();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                SimpleComboPropertyDescriptor.this.handleComboSelectEvent();
            }
        });
        this.focusListener = new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                if (SimpleComboPropertyDescriptor.this.combo.isEnabled()) {
                    SimpleComboPropertyDescriptor.this.handleComboSelectEvent();
                }
            }
        };
    }

    protected void handleComboSelectEvent() {
        String newValue = this.combo.getText();
        if (ChoiceSetFactory.CHOICE_NONE.equals(newValue)) {
            newValue = null;
        }
        try {
            this.save(newValue);
        }
        catch (SemanticException e) {
            this.combo.setText(this.oldValue);
            this.combo.setSelection(new Point(0, this.oldValue.length()));
            WidgetUtil.processError((Shell)this.combo.getShell(), (Exception)((Object)e));
        }
    }

    public int getStyle() {
        return this.style;
    }

    public void load() {
        this.oldValue = this.getDescriptorProvider().load().toString();
        this.refresh(this.oldValue);
    }

    public void addStyle(int style) {
        this.style |= style;
    }

    protected void refresh(String value) {
        if (this.getDescriptorProvider() instanceof SimpleComboPropertyDescriptorProvider) {
            boolean stateFlag;
            String[] items = ((SimpleComboPropertyDescriptorProvider)this.getDescriptorProvider()).getItems();
            this.combo.setItems(items);
            boolean bl = stateFlag = value == null == this.combo.getEnabled();
            if (stateFlag) {
                this.combo.setEnabled(value != null);
            }
            if (((PropertyDescriptorProvider)this.getDescriptorProvider()).isReadOnly()) {
                this.combo.setEnabled(false);
            }
            boolean isEditable = ((SimpleComboPropertyDescriptorProvider)this.getDescriptorProvider()).isEditable();
            this.setComboEditable(isEditable);
            int sindex = Arrays.asList(items).indexOf(this.oldValue);
            if (((SimpleComboPropertyDescriptorProvider)this.getDescriptorProvider()).isSpecialProperty() && sindex < 0) {
                if (value != null && value.length() > 0) {
                    this.combo.setText(value);
                    return;
                }
                if (this.combo.getItemCount() > 0) {
                    this.combo.select(0);
                    return;
                }
            }
            this.combo.select(sindex);
        }
    }

    protected void setComboEditable(boolean isEditable) {
        this.combo.setEditable(isEditable);
        if (this.focusListener != null) {
            this.combo.removeFocusListener((FocusListener)this.focusListener);
            if (this.combo.getEditable()) {
                this.combo.addFocusListener((FocusListener)this.focusListener);
            }
        }
    }

    public void save(Object value) throws SemanticException {
        this.descriptorProvider.save(value);
    }

    public String getStringValue() {
        return this.combo.getText();
    }

    public void setStringValue(String value) {
        this.combo.setText(value);
    }

    public void setHidden(boolean isHidden) {
        WidgetUtil.setExcludeGridData((Control)this.combo, (boolean)isHidden);
    }

    public void setVisible(boolean isVisible) {
        this.combo.setVisible(isVisible);
    }
}

