/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.data;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.report.designer.core.mediator.IMediator;
import org.eclipse.birt.report.designer.core.mediator.IMediatorColleague;
import org.eclipse.birt.report.designer.core.mediator.IMediatorRequest;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.core.util.mediator.request.ReportRequest;
import org.eclipse.birt.report.designer.internal.ui.editors.ReportColorConstants;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.ui.views.INodeProvider;
import org.eclipse.birt.report.designer.ui.views.ProviderFactory;
import org.eclipse.birt.report.designer.ui.views.data.IDataViewPage;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.part.Page;

public abstract class DataViewPage
extends Page
implements IDataViewPage,
ISelectionProvider,
IMediatorColleague {
    private TreeViewer treeViewer;
    private ModuleHandle model;
    private ListenerList selectionChangedListeners = new ListenerList(1);

    public void createControl(Composite parent) {
        this.treeViewer = this.createTreeViewer(parent);
        this.getTreeViewer().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                DataViewPage.this.treeSelect(event);
            }
        });
        this.treeViewer.getTree().addListener(42, new Listener(){

            public void handleEvent(Event event) {
                TreeItem item = (TreeItem)event.item;
                if (item == null) {
                    return;
                }
                INodeProvider provider = null;
                if (item != null && item.getData() != null) {
                    provider = ProviderFactory.createProvider((Object)item.getData());
                }
                if (provider != null && item != null && provider.isReadOnly(item.getData())) {
                    Color gray = Display.getCurrent().getSystemColor(16);
                    if (!item.getForeground().equals((Object)gray)) {
                        item.setForeground(gray);
                    }
                } else {
                    Color black = ReportColorConstants.ReportForeground;
                    if (item != null && !black.equals((Object)item.getForeground())) {
                        item.setForeground(black);
                    }
                }
            }
        });
        this.configTreeViewer();
        this.hookTreeViewer();
        this.initPage();
        if (this.model != null) {
            SessionHandleAdapter.getInstance().getMediator(this.model).addColleague((IMediatorColleague)this);
        }
    }

    protected void initPage() {
    }

    public void init(IPageSite pageSite) {
        super.init(pageSite);
        pageSite.setSelectionProvider((ISelectionProvider)this);
    }

    public Control getControl() {
        if (this.treeViewer == null) {
            return null;
        }
        return this.treeViewer.getControl();
    }

    public void setFocus() {
        this.treeViewer.getControl().setFocus();
    }

    protected void configTreeViewer() {
    }

    protected abstract TreeViewer createTreeViewer(Composite var1);

    protected void hookTreeViewer() {
    }

    public TreeViewer getTreeViewer() {
        return this.treeViewer;
    }

    protected void treeSelect(SelectionChangedEvent event) {
        this.fireSelectionChanged(event.getSelection());
    }

    protected void fireSelectionChanged(ISelection selection) {
        final SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)this, selection);
        ReportRequest request = new ReportRequest((Object)this);
        List list = new ArrayList();
        if (selection instanceof IStructuredSelection) {
            list = ((IStructuredSelection)selection).toList();
        }
        request.setSelectionObject(list);
        request.setType((Object)"selection");
        SessionHandleAdapter.getInstance().getMediator().notifyRequest((IMediatorRequest)request);
        Object[] listeners = this.selectionChangedListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            final ISelectionChangedListener l = (ISelectionChangedListener)listeners[i];
            SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    l.selectionChanged(event);
                }
            });
            ++i;
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.setSelection(event.getSelection());
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.add((Object)listener);
    }

    public ISelection getSelection() {
        if (this.getTreeViewer() == null) {
            return StructuredSelection.EMPTY;
        }
        return this.getTreeViewer().getSelection();
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.remove((Object)listener);
    }

    public void setSelection(ISelection selection) {
        if (this.getTreeViewer() != null) {
            this.getTreeViewer().setSelection(selection);
        }
    }

    public void dispose() {
        IMediator mediator;
        this.selectionChangedListeners.clear();
        this.treeViewer = null;
        if (this.model != null && (mediator = SessionHandleAdapter.getInstance().getMediator(this.model, false)) != null) {
            mediator.removeColleague((IMediatorColleague)this);
        }
        super.dispose();
    }

    public boolean isInterested(IMediatorRequest request) {
        return request instanceof ReportRequest;
    }

    public void performRequest(final IMediatorRequest request) {
        if ("selection".equals(request.getType())) {
            this.handleSelectionChange((ReportRequest)request);
        }
        if ("create element".equals(request.getType())) {
            Display.getCurrent().asyncExec(new Runnable(){

                public void run() {
                    if (DataViewPage.this.getTreeViewer() != null) {
                        DataViewPage.this.getTreeViewer().refresh();
                        DataViewPage.this.handleSelectionChange((ReportRequest)request);
                    }
                }
            });
        }
    }

    protected void handleSelectionChange(ReportRequest request) {
        if (request.getSource() == this) {
            return;
        }
        if (this.getTreeViewer() == null) {
            return;
        }
        List list = request.getSelectionModelList();
        if (this.canSetSelection(list)) {
            this.setSelection((ISelection)new StructuredSelection(list));
        }
    }

    private boolean canSetSelection(List list) {
        for (Object element : list) {
            if (!UIUtil.containElement((AbstractTreeViewer)this.getTreeViewer(), element)) continue;
            return true;
        }
        return false;
    }

    public ModuleHandle getRoot() {
        return this.model;
    }

    protected void setRoot(ModuleHandle reportHandle) {
        this.model = reportHandle;
    }
}

