/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.dialogs;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.internal.ui.util.LinkedProperties;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.dialogs.BaseDialog;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;

public class ResourceEditDialog
extends BaseDialog {
    protected TableViewer viewer;
    protected Text keyText;
    protected Text valueText;
    private Button btnDelete;
    private LinkedProperties[] contents;
    protected String[] propFileName;
    protected boolean listChanged;
    private URL[] resourceURLs;
    private Button btnAdd;
    protected List<GlobalProperty> globalLinkedProperties = new ArrayList<GlobalProperty>();
    private Object detailResult;

    public ResourceEditDialog(Shell parentShell, String title) {
        super(parentShell, title);
        this.setShellStyle(67696);
        this.listChanged = false;
    }

    public void setResourceURL(URL url) {
        this.resourceURLs = new URL[]{url};
    }

    public void setResourceURLs(URL[] urls) {
        this.resourceURLs = urls;
    }

    public void create() {
        super.create();
        Point pt = this.getShell().computeSize(-1, -1);
        pt.y = Math.max(pt.y, 400);
        this.getShell().setSize(pt);
        this.updateButtonState();
    }

    private void loadMessage() {
        if (this.resourceURLs != null && this.resourceURLs.length > 0) {
            if (this.contents == null) {
                this.contents = new LinkedProperties[this.resourceURLs.length];
            }
            if (this.propFileName == null) {
                this.propFileName = new String[this.resourceURLs.length];
            }
            LinkedHashMap<String, GlobalProperty> propertyMap = new LinkedHashMap<String, GlobalProperty>();
            int i = 0;
            while (i < this.resourceURLs.length) {
                this.contents[i] = new LinkedProperties();
                try {
                    if (this.resourceURLs[i] != null) {
                        InputStream in = this.resourceURLs[i].openStream();
                        this.contents[i].load(in);
                        in.close();
                        this.propFileName[i] = DEUtil.getFilePathFormURL((URL)this.resourceURLs[i]);
                        Iterator iter = this.contents[i].keySet().iterator();
                        if (iter != null) {
                            while (iter.hasNext()) {
                                String key = (String)iter.next();
                                if (propertyMap.containsKey(key)) continue;
                                GlobalProperty property = new GlobalProperty();
                                property.key = key;
                                property.value = this.contents[i].getProperty(key);
                                property.holder = this.contents[i];
                                property.isDeleted = false;
                                property.holderFile = this.propFileName[i];
                                propertyMap.put(key, property);
                            }
                        }
                    }
                }
                catch (Exception e) {
                    ExceptionHandler.handle(e);
                }
                ++i;
            }
            Iterator iter = propertyMap.keySet().iterator();
            while (iter.hasNext()) {
                this.globalLinkedProperties.add((GlobalProperty)propertyMap.get(iter.next()));
            }
        }
    }

    private boolean saveMessage() {
        if (this.isFileSystemFile()) {
            if (this.listChanged) {
                GlobalProperty property;
                int i = 0;
                while (i < this.globalLinkedProperties.size()) {
                    property = this.globalLinkedProperties.get(i);
                    if (property.isDeleted && property.holder != null) {
                        property.holder.remove(property.key);
                        this.globalLinkedProperties.remove(i);
                        --i;
                    }
                    ++i;
                }
                i = 0;
                while (i < this.globalLinkedProperties.size()) {
                    property = this.globalLinkedProperties.get(i);
                    if (!property.isDeleted && property.holder != null) {
                        property.holder.put(property.key, property.value);
                    }
                    ++i;
                }
                i = 0;
                while (i < this.resourceURLs.length) {
                    URL url = this.resourceURLs[i];
                    if (url != null && url.getProtocol().equals("file")) {
                        try {
                            this.saveFile(DEUtil.getFilePathFormURL((URL)url), this.contents[i], this.propFileName[i]);
                        }
                        catch (Exception e) {
                            ExceptionHandler.handle(e);
                        }
                    }
                    ++i;
                }
            }
            return true;
        }
        return false;
    }

    private boolean saveFile(String filePath, LinkedProperties properties, String fileName) {
        File f = new File(filePath);
        if (!f.exists() || !f.isFile()) {
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.getString((String)"ResourceEditDialog.NotFile.Title"), (String)Messages.getFormattedString((String)"ResourceEditDialog.NotFile.Message", (Object[])new Object[]{this.propFileName}));
            return false;
        }
        if (!f.canWrite()) {
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.getString((String)"ResourceEditDialog.ReadOnlyEncounter.Title"), (String)Messages.getFormattedString((String)"ResourceEditDialog.ReadOnlyEncounter.Message", (Object[])new Object[]{this.propFileName}));
            return false;
        }
        FileOutputStream fos = null;
        try {
            if (f.canWrite()) {
                fos = new FileOutputStream(f);
                properties.store(fos, "");
            }
            return true;
        }
        catch (Exception e) {
            ExceptionHandler.handle(e);
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {
                    ExceptionHandler.handle(e);
                }
            }
        }
        return false;
    }

    protected Control createDialogArea(Composite parent) {
        UIUtil.bindHelp((Control)parent, "org.eclipse.birt.cshelp.ResourceEditDialog_ID");
        this.loadMessage();
        final Composite innerParent = (Composite)super.createDialogArea(parent);
        final Table table = new Table(innerParent, 67584);
        GridData data = new GridData(1808);
        table.setLayoutData((Object)data);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        TableLayout tableLayout = new TableLayout();
        table.setLayout((Layout)tableLayout);
        final TableColumn column1 = new TableColumn(table, 0);
        column1.setText(Messages.getString((String)"ResourceEditDialog.text.Key.TableColumn"));
        final TableColumn column2 = new TableColumn(table, 0);
        column2.setText(Messages.getString((String)"ResourceEditDialog.text.Value.TableColumn"));
        this.viewer = new TableViewer(table);
        this.viewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                if (inputElement instanceof List) {
                    List list = (List)inputElement;
                    ArrayList<GlobalProperty> availableList = new ArrayList<GlobalProperty>();
                    int i = 0;
                    while (i < list.size()) {
                        GlobalProperty property = (GlobalProperty)list.get(i);
                        if (!property.isDeleted) {
                            availableList.add(property);
                        }
                        ++i;
                    }
                    return availableList.toArray();
                }
                return new Object[0];
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }
        });
        this.viewer.setLabelProvider((IBaseLabelProvider)new PropertyLabelProvider());
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ResourceEditDialog.this.updateSelection();
            }
        });
        innerParent.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                Rectangle area = innerParent.getClientArea();
                Point preferredSize = table.computeSize(-1, -1);
                int width = area.width - 2 * table.getBorderWidth();
                if (preferredSize.y > area.height) {
                    Point vBarSize = table.getVerticalBar().getSize();
                    width -= vBarSize.x;
                }
                Point oldSize = table.getSize();
                if (oldSize.x > width) {
                    column1.setWidth(2 * width / 5);
                    column2.setWidth(width - column1.getWidth());
                    table.setSize(width, area.height);
                } else {
                    table.setSize(width, area.height);
                    column1.setWidth(2 * width / 5);
                    column2.setWidth(width - column1.getWidth());
                }
            }
        });
        Group gp = new Group(innerParent, 0);
        gp.setText(Messages.getString((String)"ResourceEditDialog.text.QuickAdd"));
        gp.setLayoutData((Object)new GridData(768));
        gp.setLayout((Layout)new GridLayout(6, false));
        Label lb = new Label((Composite)gp, 0);
        lb.setText(Messages.getString((String)"ResourceEditDialog.text.Key"));
        this.keyText = new Text((Composite)gp, 2052);
        this.keyText.setLayoutData((Object)new GridData(768));
        lb = new Label((Composite)gp, 0);
        lb.setText(Messages.getString((String)"ResourceEditDialog.text.Value"));
        this.valueText = new Text((Composite)gp, 2052);
        this.valueText.setLayoutData((Object)new GridData(768));
        this.btnAdd = new Button((Composite)gp, 8);
        this.btnAdd.setText(Messages.getString((String)"ResourceEditDialog.text.Add"));
        this.btnAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ResourceEditDialog.this.addSelection();
            }
        });
        this.btnAdd.setEnabled(this.isFileSystemFile());
        this.btnDelete = new Button((Composite)gp, 8);
        this.btnDelete.setText(Messages.getString((String)"ResourceEditDialog.text.Delete"));
        this.btnDelete.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ResourceEditDialog.this.deleteSelection();
            }
        });
        lb = new Label(innerParent, 0);
        lb.setText(Messages.getString((String)"ResourceEditDialog.message.AddNote"));
        lb.setLayoutData((Object)new GridData(768));
        this.viewer.setInput(this.globalLinkedProperties);
        return innerParent;
    }

    protected void updateSelection() {
        if (this.viewer.getTable().getSelectionCount() > 0) {
            this.keyText.setText(this.viewer.getTable().getSelection()[0].getText(0));
            this.valueText.setText(this.viewer.getTable().getSelection()[0].getText(1));
        }
        this.updateButtonState();
    }

    protected void addSelection() {
        String key = this.keyText.getText();
        String val = this.valueText.getText();
        if (key != null && key.trim().length() > 0) {
            GlobalProperty property;
            boolean isContained = false;
            int i = 0;
            while (i < this.globalLinkedProperties.size()) {
                property = this.globalLinkedProperties.get(i);
                if (key.equals(property.key) && !property.isDeleted) {
                    property.value = val;
                    isContained = true;
                    break;
                }
                ++i;
            }
            if (!isContained) {
                if (this.propFileName[0] == null) {
                    return;
                }
                File f = new File(this.propFileName[0]);
                if (!f.exists() || !f.isFile()) {
                    MessageDialog.openError((Shell)this.getShell(), (String)Messages.getString((String)"ResourceEditDialog.NotFile.Title"), (String)Messages.getFormattedString((String)"ResourceEditDialog.NotFile.Message", (Object[])new Object[]{this.propFileName}));
                    return;
                }
                if (!f.canWrite()) {
                    MessageDialog.openError((Shell)this.getShell(), (String)Messages.getString((String)"ResourceEditDialog.ReadOnlyEncounter.Title"), (String)Messages.getFormattedString((String)"ResourceEditDialog.ReadOnlyEncounter.Message", (Object[])new Object[]{this.propFileName}));
                    return;
                }
                property = new GlobalProperty();
                property.key = key;
                property.value = val;
                property.holder = this.contents[0];
                property.isDeleted = false;
                property.holderFile = this.propFileName[0];
                this.globalLinkedProperties.add(property);
            }
            this.viewer.refresh();
            this.listChanged = true;
            this.updateSelection();
        } else {
            MessageDialog.openWarning((Shell)this.getShell(), (String)Messages.getString((String)"ResourceEditDialog.text.AddWarningTitle"), (String)Messages.getString((String)"ResourceEditDialog.text.AddWarningMsg"));
        }
    }

    private void deleteSelection() {
        if (this.viewer.getTable().getSelectionIndex() == -1) {
            return;
        }
        StructuredSelection selection = (StructuredSelection)this.viewer.getSelection();
        if (selection.getFirstElement() instanceof GlobalProperty) {
            GlobalProperty property = (GlobalProperty)selection.getFirstElement();
            String file = property.holderFile;
            if (file != null) {
                File f = new File(file);
                if (!f.exists() || !f.isFile()) {
                    MessageDialog.openError((Shell)this.getShell(), (String)Messages.getString((String)"ResourceEditDialog.NotFile.Title"), (String)Messages.getFormattedString((String)"ResourceEditDialog.NotFile.Message", (Object[])new Object[]{file}));
                    return;
                }
                if (!f.canWrite()) {
                    MessageDialog.openError((Shell)this.getShell(), (String)Messages.getString((String)"ResourceEditDialog.ReadOnlyEncounter.Title"), (String)Messages.getFormattedString((String)"ResourceEditDialog.ReadOnlyEncounter.Message", (Object[])new Object[]{file}));
                    return;
                }
            }
            this.listChanged = true;
            if (property.holderFile != null) {
                property.isDeleted = true;
            } else {
                this.globalLinkedProperties.remove(property);
            }
            this.viewer.refresh();
            this.updateSelection();
        }
    }

    private void updateButtonState() {
        this.getOkButton().setEnabled(this.viewer.getTable().getSelectionCount() > 0);
        this.btnDelete.setEnabled(this.isFileSystemFile() && this.viewer.getTable().getSelectionIndex() != -1);
    }

    private boolean isFileSystemFile() {
        if (this.getAvailableResourceUrls() == null || this.getAvailableResourceUrls().length == 0) {
            return false;
        }
        boolean flag = true;
        int i = 0;
        while (i < this.resourceURLs.length) {
            URL url = this.resourceURLs[i];
            if (url != null && !url.getProtocol().equals("file")) {
                flag = false;
                break;
            }
            ++i;
        }
        return flag;
    }

    private URL[] getAvailableResourceUrls() {
        ArrayList<URL> urls = new ArrayList<URL>();
        if (this.resourceURLs == null) {
            return urls.toArray(new URL[0]);
        }
        int i = 0;
        while (i < this.resourceURLs.length) {
            if (this.resourceURLs[i] != null) {
                urls.add(this.resourceURLs[i]);
            }
            ++i;
        }
        return urls.toArray(new URL[0]);
    }

    protected void okPressed() {
        this.saveMessage();
        this.setResult(this.viewer.getTable().getSelection()[0].getText(0));
        this.setDetailResult(new String[]{this.viewer.getTable().getSelection()[0].getText(0), this.viewer.getTable().getSelection()[0].getText(1)});
        super.okPressed();
    }

    public Object getDetailResult() {
        return this.detailResult;
    }

    protected final void setDetailResult(Object value) {
        this.detailResult = value;
    }

    public boolean isKeyValueListChanged() {
        return this.listChanged;
    }

    private static class GlobalProperty {
        private String key;
        private String value;
        private LinkedProperties holder;
        private String holderFile;
        private boolean isDeleted;

        private GlobalProperty() {
        }
    }

    static class PropertyLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        PropertyLabelProvider() {
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof GlobalProperty) {
                GlobalProperty entry = (GlobalProperty)element;
                switch (columnIndex) {
                    case 0: {
                        return String.valueOf(entry.key);
                    }
                    case 1: {
                        return String.valueOf(entry.value);
                    }
                }
            }
            return null;
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }
    }
}

