/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.executor;

import com.ibm.icu.util.TimeZone;
import com.ibm.icu.util.ULocale;
import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.format.DateFormatter;
import org.eclipse.birt.core.format.NumberFormatter;
import org.eclipse.birt.core.format.StringFormatter;
import org.eclipse.birt.core.script.BirtHashMap;
import org.eclipse.birt.core.script.ICompiledScript;
import org.eclipse.birt.core.script.IScriptContext;
import org.eclipse.birt.core.script.ParameterAttribute;
import org.eclipse.birt.core.script.ScriptContext;
import org.eclipse.birt.core.script.ScriptExpression;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IConditionalExpression;
import org.eclipse.birt.data.engine.api.IDataQueryDefinition;
import org.eclipse.birt.data.engine.api.IScriptExpression;
import org.eclipse.birt.data.engine.script.ScriptEvalUtil;
import org.eclipse.birt.report.data.adapter.api.AdapterException;
import org.eclipse.birt.report.data.adapter.api.DataAdapterUtil;
import org.eclipse.birt.report.data.adapter.api.DataRequestSession;
import org.eclipse.birt.report.data.adapter.api.ILinkedResult;
import org.eclipse.birt.report.engine.adapter.ProgressMonitorProxy;
import org.eclipse.birt.report.engine.api.EngineConfig;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.api.IEngineTask;
import org.eclipse.birt.report.engine.api.IHTMLActionHandler;
import org.eclipse.birt.report.engine.api.IHTMLImageHandler;
import org.eclipse.birt.report.engine.api.IProgressMonitor;
import org.eclipse.birt.report.engine.api.IRenderOption;
import org.eclipse.birt.report.engine.api.IReportDocument;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.engine.api.IStatusHandler;
import org.eclipse.birt.report.engine.api.impl.EngineTask;
import org.eclipse.birt.report.engine.api.impl.ReportDocumentWriter;
import org.eclipse.birt.report.engine.api.impl.ReportEngine;
import org.eclipse.birt.report.engine.api.impl.ReportRunnable;
import org.eclipse.birt.report.engine.api.script.IReportContext;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IReportContent;
import org.eclipse.birt.report.engine.content.impl.ReportContent;
import org.eclipse.birt.report.engine.data.IDataEngine;
import org.eclipse.birt.report.engine.data.dte.DocumentDataSource;
import org.eclipse.birt.report.engine.executor.ApplicationClassLoader;
import org.eclipse.birt.report.engine.executor.BookmarkManager;
import org.eclipse.birt.report.engine.executor.EngineExtensionManager;
import org.eclipse.birt.report.engine.executor.EventHandlerManager;
import org.eclipse.birt.report.engine.executor.ExtendedItemManager;
import org.eclipse.birt.report.engine.executor.IPageBreakListener;
import org.eclipse.birt.report.engine.executor.IReportExecutor;
import org.eclipse.birt.report.engine.executor.PageVariable;
import org.eclipse.birt.report.engine.executor.optimize.ExecutionOptimize;
import org.eclipse.birt.report.engine.executor.optimize.ExecutionPolicy;
import org.eclipse.birt.report.engine.extension.IBaseResultSet;
import org.eclipse.birt.report.engine.extension.ICubeResultSet;
import org.eclipse.birt.report.engine.extension.IQueryResultSet;
import org.eclipse.birt.report.engine.i18n.EngineResourceHandle;
import org.eclipse.birt.report.engine.ir.Expression;
import org.eclipse.birt.report.engine.ir.Report;
import org.eclipse.birt.report.engine.ir.ReportElementDesign;
import org.eclipse.birt.report.engine.ir.ReportItemDesign;
import org.eclipse.birt.report.engine.parser.ReportParser;
import org.eclipse.birt.report.engine.toc.TOCBuilder;
import org.eclipse.birt.report.engine.util.ResourceLocatorWrapper;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.simpleapi.IDesignElement;
import org.eclipse.birt.report.model.api.simpleapi.SimpleElementFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExecutionContext {
    protected static final int ERROR_TOTAL_COUNT = 60;
    private ReportEngine engine;
    private EngineTask task;
    private Logger log;
    private boolean presentationMode = false;
    private boolean factoryMode = true;
    private ScriptContext scriptContext;
    private IDataEngine dataEngine;
    private IReportExecutor executor;
    private TOCBuilder tocBuilder;
    protected ReportRunnable runnable;
    protected ReportRunnable originalRunnable;
    private Map configs = new BirtHashMap();
    private Map params = new BirtHashMap();
    private Map persistentBeans = new HashMap();
    private Map transientBeans = new HashMap();
    private Map<String, PageVariable> pageVariables = new HashMap<String, PageVariable>();
    private ReportDocumentWriter docWriter;
    protected Report reportIR;
    private Map appContext = new HashMap();
    private IReportContext reportContext;
    private IRenderOption renderOption;
    private ULocale ulocale;
    private ULocale rlocale;
    private static final String USER_LOCALE = "user_locale";
    private TimeZone timeZone;
    private IReportDocument reportDoc;
    private IReportContent reportContent;
    private ReportItemDesign design;
    private IContent content;
    private IBaseResultSet[] rsets;
    private Stack reportHandles = new Stack();
    private long totalPage;
    private long pageNumber;
    private long filteredTotalPage;
    private long filteredPageNumber;
    private boolean isCancelled = false;
    private boolean cancelOnError = false;
    private HashMap<String, StringFormatter> stringFormatters = new HashMap();
    private HashMap<String, NumberFormatter> numberFormatters = new HashMap();
    private HashMap<String, DateFormatter> dateFormatters = new HashMap();
    private ClassLoader applicationClassLoader;
    private boolean closeClassLoader;
    private int MAX_ERRORS = 100;
    private DocumentDataSource dataSource;
    private HashMap<Long, String> reportletBookmarkMap = null;
    private List pageBreakListeners;
    private ExtendedItemManager extendedItemManager = new ExtendedItemManager();
    private EngineExtensionManager engineExtensionManager = new EngineExtensionManager(this);
    private int maxRowsPerQuery = -1;
    private EventHandlerManager eventHandlerManager;
    private IProgressMonitor progressMonitor;
    private boolean needOutputResultSet;
    private boolean isFixedLayout = false;
    private IDesignElement element = null;
    private boolean refreshData = false;
    protected BookmarkManager bookmarkManager;
    private List<EngineException> errors = new ArrayList<EngineException>();
    private List<ElementExceptionInfo> contentErrors = new ArrayList<ElementExceptionInfo>();
    protected HashMap<DesignElementHandle, ElementExceptionInfo> elementExceptions = new HashMap();
    boolean isExecutingMasterPage = false;
    protected ExecutionPolicy executionPolicy;
    private String[] engineExts;
    private boolean enableProgreesiveViewing = true;

    public ExecutionContext() {
        this(null);
    }

    public ExecutionContext(EngineTask engineTask) {
        if (engineTask != null) {
            this.task = engineTask;
            this.engine = (ReportEngine)this.task.getEngine();
            this.log = this.task.getLogger();
        } else {
            this.log = Logger.getLogger(ExecutionContext.class.getName());
        }
        this.ulocale = ULocale.getDefault();
        this.timeZone = TimeZone.getDefault();
        this.eventHandlerManager = new EventHandlerManager();
    }

    private void initializeScriptContext() {
        Locale locale;
        EngineConfig config;
        IStatusHandler statusHandler;
        this.scriptContext = new ScriptContext();
        if (this.engine != null && (statusHandler = (config = this.engine.getConfig()).getStatusHandler()) != null) {
            this.scriptContext.setAttribute("statusHandle", (Object)statusHandler);
        }
        if ((locale = this.getLocale()) != null) {
            this.scriptContext.setLocale(locale);
        }
        this.scriptContext.setAttribute("report", (Object)new ReportObject());
        this.scriptContext.setAttribute("params", (Object)this.params);
        this.scriptContext.setAttribute("config", (Object)this.configs);
        this.scriptContext.setAttribute("currentPage", (Object)this.pageNumber);
        this.scriptContext.setAttribute("totalPage", (Object)this.totalPage);
        this.scriptContext.setAttribute("_jsContext", (Object)this);
        this.scriptContext.setAttribute("vars", this.pageVariables);
        if (this.runnable != null) {
            this.registerDesign(this.runnable);
        }
        if (this.reportContext != null) {
            this.scriptContext.setAttribute("reportContext", (Object)this.reportContext);
        }
        this.scriptContext.setAttribute("pageNumber", (Object)this.pageNumber);
        this.scriptContext.setAttribute("totalPage", (Object)this.totalPage);
        if (this.task != null) {
            IStatusHandler handler = this.task.getStatusHandler();
            if (handler != null) {
                handler.initialize();
            }
            if (handler == null) {
                handler = this.engine.getConfig().getStatusHandler();
            }
            if (handler != null) {
                this.scriptContext.setAttribute("_statusHandle", (Object)handler);
            }
        }
        if (this.transientBeans != null) {
            for (Map.Entry entry : this.transientBeans.entrySet()) {
                this.scriptContext.setAttribute((String)entry.getKey(), entry.getValue());
            }
        }
        if (this.persistentBeans != null) {
            for (Map.Entry entry : this.persistentBeans.entrySet()) {
                this.registerInRoot((String)entry.getKey(), entry.getValue());
            }
        }
        this.scriptContext.setApplicationClassLoader(this.getApplicationClassLoader());
    }

    public ReportEngine getEngine() {
        return this.engine;
    }

    public BookmarkManager getBookmarkManager() {
        if (this.bookmarkManager == null) {
            this.bookmarkManager = new BookmarkManager(this, 1000);
        }
        return this.bookmarkManager;
    }

    protected void unRegisterDataObject() {
        try {
            DataAdapterUtil.unRegisterDataObject((ScriptContext)this.scriptContext);
        }
        catch (AdapterException e) {
            this.log.log(Level.SEVERE, e.getLocalizedMessage(), e);
        }
    }

    public void close() {
        IStatusHandler handler;
        if (this.extendedItemManager != null) {
            this.extendedItemManager.close();
            this.extendedItemManager = null;
        }
        if (this.engineExtensionManager != null) {
            this.engineExtensionManager.close();
            this.engineExtensionManager = null;
        }
        if (this.bookmarkManager != null) {
            this.bookmarkManager.close();
            this.bookmarkManager = null;
        }
        if (this.dataEngine != null) {
            this.unRegisterDataObject();
            this.dataEngine.shutdown();
            this.dataEngine = null;
        }
        if (this.scriptContext != null) {
            this.scriptContext.close();
            this.scriptContext = null;
        }
        if (this.dataSource != null) {
            try {
                this.dataSource.close();
            }
            catch (IOException e) {
                this.log.log(Level.SEVERE, "Failed to close the data source", e);
            }
            this.dataSource = null;
        }
        if (this.closeClassLoader && this.applicationClassLoader instanceof ApplicationClassLoader) {
            ((ApplicationClassLoader)this.applicationClassLoader).close();
        }
        if ((handler = this.task.getStatusHandler()) != null) {
            handler.finish();
        }
        this.applicationClassLoader = null;
        this.engine = null;
        this.executor = null;
        this.tocBuilder = null;
        this.configs = null;
        this.params = null;
        this.persistentBeans = null;
        this.transientBeans = null;
        this.pageVariables = null;
        this.docWriter = null;
        this.reportIR = null;
        this.appContext = null;
        this.reportContext = null;
        this.renderOption = null;
        this.reportDoc = null;
        this.reportContent = null;
        this.design = null;
        this.content = null;
        this.rsets = null;
        this.reportHandles = null;
        this.errors.clear();
        this.stringFormatters = null;
        this.numberFormatters = null;
        this.dateFormatters = null;
        this.pageBreakListeners = null;
        this.eventHandlerManager = null;
        this.progressMonitor = null;
        this.element = null;
    }

    public void newScope(Object object) {
        this.scriptContext = this.getScriptContext().newContext(object);
    }

    public void exitScope() {
        if (this.scriptContext == null) {
            throw new IllegalStateException();
        }
        ScriptContext parent = this.scriptContext.getParent();
        if (parent == null) {
            throw new IllegalStateException();
        }
        this.scriptContext = parent;
    }

    public void registerBeans(Map map) {
        if (map != null) {
            for (Map.Entry entry : map.entrySet()) {
                Object keyObj = entry.getKey();
                Object value = entry.getValue();
                if (keyObj == null) continue;
                String key = keyObj.toString();
                this.registerBean(key, value);
            }
        }
    }

    public void registerBean(String name, Object value) {
        this.transientBeans.put(name, value);
        if (this.scriptContext != null) {
            this.scriptContext.setAttribute(name, value);
        }
    }

    public void unregisterBean(String name) {
        this.transientBeans.remove(name);
        if (this.scriptContext != null) {
            this.scriptContext.setAttribute(name, null);
        }
    }

    public Map getBeans() {
        return this.transientBeans;
    }

    public void registerGlobalBeans(Map map) {
        if (map != null) {
            for (Map.Entry entry : map.entrySet()) {
                Object keyObj = entry.getKey();
                Object value = entry.getValue();
                if (keyObj == null || !(value instanceof Serializable)) continue;
                String key = keyObj.toString();
                this.registerGlobalBean(key, (Serializable)value);
            }
        }
    }

    public void registerGlobalBean(String name, Serializable value) {
        this.persistentBeans.put(name, value);
        if (this.scriptContext != null) {
            this.registerInRoot(name, value);
        }
    }

    public void unregisterGlobalBean(String name) {
        this.persistentBeans.remove(name);
        if (this.scriptContext != null) {
            this.registerInRoot(name, null);
        }
    }

    public Map getGlobalBeans() {
        return this.persistentBeans;
    }

    private void registerInRoot(String name, Object value) {
        this.getRootContext().setAttribute(name, value);
    }

    public Object evaluate(Expression expr) throws BirtException {
        if (expr != null) {
            switch (expr.getType()) {
                case 0: {
                    Expression.Constant cs = (Expression.Constant)expr;
                    return cs.getValue();
                }
                case 1: {
                    Expression.Script script = (Expression.Script)expr;
                    ICompiledScript compiledScript = script.getScriptExpression();
                    if (compiledScript == null) {
                        compiledScript = this.compile(script.getLanguage(), script.getFileName(), script.getLineNumber(), script.getScriptText());
                        script.setCompiledScript(compiledScript);
                    }
                    return this.evaluate(compiledScript);
                }
                case 2: {
                    IConditionalExpression ce = ((Expression.Conditional)expr).getConditionalExpression();
                    return this.evaluateCondExpr(ce);
                }
            }
        }
        return null;
    }

    protected String getScriptLanguage() {
        if (this.reportIR != null) {
            return this.reportIR.getScriptLanguage();
        }
        return "javascript";
    }

    public Object evaluate(String scriptText) throws BirtException {
        return this.evaluate(this.getScriptLanguage(), "<inline>", 1, scriptText);
    }

    public Object evaluate(String fileName, String scriptText) throws BirtException {
        return this.evaluate(this.getScriptLanguage(), fileName, 1, scriptText);
    }

    public Object evaluateInlineScript(String language, String scriptText) throws BirtException {
        return this.evaluate(language, "<inline>", 1, scriptText);
    }

    public Object evaluate(String language, String fileName, int lineNumber, String scriptText) throws BirtException {
        if (scriptText == null) {
            return null;
        }
        ICompiledScript compiledScript = this.compile(language, fileName, lineNumber, scriptText);
        return this.evaluate(compiledScript);
    }

    private ICompiledScript compile(String language, String fileName, int lineNumber, String scriptText) throws BirtException {
        ICompiledScript compiledScript = this.runnable.getScript(language, scriptText);
        if (compiledScript == null) {
            compiledScript = this.getScriptContext().compile(language, fileName, lineNumber, scriptText);
            this.runnable.putScript(language, scriptText, compiledScript);
        }
        return compiledScript;
    }

    private Object evaluate(ICompiledScript compiledScript) throws BirtException {
        return this.getScriptContext().evaluate(compiledScript);
    }

    public Object evaluateCondExpr(IConditionalExpression expr) throws BirtException {
        IScriptExpression testExpr = expr.getExpression();
        ScriptContext scriptContext = this.getScriptContext();
        if (testExpr == null) {
            return Boolean.FALSE;
        }
        try {
            return ScriptEvalUtil.evalExpr((IBaseExpression)expr, (ScriptContext)scriptContext, (String)ScriptExpression.defaultID, (int)0);
        }
        catch (Throwable e) {
            throw new EngineException("Error.InvalidExpressionError", testExpr.getText(), e);
        }
    }

    public void execute(ICompiledScript script) {
        try {
            this.scriptContext.evaluate(script);
        }
        catch (BirtException ex) {
            this.addException(this.design, ex);
        }
    }

    public Locale getLocale() {
        if (this.rlocale != null) {
            return this.rlocale.toLocale();
        }
        return this.ulocale.toLocale();
    }

    public void setLocale(ULocale ulocale) {
        this.ulocale = ulocale;
        if (this.rlocale == null && this.scriptContext != null) {
            this.scriptContext.setLocale(ulocale.toLocale());
        }
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
        if (this.scriptContext != null) {
            this.scriptContext.setTimeZone(timeZone);
        }
    }

    public void openDataEngine() throws EngineException {
        if (this.dataEngine == null) {
            try {
                this.dataEngine = this.engine.getDataEngineFactory().createDataEngine(this, this.needOutputResultSet);
            }
            catch (Exception e) {
                throw new EngineException("Error.FailToCreateDataEngine", e);
            }
        }
    }

    public IDataEngine getDataEngine() throws EngineException {
        if (this.dataEngine == null) {
            this.openDataEngine();
        }
        return this.dataEngine;
    }

    public void closeDataEngine() {
        if (this.dataEngine != null) {
            this.dataEngine.shutdown();
            this.dataEngine = null;
        }
    }

    public void setParameterValue(String name, Object value) {
        Object parameter = this.params.get(name);
        if (parameter instanceof ParameterAttribute) {
            ((ParameterAttribute)parameter).setValue(value);
        } else {
            this.params.put(name, new ParameterAttribute(value, null));
        }
    }

    public void setParameter(String name, Object value, Object displayText) {
        if (displayText == null || displayText instanceof String) {
            this.params.put(name, new ParameterAttribute(value, (String)displayText));
        } else if (displayText instanceof String[]) {
            this.params.put(name, new ParameterAttribute((Object[])value, (String[])displayText));
        }
    }

    public void clearParameters() {
        this.params.clear();
    }

    public Object getParameterValue(String name) {
        Object parameter = this.params.get(name);
        if (parameter != null) {
            return ((ParameterAttribute)parameter).getValue();
        }
        return null;
    }

    public Map getParameterValues() {
        HashMap result = new HashMap();
        Set entries = this.params.entrySet();
        for (Map.Entry entry : entries) {
            ParameterAttribute parameter = (ParameterAttribute)entry.getValue();
            result.put(entry.getKey(), parameter.getValue());
        }
        return result;
    }

    public Map getParameterDisplayTexts() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Set entries = this.params.entrySet();
        for (Map.Entry entry : entries) {
            String name = (String)entry.getKey();
            ParameterAttribute value = (ParameterAttribute)entry.getValue();
            result.put(name, value.getDisplayText());
        }
        return result;
    }

    public Object getParameterDisplayText(String name) {
        Object parameter = this.params.get(name);
        if (parameter != null) {
            return ((ParameterAttribute)parameter).getDisplayText();
        }
        return null;
    }

    public void setParameterDisplayText(String name, String displayText) {
        Object parameter = this.params.get(name);
        if (parameter != null) {
            ((ParameterAttribute)parameter).setDisplayText(displayText);
        }
    }

    public Map getConfigs() {
        return this.configs;
    }

    public ModuleHandle getDesign() {
        return this.runnable != null ? (ModuleHandle)this.runnable.getDesignHandle() : null;
    }

    public ReportDesignHandle getReportDesign() {
        ModuleHandle design = this.getDesign();
        if (design instanceof ReportDesignHandle) {
            return (ReportDesignHandle)design;
        }
        return null;
    }

    public IReportContent getReportContent() {
        return this.reportContent;
    }

    public void setReportContent(ReportContent content) {
        this.reportContent = content;
        if (this.contentErrors.size() > 0) {
            this.reportContent.getErrors().addAll(this.contentErrors);
            this.contentErrors.clear();
        }
        content.setReportContext(this.reportContext);
    }

    public void loadScript(String language, String fileName) {
        ModuleHandle reportDesign = this.getDesign();
        try {
            byte[] script = this.getResourceLocator().findResource(reportDesign, fileName, 2, this.appContext);
            ICompiledScript compiledScript = this.getScriptContext().compile(language, fileName, 1, new String(script, "UTF-8"));
            this.execute(compiledScript);
        }
        catch (IOException ex) {
            this.log.log(Level.SEVERE, "loading external script file " + fileName + " failed.", ex);
            this.addException(new EngineException("Error.ScriptFileLoadError", fileName, (Throwable)ex));
        }
        catch (BirtException e) {
            this.log.log(Level.SEVERE, "Failed to execute script " + fileName + ".", e);
            this.addException(new EngineException("Error.ScriptEvaluationError", new Object[]{fileName, e.toString()}, (Throwable)e));
        }
    }

    public ScriptContext getScriptContext() {
        if (this.scriptContext == null) {
            this.initializeScriptContext();
        }
        return this.scriptContext;
    }

    public IContent getContent() {
        return this.content;
    }

    public void setContent(IContent content) {
        this.content = content;
    }

    public ReportItemDesign getItemDesign() {
        return this.design;
    }

    public void setItemDesign(ReportItemDesign design) {
        this.design = design;
    }

    public void pushHandle(DesignElementHandle obj) {
        this.reportHandles.push(obj);
    }

    public DesignElementHandle popHandle() {
        return (DesignElementHandle)this.reportHandles.pop();
    }

    public DesignElementHandle getHandle() {
        if (this.reportHandles.empty()) {
            return null;
        }
        return (DesignElementHandle)this.reportHandles.peek();
    }

    public void addException(BirtException ex) {
        ModuleHandle handle = this.getDesign();
        if (this.design != null) {
            handle = this.design.getHandle();
        }
        this.addException((DesignElementHandle)handle, ex);
    }

    public void clearExceptions() {
        this.errors.clear();
        this.elementExceptions.clear();
        if (this.reportContent != null) {
            this.reportContent.getErrors().clear();
        } else {
            this.contentErrors.clear();
        }
    }

    public void addException(ReportElementDesign design, BirtException ex) {
        DesignElementHandle handle = null;
        if (design != null) {
            handle = design.getHandle();
        }
        this.addException(handle, ex);
    }

    public void addException(DesignElementHandle element, BirtException ex) {
        if (this.errors.size() >= 60) {
            if (this.cancelOnError && this.task != null) {
                this.task.cancel();
            }
            return;
        }
        EngineException engineEx = null;
        engineEx = ex instanceof EngineException ? (EngineException)ex : new EngineException(ex);
        if (element != null) {
            engineEx.setElementID(element.getID());
        }
        this.errors.add(engineEx);
        ElementExceptionInfo exInfo = this.elementExceptions.get(element);
        if (exInfo == null) {
            exInfo = new ElementExceptionInfo(element);
            this.elementExceptions.put(element, exInfo);
            if (this.reportContent != null) {
                this.reportContent.getErrors().add(exInfo);
            } else {
                this.contentErrors.add(exInfo);
            }
        }
        exInfo.addException(engineEx);
        if (this.cancelOnError && this.task != null) {
            this.task.cancel();
        }
    }

    public ReportRunnable getRunnable() {
        return this.runnable;
    }

    public void setRunnable(IReportRunnable runnable) {
        this.runnable = (ReportRunnable)runnable;
        if (this.scriptContext != null) {
            this.registerDesign(runnable);
        }
    }

    public void updateRunnable(IReportRunnable newRunnable) {
        if (this.originalRunnable == null) {
            this.originalRunnable = this.runnable;
        }
        this.runnable = (ReportRunnable)newRunnable;
        if (this.scriptContext != null) {
            this.registerDesign(this.runnable);
        }
        this.reportIR = null;
    }

    public ReportRunnable getOriginalRunnable() {
        if (this.originalRunnable != null) {
            return this.originalRunnable;
        }
        return this.runnable;
    }

    private void registerDesign(IReportRunnable runnable) {
        ModuleHandle design = (ModuleHandle)runnable.getDesignHandle();
        this.element = SimpleElementFactory.getInstance().getElement((DesignElementHandle)design);
    }

    public IRenderOption getRenderOption() {
        return this.renderOption;
    }

    public void setRenderOption(IRenderOption renderOption) {
        this.renderOption = renderOption;
    }

    public String getOutputFormat() {
        String outputFormat = null;
        if (this.renderOption != null) {
            outputFormat = this.renderOption.getOutputFormat();
        }
        if (outputFormat == null) {
            outputFormat = this.isFixedLayout() ? "pdf" : "html";
        }
        return outputFormat;
    }

    public Map getAppContext() {
        return this.appContext;
    }

    public void setAppContext(Map appContext) {
        this.appContext.clear();
        if (appContext != null) {
            this.appContext.putAll(appContext);
        }
    }

    public IReportContext getReportContext() {
        return this.reportContext;
    }

    public void setReportContext(IReportContext reportContext) {
        this.reportContext = reportContext;
        if (this.scriptContext != null) {
            this.getRootContext().setAttribute("reportContext", (Object)reportContext);
        }
    }

    public void setPageNumber(long pageNo) {
        this.pageNumber = pageNo;
        if (this.scriptContext != null) {
            this.getRootContext().setAttribute("pageNumber", (Object)this.pageNumber);
        }
        if (this.totalPage < this.pageNumber) {
            this.setTotalPage(this.pageNumber);
        }
    }

    public void setTotalPage(long totalPage) {
        if (totalPage > this.totalPage) {
            this.totalPage = totalPage;
            if (this.scriptContext != null) {
                this.getRootContext().setAttribute("totalPage", (Object)totalPage);
            }
            if (this.reportContent instanceof ReportContent) {
                ((ReportContent)this.reportContent).setTotalPage(totalPage);
            }
        }
    }

    public long getPageNumber() {
        return this.pageNumber;
    }

    public long getTotalPage() {
        return this.totalPage;
    }

    public void setFilteredPageNumber(long pageNo) {
        this.filteredPageNumber = pageNo;
    }

    public void setFilteredTotalPage(long totalPage) {
        this.filteredTotalPage = totalPage;
    }

    public long getFilteredPageNumber() {
        if (this.filteredPageNumber <= 0L) {
            return this.pageNumber;
        }
        return this.filteredPageNumber;
    }

    public long getFilteredTotalPage() {
        if (this.filteredTotalPage <= 0L) {
            return this.totalPage;
        }
        return this.filteredTotalPage;
    }

    public boolean isInFactory() {
        return this.factoryMode;
    }

    public boolean isInPresentation() {
        return this.presentationMode;
    }

    public void setFactoryMode(boolean mode) {
        this.factoryMode = mode;
    }

    public boolean getFactoryMode() {
        return this.factoryMode;
    }

    public void setPresentationMode(boolean mode) {
        this.presentationMode = mode;
    }

    private ULocale determineLocale(String locale) {
        ULocale loc = null;
        loc = locale == null ? (this.rlocale == null ? this.ulocale : this.rlocale) : (USER_LOCALE.equals(locale) ? this.ulocale : new ULocale(locale));
        return loc;
    }

    public StringFormatter getStringFormatter(String pattern) {
        return this.getStringFormatter(pattern, null);
    }

    public StringFormatter getStringFormatter(String pattern, String locale) {
        String key = String.valueOf(pattern) + ":" + locale;
        StringFormatter fmt = this.stringFormatters.get(key);
        if (fmt == null) {
            ULocale loc = this.determineLocale(locale);
            fmt = new StringFormatter(pattern, loc);
            this.stringFormatters.put(key, fmt);
        }
        return fmt;
    }

    public NumberFormatter getNumberFormatter(String pattern) {
        return this.getNumberFormatter(pattern, null);
    }

    public NumberFormatter getNumberFormatter(String pattern, String locale) {
        String key = String.valueOf(pattern) + ":" + locale;
        NumberFormatter fmt = this.numberFormatters.get(key);
        if (fmt == null) {
            ULocale loc = this.determineLocale(locale);
            fmt = new NumberFormatter(pattern, loc);
            this.numberFormatters.put(key, fmt);
        }
        return fmt;
    }

    public DateFormatter getDateFormatter(String pattern) {
        return this.getDateFormatter(pattern, null);
    }

    public DateFormatter getDateFormatter(String pattern, String locale) {
        String key = String.valueOf(pattern) + ":" + locale;
        DateFormatter fmt = this.dateFormatters.get(key);
        if (fmt == null) {
            ULocale loc = this.determineLocale(locale);
            fmt = new DateFormatter(pattern, loc, this.timeZone);
            this.dateFormatters.put(key, fmt);
        }
        return fmt;
    }

    public void setExecutor(IReportExecutor executor) {
        this.executor = executor;
    }

    public IReportExecutor getExecutor() {
        return this.executor;
    }

    public TOCBuilder getTOCBuilder() {
        return this.tocBuilder;
    }

    public void setTOCBuilder(TOCBuilder builder) {
        this.tocBuilder = builder;
    }

    public void setReportDocument(IReportDocument doc) {
        this.reportDoc = doc;
    }

    public IReportDocument getReportDocument() {
        return this.reportDoc;
    }

    public void setReportDocWriter(ReportDocumentWriter docWriter) {
        this.docWriter = docWriter;
    }

    public ReportDocumentWriter getReportDocWriter() {
        return this.docWriter;
    }

    public IHTMLActionHandler getActionHandler() {
        return this.renderOption.getActionHandler();
    }

    public IHTMLImageHandler getImageHandler() {
        return this.renderOption.getImageHandler();
    }

    public ClassLoader getApplicationClassLoader() {
        if (this.applicationClassLoader == null) {
            this.closeClassLoader = true;
            this.applicationClassLoader = AccessController.doPrivileged(new PrivilegedAction<ApplicationClassLoader>(){

                @Override
                public ApplicationClassLoader run() {
                    return new ApplicationClassLoader(ExecutionContext.this.engine, ExecutionContext.this.runnable, ExecutionContext.this.appContext);
                }
            });
            if (this.scriptContext != null) {
                this.scriptContext.setApplicationClassLoader(this.applicationClassLoader);
            }
        }
        return this.applicationClassLoader;
    }

    public void setApplicationClassLoader(ClassLoader classLoader) {
        if (classLoader == null) {
            throw new NullPointerException("null classloader");
        }
        if (this.closeClassLoader && this.applicationClassLoader instanceof ApplicationClassLoader) {
            ((ApplicationClassLoader)this.applicationClassLoader).close();
        }
        this.closeClassLoader = false;
        this.applicationClassLoader = classLoader;
        if (this.scriptContext != null) {
            this.scriptContext.setApplicationClassLoader(this.applicationClassLoader);
        }
    }

    public void cancel() {
        IStatusHandler handle;
        DataRequestSession session;
        this.isCancelled = true;
        if (this.dataEngine != null && (session = this.dataEngine.getDTESession()) != null) {
            session.cancel();
        }
        if (this.task != null && (handle = this.task.getStatusHandler()) != null) {
            EngineResourceHandle rc = new EngineResourceHandle(ULocale.forLocale((Locale)this.getLocale()));
            handle.showStatus(rc.getMessage("Message.TaskCancel"));
        }
    }

    public boolean isCanceled() {
        return this.isCancelled;
    }

    public void restart() throws EngineException {
        this.getDataEngine().getDTESession().restart();
        this.isCancelled = false;
    }

    public void setCancelOnError(boolean cancel) {
        this.cancelOnError = cancel;
    }

    public void setDataSource(DocumentDataSource dataSource) throws IOException {
        this.dataSource = dataSource;
        this.dataSource.open();
    }

    public DocumentDataSource getDataSource() {
        return this.dataSource;
    }

    public IBaseResultSet executeQuery(IBaseResultSet parent, IDataQueryDefinition query, Object queryOwner, boolean useCache) throws BirtException {
        IDataEngine dataEngine = this.getDataEngine();
        return dataEngine.execute(parent, query, queryOwner, useCache);
    }

    public IBaseResultSet getResultSet() {
        if (this.rsets != null) {
            return this.rsets[0];
        }
        return null;
    }

    public void setResultSet(IBaseResultSet rset) {
        if (rset != null) {
            if (this.rsets != null && this.rsets.length == 1 && this.rsets[0] == rset) {
                return;
            }
            this.setResultSets(new IBaseResultSet[]{rset});
        } else {
            this.setResultSets(null);
        }
    }

    public IBaseResultSet[] getResultSets() {
        return this.rsets;
    }

    public void setResultSets(IBaseResultSet[] rsets) {
        if (this.rsets == rsets) {
            return;
        }
        if (rsets != null) {
            this.rsets = rsets;
            if (rsets[0] != null) {
                try {
                    DataAdapterUtil.registerDataObject((ScriptContext)this.scriptContext, (ILinkedResult)new ResultIteratorTree(rsets[0]));
                }
                catch (AdapterException e) {
                    this.log.log(Level.SEVERE, e.getLocalizedMessage(), e);
                }
            }
        } else {
            this.rsets = null;
        }
    }

    public boolean hasErrors() {
        return !this.elementExceptions.isEmpty();
    }

    public List getErrors() {
        List errors = this.getAllErrors();
        if (errors.size() > this.MAX_ERRORS) {
            errors = errors.subList(0, this.MAX_ERRORS - 1);
        }
        return errors;
    }

    public List getAllErrors() {
        return this.errors;
    }

    public int getMaxErrors() {
        return this.MAX_ERRORS;
    }

    public void setMaxErrors(int maxErrors) {
        this.MAX_ERRORS = maxErrors;
    }

    public void setExecutingMasterPage(boolean isExecutingMasterPage) {
        this.isExecutingMasterPage = isExecutingMasterPage;
    }

    public boolean isExecutingMasterPage() {
        return this.isExecutingMasterPage;
    }

    public void addPageBreakListener(IPageBreakListener listener) {
        if (this.pageBreakListeners == null) {
            this.pageBreakListeners = new ArrayList();
        }
        this.pageBreakListeners.add(listener);
    }

    public void firePageBreakEvent(boolean isHorizontalPageBreak) {
        if (this.pageBreakListeners != null) {
            int i = 0;
            while (i < this.pageBreakListeners.size()) {
                ((IPageBreakListener)this.pageBreakListeners.get(i)).onPageBreak(isHorizontalPageBreak);
                ++i;
            }
        }
    }

    public void removePageBreakListener(IPageBreakListener listener) {
        if (this.pageBreakListeners != null) {
            this.pageBreakListeners.remove(listener);
        }
    }

    public IEngineTask getEngineTask() {
        return this.task;
    }

    public Logger getLogger() {
        return this.log;
    }

    public void setLogger(Logger logger) {
        this.log = logger;
    }

    public void optimizeExecution() {
        String[] engineExts;
        if (!(this.task == null || this.task.getTaskType() != 1 || this.isFixedLayout || (engineExts = this.getEngineExtensions()) != null && engineExts.length != 0)) {
            this.executionPolicy = new ExecutionOptimize().optimize(this.getReport());
        }
    }

    public ExecutionPolicy getExecutionPolicy() {
        return this.executionPolicy;
    }

    public Report getReport() {
        if (this.reportIR != null) {
            return this.reportIR;
        }
        if (this.runnable != null) {
            this.reportIR = new ReportParser().parse((ReportDesignHandle)this.runnable.getDesignHandle());
            this.setupFromReport();
        }
        return this.reportIR;
    }

    public void setReport(Report reportIR) {
        this.reportIR = reportIR;
        this.setupFromReport();
    }

    protected void setupFromReport() {
        if (this.reportIR == null) {
            return;
        }
        String locale = this.reportIR.getLocale();
        if (locale != null) {
            this.rlocale = new ULocale(locale);
            if (this.scriptContext != null) {
                this.scriptContext.setLocale(this.rlocale.toLocale());
            }
        }
    }

    public URL getResource(String resourceName) {
        if (this.getDesign() != null) {
            return this.getDesign().findResource(resourceName, 0, this.appContext);
        }
        return null;
    }

    public ResourceLocatorWrapper getResourceLocator() {
        return this.task.getResourceLocatorWrapper();
    }

    public ExtendedItemManager getExtendedItemManager() {
        return this.extendedItemManager;
    }

    public EngineExtensionManager getEngineExtensionManager() {
        return this.engineExtensionManager;
    }

    public void setMaxRowsPerQuery(int maxRows) {
        if (maxRows >= 0) {
            this.maxRowsPerQuery = maxRows;
        }
    }

    public int getMaxRowsPerQuery() {
        return this.maxRowsPerQuery;
    }

    public String[] getEngineExtensions() {
        if (this.engineExts != null) {
            return this.engineExts;
        }
        this.engineExts = this.engine.getEngineExtensions(this.runnable);
        if (this.engineExts == null) {
            this.engineExts = new String[0];
        }
        return this.engineExts;
    }

    public void enableProgressiveViewing(boolean enabled) {
        this.enableProgreesiveViewing = enabled;
    }

    public boolean isProgressiveViewingEnable() {
        return this.enableProgreesiveViewing;
    }

    public EventHandlerManager getEventHandlerManager() {
        return this.eventHandlerManager;
    }

    public void setProgressMonitor(IProgressMonitor monitor) {
        this.progressMonitor = new ProgressMonitorProxy(monitor);
    }

    public IProgressMonitor getProgressMonitor() {
        if (this.progressMonitor == null) {
            this.progressMonitor = new ProgressMonitorProxy(null);
        }
        return this.progressMonitor;
    }

    public boolean needOutputResultSet() {
        return this.needOutputResultSet;
    }

    public void setNeedOutputResultSet(boolean needOutputResultSet) {
        this.needOutputResultSet = needOutputResultSet;
    }

    public Object getPageVariable(String name) {
        if ("totalPage".equals(name)) {
            return this.totalPage;
        }
        if ("pageNumber".equals(name)) {
            return this.pageNumber;
        }
        PageVariable var = this.pageVariables.get(name);
        if (var != null) {
            return var.getValue();
        }
        return null;
    }

    public void setPageVariable(String name, Object value) {
        PageVariable var = this.pageVariables.get(name);
        if (var != null) {
            var.setValue(value);
        } else if ("pageLabel".equals(name)) {
            this.addPageVariable(new PageVariable("pageLabel", "page", value));
        }
    }

    public void addPageVariables(Collection<PageVariable> vars) {
        for (PageVariable var : vars) {
            this.pageVariables.put(var.getName(), var);
        }
    }

    public Collection<PageVariable> getPageVariables() {
        return this.pageVariables.values();
    }

    public void addPageVariable(PageVariable var) {
        this.pageVariables.put(var.getName(), var);
    }

    public boolean isFixedLayout() {
        return this.isFixedLayout;
    }

    public void setFixedLayout(boolean isFixedLayout) {
        this.isFixedLayout = isFixedLayout;
    }

    public int getTaskType() {
        return this.task.getTaskType();
    }

    private IScriptContext getRootContext() {
        ScriptContext result = this.scriptContext;
        while (result.getParent() != null) {
            result = result.getParent();
        }
        return result;
    }

    public boolean needRefreshData() {
        return this.refreshData;
    }

    public void setRefreshData(boolean refreshData) {
        this.refreshData = refreshData;
    }

    public void setReportletBookmark(long id, String bookmark) {
        if (this.reportletBookmarkMap == null) {
            this.reportletBookmarkMap = new HashMap();
        }
        this.reportletBookmarkMap.put(id, bookmark);
    }

    public String getReportletBookmark(long id) {
        if (this.reportletBookmarkMap == null) {
            return null;
        }
        return this.reportletBookmarkMap.get(id);
    }

    public boolean isBookmarkExist(String bookmark) {
        if (this.reportletBookmarkMap == null) {
            return false;
        }
        return this.reportletBookmarkMap.values().contains(bookmark);
    }

    public boolean isReportDocumentFinished() {
        if (this.reportDoc != null) {
            return this.reportDoc.isComplete();
        }
        return false;
    }

    public static class ElementExceptionInfo {
        DesignElementHandle element;
        ArrayList exList = new ArrayList();
        ArrayList countList = new ArrayList();

        public ElementExceptionInfo(DesignElementHandle element) {
            this.element = element;
        }

        public void addException(BirtException e) {
            int i = 0;
            while (i < this.exList.size()) {
                BirtException err = (BirtException)((Object)this.exList.get(i));
                if (e.getErrorCode() != null && e.getErrorCode().equals(err.getErrorCode()) && e.getLocalizedMessage() != null && e.getLocalizedMessage().equals(err.getLocalizedMessage())) {
                    this.countList.set(i, (Integer)this.countList.get(i) + 1);
                    return;
                }
                ++i;
            }
            this.exList.add(e);
            this.countList.add(1);
        }

        public String getType() {
            if (this.element == null) {
                return "report";
            }
            return this.element.getDefn().getName();
        }

        public String getName() {
            if (this.element == null) {
                return "report";
            }
            return this.element.getName();
        }

        public String getID() {
            if (this.element == null) {
                return null;
            }
            return String.valueOf(this.element.getID());
        }

        public ArrayList getErrorList() {
            return this.exList;
        }

        public ArrayList getCountList() {
            return this.countList;
        }
    }

    public class ReportObject {
        public Object getDesign() {
            return ExecutionContext.this.element;
        }

        public Object getDocument() {
            return ExecutionContext.this.reportDoc;
        }

        public Map getParams() {
            return ExecutionContext.this.params;
        }

        public Object getDataSets() {
            return null;
        }

        public Object getDataSources() {
            return null;
        }

        public Map getConfig() {
            return ExecutionContext.this.configs;
        }

        public Object getReportContext() {
            return ExecutionContext.this.reportContext;
        }
    }

    private class ResultIteratorTree
    implements ILinkedResult {
        IBaseResultSet currentRset;
        int resultType = -1;

        public ResultIteratorTree(IBaseResultSet rset) {
            this.currentRset = rset;
            if (rset instanceof IQueryResultSet) {
                this.resultType = 2;
            } else if (rset instanceof ICubeResultSet) {
                this.resultType = 1;
            }
        }

        public ILinkedResult getParent() {
            return new ResultIteratorTree(this.currentRset.getParent());
        }

        public Object getCurrentResult() {
            if (this.resultType == 2) {
                return ((IQueryResultSet)this.currentRset).getResultIterator();
            }
            if (this.resultType == 1) {
                return ((ICubeResultSet)this.currentRset).getCubeCursor();
            }
            return null;
        }

        public int getCurrentResultType() {
            return this.resultType;
        }
    }
}

