/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.item.crosstab.internal.ui.editors.action;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.report.designer.ui.util.ExceptionUtil;
import org.eclipse.birt.report.designer.ui.util.UIUtil;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.item.crosstab.core.de.AggregationCellHandle;
import org.eclipse.birt.report.item.crosstab.core.de.ComputedMeasureViewHandle;
import org.eclipse.birt.report.item.crosstab.core.de.CrosstabCellHandle;
import org.eclipse.birt.report.item.crosstab.core.de.CrosstabReportItemHandle;
import org.eclipse.birt.report.item.crosstab.core.de.CrosstabViewHandle;
import org.eclipse.birt.report.item.crosstab.core.de.DimensionViewHandle;
import org.eclipse.birt.report.item.crosstab.core.de.LevelViewHandle;
import org.eclipse.birt.report.item.crosstab.core.de.MeasureViewHandle;
import org.eclipse.birt.report.item.crosstab.core.util.CrosstabUtil;
import org.eclipse.birt.report.item.crosstab.internal.ui.AggregationCellProviderWrapper;
import org.eclipse.birt.report.item.crosstab.internal.ui.dialogs.AggregationDialog;
import org.eclipse.birt.report.item.crosstab.internal.ui.editors.action.AbstractCrosstabAction;
import org.eclipse.birt.report.item.crosstab.internal.ui.editors.model.CrosstabAdaptUtil;
import org.eclipse.birt.report.item.crosstab.internal.ui.util.CrosstabUIHelper;
import org.eclipse.birt.report.item.crosstab.ui.extension.IAggregationCellViewProvider;
import org.eclipse.birt.report.item.crosstab.ui.extension.SwitchCellInfo;
import org.eclipse.birt.report.item.crosstab.ui.i18n.Messages;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.olap.LevelHandle;
import org.eclipse.birt.report.model.api.olap.MeasureHandle;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddSubTotalAction
extends AbstractCrosstabAction {
    boolean needUpdateView = false;
    LevelViewHandle levelHandle = null;
    private static final String NAME = Messages.getString("AddSubTotalAction.TransName");
    private static final String ID = "add_subtotal";
    private static final String TEXT = Messages.getString("AddSubTotalAction.DisplayName");
    private AggregationCellProviderWrapper providerWrapper;

    public AddSubTotalAction(DesignElementHandle handle) {
        super(handle);
        this.setId(ID);
        this.setText(TEXT);
        ExtendedItemHandle extendedHandle = CrosstabAdaptUtil.getExtendedItemHandle(handle);
        this.setHandle((DesignElementHandle)extendedHandle);
        this.levelHandle = CrosstabAdaptUtil.getLevelViewHandle(extendedHandle);
        Image image = CrosstabUIHelper.getImage("icons/pal/cell-level-aggregation.gif");
        this.setImageDescriptor(ImageDescriptor.createFromImage((Image)image));
    }

    private void initializeProviders() {
        this.providerWrapper = new AggregationCellProviderWrapper((ExtendedItemHandle)this.levelHandle.getCrosstab().getModelHandle());
    }

    @Override
    public boolean isEnabled() {
        boolean result;
        boolean bl = result = this.levelHandle == null || this.levelHandle.getCrosstab() == null || this.levelHandle.getCrosstab().getCube() == null;
        if (result) {
            return false;
        }
        return !DEUtil.isReferenceElement((DesignElementHandle)this.levelHandle.getCrosstabHandle());
    }

    public void run() {
        block4: {
            this.transStar(NAME);
            try {
                AggregationDialog dialog = new AggregationDialog(UIUtil.getDefaultShell(), this.levelHandle.getCrosstab());
                dialog.setAxis(this.levelHandle.getAxisType());
                List<AggregationDialog.SubTotalInfo> rowSubTotals = this.getSubTotalInfo(0);
                List<AggregationDialog.GrandTotalInfo> rowGrandTotals = this.getGrandTotalInfo(0);
                List<AggregationDialog.SubTotalInfo> colSubTotals = this.getSubTotalInfo(1);
                List<AggregationDialog.GrandTotalInfo> colGrandTotals = this.getGrandTotalInfo(1);
                dialog.setInput(this.copySubTotal(rowSubTotals), this.copyGrandTotal(rowGrandTotals), this.copySubTotal(colSubTotals), this.copyGrandTotal(colGrandTotals));
                if (dialog.open() == 0) {
                    this.initializeProviders();
                    Object[] result = (Object[])dialog.getResult();
                    this.processSubTotal(rowSubTotals, (List)result[0]);
                    this.processGrandTotal(rowGrandTotals, (List)result[1], 0);
                    this.processSubTotal(colSubTotals, (List)result[2]);
                    this.processGrandTotal(colGrandTotals, (List)result[3], 1);
                    this.providerWrapper.switchViews();
                    if (this.needUpdateView) {
                        this.providerWrapper.updateAllAggregationCells(0);
                    }
                    break block4;
                }
                this.rollBack();
                return;
            }
            catch (SemanticException e) {
                this.rollBack();
                ExceptionUtil.handle((Throwable)e);
                return;
            }
        }
        this.transEnd();
    }

    private List<AggregationDialog.SubTotalInfo> copySubTotal(List<AggregationDialog.SubTotalInfo> list) {
        ArrayList<AggregationDialog.SubTotalInfo> retValue = new ArrayList<AggregationDialog.SubTotalInfo>();
        int i = 0;
        while (i < list.size()) {
            retValue.add(list.get(i).copy());
            ++i;
        }
        return retValue;
    }

    private List<AggregationDialog.GrandTotalInfo> copyGrandTotal(List<AggregationDialog.GrandTotalInfo> list) {
        ArrayList<AggregationDialog.GrandTotalInfo> retValue = new ArrayList<AggregationDialog.GrandTotalInfo>();
        int i = 0;
        while (i < list.size()) {
            retValue.add(list.get(i).copy());
            ++i;
        }
        return retValue;
    }

    private void processGrandTotal(List<AggregationDialog.GrandTotalInfo> ori, List<AggregationDialog.GrandTotalInfo> newList, int axisType) throws SemanticException {
        GrandOpration oriOperation = new GrandOpration();
        GrandOpration newOperation = new GrandOpration();
        int i = 0;
        while (i < ori.size()) {
            AggregationDialog.GrandTotalInfo oriInfo = ori.get(i);
            AggregationDialog.GrandTotalInfo newInfo = newList.get(i);
            oriOperation.addInfo(oriInfo);
            newOperation.addInfo(newInfo);
            if (i == ori.size() - 1) {
                this.processOperation(oriOperation, newOperation, axisType);
            }
            ++i;
        }
    }

    private void processOperation(GrandOpration oriOperation, GrandOpration newOperation, int axisType) throws SemanticException {
        if (oriOperation.getMeasures().size() == 0 && newOperation.getMeasures().size() == 0) {
            return;
        }
        if (oriOperation.getMeasures().size() == 0 && newOperation.getMeasures().size() != 0) {
            this.addGrandTotal(this.levelHandle.getCrosstab(), axisType, newOperation.getFunctions(), this.findMeasureViewHandleList(newOperation.getMeasures()));
            this.markSwitchViews(newOperation, axisType, true);
        } else if (oriOperation.getMeasures().size() != 0 && newOperation.getMeasures().size() == 0) {
            this.levelHandle.getCrosstab().removeGrandTotal(axisType);
            this.needUpdateView = true;
        } else {
            int newSize;
            int oriSize = oriOperation.getMeasures().size();
            if (oriSize != (newSize = newOperation.getMeasures().size())) {
                this.levelHandle.getCrosstab().removeGrandTotal(axisType);
                this.addGrandTotal(this.levelHandle.getCrosstab(), axisType, newOperation.getFunctions(), this.findMeasureViewHandleList(newOperation.getMeasures()));
                this.markSwitchViews(newOperation, axisType, true);
                return;
            }
            int i = 0;
            while (i < oriSize) {
                if (!oriOperation.getMeasures().get(i).equals(newOperation.getMeasures().get(i))) {
                    this.levelHandle.getCrosstab().removeGrandTotal(axisType);
                    this.addGrandTotal(this.levelHandle.getCrosstab(), axisType, newOperation.getFunctions(), this.findMeasureViewHandleList(newOperation.getMeasures()));
                    this.markSwitchViews(newOperation, axisType, true);
                    return;
                }
                ++i;
            }
            i = 0;
            while (i < oriSize) {
                if (!oriOperation.getFunctions().get(i).equals(newOperation.getFunctions().get(i))) {
                    this.levelHandle.getCrosstab().setAggregationFunction(axisType, this.findMeasureViewHandle(newOperation.getMeasures().get(i)), newOperation.getFunctions().get(i));
                }
                this.markSwitchViews(newOperation, axisType, false);
                ++i;
            }
        }
    }

    private void processSubTotal(List<AggregationDialog.SubTotalInfo> ori, List<AggregationDialog.SubTotalInfo> newList) throws SemanticException {
        SubOpration oriOperation = new SubOpration();
        SubOpration newOperation = new SubOpration();
        int i = 0;
        while (i < ori.size()) {
            AggregationDialog.SubTotalInfo oriInfo = ori.get(i);
            AggregationDialog.SubTotalInfo newInfo = newList.get(i);
            if (i == 0) {
                oriOperation.setLevelHandle(oriInfo.getLevel());
                newOperation.setLevelHandle(newInfo.getLevel());
            } else if (!oriOperation.isSameOperation(oriInfo)) {
                this.processOperation(oriOperation, newOperation);
                oriOperation = new SubOpration();
                oriOperation.setLevelHandle(oriInfo.getLevel());
                newOperation = new SubOpration();
                newOperation.setLevelHandle(newInfo.getLevel());
            }
            oriOperation.addInfo(oriInfo);
            newOperation.addInfo(newInfo);
            if (i == ori.size() - 1) {
                this.processOperation(oriOperation, newOperation);
            }
            ++i;
        }
    }

    private AggregationCellHandle getGrandAggregationCell(MeasureViewHandle measureView, LevelViewHandle levelHandle, int axisType) {
        AggregationCellHandle cell = null;
        CrosstabReportItemHandle crosstab = levelHandle.getCrosstab();
        int counterAxisType = AddSubTotalAction.getOppositeAxisType(axisType);
        DimensionViewHandle counterDimension = crosstab.getDimension(counterAxisType, crosstab.getDimensionCount(counterAxisType) - 1);
        String counterDimensionName = null;
        String counterLevelName = null;
        if (counterDimension != null) {
            counterDimensionName = counterDimension.getCubeDimensionName();
            counterLevelName = counterDimension.getLevel(counterDimension.getLevelCount() - 1).getCubeLevelName();
        }
        String rowDimension = null;
        String rowLevel = null;
        String colDimension = null;
        String colLevel = null;
        if (axisType == 0) {
            colDimension = counterDimensionName;
            colLevel = counterLevelName;
        } else if (axisType == 1) {
            rowDimension = counterDimensionName;
            rowLevel = counterLevelName;
        }
        cell = measureView.getAggregationCell(rowDimension, rowLevel, colDimension, colLevel);
        return cell;
    }

    private AggregationCellHandle getSubAggregationCell(MeasureViewHandle measureView, LevelViewHandle levelView) {
        AggregationCellHandle cell = null;
        String rowDimension = null;
        String rowLevel = null;
        String colDimension = null;
        String colLevel = null;
        int axisType = levelView.getAxisType();
        int counterAxisType = AddSubTotalAction.getOppositeAxisType(levelView.getAxisType());
        CrosstabReportItemHandle crosstab = this.levelHandle.getCrosstab();
        DimensionViewHandle counterDimension = crosstab.getDimension(counterAxisType, crosstab.getDimensionCount(counterAxisType) - 1);
        String counterDimensionName = null;
        String counterLevelName = null;
        if (counterDimension != null) {
            counterDimensionName = counterDimension.getCubeDimensionName();
            counterLevelName = counterDimension.getLevel(counterDimension.getLevelCount() - 1).getCubeLevelName();
        }
        String dimensionName = ((DimensionViewHandle)levelView.getContainer()).getCubeDimensionName();
        String levelName = levelView.getCubeLevelName();
        if (levelName == null || dimensionName == null) {
            return null;
        }
        if (axisType == 0) {
            rowDimension = dimensionName;
            rowLevel = levelName;
            colDimension = counterDimensionName;
            colLevel = counterLevelName;
        } else if (axisType == 1) {
            colDimension = dimensionName;
            colLevel = levelName;
            rowDimension = counterDimensionName;
            rowLevel = counterLevelName;
        }
        cell = measureView.getAggregationCell(rowDimension, rowLevel, colDimension, colLevel);
        return cell;
    }

    private void markSwitchViews(GrandOpration newOperation, int axisType, boolean isNew) {
        int count = newOperation.getMeasures().size();
        int i = 0;
        while (i < count) {
            String tmpMeasureName = newOperation.getMeasures().get(i);
            MeasureViewHandle measureView = this.findMeasureViewHandle(tmpMeasureName);
            String expectedView = newOperation.getExpectedViews().get(i);
            if (expectedView != null && expectedView.length() != 0) {
                CrosstabReportItemHandle crosstab = this.levelHandle.getCrosstab();
                AggregationCellHandle cell = this.getGrandAggregationCell(measureView, this.levelHandle, axisType);
                if (cell != null) {
                    SwitchCellInfo swtichCellInfo = new SwitchCellInfo(crosstab, 1);
                    AggregationDialog.GrandTotalInfo grandTotal = new AggregationDialog.GrandTotalInfo();
                    grandTotal.setExpectedView(expectedView);
                    grandTotal.setMeasureQualifiedName(tmpMeasureName);
                    swtichCellInfo.setGrandTotalInfo(grandTotal, axisType);
                    swtichCellInfo.setIsNew(isNew);
                    this.providerWrapper.addSwitchInfo(swtichCellInfo);
                    this.needUpdateView = true;
                }
            }
            ++i;
        }
    }

    private void markSwitchViews(SubOpration newOperation, boolean isNew) {
        int count = newOperation.getMeasures().size();
        int i = 0;
        while (i < count) {
            String tmpMeasureName = newOperation.getMeasures().get(i);
            String expectedView = newOperation.getExpectedViews().get(i);
            if (expectedView != null && expectedView.length() != 0) {
                MeasureViewHandle measureView = this.findMeasureViewHandle(tmpMeasureName);
                CrosstabReportItemHandle crosstab = this.levelHandle.getCrosstab();
                LevelViewHandle levelView = this.findLevelViewHandle(newOperation.getLevelHandle());
                AggregationCellHandle cell = this.getSubAggregationCell(measureView, levelView);
                if (cell != null) {
                    SwitchCellInfo swtichCellInfo = new SwitchCellInfo(crosstab, 2);
                    AggregationDialog.SubTotalInfo subTotal = new AggregationDialog.SubTotalInfo();
                    subTotal.setExpectedView(expectedView);
                    subTotal.setAggregateOnMeasureName(tmpMeasureName);
                    subTotal.setLevelView(levelView);
                    swtichCellInfo.setIsNew(isNew);
                    swtichCellInfo.setSubTotalInfo(subTotal);
                    this.providerWrapper.addSwitchInfo(swtichCellInfo);
                }
            }
            ++i;
        }
    }

    public static int getOppositeAxisType(int axisType) {
        switch (axisType) {
            case 1: {
                return 0;
            }
            case 0: {
                return 1;
            }
        }
        return -1;
    }

    private void processOperation(SubOpration oriOperation, SubOpration newOperation) throws SemanticException {
        if (oriOperation.getMeasures().size() == 0 && newOperation.getMeasures().size() == 0) {
            return;
        }
        if (oriOperation.getMeasures().size() == 0 && newOperation.getMeasures().size() != 0) {
            this.addAggregationHeader(this.findLevelViewHandle(newOperation.getLevelHandle()), newOperation.getFunctions(), this.findMeasureViewHandleList(newOperation.getMeasures()));
            this.markSwitchViews(newOperation, true);
        } else if (oriOperation.getMeasures().size() != 0 && newOperation.getMeasures().size() == 0) {
            this.findLevelViewHandle(oriOperation.getLevelHandle()).removeSubTotal();
            this.needUpdateView = true;
        } else {
            int newSize;
            int oriSize = oriOperation.getMeasures().size();
            if (oriSize != (newSize = newOperation.getMeasures().size())) {
                this.findLevelViewHandle(oriOperation.getLevelHandle()).removeSubTotal();
                this.addAggregationHeader(this.findLevelViewHandle(newOperation.getLevelHandle()), newOperation.getFunctions(), this.findMeasureViewHandleList(newOperation.getMeasures()));
                this.markSwitchViews(newOperation, true);
                return;
            }
            int i = 0;
            while (i < oriSize) {
                if (!oriOperation.getMeasures().get(i).equals(newOperation.getMeasures().get(i))) {
                    this.findLevelViewHandle(oriOperation.getLevelHandle()).removeSubTotal();
                    this.addAggregationHeader(this.findLevelViewHandle(newOperation.getLevelHandle()), newOperation.getFunctions(), this.findMeasureViewHandleList(newOperation.getMeasures()));
                    this.markSwitchViews(newOperation, true);
                    return;
                }
                ++i;
            }
            i = 0;
            while (i < oriSize) {
                if (!oriOperation.getFunctions().get(i).equals(newOperation.getFunctions().get(i))) {
                    this.findLevelViewHandle(newOperation.getLevelHandle()).setAggregationFunction(this.findMeasureViewHandle(newOperation.getMeasures().get(i)), newOperation.getFunctions().get(i));
                }
                this.markSwitchViews(newOperation, false);
                ++i;
            }
        }
    }

    private void addGrandTotal(CrosstabReportItemHandle crosstab, int axisType, List functions, List measures) throws SemanticException {
        CrosstabCellHandle cellHandle = crosstab.addGrandTotal(axisType, measures, functions);
        if (cellHandle == null) {
            return;
        }
        CrosstabUIHelper.createGrandTotalLabel(cellHandle);
    }

    private void addAggregationHeader(LevelViewHandle levelView, List functions, List measures) throws SemanticException {
        CrosstabCellHandle cellHandle = levelView.addSubTotal(measures, functions);
        if (cellHandle == null) {
            return;
        }
        CrosstabUIHelper.createSubTotalLabel(levelView, cellHandle);
    }

    private List<MeasureViewHandle> findMeasureViewHandleList(List<String> list) {
        ArrayList<MeasureViewHandle> retValue = new ArrayList<MeasureViewHandle>();
        int i = 0;
        while (i < list.size()) {
            retValue.add(this.findMeasureViewHandle(list.get(i)));
            ++i;
        }
        return retValue;
    }

    private MeasureViewHandle findMeasureViewHandle(String measureName) {
        return this.levelHandle.getCrosstab().getMeasure(measureName);
    }

    private LevelViewHandle findLevelViewHandle(LevelHandle handle) {
        LevelViewHandle levelView;
        DimensionViewHandle tmpDimView;
        DimensionViewHandle viewHandle = this.getDimensionViewHandle();
        CrosstabReportItemHandle crosstab = viewHandle.getCrosstab();
        int dimCount = crosstab.getDimensionCount(0);
        int i = 0;
        while (i < dimCount) {
            tmpDimView = crosstab.getDimension(0, i);
            levelView = tmpDimView.getLevel(handle.getQualifiedName());
            if (levelView != null) {
                return levelView;
            }
            ++i;
        }
        dimCount = crosstab.getDimensionCount(1);
        i = 0;
        while (i < dimCount) {
            tmpDimView = crosstab.getDimension(1, i);
            levelView = tmpDimView.getLevel(handle.getQualifiedName());
            if (levelView != null) {
                return levelView;
            }
            ++i;
        }
        return null;
    }

    private boolean isVertical(CrosstabReportItemHandle reportHandle) {
        return "vertical".equals(reportHandle.getMeasureDirection());
    }

    private boolean getAssociation(int axis) {
        DimensionViewHandle viewHandle = this.getDimensionViewHandle();
        CrosstabReportItemHandle reportHandle = viewHandle.getCrosstab();
        if (1 == axis) {
            return this.isVertical(reportHandle);
        }
        if (axis == 0) {
            return !this.isVertical(reportHandle);
        }
        return false;
    }

    private List<AggregationDialog.SubTotalInfo> getSubTotalInfo(int axis) {
        LevelViewHandle tempViewHandle;
        int i;
        int count;
        DimensionViewHandle dimension;
        ArrayList<AggregationDialog.SubTotalInfo> retValue = new ArrayList<AggregationDialog.SubTotalInfo>();
        DimensionViewHandle viewHandle = this.getDimensionViewHandle();
        CrosstabReportItemHandle reportHandle = viewHandle.getCrosstab();
        int dimCount = reportHandle.getDimensionCount(axis);
        int measureCount = reportHandle.getMeasureCount();
        LevelViewHandle lastLevelHandle = this.getLastLevelViewHandle(axis);
        int k = 0;
        while (k < dimCount) {
            dimension = reportHandle.getDimension(axis, k);
            count = dimension.getLevelCount();
            i = 0;
            while (i < count) {
                tempViewHandle = dimension.getLevel(i);
                if (tempViewHandle != lastLevelHandle) {
                    tempViewHandle.getCubeLevel();
                    int j = 0;
                    while (j < measureCount) {
                        MeasureViewHandle measureView = reportHandle.getMeasure(j);
                        if (!(measureView instanceof ComputedMeasureViewHandle)) {
                            AggregationDialog.SubTotalInfo info = new AggregationDialog.SubTotalInfo();
                            info.setLevelView(tempViewHandle);
                            if (reportHandle.getMeasure(j).getCubeMeasure() != null) {
                                info.setAggregateOnMeasureName(reportHandle.getMeasure(j).getCubeMeasure().getQualifiedName());
                                info.setAggregateOnMeasureDisplayName(reportHandle.getMeasure(j).getCubeMeasure().getName());
                            }
                            info.setFunction(CrosstabUtil.getDefaultMeasureAggregationFunction((MeasureViewHandle)reportHandle.getMeasure(j)));
                            info.setExpectedView("");
                            retValue.add(info);
                            info.setAssociation(this.getAssociation(axis));
                        }
                        ++j;
                    }
                }
                ++i;
            }
            ++k;
        }
        k = 0;
        while (k < dimCount) {
            dimension = reportHandle.getDimension(axis, k);
            count = dimension.getLevelCount();
            i = 0;
            while (i < count) {
                tempViewHandle = dimension.getLevel(i);
                tempViewHandle.getCubeLevel();
                List measures = tempViewHandle.getAggregationMeasures();
                int j = 0;
                while (j < measures.size()) {
                    MeasureHandle tempMeasureHandle = ((MeasureViewHandle)measures.get(j)).getCubeMeasure();
                    AggregationDialog.SubTotalInfo info = new AggregationDialog.SubTotalInfo();
                    info.setLevelView(tempViewHandle);
                    if (tempMeasureHandle != null) {
                        info.setAggregateOnMeasureName(tempMeasureHandle.getQualifiedName());
                        info.setAggregateOnMeasureDisplayName(tempMeasureHandle.getName());
                    }
                    info.setFunction(CrosstabUtil.getDefaultMeasureAggregationFunction((MeasureViewHandle)((MeasureViewHandle)measures.get(j))));
                    AggregationCellHandle cell = this.getSubAggregationCell((MeasureViewHandle)measures.get(j), tempViewHandle);
                    String view = this.getExpectedView(cell);
                    info.setExpectedView(view);
                    this.replaceInfo(info, retValue);
                    ++j;
                }
                ++i;
            }
            ++k;
        }
        return retValue;
    }

    private LevelViewHandle getLastLevelViewHandle(int axis) {
        DimensionViewHandle viewHandle = this.getDimensionViewHandle();
        CrosstabReportItemHandle reportHandle = viewHandle.getCrosstab();
        int count = reportHandle.getDimensionCount(axis);
        if (count == 0) {
            return null;
        }
        DimensionViewHandle lastDimension = reportHandle.getDimension(axis, count - 1);
        return lastDimension.getLevel(lastDimension.getLevelCount() - 1);
    }

    private List<AggregationDialog.GrandTotalInfo> getGrandTotalInfo(int axis) {
        ArrayList<AggregationDialog.GrandTotalInfo> retValue = new ArrayList<AggregationDialog.GrandTotalInfo>();
        CrosstabReportItemHandle reportHandle = this.levelHandle.getCrosstab();
        CrosstabViewHandle crosstabView = reportHandle.getCrosstabView(axis);
        if (crosstabView == null || crosstabView.getDimensionCount() == 0) {
            return retValue;
        }
        int measureCount = reportHandle.getMeasureCount();
        int i = 0;
        while (i < measureCount) {
            MeasureViewHandle measureView = reportHandle.getMeasure(i);
            if (!(measureView instanceof ComputedMeasureViewHandle)) {
                AggregationDialog.GrandTotalInfo info = new AggregationDialog.GrandTotalInfo();
                info.setViewHandle(reportHandle.getCrosstabView(axis));
                info.setMeasureQualifiedName(reportHandle.getMeasure(i).getCubeMeasure().getQualifiedName());
                info.setMeasureDisplayName(reportHandle.getMeasure(i).getCubeMeasure().getName());
                info.setFunction(CrosstabUtil.getDefaultMeasureAggregationFunction((MeasureViewHandle)reportHandle.getMeasure(i)));
                info.setExpectedView("");
                info.setPosition(reportHandle.getCrosstabView(axis).getGrandTotalLocation());
                retValue.add(info);
                info.setAssociation(this.getAssociation(axis));
            }
            ++i;
        }
        List measures = reportHandle.getAggregationMeasures(axis);
        int i2 = 0;
        while (i2 < measures.size()) {
            MeasureViewHandle measureView = (MeasureViewHandle)measures.get(i2);
            if (!(measureView instanceof ComputedMeasureViewHandle)) {
                AggregationDialog.GrandTotalInfo info = new AggregationDialog.GrandTotalInfo();
                MeasureViewHandle measureViewHandle = (MeasureViewHandle)measures.get(i2);
                info.setViewHandle(reportHandle.getCrosstabView(axis));
                info.setMeasureQualifiedName(measureViewHandle.getCubeMeasure().getQualifiedName());
                info.setMeasureDisplayName(measureViewHandle.getCubeMeasure().getName());
                info.setFunction(CrosstabUtil.getDefaultMeasureAggregationFunction((MeasureViewHandle)measureViewHandle));
                AggregationCellHandle cell = this.getGrandAggregationCell(measureView, this.levelHandle, axis);
                String view = this.getExpectedView(cell);
                info.setExpectedView(view);
                info.setPosition(reportHandle.getCrosstabView(axis).getGrandTotalLocation());
                this.replaceInfo(info, retValue);
            }
            ++i2;
        }
        return retValue;
    }

    private void replaceInfo(AggregationDialog.SubTotalInfo info, List list) {
        int i = 0;
        while (i < list.size()) {
            if (info.isSameInfo(list.get(i))) {
                AggregationDialog.SubTotalInfo tempInfo = (AggregationDialog.SubTotalInfo)list.get(i);
                tempInfo.setAggregationOn(true);
                tempInfo.setFunction(info.getFunction());
                tempInfo.setExpectedView(info.getExpectedView());
                break;
            }
            ++i;
        }
    }

    private void replaceInfo(AggregationDialog.GrandTotalInfo info, List list) {
        int i = 0;
        while (i < list.size()) {
            if (info.isSameInfo(list.get(i))) {
                AggregationDialog.GrandTotalInfo tempInfo = (AggregationDialog.GrandTotalInfo)list.get(i);
                tempInfo.setAggregationOn(true);
                tempInfo.setFunction(info.getFunction());
                tempInfo.setExpectedView(info.getExpectedView());
                tempInfo.setViewHandle(info.getViewHandle());
                tempInfo.setPosition(info.getPosition());
            }
            ++i;
        }
    }

    private DimensionViewHandle getDimensionViewHandle() {
        return CrosstabAdaptUtil.getDimensionViewHandle((ExtendedItemHandle)this.levelHandle.getModelHandle());
    }

    private String getExpectedView(AggregationCellHandle cell) {
        String view = "";
        AggregationCellProviderWrapper wrapper = new AggregationCellProviderWrapper(this.levelHandle.getCrosstab());
        IAggregationCellViewProvider provider = wrapper.getMatchProvider(cell);
        if (provider != null) {
            view = provider.getViewName();
        }
        return view;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class GrandOpration {
        private List<String> functions = new ArrayList<String>();
        private List<String> measures = new ArrayList<String>();
        private List<String> expectedViews = new ArrayList<String>();

        GrandOpration() {
        }

        public void addInfo(AggregationDialog.GrandTotalInfo info) {
            if (info.isAggregationOn()) {
                this.functions.add(info.getFunction());
                this.measures.add(info.getMeasureQualifiedName());
                this.expectedViews.add(info.getExpectedView());
            }
        }

        public List<String> getFunctions() {
            return this.functions;
        }

        public List<String> getMeasures() {
            return this.measures;
        }

        public List<String> getExpectedViews() {
            return this.expectedViews;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class SubOpration {
        private LevelHandle levelHandle;
        private List<String> functions = new ArrayList<String>();
        private List<String> measures = new ArrayList<String>();
        private List<String> expectedViews = new ArrayList<String>();

        SubOpration() {
        }

        public boolean isSameOperation(AggregationDialog.SubTotalInfo info) {
            return info.getLevel() == this.levelHandle;
        }

        public LevelHandle getLevelHandle() {
            return this.levelHandle;
        }

        public void setLevelHandle(LevelHandle levelHandle) {
            this.levelHandle = levelHandle;
        }

        public void addInfo(AggregationDialog.SubTotalInfo info) {
            if (info.isAggregationOn()) {
                this.functions.add(info.getFunction());
                this.measures.add(info.getAggregateOnMeasureName());
                this.expectedViews.add(info.getExpectedView());
            }
        }

        public List<String> getFunctions() {
            return this.functions;
        }

        public List<String> getMeasures() {
            return this.measures;
        }

        public List<String> getExpectedViews() {
            return this.expectedViews;
        }
    }
}

