/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.xlc.core.scannerconfig;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.cdt.make.core.scannerconfig.IScannerInfoCollector2;
import org.eclipse.cdt.make.core.scannerconfig.ScannerInfoTypes;
import org.eclipse.cdt.make.internal.core.MakeMessages;
import org.eclipse.cdt.make.internal.core.scannerconfig.util.TraceUtil;
import org.eclipse.cdt.make.xlc.core.activator.Activator;
import org.eclipse.cdt.make.xlc.core.scannerconfig.AbstractXLCBuildOutputParser;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;

public class XLCPerProjectBuildOutputParser
extends AbstractXLCBuildOutputParser {
    @Override
    protected boolean processCommand(String[] tokens) {
        int compilerInvocationIdx = this.findCompilerInvocation(tokens);
        if (compilerInvocationIdx < 0) {
            return false;
        }
        if (compilerInvocationIdx + 1 >= tokens.length) {
            return false;
        }
        ArrayList<String> includes = new ArrayList<String>();
        ArrayList<String> symbols = new ArrayList<String>();
        ArrayList targetSpecificOptions = new ArrayList();
        String fileName = null;
        int j = compilerInvocationIdx + 1;
        while (j < tokens.length) {
            String token = tokens[j];
            if (!token.equals("-I-")) {
                if (token.startsWith("-I")) {
                    String candidate = null;
                    if (token.length() > 2) {
                        candidate = token.substring(2).trim();
                    } else if (j + 1 < tokens.length) {
                        candidate = tokens[j + 1];
                        if (candidate.startsWith("-")) {
                            candidate = null;
                        } else {
                            ++j;
                        }
                    }
                    if (candidate != null && candidate.length() > 0) {
                        if (this.getUtility() != null) {
                            candidate = this.getUtility().normalizePath(candidate);
                        }
                        if (!includes.contains(candidate)) {
                            includes.add(candidate);
                        }
                    }
                } else if (token.startsWith("-D")) {
                    String candidate = null;
                    if (token.length() > 2) {
                        candidate = token.substring(2).trim();
                    } else if (j + 1 < tokens.length) {
                        candidate = tokens[j + 1];
                        if (candidate.startsWith("-")) {
                            candidate = null;
                        } else {
                            ++j;
                        }
                    }
                    if (candidate != null && candidate.length() > 0) {
                        if (candidate.indexOf(61) == -1) {
                            candidate = String.valueOf(candidate) + '=' + this.getUtility().getDefaultMacroDefinitionValue();
                        }
                        if (!symbols.contains(candidate)) {
                            symbols.add(candidate);
                        }
                    }
                } else if (fileName == null) {
                    int extIndex = token.lastIndexOf(46);
                    String extension = null;
                    if (extIndex != -1) {
                        extension = token.substring(extIndex);
                    }
                    List<String> extensions = this.getFileExtensionsList();
                    if (extension != null && extensions.contains(extension)) {
                        fileName = token;
                    }
                }
            }
            ++j;
        }
        if (fileName == null) {
            return false;
        }
        IProject project = this.getProject();
        IFile file = null;
        List<String> translatedIncludes = includes;
        if (includes.size() > 0) {
            if (fileName != null) {
                if (this.getUtility() != null && (file = this.getUtility().findFile(fileName)) != null) {
                    project = file.getProject();
                    translatedIncludes = this.getUtility().translateRelativePaths(file, fileName, includes);
                }
            } else {
                StringBuffer line = new StringBuffer();
                int j2 = 0;
                while (j2 < tokens.length) {
                    line.append(tokens[j2]);
                    line.append(' ');
                    ++j2;
                }
                String error = MakeMessages.getString((String)"ConsoleParser.Filename_Missing_Error_Message");
                TraceUtil.outputError((String)error, (String)line.toString());
                if (this.getUtility() != null) {
                    this.getUtility().generateMarker((IResource)this.getProject(), -1, String.valueOf(error) + line.toString(), 1, null);
                }
            }
            if (file == null && this.getUtility() != null) {
                translatedIncludes.clear();
            }
        }
        if (translatedIncludes.size() > 0 || symbols.size() > 0) {
            HashMap scannerInfo = new HashMap();
            scannerInfo.put(ScannerInfoTypes.INCLUDE_PATHS, translatedIncludes);
            scannerInfo.put(ScannerInfoTypes.SYMBOL_DEFINITIONS, symbols);
            scannerInfo.put(ScannerInfoTypes.TARGET_SPECIFIC_OPTION, targetSpecificOptions);
            this.getCollector().contributeToScannerConfig((Object)project, scannerInfo);
            if (this.fCollector != null && this.fCollector instanceof IScannerInfoCollector2) {
                IScannerInfoCollector2 collector = (IScannerInfoCollector2)this.fCollector;
                try {
                    collector.updateScannerConfiguration(null);
                }
                catch (CoreException e) {
                    Activator.log(e);
                }
            }
            TraceUtil.outputTrace((String)("Discovered scanner info for file '" + fileName + '\''), (String)"Include paths", includes, translatedIncludes, (String)"Defined symbols", symbols);
        }
        return true;
    }
}

