/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.osgi.services.remoteserviceadmin;

import java.security.Permission;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import org.eclipse.core.runtime.Assert;
import org.eclipse.ecf.core.ContainerTypeDescription;
import org.eclipse.ecf.core.IContainer;
import org.eclipse.ecf.core.IContainerManager;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.util.ECFException;
import org.eclipse.ecf.internal.osgi.services.remoteserviceadmin.Activator;
import org.eclipse.ecf.internal.osgi.services.remoteserviceadmin.LogUtility;
import org.eclipse.ecf.internal.osgi.services.remoteserviceadmin.PropertiesUtil;
import org.eclipse.ecf.osgi.services.remoteserviceadmin.ConsumerContainerSelector;
import org.eclipse.ecf.osgi.services.remoteserviceadmin.EndpointDescription;
import org.eclipse.ecf.osgi.services.remoteserviceadmin.HostContainerSelector;
import org.eclipse.ecf.osgi.services.remoteserviceadmin.IConsumerContainerSelector;
import org.eclipse.ecf.osgi.services.remoteserviceadmin.IHostContainerSelector;
import org.eclipse.ecf.osgi.services.remoteserviceadmin.RemoteReferenceNotFoundException;
import org.eclipse.ecf.osgi.services.remoteserviceadmin.SelectContainerException;
import org.eclipse.ecf.remoteservice.IOSGiRemoteServiceContainerAdapter;
import org.eclipse.ecf.remoteservice.IRemoteService;
import org.eclipse.ecf.remoteservice.IRemoteServiceContainer;
import org.eclipse.ecf.remoteservice.IRemoteServiceContainerAdapter;
import org.eclipse.ecf.remoteservice.IRemoteServiceID;
import org.eclipse.ecf.remoteservice.IRemoteServiceListener;
import org.eclipse.ecf.remoteservice.IRemoteServiceReference;
import org.eclipse.ecf.remoteservice.IRemoteServiceRegistration;
import org.eclipse.ecf.remoteservice.events.IRemoteServiceEvent;
import org.eclipse.ecf.remoteservice.events.IRemoteServiceUnregisteredEvent;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceException;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.Version;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.framework.wiring.BundleWire;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;
import org.osgi.service.remoteserviceadmin.EndpointPermission;
import org.osgi.service.remoteserviceadmin.RemoteServiceAdminListener;
import org.osgi.util.tracker.ServiceTracker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteServiceAdmin
implements org.osgi.service.remoteserviceadmin.RemoteServiceAdmin {
    public static final String SERVICE_PROP = "org.eclipse.ecf.rsa";
    private Bundle clientBundle;
    private boolean hostAutoCreateContainer = new Boolean(System.getProperty("org.eclipse.ecf.osgi.services.remoteserviceadmin.hostAutoCreateContainer", "true"));
    private String[] hostDefaultConfigTypes = new String[]{System.getProperty("org.eclipse.ecf.osgi.services.remoteserviceadmin.hostDefaultConfigType", "ecf.generic.server")};
    private boolean consumerAutoCreateContainer = new Boolean(System.getProperty("org.eclipse.ecf.osgi.services.remoteserviceadmin.consumerAutoCreateContainer", "true"));
    private ServiceTracker packageAdminTracker;
    private Object packageAdminTrackerLock = new Object();
    private Object eventAdminTrackerLock = new Object();
    private ServiceTracker eventAdminTracker;
    private Object remoteServiceAdminListenerTrackerLock = new Object();
    private ServiceTracker remoteServiceAdminListenerTracker;
    private HostContainerSelector defaultHostContainerSelector;
    private ServiceRegistration defaultHostContainerSelectorRegistration;
    private ConsumerContainerSelector defaultConsumerContainerSelector;
    private ServiceRegistration defaultConsumerContainerSelectorRegistration;
    private Collection<ExportRegistration> exportedRegistrations = new ArrayList<ExportRegistration>();
    private Collection<ImportRegistration> importedRegistrations = new ArrayList<ImportRegistration>();
    private Object consumerContainerSelectorTrackerLock = new Object();
    private ServiceTracker consumerContainerSelectorTracker;
    private Object hostContainerSelectorTrackerLock = new Object();
    private ServiceTracker hostContainerSelectorTracker;
    private Map<Bundle, ProxyClassLoader> proxyClassLoaders = new HashMap<Bundle, ProxyClassLoader>();

    public RemoteServiceAdmin(Bundle clientBundle) {
        this.clientBundle = clientBundle;
        Assert.isNotNull((Object)this.clientBundle);
        this.trace("RemoteServiceAdmin<init>", "clientBundle=" + clientBundle.getSymbolicName());
        Properties props = new Properties();
        props.put("service.ranking", new Integer(Integer.MIN_VALUE));
        ServiceReference[] hostContainerSelectorRefs = null;
        try {
            hostContainerSelectorRefs = this.getClientBundleContext().getServiceReferences(IHostContainerSelector.class.getName(), null);
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            // empty catch block
        }
        if (hostContainerSelectorRefs == null || hostContainerSelectorRefs.length == 0) {
            this.defaultHostContainerSelector = new HostContainerSelector(this.hostDefaultConfigTypes, this.hostAutoCreateContainer);
            this.defaultHostContainerSelectorRegistration = this.getClientBundleContext().registerService(IHostContainerSelector.class.getName(), (Object)this.defaultHostContainerSelector, (Dictionary)props);
        }
        ServiceReference[] consumerContainerSelectorRefs = null;
        try {
            consumerContainerSelectorRefs = this.getClientBundleContext().getServiceReferences(IConsumerContainerSelector.class.getName(), null);
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            // empty catch block
        }
        if (consumerContainerSelectorRefs == null || consumerContainerSelectorRefs.length == 0) {
            this.defaultConsumerContainerSelector = new ConsumerContainerSelector(this.consumerAutoCreateContainer);
            this.defaultConsumerContainerSelectorRegistration = this.getClientBundleContext().registerService(IConsumerContainerSelector.class.getName(), (Object)this.defaultConsumerContainerSelector, (Dictionary)props);
        }
    }

    private boolean validExportedInterfaces(ServiceReference serviceReference, String[] exportedInterfaces) {
        if (exportedInterfaces == null || exportedInterfaces.length == 0) {
            return false;
        }
        List<String> objectClassList = Arrays.asList((String[])serviceReference.getProperty("objectClass"));
        int i = 0;
        while (i < exportedInterfaces.length) {
            if (!objectClassList.contains(exportedInterfaces[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<org.osgi.service.remoteserviceadmin.ExportRegistration> exportService(ServiceReference serviceReference, Map<String, ?> overridingProperties) {
        this.trace("exportService", "serviceReference=" + serviceReference + ",properties=" + overridingProperties);
        overridingProperties = PropertiesUtil.mergeProperties(serviceReference, overridingProperties == null ? Collections.EMPTY_MAP : overridingProperties);
        String[] exportedInterfaces = PropertiesUtil.getExportedInterfaces(serviceReference, overridingProperties);
        if (exportedInterfaces == null) {
            throw new IllegalArgumentException("service.exported.interfaces not set");
        }
        if (!this.validExportedInterfaces(serviceReference, exportedInterfaces)) {
            return Collections.EMPTY_LIST;
        }
        String[] exportedConfigs = PropertiesUtil.getStringArrayFromPropertyValue(overridingProperties.get("service.exported.configs"));
        if (exportedConfigs == null) {
            exportedConfigs = PropertiesUtil.getStringArrayFromPropertyValue(serviceReference.getProperty("service.exported.configs"));
        }
        String[] serviceIntents = PropertiesUtil.getServiceIntents(serviceReference, overridingProperties);
        IHostContainerSelector hostContainerSelector = this.getHostContainerSelector();
        IRemoteServiceContainer[] rsContainers = null;
        try {
            rsContainers = hostContainerSelector.selectHostContainers(serviceReference, overridingProperties, exportedInterfaces, exportedConfigs, serviceIntents);
        }
        catch (SelectContainerException e) {
            ExportRegistration errorRegistration = this.createErrorExportRegistration(serviceReference, overridingProperties, "Error selecting or creating host container for serviceReference=" + serviceReference + " properties=" + overridingProperties, e);
            ArrayList<org.osgi.service.remoteserviceadmin.ExportRegistration> result = new ArrayList<org.osgi.service.remoteserviceadmin.ExportRegistration>();
            result.add(errorRegistration);
            this.publishExportEvent(errorRegistration);
            return result;
        }
        if (rsContainers == null || rsContainers.length == 0) {
            String errorMessage = "No containers found for serviceReference=" + serviceReference + " properties=" + overridingProperties + ". Remote service NOT EXPORTED";
            this.logWarning("exportService", errorMessage);
            return Collections.EMPTY_LIST;
        }
        ArrayList<ExportRegistration> exportRegistrations = new ArrayList<ExportRegistration>();
        Collection<ExportRegistration> errorRegistration = this.exportedRegistrations;
        synchronized (errorRegistration) {
            int i = 0;
            while (i < rsContainers.length) {
                ExportRegistration exportRegistration = null;
                ExportEndpoint exportEndpoint = this.findExistingExportEndpoint(serviceReference, rsContainers[i].getContainer().getID());
                if (exportEndpoint != null) {
                    exportRegistration = new ExportRegistration(exportEndpoint);
                } else {
                    Map<String, Object> endpointDescriptionProperties = this.createExportEndpointDescriptionProperties(serviceReference, overridingProperties, exportedInterfaces, serviceIntents, rsContainers[i]);
                    EndpointDescription endpointDescription = new EndpointDescription(serviceReference, endpointDescriptionProperties);
                    try {
                        this.checkEndpointPermission(endpointDescription, "export");
                        exportRegistration = this.exportService(serviceReference, overridingProperties, exportedInterfaces, rsContainers[i], endpointDescriptionProperties);
                    }
                    catch (Exception e) {
                        exportRegistration = new ExportRegistration(e, endpointDescription);
                    }
                }
                if (exportRegistration.getException() == null) {
                    this.addExportRegistration(exportRegistration);
                }
                exportRegistrations.add(exportRegistration);
                ++i;
            }
        }
        for (ExportRegistration exportReg : exportRegistrations) {
            this.publishExportEvent(exportReg);
        }
        return new ArrayList<org.osgi.service.remoteserviceadmin.ExportRegistration>(exportRegistrations);
    }

    private ExportRegistration createErrorExportRegistration(ServiceReference serviceReference, Map<String, Object> overridingProperties, String errorMessage, SelectContainerException exception) {
        ContainerTypeDescription ctd = exception.getContainerTypeDescription();
        overridingProperties.put("endpoint.id", "noendpoint");
        overridingProperties.put("service.imported.configs", ctd == null ? "noconfig" : ctd.getName());
        return new ExportRegistration(exception, new EndpointDescription(serviceReference, overridingProperties));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public org.osgi.service.remoteserviceadmin.ImportRegistration importService(org.osgi.service.remoteserviceadmin.EndpointDescription endpointDescription) {
        this.trace("importService", "endpointDescription=" + endpointDescription);
        this.checkEndpointPermission(endpointDescription, "import");
        EndpointDescription ed = null;
        ed = endpointDescription instanceof EndpointDescription ? (EndpointDescription)endpointDescription : new EndpointDescription(endpointDescription.getProperties());
        IConsumerContainerSelector consumerContainerSelector = this.getConsumerContainerSelector();
        if (consumerContainerSelector == null) {
            this.logError("importService", "No defaultConsumerContainerSelector available");
            return null;
        }
        IRemoteServiceContainer rsContainer = null;
        try {
            rsContainer = consumerContainerSelector.selectConsumerContainer(ed);
        }
        catch (SelectContainerException e) {
            ImportRegistration errorRegistration = new ImportRegistration(ed, e);
            this.publishImportEvent(errorRegistration);
            return errorRegistration;
        }
        if (rsContainer == null) {
            this.logWarning("importService", "No remote service container selected for endpoint=" + endpointDescription + ". Remote service NOT IMPORTED");
            return null;
        }
        ImportRegistration importRegistration = null;
        Collection<ImportRegistration> collection = this.importedRegistrations;
        synchronized (collection) {
            ImportEndpoint importEndpoint = this.findImportEndpoint(ed);
            if (importEndpoint != null) {
                importRegistration = new ImportRegistration(importEndpoint);
            } else {
                importRegistration = this.importService(ed, rsContainer);
                if (importRegistration.getException() == null) {
                    this.addImportRegistration(importRegistration);
                }
            }
        }
        this.publishImportEvent(importRegistration);
        return importRegistration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<org.osgi.service.remoteserviceadmin.ExportReference> getExportedServices() {
        ArrayList<org.osgi.service.remoteserviceadmin.ExportReference> results = new ArrayList<org.osgi.service.remoteserviceadmin.ExportReference>();
        Collection<ExportRegistration> collection = this.exportedRegistrations;
        synchronized (collection) {
            for (ExportRegistration reg : this.exportedRegistrations) {
                org.osgi.service.remoteserviceadmin.ExportReference eRef = reg.getExportReference();
                if (eRef == null || !this.checkEndpointPermissionRead("getExportedServices", eRef.getExportedEndpoint())) continue;
                results.add(eRef);
            }
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<org.osgi.service.remoteserviceadmin.ImportReference> getImportedEndpoints() {
        ArrayList<org.osgi.service.remoteserviceadmin.ImportReference> results = new ArrayList<org.osgi.service.remoteserviceadmin.ImportReference>();
        Collection<ImportRegistration> collection = this.importedRegistrations;
        synchronized (collection) {
            for (ImportRegistration reg : this.importedRegistrations) {
                org.osgi.service.remoteserviceadmin.ImportReference iRef = reg.getImportReference();
                if (iRef == null || !this.checkEndpointPermissionRead("getImportedEndpoints", iRef.getImportedEndpoint())) continue;
                results.add(iRef);
            }
        }
        return results;
    }

    private boolean checkEndpointPermissionRead(String methodName, org.osgi.service.remoteserviceadmin.EndpointDescription endpointDescription) {
        try {
            this.checkEndpointPermission(endpointDescription, "read");
            return true;
        }
        catch (SecurityException e) {
            this.logError(methodName, "permission check failed for read access to endpointDescription=" + endpointDescription, e);
            return false;
        }
    }

    private BundleContext getClientBundleContext() {
        return this.clientBundle.getBundleContext();
    }

    private Bundle getRSABundle() {
        BundleContext bundleContext = Activator.getContext();
        if (bundleContext == null) {
            return null;
        }
        return bundleContext.getBundle();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addImportRegistration(ImportRegistration importRegistration) {
        Collection<ImportRegistration> collection = this.importedRegistrations;
        synchronized (collection) {
            this.importedRegistrations.add(importRegistration);
            this.trace("addImportRegistration", "importRegistration=" + importRegistration + " importedRegistrations=" + this.importedRegistrations);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addExportRegistration(ExportRegistration exportRegistration) {
        Collection<ExportRegistration> collection = this.exportedRegistrations;
        synchronized (collection) {
            this.exportedRegistrations.add(exportRegistration);
            this.trace("addExportRegistration", "exportRegistration=" + exportRegistration + " exportedRegistrations=" + this.exportedRegistrations);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean removeExportRegistration(ExportRegistration exportRegistration) {
        Collection<ExportRegistration> collection = this.exportedRegistrations;
        synchronized (collection) {
            boolean removed = this.exportedRegistrations.remove(exportRegistration);
            this.trace("removeExportRegistration", "exportRegistration=" + exportRegistration + " exportedRegistrations=" + this.exportedRegistrations + " removed=" + removed);
            return removed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean removeImportRegistration(ImportRegistration importRegistration) {
        Collection<ImportRegistration> collection = this.importedRegistrations;
        synchronized (collection) {
            boolean removed = this.importedRegistrations.remove(importRegistration);
            this.trace("removeImportRegistration", "importRegistration=" + importRegistration + " importedRegistrations=" + this.importedRegistrations + " removed=" + removed);
            return removed;
        }
    }

    private void closeDefaultContainerSelectors() {
        if (this.defaultHostContainerSelectorRegistration != null) {
            this.defaultHostContainerSelectorRegistration.unregister();
            this.defaultHostContainerSelectorRegistration = null;
        }
        if (this.defaultHostContainerSelector != null) {
            this.defaultHostContainerSelector.close();
            this.defaultHostContainerSelector = null;
        }
        if (this.defaultConsumerContainerSelectorRegistration != null) {
            this.defaultConsumerContainerSelectorRegistration.unregister();
            this.defaultConsumerContainerSelectorRegistration = null;
        }
        if (this.defaultConsumerContainerSelector != null) {
            this.defaultConsumerContainerSelector.close();
            this.defaultConsumerContainerSelector = null;
        }
    }

    private void checkEndpointPermission(org.osgi.service.remoteserviceadmin.EndpointDescription endpointDescription, String permissionType) throws SecurityException {
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            return;
        }
        sm.checkPermission((Permission)new EndpointPermission(endpointDescription, Activator.getDefault().getFrameworkUUID(), permissionType));
    }

    private void publishEvent(RemoteServiceAdminEvent event, EndpointDescription endpointDescription) {
        EndpointPermission perm = new EndpointPermission((org.osgi.service.remoteserviceadmin.EndpointDescription)endpointDescription, Activator.getDefault().getFrameworkUUID(), "read");
        RemoteServiceAdminListener[] listeners = this.getListeners(perm);
        if (listeners != null) {
            int i = 0;
            while (i < listeners.length) {
                listeners[i].remoteAdminEvent((org.osgi.service.remoteserviceadmin.RemoteServiceAdminEvent)event);
                ++i;
            }
        }
        this.postEvent(event, endpointDescription);
    }

    private void postEvent(RemoteServiceAdminEvent event, EndpointDescription endpointDescription) {
        List importedConfigs;
        List interfaces;
        String endpointId;
        String frameworkUUID;
        long serviceId;
        Throwable t;
        EventAdmin eventAdmin = this.getEventAdmin();
        if (eventAdmin == null) {
            return;
        }
        int eventType = event.getType();
        String eventTypeName = null;
        String registrationTypeName = null;
        switch (eventType) {
            case 2: {
                eventTypeName = "EXPORT_REGISTRATION";
                registrationTypeName = "export.registration";
                break;
            }
            case 6: {
                eventTypeName = "EXPORT_ERROR";
                registrationTypeName = "export.registration";
                break;
            }
            case 3: {
                eventTypeName = "EXPORT_UNREGISTRATION";
                registrationTypeName = "export.registration";
                break;
            }
            case 7: {
                eventTypeName = "EXPORT_WARNING";
                registrationTypeName = "export.registration";
                break;
            }
            case 1: {
                eventTypeName = "IMPORT_REGISTRATION";
                registrationTypeName = "import.registration";
                break;
            }
            case 5: {
                eventTypeName = "IMPORT_ERROR";
                registrationTypeName = "import.registration";
                break;
            }
            case 4: {
                eventTypeName = "IMPORT_UNREGISTRATION";
                registrationTypeName = "import.registration";
                break;
            }
            case 8: {
                eventTypeName = "IMPORT_WARNING";
                registrationTypeName = "import.registration";
            }
        }
        if (eventTypeName == null) {
            this.logError("postEvent", "Event type=" + eventType + " not understood for event=" + (Object)((Object)event) + ".  Not posting");
            return;
        }
        String topic = "org/osgi/service/remoteserviceadmin/" + eventTypeName;
        Bundle rsaBundle = this.getRSABundle();
        if (rsaBundle == null) {
            this.logError("postEvent", "RSA Bundle is null.  Not posting remote service admin event=" + (Object)((Object)event));
            return;
        }
        Properties eventProperties = new Properties();
        ((Dictionary)eventProperties).put("bundle", rsaBundle);
        ((Dictionary)eventProperties).put("bundle.id", new Long(rsaBundle.getBundleId()));
        ((Dictionary)eventProperties).put("bundle.symbolicname", rsaBundle.getSymbolicName());
        ((Dictionary)eventProperties).put("bundle.version", rsaBundle.getVersion());
        String[] signers = this.getSignersForBundle(this.clientBundle);
        if (signers != null && signers.length > 0) {
            ((Dictionary)eventProperties).put("bundle.signer", signers);
        }
        if ((t = event.getException()) != null) {
            ((Dictionary)eventProperties).put("cause", t);
        }
        if ((serviceId = endpointDescription.getServiceId()) != 0L) {
            ((Dictionary)eventProperties).put("endpoint.service.id", new Long(serviceId));
        }
        if ((frameworkUUID = endpointDescription.getFrameworkUUID()) != null) {
            ((Dictionary)eventProperties).put("endpoint.framework.uuid", frameworkUUID);
        }
        if ((endpointId = endpointDescription.getId()) != null) {
            ((Dictionary)eventProperties).put("endpoint.id", endpointId);
        }
        if ((interfaces = endpointDescription.getInterfaces()) != null && interfaces.size() > 0) {
            ((Dictionary)eventProperties).put("objectClass", interfaces.toArray(new String[interfaces.size()]));
        }
        if ((importedConfigs = endpointDescription.getConfigurationTypes()) != null && importedConfigs.size() > 0) {
            ((Dictionary)eventProperties).put("service.imported.configs", importedConfigs.toArray(new String[importedConfigs.size()]));
        }
        ((Dictionary)eventProperties).put("timestamp", new Long(new Date().getTime()));
        ((Dictionary)eventProperties).put("event", event);
        if (registrationTypeName != null) {
            ((Dictionary)eventProperties).put(registrationTypeName, endpointDescription);
        }
        this.postRemoteServiceAdminEvent(topic, eventProperties);
    }

    private String[] getSignersForBundle(Bundle bundle) {
        ArrayList<String> result = new ArrayList<String>();
        Map signers = bundle.getSignerCertificates(1);
        Iterator i = signers.keySet().iterator();
        while (i.hasNext()) {
            result.add(i.next().toString());
        }
        return result.toArray(new String[result.size()]);
    }

    private void publishExportEvent(ExportRegistration exportRegistration) {
        Throwable exception = exportRegistration.getException();
        org.osgi.service.remoteserviceadmin.ExportReference exportReference = exception == null ? exportRegistration.getExportReference() : null;
        RemoteServiceAdminEvent rsaEvent = new RemoteServiceAdminEvent(exportRegistration.getContainerID(), exception == null ? 2 : 6, this.getRSABundle(), exportReference, exception);
        this.publishEvent(rsaEvent, exportRegistration.getEndpointDescription());
    }

    private void publishImportEvent(ImportRegistration importRegistration) {
        Throwable exception = importRegistration.getException();
        org.osgi.service.remoteserviceadmin.ImportReference importReference = exception == null ? importRegistration.getImportReference() : null;
        RemoteServiceAdminEvent rsaEvent = new RemoteServiceAdminEvent(importRegistration.getContainerID(), exception == null ? 1 : 5, this.getRSABundle(), importReference, exception);
        this.publishEvent(rsaEvent, importRegistration.getEndpointDescription());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeRemoteServiceAdminListenerTracker() {
        Object object = this.remoteServiceAdminListenerTrackerLock;
        synchronized (object) {
            if (this.remoteServiceAdminListenerTracker != null) {
                this.remoteServiceAdminListenerTracker.close();
                this.remoteServiceAdminListenerTracker = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RemoteServiceAdminListener[] getListeners(EndpointPermission perm) {
        Object object = this.remoteServiceAdminListenerTrackerLock;
        synchronized (object) {
            if (this.remoteServiceAdminListenerTracker == null) {
                this.remoteServiceAdminListenerTracker = new ServiceTracker(this.getClientBundleContext(), RemoteServiceAdminListener.class.getName(), null);
                this.remoteServiceAdminListenerTracker.open();
            }
        }
        ServiceReference[] unfilteredRefs = this.remoteServiceAdminListenerTracker.getServiceReferences();
        if (unfilteredRefs == null) {
            return null;
        }
        ArrayList<ServiceReference> filteredRefs = new ArrayList<ServiceReference>();
        ServiceReference[] serviceReferenceArray = unfilteredRefs;
        int n = unfilteredRefs.length;
        int n2 = 0;
        while (n2 < n) {
            ServiceReference ref = serviceReferenceArray[n2];
            if (perm == null || ref.getBundle().hasPermission((Object)perm)) {
                filteredRefs.add(ref);
            }
            ++n2;
        }
        ArrayList<RemoteServiceAdminListener> results = new ArrayList<RemoteServiceAdminListener>();
        for (ServiceReference ref : filteredRefs) {
            RemoteServiceAdminListener l = (RemoteServiceAdminListener)this.remoteServiceAdminListenerTracker.getService(ref);
            if (l == null) continue;
            results.add(l);
        }
        return results.toArray(new RemoteServiceAdminListener[results.size()]);
    }

    private ExportEndpoint findExistingExportEndpoint(ServiceReference serviceReference, ID containerID) {
        for (ExportRegistration eReg : this.exportedRegistrations) {
            ExportEndpoint exportEndpoint = eReg.getExportEndpoint(serviceReference, containerID);
            if (exportEndpoint == null) continue;
            return exportEndpoint;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EventAdmin getEventAdmin() {
        Object object = this.eventAdminTrackerLock;
        synchronized (object) {
            this.eventAdminTracker = new ServiceTracker(this.getClientBundleContext(), EventAdmin.class.getName(), null);
            this.eventAdminTracker.open();
        }
        return (EventAdmin)this.eventAdminTracker.getService();
    }

    private void postRemoteServiceAdminEvent(String topic, Dictionary eventProperties) {
        EventAdmin eventAdmin = this.getEventAdmin();
        if (eventAdmin == null) {
            this.logError("postRemoteServiceAdminEvent", "No EventAdmin service available to send eventTopic=" + topic + " eventProperties=" + eventProperties);
            return;
        }
        eventAdmin.postEvent(new Event(topic, eventProperties));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeEventAdminTracker() {
        Object object = this.eventAdminTrackerLock;
        synchronized (object) {
            if (this.eventAdminTracker != null) {
                this.eventAdminTracker.close();
                this.eventAdminTracker = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closePackageAdminTracker() {
        Object object = this.packageAdminTrackerLock;
        synchronized (object) {
            if (this.packageAdminTracker != null) {
                this.packageAdminTracker.close();
                this.packageAdminTracker = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeConsumerContainerSelectorTracker() {
        Object object = this.consumerContainerSelectorTrackerLock;
        synchronized (object) {
            if (this.consumerContainerSelectorTracker != null) {
                this.consumerContainerSelectorTracker.close();
                this.consumerContainerSelectorTracker = null;
            }
        }
        if (this.defaultConsumerContainerSelector != null) {
            this.defaultConsumerContainerSelector.close();
            this.defaultConsumerContainerSelector = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeHostContainerSelectorTracker() {
        Object object = this.hostContainerSelectorTrackerLock;
        synchronized (object) {
            if (this.hostContainerSelectorTracker != null) {
                this.hostContainerSelectorTracker.close();
                this.hostContainerSelectorTracker = null;
            }
        }
        if (this.defaultHostContainerSelector != null) {
            this.defaultHostContainerSelector.close();
            this.defaultHostContainerSelector = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IHostContainerSelector getHostContainerSelector() {
        Object object = this.hostContainerSelectorTrackerLock;
        synchronized (object) {
            if (this.hostContainerSelectorTracker == null) {
                this.hostContainerSelectorTracker = new ServiceTracker(this.getClientBundleContext(), IHostContainerSelector.class.getName(), null);
                this.hostContainerSelectorTracker.open();
            }
        }
        return (IHostContainerSelector)this.hostContainerSelectorTracker.getService();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IConsumerContainerSelector getConsumerContainerSelector() {
        Object object = this.consumerContainerSelectorTrackerLock;
        synchronized (object) {
            if (this.consumerContainerSelectorTracker == null) {
                this.consumerContainerSelectorTracker = new ServiceTracker(this.getClientBundleContext(), IConsumerContainerSelector.class.getName(), null);
                this.consumerContainerSelectorTracker.open();
            }
        }
        return (IConsumerContainerSelector)this.consumerContainerSelectorTracker.getService();
    }

    private Version getPackageVersion(ServiceReference serviceReference, String serviceInterface, String packageName) {
        Object service = this.getClientBundleContext().getService(serviceReference);
        if (service == null) {
            return null;
        }
        Class<?>[] interfaceClasses = service.getClass().getInterfaces();
        if (interfaceClasses == null) {
            return null;
        }
        Class<?> interfaceClass = null;
        int i = 0;
        while (i < interfaceClasses.length) {
            if (interfaceClasses[i].getName().equals(serviceInterface)) {
                interfaceClass = interfaceClasses[i];
            }
            ++i;
        }
        if (interfaceClass == null) {
            return null;
        }
        Bundle providingBundle = FrameworkUtil.getBundle(interfaceClass);
        if (providingBundle == null) {
            return null;
        }
        return this.getVersionForPackage(providingBundle, packageName);
    }

    private Map<String, Object> createExportEndpointDescriptionProperties(ServiceReference serviceReference, Map<String, Object> overridingProperties, String[] exportedInterfaces, String[] serviceIntents, IRemoteServiceContainer rsContainer) {
        String rsFilter;
        String[] idFilter;
        ID connectedID;
        String[] remoteIntentsSupported;
        IContainer container = rsContainer.getContainer();
        ID containerID = container.getID();
        TreeMap<String, Object> endpointDescriptionProperties = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
        endpointDescriptionProperties.put("objectClass", exportedInterfaces);
        int i = 0;
        while (i < exportedInterfaces.length) {
            Version version;
            String packageName = this.getPackageName(exportedInterfaces[i]);
            String packageVersionKey = "endpoint.package.version." + packageName;
            String packageVersion = (String)PropertiesUtil.getPropertyValue(serviceReference, overridingProperties, packageVersionKey);
            if (packageVersion == null && (version = this.getPackageVersion(serviceReference, exportedInterfaces[i], packageName)) != null && !version.equals((Object)Version.emptyVersion)) {
                packageVersion = version.toString();
            }
            if (packageVersion != null) {
                endpointDescriptionProperties.put(packageVersionKey, packageVersion);
            }
            ++i;
        }
        String endpointId = (String)PropertiesUtil.getPropertyValue(serviceReference, overridingProperties, "endpoint.id");
        if (endpointId == null) {
            endpointId = containerID.getName();
        }
        endpointDescriptionProperties.put("endpoint.id", endpointId);
        Long serviceId = (Long)serviceReference.getProperty("service.id");
        endpointDescriptionProperties.put("service.id", serviceId);
        String frameworkId = (String)PropertiesUtil.getPropertyValue(serviceReference, overridingProperties, "endpoint.framework.uuid");
        if (frameworkId == null) {
            frameworkId = Activator.getDefault().getFrameworkUUID();
        }
        endpointDescriptionProperties.put("endpoint.framework.uuid", frameworkId);
        String[] remoteConfigsSupported = this.getSupportedConfigs(container);
        if (remoteConfigsSupported != null) {
            endpointDescriptionProperties.put("remote.configs.supported", remoteConfigsSupported);
        }
        endpointDescriptionProperties.put("service.imported.configs", remoteConfigsSupported);
        String[] intents = PropertiesUtil.getPropertyValue(null, overridingProperties, "service.intents");
        if (intents == null) {
            intents = serviceIntents;
        }
        if (intents != null) {
            endpointDescriptionProperties.put("service.intents", intents);
        }
        if ((remoteIntentsSupported = this.getSupportedIntents(container)) != null) {
            endpointDescriptionProperties.put("remote.intents.supported", remoteIntentsSupported);
        }
        String idNamespace = containerID.getNamespace().getName();
        endpointDescriptionProperties.put("ecf.endpoint.id.ns", idNamespace);
        String connectTarget = (String)PropertiesUtil.getPropertyValue(serviceReference, overridingProperties, "ecf.endpoint.connecttarget.id");
        if (connectTarget == null && (connectedID = rsContainer.getContainer().getConnectedID()) != null && !connectedID.equals((Object)containerID)) {
            connectTarget = connectedID.getName();
        }
        if (connectTarget != null) {
            endpointDescriptionProperties.put("ecf.endpoint.connecttarget.id", connectTarget);
        }
        if ((idFilter = (String[])PropertiesUtil.getPropertyValue(serviceReference, overridingProperties, "ecf.endpoint.idfilter.ids")) != null && idFilter.length > 0) {
            endpointDescriptionProperties.put("ecf.endpoint.idfilter.ids", idFilter);
        }
        if ((rsFilter = (String)PropertiesUtil.getPropertyValue(serviceReference, overridingProperties, "ecf.endpoint.rsfilter")) != null) {
            endpointDescriptionProperties.put("ecf.endpoint.rsfilter", rsFilter);
        }
        return PropertiesUtil.copyNonReservedProperties(overridingProperties, endpointDescriptionProperties);
    }

    private Map<String, Object> copyNonReservedProperties(ServiceReference serviceReference, Map<String, Object> overridingProperties, Map<String, Object> target) {
        PropertiesUtil.copyNonReservedProperties(serviceReference, target);
        PropertiesUtil.copyNonReservedProperties(overridingProperties, target);
        return target;
    }

    private ContainerTypeDescription getContainerTypeDescription(IContainer container) {
        IContainerManager containerManager = Activator.getDefault().getContainerManager();
        if (containerManager == null) {
            return null;
        }
        return containerManager.getContainerTypeDescription(container.getID());
    }

    private String[] getSupportedConfigs(IContainer container) {
        ContainerTypeDescription ctd = this.getContainerTypeDescription(container);
        return ctd == null ? null : ctd.getSupportedConfigs();
    }

    private String[] getImportedConfigs(IContainer container, String[] exporterSupportedConfigs) {
        ContainerTypeDescription ctd = this.getContainerTypeDescription(container);
        return ctd == null ? null : ctd.getImportedConfigs(exporterSupportedConfigs);
    }

    private String[] getSupportedIntents(IContainer container) {
        ContainerTypeDescription ctd = this.getContainerTypeDescription(container);
        return ctd == null ? null : ctd.getSupportedIntents();
    }

    private ID[] getIDFilter(EndpointDescription endpointDescription, ID endpointID) {
        ID[] iDArray;
        ID[] idFilter = endpointDescription.getIDFilter();
        if (idFilter == null) {
            ID[] iDArray2 = new ID[1];
            iDArray = iDArray2;
            iDArray2[0] = endpointID;
        } else {
            iDArray = idFilter;
        }
        return iDArray;
    }

    private String getRemoteServiceFilter(EndpointDescription endpointDescription) {
        long rsId = 0L;
        Long l = (Long)endpointDescription.getProperties().get("ecf.rsvc.id");
        if (l != null) {
            rsId = l;
        }
        if (rsId == 0L) {
            rsId = endpointDescription.getServiceId();
        }
        if (rsId == 0L) {
            return endpointDescription.getRemoteServiceFilter();
        }
        String edRsFilter = endpointDescription.getRemoteServiceFilter();
        StringBuffer result = new StringBuffer("(&(").append("ecf.rsvc.id").append("=").append(rsId).append(")");
        if (edRsFilter != null) {
            result.append(edRsFilter);
        }
        result.append(")");
        return result.toString();
    }

    private ImportEndpoint createAndRegisterProxy(EndpointDescription endpointDescription, IRemoteServiceContainer rsContainer, IRemoteServiceReference selectedRsReference) throws Exception {
        BundleContext proxyServiceFactoryContext = this.getProxyServiceFactoryContext(endpointDescription);
        if (proxyServiceFactoryContext == null) {
            throw new NullPointerException("getProxyServiceFactoryContext returned null.  Cannot register proxy service factory");
        }
        IRemoteServiceContainerAdapter containerAdapter = rsContainer.getContainerAdapter();
        ID rsContainerID = rsContainer.getContainer().getID();
        IRemoteService rs = containerAdapter.getRemoteService(selectedRsReference);
        if (rs == null) {
            throw new NullPointerException("getRemoteService returned null for selectedRsReference=" + selectedRsReference + ",rsContainerID=" + rsContainerID);
        }
        Map proxyProperties = this.createProxyProperties(endpointDescription, rsContainer, selectedRsReference, rs);
        endpointDescription.setPropertiesOverrides(proxyProperties);
        List serviceTypes = endpointDescription.getInterfaces();
        ServiceRegistration proxyRegistration = proxyServiceFactoryContext.registerService(serviceTypes.toArray(new String[serviceTypes.size()]), (Object)this.createProxyServiceFactory(endpointDescription, rs), PropertiesUtil.createDictionaryFromMap(proxyProperties));
        return new ImportEndpoint(containerAdapter, selectedRsReference, new RemoteServiceListener(), proxyRegistration, endpointDescription);
    }

    private BundleContext getProxyServiceFactoryContext(EndpointDescription endpointDescription) throws Exception {
        Activator a = Activator.getDefault();
        if (a == null) {
            throw new NullPointerException("ECF RemoteServiceAdmin Activator cannot be null.");
        }
        if (a.isOldEquinox()) {
            BundleContext rsaContext = Activator.getContext();
            if (rsaContext == null) {
                throw new NullPointerException("RSA BundleContext cannot be null");
            }
            List interfaces = endpointDescription.getInterfaces();
            Collection<Class> serviceInterfaceClasses = this.loadServiceInterfacesViaBundle(rsaContext.getBundle(), interfaces.toArray(new String[interfaces.size()]));
            if (serviceInterfaceClasses.size() == 0) {
                throw new NullPointerException("No interface classes loadable for endpointDescription=" + (Object)((Object)endpointDescription));
            }
            Class serviceInterfaceClass = serviceInterfaceClasses.iterator().next();
            Bundle bundle = FrameworkUtil.getBundle((Class)serviceInterfaceClass);
            if (bundle == null) {
                throw new BundleException("Bundle for service interface class=" + serviceInterfaceClass.getName() + " cannot be found");
            }
            int bundleState = bundle.getState();
            BundleContext bundleContext = bundle.getBundleContext();
            if (bundleContext == null) {
                throw new BundleException("Bundle=" + bundle.getSymbolicName() + " in wrong state (" + bundleState + ") for using BundleContext proxy service factory");
            }
            return bundleContext;
        }
        return a.getProxyServiceFactoryBundleContext();
    }

    private ServiceFactory createProxyServiceFactory(EndpointDescription endpointDescription, IRemoteService remoteService) {
        return new ProxyServiceFactory(endpointDescription.getInterfaceVersions(), remoteService);
    }

    private Collection<Class> loadServiceInterfacesViaBundle(Bundle bundle, String[] interfaces) {
        ArrayList<Class> result = new ArrayList<Class>();
        int i = 0;
        while (i < interfaces.length) {
            try {
                result.add(bundle.loadClass(interfaces[i]));
            }
            catch (ClassNotFoundException e) {
                this.logError("loadInterfacesViaBundle", "interface=" + interfaces[i] + " cannot be loaded by clientBundle=" + bundle.getSymbolicName(), e);
            }
            catch (IllegalStateException e) {
                this.logError("loadInterfacesViaBundle", "interface=" + interfaces[i] + " cannot be loaded since clientBundle is in illegal state", e);
            }
            ++i;
        }
        return result;
    }

    private Object createProxy(Bundle requestingBundle, ServiceReference serviceReference, IRemoteService remoteService, Map<String, Version> interfaceVersions) {
        String bundleSymbolicName = requestingBundle.getSymbolicName();
        String[] serviceClassnames = (String[])serviceReference.getProperty("objectClass");
        Collection<Class> serviceInterfaceClasses = this.loadServiceInterfacesViaBundle(requestingBundle, serviceClassnames);
        if (serviceInterfaceClasses.size() < 1) {
            throw new RuntimeException("ProxyServiceFactory cannot load any serviceInterfaces=" + serviceInterfaceClasses + " for serviceReference=" + serviceReference + " via clientBundle=" + bundleSymbolicName);
        }
        if (!this.verifyServiceInterfaceVersionsForProxy(requestingBundle, serviceInterfaceClasses, interfaceVersions)) {
            return null;
        }
        ClassLoader cl = this.getProxyClassLoader(requestingBundle);
        try {
            return remoteService.getProxy(cl, serviceInterfaceClasses.toArray(new Class[serviceInterfaceClasses.size()]));
        }
        catch (ECFException e) {
            throw new ServiceException("ProxyServiceFactory cannot create proxy for clientBundle=" + bundleSymbolicName + " from serviceReference=" + serviceReference, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeProxyClassLoaderCache() {
        Map<Bundle, ProxyClassLoader> map = this.proxyClassLoaders;
        synchronized (map) {
            this.proxyClassLoaders.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClassLoader getProxyClassLoader(Bundle bundle) {
        ProxyClassLoader proxyClassLoaderForBundle = null;
        Map<Bundle, ProxyClassLoader> map = this.proxyClassLoaders;
        synchronized (map) {
            proxyClassLoaderForBundle = this.proxyClassLoaders.get(bundle);
            if (proxyClassLoaderForBundle == null) {
                proxyClassLoaderForBundle = new ProxyClassLoader(bundle);
                this.proxyClassLoaders.put(bundle, proxyClassLoaderForBundle);
            } else {
                proxyClassLoaderForBundle.addServiceUseCount();
            }
        }
        return proxyClassLoaderForBundle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ungetProxyClassLoader(Bundle bundle) {
        Map<Bundle, ProxyClassLoader> map = this.proxyClassLoaders;
        synchronized (map) {
            ProxyClassLoader proxyClassLoaderForBundle = this.proxyClassLoaders.get(bundle);
            if (proxyClassLoaderForBundle != null) {
                int useCount = proxyClassLoaderForBundle.getServiceUseCount();
                if (useCount == 0) {
                    this.proxyClassLoaders.remove(bundle);
                } else {
                    proxyClassLoaderForBundle.removeServiceUseCount();
                }
            }
        }
    }

    private String getPackageName(String className) {
        int lastDotIndex = className.lastIndexOf(".");
        if (lastDotIndex == -1) {
            return "";
        }
        return className.substring(0, lastDotIndex);
    }

    private boolean comparePackageVersions(String packageName, Version remoteVersion, Version localVersion) throws RuntimeException {
        int compareResult;
        LogUtility.trace("comparePackageVersions", "org.eclipse.ecf.osgi.services.remoteserviceadmin/debug/packageversioncomparator", this.getClass(), "packageName=" + packageName + ",remoteVersion=" + remoteVersion + ",localVersion=" + localVersion);
        if (remoteVersion == null) {
            remoteVersion = Version.emptyVersion;
        }
        if (localVersion == null) {
            localVersion = Version.emptyVersion;
        }
        return (compareResult = localVersion.compareTo(remoteVersion)) != 0;
    }

    private boolean verifyServiceInterfaceVersionsForProxy(Bundle bundle, Collection<Class> classes, Map<String, Version> interfaceVersions) {
        boolean result = true;
        for (Class clazz : classes) {
            Version localVersion;
            Version remoteVersion;
            String className = clazz.getName();
            String packageName = this.getPackageName(className);
            if (!this.comparePackageVersions(packageName, remoteVersion = interfaceVersions.get(className), localVersion = this.getPackageVersionViaRequestingBundle(packageName, bundle))) continue;
            this.logError("verifyServiceInterfaceVersionsForProxy", "Failed version check for proxy creation.  clientBundle=" + this.clientBundle + " interfaceType=" + className + " remoteVersion=" + remoteVersion + " localVersion=" + localVersion);
            result = false;
        }
        return result;
    }

    private Version getVersionForMatchingCapability(String packageName, BundleCapability capability) {
        Map attributes = capability.getAttributes();
        String p = (String)attributes.get("osgi.wiring.package");
        if (p != null && packageName.equals(p)) {
            return (Version)attributes.get("version");
        }
        return null;
    }

    private Version getPackageVersionForMatchingWire(String packageName, List<BundleWire> bundleWires, String namespace) {
        Version result = null;
        for (BundleWire wire : bundleWires) {
            if (namespace.equals("osgi.wiring.package")) {
                result = this.getVersionForMatchingCapability(packageName, wire.getCapability());
            } else if (namespace.equals("osgi.wiring.bundle")) {
                result = this.getVersionForPackage(wire.getProvider().getBundle(), packageName);
            }
            if (result == null) continue;
            return result;
        }
        return result;
    }

    private Version getVersionForPackage(Bundle providingBundle, String packageName) {
        Version result = null;
        BundleRevision providingBundleRevision = (BundleRevision)providingBundle.adapt(BundleRevision.class);
        if (providingBundleRevision == null) {
            return null;
        }
        List providerCapabilities = providingBundleRevision.getDeclaredCapabilities("osgi.wiring.package");
        for (BundleCapability c : providerCapabilities) {
            result = this.getVersionForMatchingCapability(packageName, c);
            if (result == null) continue;
            return result;
        }
        return result;
    }

    private Version getPackageVersionViaRequestingBundle(String packageName, Bundle requestingBundle) {
        BundleWiring requestingBundleWiring;
        Version result = null;
        BundleRevision requestingBundleRevision = (BundleRevision)requestingBundle.adapt(BundleRevision.class);
        if (requestingBundleRevision != null) {
            List requestingBundleCapabilities = requestingBundleRevision.getDeclaredCapabilities("osgi.wiring.package");
            for (BundleCapability requestingBundleCapability : requestingBundleCapabilities) {
                Version version = this.getVersionForMatchingCapability(packageName, requestingBundleCapability);
                if (version == null) continue;
                result = version;
            }
        }
        if (result == null && (requestingBundleWiring = (BundleWiring)requestingBundle.adapt(BundleWiring.class)) != null && (result = this.getPackageVersionForMatchingWire(packageName, requestingBundleWiring.getRequiredWires("osgi.wiring.package"), "osgi.wiring.package")) == null) {
            result = this.getPackageVersionForMatchingWire(packageName, requestingBundleWiring.getRequiredWires("osgi.wiring.bundle"), "osgi.wiring.bundle");
        }
        return result;
    }

    private IRemoteServiceReference selectRemoteServiceReference(Collection<IRemoteServiceReference> rsRefs, ID targetID, ID[] idFilter, Collection<String> interfaces, String rsFilter, IRemoteServiceContainer rsContainer) {
        if (rsRefs.size() == 0) {
            return null;
        }
        if (rsRefs.size() > 1) {
            this.logWarning("selectRemoteServiceReference", "rsRefs=" + rsRefs + ",targetID=" + targetID + ",idFilter=" + idFilter + ",interfaces=" + interfaces + ",rsFilter=" + rsFilter + ",rsContainer=" + rsContainer.getContainer().getID() + " has " + rsRefs.size() + " values.  Selecting the first element");
        }
        return rsRefs.iterator().next();
    }

    private Map createProxyProperties(EndpointDescription endpointDescription, IRemoteServiceContainer rsContainer, IRemoteServiceReference rsReference, IRemoteService remoteService) {
        String serviceImportedType;
        TreeMap<String, Object> resultProperties = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
        PropertiesUtil.copyNonReservedProperties(rsReference, resultProperties);
        resultProperties.remove("ecf.robjectClass");
        resultProperties.remove("ecf.rsvc.id");
        Object intentsValue = PropertiesUtil.convertToStringPlusValue(endpointDescription.getIntents());
        if (intentsValue != null) {
            resultProperties.put("service.intents", intentsValue);
        }
        if ((serviceImportedType = (String)endpointDescription.getProperties().get("ecf.service.imported.valuetype")) == null || serviceImportedType.equals(IRemoteService.class.getName())) {
            resultProperties.put("service.imported", remoteService);
        } else {
            resultProperties.put("service.imported", new Boolean(true));
        }
        String[] exporterSupportedConfigs = (String[])endpointDescription.getProperties().get("remote.configs.supported");
        String[] importedConfigs = this.getImportedConfigs(rsContainer.getContainer(), exporterSupportedConfigs);
        resultProperties.put("service.imported.configs", importedConfigs);
        resultProperties.put("ecf.service.imported.endpoint.id", endpointDescription.getProperties().get("endpoint.id"));
        resultProperties.put("ecf.service.imported.endpoint.service.id", endpointDescription.getProperties().get("endpoint.service.id"));
        return resultProperties;
    }

    private ExportRegistration exportService(ServiceReference serviceReference, Map<String, ?> overridingProperties, String[] exportedInterfaces, IRemoteServiceContainer rsContainer, Map<String, Object> endpointDescriptionProperties) throws Exception {
        Map<String, Object> remoteServiceProperties = this.copyNonReservedProperties(serviceReference, overridingProperties, new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER));
        IRemoteServiceContainerAdapter containerAdapter = rsContainer.getContainerAdapter();
        IRemoteServiceRegistration remoteRegistration = null;
        if (containerAdapter instanceof IOSGiRemoteServiceContainerAdapter) {
            IOSGiRemoteServiceContainerAdapter osgiContainerAdapter = (IOSGiRemoteServiceContainerAdapter)containerAdapter;
            remoteRegistration = osgiContainerAdapter.registerRemoteService(exportedInterfaces, serviceReference, PropertiesUtil.createDictionaryFromMap(remoteServiceProperties));
        } else {
            remoteRegistration = containerAdapter.registerRemoteService(exportedInterfaces, this.getClientBundleContext().getService(serviceReference), PropertiesUtil.createDictionaryFromMap(remoteServiceProperties));
        }
        endpointDescriptionProperties.put("endpoint.service.id", remoteRegistration.getProperty("ecf.rsvc.id"));
        EndpointDescription endpointDescription = new EndpointDescription(serviceReference, endpointDescriptionProperties);
        return new ExportRegistration(new ExportEndpoint(serviceReference, endpointDescription, remoteRegistration));
    }

    private ImportRegistration importService(EndpointDescription endpointDescription, IRemoteServiceContainer rsContainer) {
        this.trace("doImportService", "endpointDescription=" + (Object)((Object)endpointDescription) + ",rsContainerID=" + rsContainer.getContainer().getID());
        List interfaces = endpointDescription.getInterfaces();
        Assert.isNotNull((Object)interfaces);
        Assert.isTrue((interfaces.size() > 0 ? 1 : 0) != 0);
        ID endpointContainerID = endpointDescription.getContainerID();
        Assert.isNotNull((Object)endpointContainerID);
        ID targetID = endpointDescription.getConnectTargetID();
        if (targetID == null) {
            targetID = endpointContainerID;
        }
        ID[] idFilter = this.getIDFilter(endpointDescription, endpointContainerID);
        String rsFilter = this.getRemoteServiceFilter(endpointDescription);
        ArrayList<IRemoteServiceReference> rsRefs = new ArrayList<IRemoteServiceReference>();
        IRemoteServiceContainerAdapter containerAdapter = rsContainer.getContainerAdapter();
        ID rsContainerID = rsContainer.getContainer().getID();
        try {
            String intf = (String)interfaces.iterator().next();
            IRemoteServiceReference[] refs = containerAdapter.getRemoteServiceReferences(targetID, idFilter, intf, rsFilter);
            if (refs == null) {
                this.logWarning("doImportService", "getRemoteServiceReferences return null for targetID=" + targetID + ",idFilter=" + idFilter + ",intf=" + intf + ",rsFilter=" + rsFilter + " on rsContainerID=" + rsContainerID);
            } else {
                int i = 0;
                while (i < refs.length) {
                    rsRefs.add(refs[i]);
                    ++i;
                }
            }
            IRemoteServiceReference selectedRsReference = this.selectRemoteServiceReference(rsRefs, targetID, idFilter, interfaces, rsFilter, rsContainer);
            if (selectedRsReference == null) {
                throw new RemoteReferenceNotFoundException(targetID, idFilter, interfaces, rsFilter);
            }
            return new ImportRegistration(this.createAndRegisterProxy(endpointDescription, rsContainer, selectedRsReference));
        }
        catch (Exception e) {
            this.logError("importService", "selectRemoteServiceReference returned null for rsRefs=" + rsRefs + ",targetID=" + targetID + ",idFilter=" + idFilter + ",interfaces=" + interfaces + ",rsFilter=" + rsFilter + ",rsContainerID=" + rsContainerID, e);
            return new ImportRegistration(endpointDescription, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeExportRegistrations() {
        ArrayList<ExportRegistration> toClose = null;
        Collection<ExportRegistration> collection = this.exportedRegistrations;
        synchronized (collection) {
            toClose = new ArrayList<ExportRegistration>(this.exportedRegistrations);
            this.exportedRegistrations.clear();
        }
        for (ExportRegistration reg : toClose) {
            reg.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeImportRegistrations() {
        ArrayList<ImportRegistration> toClose = null;
        Collection<ImportRegistration> collection = this.importedRegistrations;
        synchronized (collection) {
            toClose = new ArrayList<ImportRegistration>(this.importedRegistrations);
            this.importedRegistrations.clear();
        }
        for (ImportRegistration reg : toClose) {
            reg.close();
        }
    }

    public void close() {
        this.trace("close", "closing importedRegistrations=" + this.importedRegistrations + " exportedRegistrations=" + this.exportedRegistrations);
        this.closeRemoteServiceAdminListenerTracker();
        this.closeEventAdminTracker();
        this.closePackageAdminTracker();
        this.closeProxyClassLoaderCache();
        this.closeConsumerContainerSelectorTracker();
        this.closeHostContainerSelectorTracker();
        this.closeDefaultContainerSelectors();
        this.closeImportRegistrations();
        this.closeExportRegistrations();
        this.clientBundle = null;
    }

    private ImportEndpoint findImportEndpoint(EndpointDescription ed) {
        for (ImportRegistration reg : this.importedRegistrations) {
            ImportEndpoint endpoint = reg.getImportEndpoint(ed);
            if (endpoint == null) continue;
            return endpoint;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unimportService(IRemoteServiceID remoteServiceID) {
        ArrayList<ImportRegistration> removedRegistrations = new ArrayList<ImportRegistration>();
        Collection<ImportRegistration> collection = this.importedRegistrations;
        synchronized (collection) {
            for (ImportRegistration importRegistration : this.importedRegistrations) {
                if (importRegistration == null || !importRegistration.match(remoteServiceID)) continue;
                removedRegistrations.add(importRegistration);
            }
        }
        for (ImportRegistration removedReg : removedRegistrations) {
            this.trace("unimportService", "closing importRegistration=" + removedReg);
            removedReg.close();
        }
    }

    private void trace(String methodName, String message) {
        LogUtility.trace(methodName, "org.eclipse.ecf.osgi.services.remoteserviceadmin/debug/remoteserviceadmin", this.getClass(), message);
    }

    private void logWarning(String methodName, String message) {
        LogUtility.logWarning(methodName, "org.eclipse.ecf.osgi.services.remoteserviceadmin/debug/remoteserviceadmin", this.getClass(), message);
    }

    private void logError(String methodName, String message, Throwable t) {
        LogUtility.logError(methodName, "org.eclipse.ecf.osgi.services.remoteserviceadmin/debug/remoteserviceadmin", this.getClass(), message, t);
    }

    private void logError(String methodName, String message) {
        this.logError(methodName, message, null);
    }

    class ExportEndpoint {
        private ServiceReference serviceReference;
        private EndpointDescription endpointDescription;
        private IRemoteServiceRegistration rsRegistration;
        private Set<ExportRegistration> activeExportRegistrations = new HashSet<ExportRegistration>();

        ExportEndpoint(ServiceReference serviceReference, EndpointDescription endpointDescription, IRemoteServiceRegistration reg) {
            Assert.isNotNull((Object)serviceReference);
            this.serviceReference = serviceReference;
            Assert.isNotNull((Object)((Object)endpointDescription));
            this.endpointDescription = endpointDescription;
            Assert.isNotNull((Object)reg);
            this.rsRegistration = reg;
        }

        synchronized ID getContainerID() {
            return this.endpointDescription.getContainerID();
        }

        synchronized ServiceReference getServiceReference() {
            return this.serviceReference;
        }

        synchronized EndpointDescription getEndpointDescription() {
            return this.endpointDescription;
        }

        synchronized IRemoteServiceRegistration getRemoteServiceRegistration() {
            return this.rsRegistration;
        }

        synchronized boolean addExportRegistration(ExportRegistration exportRegistration) {
            return this.activeExportRegistrations.add(exportRegistration);
        }

        synchronized boolean close(ExportRegistration exportRegistration) {
            boolean removed = this.activeExportRegistrations.remove(exportRegistration);
            if (removed && this.activeExportRegistrations.size() == 0) {
                if (this.rsRegistration != null) {
                    this.rsRegistration.unregister();
                    this.rsRegistration = null;
                }
                this.serviceReference = null;
                this.endpointDescription = null;
            }
            return removed;
        }
    }

    class ExportReference
    implements org.osgi.service.remoteserviceadmin.ExportReference {
        private ExportEndpoint exportEndpoint;
        private Throwable exception;
        private EndpointDescription errorEndpointDescription;

        ExportReference(ExportEndpoint exportEndpoint) {
            Assert.isNotNull((Object)exportEndpoint);
            this.exportEndpoint = exportEndpoint;
        }

        ExportReference(Throwable exception, EndpointDescription errorEndpointDescription) {
            Assert.isNotNull((Object)exception);
            this.exception = exception;
            Assert.isNotNull((Object)exception);
            this.errorEndpointDescription = errorEndpointDescription;
        }

        synchronized Throwable getException() {
            return this.exception;
        }

        synchronized boolean close(ExportRegistration exportRegistration) {
            if (this.exportEndpoint == null) {
                return false;
            }
            boolean result = this.exportEndpoint.close(exportRegistration);
            this.exportEndpoint = null;
            return result;
        }

        synchronized ExportEndpoint getExportEndpoint() {
            return this.exportEndpoint;
        }

        synchronized IRemoteServiceRegistration getRemoteServiceRegistration() {
            return this.exportEndpoint == null ? null : this.exportEndpoint.getRemoteServiceRegistration();
        }

        synchronized ID getContainerID() {
            return this.exportEndpoint == null ? null : this.exportEndpoint.getContainerID();
        }

        public synchronized ServiceReference getExportedService() {
            return this.exportEndpoint == null ? null : this.exportEndpoint.getServiceReference();
        }

        public synchronized org.osgi.service.remoteserviceadmin.EndpointDescription getExportedEndpoint() {
            return this.exportEndpoint == null ? null : this.exportEndpoint.getEndpointDescription();
        }

        synchronized EndpointDescription getEndpointDescription() {
            return this.exportEndpoint == null ? this.errorEndpointDescription : this.exportEndpoint.getEndpointDescription();
        }
    }

    class ExportRegistration
    implements org.osgi.service.remoteserviceadmin.ExportRegistration {
        private ExportReference exportReference;
        private boolean closed = false;

        ExportRegistration(ExportEndpoint exportEndpoint) {
            Assert.isNotNull((Object)exportEndpoint);
            exportEndpoint.addExportRegistration(this);
            this.exportReference = new ExportReference(exportEndpoint);
        }

        ExportRegistration(Throwable exception, EndpointDescription errorEndpointDescription) {
            Assert.isNotNull((Object)exception);
            this.exportReference = new ExportReference(exception, errorEndpointDescription);
            this.closed = true;
        }

        ID getContainerID() {
            return this.exportReference.getContainerID();
        }

        ServiceReference getServiceReference() {
            return this.exportReference.getExportedService();
        }

        public org.osgi.service.remoteserviceadmin.ExportReference getExportReference() {
            Throwable t = this.getException();
            if (t != null) {
                throw new IllegalStateException("Cannot get export reference as export registration is invalid", t);
            }
            return this.exportReference;
        }

        boolean match(ServiceReference serviceReference) {
            return this.match(serviceReference, null);
        }

        boolean match(ServiceReference serviceReference, ID containerID) {
            ServiceReference ourServiceReference = this.getServiceReference();
            if (ourServiceReference == null) {
                return false;
            }
            boolean serviceReferenceCompare = ourServiceReference.equals(serviceReference);
            if (containerID == null) {
                return serviceReferenceCompare;
            }
            ID ourContainerID = this.getContainerID();
            if (ourContainerID == null) {
                return false;
            }
            return serviceReferenceCompare && ourContainerID.equals((Object)containerID);
        }

        synchronized ExportEndpoint getExportEndpoint(ServiceReference serviceReference, ID containerID) {
            return this.match(serviceReference, containerID) ? this.exportReference.getExportEndpoint() : null;
        }

        IRemoteServiceRegistration getRemoteServiceRegistration() {
            return this.exportReference.getRemoteServiceRegistration();
        }

        EndpointDescription getEndpointDescription() {
            return this.exportReference.getEndpointDescription();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            boolean publish = false;
            ID containerID = null;
            Throwable exception = null;
            EndpointDescription endpointDescription = null;
            ExportRegistration exportRegistration = this;
            synchronized (exportRegistration) {
                if (!this.closed) {
                    containerID = this.getContainerID();
                    exception = this.getException();
                    endpointDescription = this.getEndpointDescription();
                    publish = this.exportReference.close(this);
                    this.closed = true;
                }
            }
            RemoteServiceAdmin.this.removeExportRegistration(this);
            Bundle rsaBundle = RemoteServiceAdmin.this.getRSABundle();
            if (publish && rsaBundle != null) {
                RemoteServiceAdmin.this.publishEvent(new RemoteServiceAdminEvent(containerID, 3, rsaBundle, this.exportReference, exception), endpointDescription);
            }
        }

        public Throwable getException() {
            return this.exportReference.getException();
        }
    }

    class ImportEndpoint {
        private IRemoteServiceContainerAdapter rsContainerAdapter;
        private EndpointDescription endpointDescription;
        private IRemoteServiceListener rsListener;
        private IRemoteServiceReference rsReference;
        private ServiceRegistration proxyRegistration;
        private Set<ImportRegistration> activeImportRegistrations = new HashSet<ImportRegistration>();

        ImportEndpoint(IRemoteServiceContainerAdapter rsContainerAdapter, IRemoteServiceReference rsReference, IRemoteServiceListener rsListener, ServiceRegistration proxyRegistration, EndpointDescription endpointDescription) {
            this.rsContainerAdapter = rsContainerAdapter;
            this.endpointDescription = endpointDescription;
            this.rsReference = rsReference;
            this.rsListener = rsListener;
            this.proxyRegistration = proxyRegistration;
            this.rsContainerAdapter.addRemoteServiceListener(this.rsListener);
        }

        synchronized EndpointDescription getEndpointDescription() {
            return this.endpointDescription;
        }

        synchronized ServiceRegistration getProxyRegistration() {
            return this.proxyRegistration;
        }

        synchronized ID getContainerID() {
            return this.rsReference == null ? null : this.rsReference.getContainerID();
        }

        synchronized boolean addImportRegistration(ImportRegistration importRegistration) {
            return this.activeImportRegistrations.add(importRegistration);
        }

        synchronized boolean close(ImportRegistration importRegistration) {
            boolean removed = this.activeImportRegistrations.remove(importRegistration);
            if (removed && this.activeImportRegistrations.size() == 0) {
                if (this.proxyRegistration != null) {
                    this.proxyRegistration.unregister();
                    this.proxyRegistration = null;
                }
                if (this.rsContainerAdapter != null) {
                    if (this.rsReference != null) {
                        this.rsContainerAdapter.ungetRemoteService(this.rsReference);
                        this.rsReference = null;
                    }
                    if (this.rsListener != null) {
                        this.rsContainerAdapter.removeRemoteServiceListener(this.rsListener);
                        this.rsListener = null;
                    }
                    this.rsContainerAdapter = null;
                }
                this.endpointDescription = null;
            }
            return removed;
        }

        synchronized boolean match(IRemoteServiceID remoteServiceID) {
            if (remoteServiceID == null || this.rsReference == null) {
                return false;
            }
            return this.rsReference.getID().equals((Object)remoteServiceID);
        }

        synchronized boolean match(EndpointDescription ed) {
            if (this.activeImportRegistrations.size() == 0) {
                return false;
            }
            return this.endpointDescription.isSameService(ed);
        }
    }

    class ImportReference
    implements org.osgi.service.remoteserviceadmin.ImportReference {
        private ImportEndpoint importEndpoint;
        private Throwable exception;
        private EndpointDescription errorEndpointDescription;

        ImportReference(ImportEndpoint importEndpoint) {
            Assert.isNotNull((Object)importEndpoint);
            this.importEndpoint = importEndpoint;
        }

        ImportReference(EndpointDescription endpointDescription, Throwable exception) {
            Assert.isNotNull((Object)exception);
            this.exception = exception;
            Assert.isNotNull((Object)((Object)endpointDescription));
            this.errorEndpointDescription = endpointDescription;
        }

        synchronized Throwable getException() {
            return this.exception;
        }

        synchronized boolean match(IRemoteServiceID remoteServiceID) {
            return this.importEndpoint == null ? null : Boolean.valueOf(this.importEndpoint.match(remoteServiceID));
        }

        synchronized ImportEndpoint match(EndpointDescription ed) {
            if (this.importEndpoint != null && this.importEndpoint.match(ed)) {
                return this.importEndpoint;
            }
            return null;
        }

        synchronized EndpointDescription getEndpointDescription() {
            return this.importEndpoint == null ? this.errorEndpointDescription : this.importEndpoint.getEndpointDescription();
        }

        synchronized ID getContainerID() {
            return this.importEndpoint == null ? null : this.importEndpoint.getContainerID();
        }

        public synchronized ServiceReference getImportedService() {
            return this.importEndpoint == null ? null : this.importEndpoint.getProxyRegistration().getReference();
        }

        public synchronized org.osgi.service.remoteserviceadmin.EndpointDescription getImportedEndpoint() {
            return this.importEndpoint == null ? null : this.importEndpoint.getEndpointDescription();
        }

        synchronized boolean close(ImportRegistration importRegistration) {
            if (this.importEndpoint == null) {
                return false;
            }
            boolean result = this.importEndpoint.close(importRegistration);
            this.importEndpoint = null;
            return result;
        }
    }

    class ImportRegistration
    implements org.osgi.service.remoteserviceadmin.ImportRegistration {
        private ImportReference importReference;
        private boolean closed = false;

        ImportRegistration(ImportEndpoint importEndpoint) {
            Assert.isNotNull((Object)importEndpoint);
            importEndpoint.addImportRegistration(this);
            this.importReference = new ImportReference(importEndpoint);
        }

        ImportRegistration(EndpointDescription errorEndpointDescription, Throwable exception) {
            this.importReference = new ImportReference(errorEndpointDescription, exception);
        }

        ID getContainerID() {
            return this.importReference.getContainerID();
        }

        EndpointDescription getEndpointDescription() {
            return this.importReference.getEndpointDescription();
        }

        boolean match(IRemoteServiceID remoteServiceID) {
            return this.importReference.match(remoteServiceID);
        }

        ImportEndpoint getImportEndpoint(EndpointDescription ed) {
            return this.importReference.match(ed);
        }

        public org.osgi.service.remoteserviceadmin.ImportReference getImportReference() {
            Throwable t = this.getException();
            if (t != null) {
                throw new IllegalStateException("Cannot get import reference as registration not properly initialized", t);
            }
            return this.importReference;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            boolean publish = false;
            ID containerID = null;
            Throwable exception = null;
            EndpointDescription endpointDescription = null;
            ImportRegistration importRegistration = this;
            synchronized (importRegistration) {
                if (!this.closed) {
                    containerID = this.getContainerID();
                    exception = this.getException();
                    endpointDescription = this.getEndpointDescription();
                    publish = this.importReference.close(this);
                    this.closed = true;
                }
            }
            RemoteServiceAdmin.this.removeImportRegistration(this);
            Bundle rsaBundle = RemoteServiceAdmin.this.getRSABundle();
            if (publish && rsaBundle != null) {
                RemoteServiceAdmin.this.publishEvent(new RemoteServiceAdminEvent(containerID, 4, rsaBundle, this.importReference, exception), endpointDescription);
            }
        }

        public Throwable getException() {
            return this.importReference.getException();
        }
    }

    protected class ProxyClassLoader
    extends ClassLoader {
        private Bundle loadingBundle;
        private int serviceUseCount = 0;

        public ProxyClassLoader(Bundle loadingBundle) {
            this.loadingBundle = loadingBundle;
        }

        public Class loadClass(String name) throws ClassNotFoundException {
            return this.loadingBundle.loadClass(name);
        }

        public int getServiceUseCount() {
            return this.serviceUseCount;
        }

        public void addServiceUseCount() {
            ++this.serviceUseCount;
        }

        public void removeServiceUseCount() {
            --this.serviceUseCount;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ProxyServiceFactory
    implements ServiceFactory {
        private IRemoteService remoteService;
        private Map<String, Version> interfaceVersions;

        public ProxyServiceFactory(Map<String, Version> interfaceVersions, IRemoteService remoteService) {
            this.interfaceVersions = interfaceVersions;
            this.remoteService = remoteService;
        }

        public Object getService(Bundle bundle, ServiceRegistration registration) {
            return RemoteServiceAdmin.this.createProxy(bundle, registration.getReference(), this.remoteService, this.interfaceVersions);
        }

        public void ungetService(Bundle bundle, ServiceRegistration registration, Object service) {
            RemoteServiceAdmin.this.ungetProxyClassLoader(bundle);
        }
    }

    public class RemoteServiceAdminEvent
    extends org.osgi.service.remoteserviceadmin.RemoteServiceAdminEvent {
        private ID containerID;

        public RemoteServiceAdminEvent(ID containerID, int type, Bundle source, org.osgi.service.remoteserviceadmin.ExportReference exportReference, Throwable exception) {
            super(type, source, exportReference, exception);
            this.containerID = containerID;
        }

        public RemoteServiceAdminEvent(ID containerID, int type, Bundle source, org.osgi.service.remoteserviceadmin.ImportReference importReference, Throwable exception) {
            super(type, source, importReference, exception);
            this.containerID = containerID;
        }

        public ID getContainerID() {
            return this.containerID;
        }

        public String toString() {
            return "RemoteServiceAdminEvent[containerID=" + this.containerID + ", getType()=" + this.getType() + ", getSource()=" + this.getSource() + ", getException()=" + this.getException() + ", getImportReference()=" + this.getImportReference() + ", getExportReference()=" + this.getExportReference() + "]";
        }
    }

    class RemoteServiceListener
    implements IRemoteServiceListener {
        RemoteServiceListener() {
        }

        public void handleServiceEvent(IRemoteServiceEvent event) {
            if (event instanceof IRemoteServiceUnregisteredEvent) {
                RemoteServiceAdmin.this.unimportService(event.getReference().getID());
            }
        }
    }
}

