/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core.op;

import java.util.Collection;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.egit.core.Activator;
import org.eclipse.egit.core.CoreText;
import org.eclipse.egit.core.internal.job.RuleUtil;
import org.eclipse.egit.core.internal.util.ResourceUtil;
import org.eclipse.egit.core.op.IEGitOperation;
import org.eclipse.egit.core.project.RepositoryMapping;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.ResetCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.Repository;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoveFromIndexOperation
implements IEGitOperation {
    private final Map<Repository, Collection<String>> pathsByRepository;

    public RemoveFromIndexOperation(Collection<IPath> paths) {
        this.pathsByRepository = ResourceUtil.splitPathsByRepository(paths);
    }

    @Deprecated
    public RemoveFromIndexOperation(Repository repo, IResource[] resources) {
        this.pathsByRepository = ResourceUtil.splitResourcesByRepository(resources);
    }

    @Override
    public void execute(IProgressMonitor m) throws CoreException {
        IProgressMonitor monitor = m != null ? m : new NullProgressMonitor();
        monitor.beginTask(CoreText.RemoveFromIndexOperation_removingFilesFromIndex, this.pathsByRepository.size());
        for (Map.Entry<Repository, Collection<String>> entry : this.pathsByRepository.entrySet()) {
            Repository repository = entry.getKey();
            Collection<String> paths = entry.getValue();
            ResetCommand resetCommand = new Git(repository).reset();
            resetCommand.setRef("HEAD");
            for (String path : paths) {
                if (path == "") {
                    resetCommand.addPath(".");
                    continue;
                }
                resetCommand.addPath(path);
            }
            try {
                try {
                    resetCommand.call();
                    monitor.worked(1);
                }
                catch (GitAPIException e) {
                    Activator.logError(e.getMessage(), e);
                    RepositoryMapping.findRepositoryMapping(repository).fireRepositoryChanged();
                    continue;
                }
            }
            catch (Throwable throwable) {
                RepositoryMapping.findRepositoryMapping(repository).fireRepositoryChanged();
                throw throwable;
            }
            RepositoryMapping.findRepositoryMapping(repository).fireRepositoryChanged();
        }
        monitor.done();
    }

    @Override
    public ISchedulingRule getSchedulingRule() {
        return RuleUtil.getRuleForRepositories(this.pathsByRepository.keySet());
    }
}

