/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.CompareUI;
import org.eclipse.compare.IContentChangeListener;
import org.eclipse.compare.IContentChangeNotifier;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.structuremergeviewer.DiffNode;
import org.eclipse.compare.structuremergeviewer.IDiffElement;
import org.eclipse.compare.structuremergeviewer.IStructureComparator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.egit.core.RevUtils;
import org.eclipse.egit.core.internal.CompareCoreUtils;
import org.eclipse.egit.core.internal.storage.GitFileRevision;
import org.eclipse.egit.core.internal.storage.WorkingTreeFileRevision;
import org.eclipse.egit.core.internal.storage.WorkspaceFileRevision;
import org.eclipse.egit.core.project.RepositoryMapping;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.UIText;
import org.eclipse.egit.ui.internal.EditableRevision;
import org.eclipse.egit.ui.internal.FileRevisionTypedElement;
import org.eclipse.egit.ui.internal.GitCompareFileRevisionEditorInput;
import org.eclipse.egit.ui.internal.merge.GitCompareEditorInput;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.util.OpenStrategy;
import org.eclipse.jgit.dircache.DirCache;
import org.eclipse.jgit.dircache.DirCacheEditor;
import org.eclipse.jgit.dircache.DirCacheEntry;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectInserter;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.filter.AndTreeFilter;
import org.eclipse.jgit.treewalk.filter.PathFilter;
import org.eclipse.jgit.treewalk.filter.TreeFilter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.team.core.history.IFileRevision;
import org.eclipse.team.ui.synchronize.SaveableCompareEditorInput;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IReusableEditor;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.actions.ActionFactory;

public class CompareUtils {
    private static final String REUSE_COMPARE_EDITOR_PREFID = "org.eclipse.team.ui.reuse_open_compare_editors";
    private static final String TEAM_UI_PLUGIN = "org.eclipse.team.ui";

    public static ITypedElement getFileRevisionTypedElement(String gitPath, RevCommit commit, Repository db) {
        return CompareUtils.getFileRevisionTypedElement(gitPath, commit, db, null);
    }

    public static ITypedElement getFileRevisionTypedElement(String gitPath, RevCommit commit, Repository db, ObjectId blobId) {
        Object right = new GitCompareFileRevisionEditorInput.EmptyTypedElement(NLS.bind((String)UIText.GitHistoryPage_FileNotInCommit, (Object)CompareUtils.getName(gitPath), (Object)commit));
        try {
            IFileRevision nextFile = CompareUtils.getFileRevision(gitPath, commit, db, blobId);
            if (nextFile != null) {
                String encoding = CompareCoreUtils.getResourceEncoding((Repository)db, (String)gitPath);
                right = new FileRevisionTypedElement(nextFile, encoding);
            }
        }
        catch (IOException e) {
            Activator.error(NLS.bind((String)UIText.GitHistoryPage_errorLookingUpPath, (Object)gitPath, (Object)commit.getId()), e);
        }
        return right;
    }

    private static String getName(String gitPath) {
        int last = gitPath.lastIndexOf(47);
        return last >= 0 ? gitPath.substring(last + 1) : gitPath;
    }

    public static IFileRevision getFileRevision(String gitPath, RevCommit commit, Repository db, ObjectId blobId) throws IOException {
        TreeWalk w = TreeWalk.forPath((Repository)db, (String)gitPath, (RevTree)commit.getTree());
        if (w != null) {
            GitFileRevision fileRevision = GitFileRevision.inCommit((Repository)db, (RevCommit)commit, (String)gitPath, (ObjectId)blobId);
            return fileRevision;
        }
        return null;
    }

    public static ITypedElement getFileRevisionTypedElementForCommonAncestor(String gitPath, ObjectId commit1, ObjectId commit2, Repository db) {
        ITypedElement ancestor = null;
        RevCommit commonAncestor = null;
        try {
            commonAncestor = RevUtils.getCommonAncestor((Repository)db, (AnyObjectId)commit1, (AnyObjectId)commit2);
        }
        catch (IOException e) {
            Activator.logError(NLS.bind((String)UIText.CompareUtils_errorCommonAncestor, (Object)commit1.getName(), (Object)commit2.getName()), e);
        }
        if (commonAncestor != null) {
            ancestor = CompareUtils.getFileRevisionTypedElement(gitPath, commonAncestor, db);
        }
        return ancestor;
    }

    public static Object getAdapter(Object element, Class adapterType) {
        return CompareUtils.getAdapter(element, adapterType, false);
    }

    public static String truncatedRevision(String ci) {
        if (ci.length() > 10) {
            return String.valueOf(ci.substring(0, 7)) + "...";
        }
        return ci;
    }

    private static Object getAdapter(Object element, Class adapterType, boolean load) {
        Object adapted;
        if (adapterType.isInstance(element)) {
            return element;
        }
        if (element instanceof IAdaptable && adapterType.isInstance(adapted = ((IAdaptable)element).getAdapter(adapterType))) {
            return adapted;
        }
        if (load ? adapterType.isInstance(adapted = Platform.getAdapterManager().loadAdapter(element, adapterType.getName())) : adapterType.isInstance(adapted = Platform.getAdapterManager().getAdapter(element, adapterType))) {
            return adapted;
        }
        return null;
    }

    public static void openInCompare(IWorkbenchPage workBenchPage, CompareEditorInput input) {
        IEditorPart editor = CompareUtils.findReusableCompareEditor(input, workBenchPage);
        if (editor != null) {
            IEditorInput otherInput = editor.getEditorInput();
            if (otherInput.equals(input)) {
                if (OpenStrategy.activateOnOpen()) {
                    workBenchPage.activate((IWorkbenchPart)editor);
                } else {
                    workBenchPage.bringToTop((IWorkbenchPart)editor);
                }
            } else {
                CompareUI.reuseCompareEditor((CompareEditorInput)input, (IReusableEditor)((IReusableEditor)editor));
                if (OpenStrategy.activateOnOpen()) {
                    workBenchPage.activate((IWorkbenchPart)editor);
                } else {
                    workBenchPage.bringToTop((IWorkbenchPart)editor);
                }
            }
        } else {
            CompareUI.openCompareEditor((CompareEditorInput)input);
        }
    }

    private static IEditorPart findReusableCompareEditor(CompareEditorInput input, IWorkbenchPage page) {
        IEditorPart part;
        IEditorReference[] editorRefs = page.getEditorReferences();
        int i = 0;
        while (i < editorRefs.length) {
            part = editorRefs[i].getEditor(false);
            if (part != null && (part.getEditorInput() instanceof GitCompareFileRevisionEditorInput || part.getEditorInput() instanceof GitCompareEditorInput) && part instanceof IReusableEditor && part.getEditorInput().equals(input)) {
                return part;
            }
            ++i;
        }
        if (CompareUtils.isReuseOpenEditor()) {
            i = 0;
            while (i < editorRefs.length) {
                part = editorRefs[i].getEditor(false);
                if (part != null && part.getEditorInput() instanceof SaveableCompareEditorInput && part instanceof IReusableEditor && !part.isDirty()) {
                    return part;
                }
                ++i;
            }
        }
        return null;
    }

    private static boolean isReuseOpenEditor() {
        boolean defaultReuse = DefaultScope.INSTANCE.getNode(TEAM_UI_PLUGIN).getBoolean(REUSE_COMPARE_EDITOR_PREFID, false);
        return InstanceScope.INSTANCE.getNode(TEAM_UI_PLUGIN).getBoolean(REUSE_COMPARE_EDITOR_PREFID, defaultReuse);
    }

    private static void setReuseOpenEditor(boolean value) {
        InstanceScope.INSTANCE.getNode(TEAM_UI_PLUGIN).putBoolean(REUSE_COMPARE_EDITOR_PREFID, value);
    }

    public static void compareHeadWithWorkspace(Repository repository, IFile file) {
        String path = RepositoryMapping.getMapping((IResource)file).getRepoRelativePath((IResource)file);
        ITypedElement base = CompareUtils.getHeadTypedElement(repository, path);
        if (base == null) {
            return;
        }
        WorkspaceFileRevision nextFile = new WorkspaceFileRevision((IResource)file);
        String encoding = null;
        try {
            encoding = file.getCharset();
        }
        catch (CoreException e) {
            Activator.handleError(UIText.CompareUtils_errorGettingEncoding, e, true);
        }
        FileRevisionTypedElement next = new FileRevisionTypedElement((IFileRevision)nextFile, encoding);
        GitCompareFileRevisionEditorInput input = new GitCompareFileRevisionEditorInput(next, base, null);
        CompareUI.openCompareDialog((CompareEditorInput)input);
    }

    public static void compareHeadWithWorkingTree(Repository repository, String path) {
        ITypedElement base = CompareUtils.getHeadTypedElement(repository, path);
        if (base == null) {
            return;
        }
        WorkingTreeFileRevision nextFile = new WorkingTreeFileRevision(new File(repository.getWorkTree(), path));
        String encoding = ResourcesPlugin.getEncoding();
        FileRevisionTypedElement next = new FileRevisionTypedElement((IFileRevision)nextFile, encoding);
        GitCompareFileRevisionEditorInput input = new GitCompareFileRevisionEditorInput(next, base, null);
        CompareUI.openCompareDialog((CompareEditorInput)input);
    }

    public static ITypedElement getHeadTypedElement(Repository repository, String repoRelativePath) {
        try {
            RevCommit latestFileCommit;
            Ref head = repository.getRef("HEAD");
            if (head == null || head.getObjectId() == null) {
                return new GitCompareFileRevisionEditorInput.EmptyTypedElement("");
            }
            RevWalk rw = new RevWalk(repository);
            try {
                RevCommit headCommit = rw.parseCommit((AnyObjectId)head.getObjectId());
                rw.markStart(headCommit);
                rw.setTreeFilter(AndTreeFilter.create((TreeFilter)PathFilter.create((String)repoRelativePath), (TreeFilter)TreeFilter.ANY_DIFF));
                latestFileCommit = rw.next();
                if (latestFileCommit == null) {
                    latestFileCommit = headCommit;
                }
            }
            finally {
                rw.release();
            }
            return CompareUtils.getFileRevisionTypedElement(repoRelativePath, latestFileCommit, repository);
        }
        catch (IOException e) {
            Activator.handleError(UIText.CompareUtils_errorGettingHeadCommit, e, true);
            return null;
        }
    }

    public static ITypedElement getIndexTypedElement(IFile baseFile) throws IOException {
        RepositoryMapping mapping = RepositoryMapping.getMapping((IResource)baseFile);
        Repository repository = mapping.getRepository();
        String gitPath = mapping.getRepoRelativePath((IResource)baseFile);
        String encoding = CompareCoreUtils.getResourceEncoding((IResource)baseFile);
        return CompareUtils.getIndexTypedElement(repository, gitPath, encoding);
    }

    public static ITypedElement getIndexTypedElement(Repository repository, String repoRelativePath) throws IOException {
        String encoding = CompareCoreUtils.getResourceEncoding((Repository)repository, (String)repoRelativePath);
        return CompareUtils.getIndexTypedElement(repository, repoRelativePath, encoding);
    }

    private static ITypedElement getIndexTypedElement(final Repository repository, final String gitPath, String encoding) throws IOException {
        DirCacheEntry entry;
        DirCache dc = repository.lockDirCache();
        try {
            entry = dc.getEntry(gitPath);
        }
        finally {
            dc.unlock();
        }
        GitFileRevision nextFile = GitFileRevision.inIndex((Repository)repository, (String)gitPath);
        final EditableRevision next = new EditableRevision((IFileRevision)nextFile, encoding);
        IContentChangeListener listener = new IContentChangeListener(){

            public void contentChanged(IContentChangeNotifier source) {
                byte[] newContent = next.getModifiedContent();
                DirCache cache = null;
                try {
                    try {
                        cache = repository.lockDirCache();
                        DirCacheEditor editor = cache.editor();
                        if (newContent.length == 0) {
                            editor.add((DirCacheEditor.PathEdit)new DirCacheEditor.DeletePath(gitPath));
                        } else {
                            editor.add((DirCacheEditor.PathEdit)new DirCacheEntryEditor(gitPath, repository, entry, newContent));
                        }
                        try {
                            editor.commit();
                        }
                        catch (RuntimeException e) {
                            if (e.getCause() instanceof IOException) {
                                throw (IOException)e.getCause();
                            }
                            throw e;
                        }
                    }
                    catch (IOException e) {
                        Activator.handleError(UIText.CompareWithIndexAction_errorOnAddToIndex, e, true);
                        if (cache != null) {
                            cache.unlock();
                        }
                    }
                }
                finally {
                    if (cache != null) {
                        cache.unlock();
                    }
                }
            }
        };
        next.addContentChangeListener(listener);
        return next;
    }

    public static DiffNode prepareGitCompare(ITypedElement actLeft, ITypedElement actRight) {
        if (actLeft.getType().equals("FOLDER")) {
            ITypedElement child;
            DiffNode childDiffNode;
            ITypedElement ln;
            DiffNode diffNode = new DiffNode(null, 3, null, actLeft, actRight);
            ITypedElement[] lc = (ITypedElement[])((IStructureComparator)actLeft).getChildren();
            ITypedElement[] rc = (ITypedElement[])((IStructureComparator)actRight).getChildren();
            int li = 0;
            int ri = 0;
            while (li < lc.length && ri < rc.length) {
                ITypedElement child2;
                int n;
                int n2;
                ITypedElement[] iTypedElementArray;
                ITypedElement[] children;
                DiffNode childDiffNode2;
                ln = lc[li];
                ITypedElement rn = rc[ri];
                int compareTo = ln.getName().compareTo(rn.getName());
                if (compareTo == 0) {
                    if (!ln.equals(rn)) {
                        diffNode.add((IDiffElement)CompareUtils.prepareGitCompare(ln, rn));
                    }
                    ++li;
                    ++ri;
                    continue;
                }
                if (compareTo < 0) {
                    childDiffNode2 = new DiffNode(1, null, ln, null);
                    diffNode.add((IDiffElement)childDiffNode2);
                    if (ln.getType().equals("FOLDER") && (children = (ITypedElement[])((IStructureComparator)ln).getChildren()) != null && children.length > 0) {
                        iTypedElementArray = children;
                        n2 = children.length;
                        n = 0;
                        while (n < n2) {
                            child2 = iTypedElementArray[n];
                            childDiffNode2.add((IDiffElement)CompareUtils.addDirectoryFiles(child2, 1));
                            ++n;
                        }
                    }
                    ++li;
                    continue;
                }
                childDiffNode2 = new DiffNode(2, null, null, rn);
                diffNode.add((IDiffElement)childDiffNode2);
                if (rn.getType().equals("FOLDER") && (children = (ITypedElement[])((IStructureComparator)rn).getChildren()) != null && children.length > 0) {
                    iTypedElementArray = children;
                    n2 = children.length;
                    n = 0;
                    while (n < n2) {
                        child2 = iTypedElementArray[n];
                        childDiffNode2.add((IDiffElement)CompareUtils.addDirectoryFiles(child2, 2));
                        ++n;
                    }
                }
                ++ri;
            }
            while (li < lc.length) {
                ITypedElement[] children;
                ln = lc[li];
                childDiffNode = new DiffNode(1, null, ln, null);
                diffNode.add((IDiffElement)childDiffNode);
                if (ln.getType().equals("FOLDER") && (children = (ITypedElement[])((IStructureComparator)ln).getChildren()) != null && children.length > 0) {
                    ITypedElement[] iTypedElementArray = children;
                    int n = children.length;
                    int n3 = 0;
                    while (n3 < n) {
                        child = iTypedElementArray[n3];
                        childDiffNode.add((IDiffElement)CompareUtils.addDirectoryFiles(child, 1));
                        ++n3;
                    }
                }
                ++li;
            }
            while (ri < rc.length) {
                ITypedElement[] children;
                ITypedElement rn = rc[ri];
                childDiffNode = new DiffNode(2, null, null, rn);
                diffNode.add((IDiffElement)childDiffNode);
                if (rn.getType().equals("FOLDER") && (children = (ITypedElement[])((IStructureComparator)rn).getChildren()) != null && children.length > 0) {
                    ITypedElement[] iTypedElementArray = children;
                    int n = children.length;
                    int n4 = 0;
                    while (n4 < n) {
                        child = iTypedElementArray[n4];
                        childDiffNode.add((IDiffElement)CompareUtils.addDirectoryFiles(child, 2));
                        ++n4;
                    }
                }
                ++ri;
            }
            return diffNode;
        }
        return new DiffNode(actLeft, actRight);
    }

    private static DiffNode addDirectoryFiles(ITypedElement elem, int diffType) {
        ITypedElement l = null;
        ITypedElement r = null;
        if (diffType == 2) {
            r = elem;
        } else {
            l = elem;
        }
        if (elem.getType().equals("FOLDER")) {
            ITypedElement[] children;
            DiffNode diffNode = null;
            diffNode = new DiffNode(null, 3, null, l, r);
            ITypedElement[] iTypedElementArray = children = (ITypedElement[])((IStructureComparator)elem).getChildren();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                ITypedElement child = iTypedElementArray[n2];
                diffNode.add((IDiffElement)CompareUtils.addDirectoryFiles(child, diffType));
                ++n2;
            }
            return diffNode;
        }
        return new DiffNode(diffType, null, l, r);
    }

    private static class DirCacheEntryEditor
    extends DirCacheEditor.PathEdit {
        private final Repository repo;
        private final DirCacheEntry oldEntry;
        private final byte[] newContent;

        public DirCacheEntryEditor(String path, Repository repo, DirCacheEntry oldEntry, byte[] newContent) {
            super(path);
            this.repo = repo;
            this.oldEntry = oldEntry;
            this.newContent = newContent;
        }

        public void apply(DirCacheEntry ent) {
            ObjectInserter inserter = this.repo.newObjectInserter();
            if (this.oldEntry != null) {
                ent.copyMetaData(this.oldEntry);
            } else {
                ent.setFileMode(FileMode.REGULAR_FILE);
            }
            ent.setLength(this.newContent.length);
            ent.setLastModified(System.currentTimeMillis());
            ByteArrayInputStream in = new ByteArrayInputStream(this.newContent);
            try {
                try {
                    ent.setObjectId((AnyObjectId)inserter.insert(3, (long)this.newContent.length, (InputStream)in));
                    inserter.flush();
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
            }
            catch (Throwable throwable) {
                try {
                    ((InputStream)in).close();
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                ((InputStream)in).close();
            }
            catch (IOException iOException) {}
        }
    }

    public static class ReuseCompareEditorAction
    extends Action
    implements IEclipsePreferences.IPreferenceChangeListener,
    ActionFactory.IWorkbenchAction {
        IEclipsePreferences node = InstanceScope.INSTANCE.getNode("org.eclipse.team.ui");

        public ReuseCompareEditorAction() {
            this.node.addPreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this);
            this.setText(UIText.GitHistoryPage_ReuseCompareEditorMenuLabel);
            this.setChecked(CompareUtils.isReuseOpenEditor());
        }

        public void run() {
            CompareUtils.setReuseOpenEditor(this.isChecked());
        }

        public void dispose() {
            this.node.removePreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this);
        }

        public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
            this.setChecked(CompareUtils.isReuseOpenEditor());
        }
    }
}

