/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.actions;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.egit.core.op.DiscardChangesOperation;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.JobFamilies;
import org.eclipse.egit.ui.UIText;
import org.eclipse.egit.ui.internal.actions.RepositoryActionHandler;
import org.eclipse.egit.ui.internal.operations.GitScopeUtil;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryState;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;

public class DiscardChangesActionHandler
extends RepositoryActionHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchPart part = this.getPart(event);
        boolean performAction = MessageDialog.openConfirm((Shell)this.getShell(event), (String)UIText.DiscardChangesAction_confirmActionTitle, (String)UIText.DiscardChangesAction_confirmActionMessage);
        if (!performAction) {
            return null;
        }
        final DiscardChangesOperation operation = this.createOperation(part, event);
        if (operation == null) {
            return null;
        }
        String jobname = UIText.DiscardChangesAction_discardChanges;
        Job job = new Job(jobname){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    operation.execute(monitor);
                }
                catch (CoreException e) {
                    return Activator.createErrorStatus(e.getStatus().getMessage(), e);
                }
                return Status.OK_STATUS;
            }

            public boolean belongsTo(Object family) {
                if (family.equals(JobFamilies.DISCARD_CHANGES)) {
                    return true;
                }
                return super.belongsTo(family);
            }
        };
        job.setUser(true);
        job.setRule(operation.getSchedulingRule());
        job.schedule();
        return null;
    }

    public boolean isEnabled() {
        IResource[] iResourceArray = this.getSelectedResources();
        int n = iResourceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IResource res = iResourceArray[n2];
            IProject[] proj = new IProject[]{res.getProject()};
            Repository[] repositories = this.getRepositoriesFor(proj);
            if (repositories.length == 0) {
                return false;
            }
            Repository repository = repositories[0];
            if (!repository.getRepositoryState().equals((Object)RepositoryState.SAFE)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private DiscardChangesOperation createOperation(IWorkbenchPart part, ExecutionEvent event) throws ExecutionException {
        IResource[] resourcesInScope;
        String revision;
        IResource[] selectedResources = this.gatherResourceToOperateOn(event);
        try {
            revision = this.gatherRevision(event);
        }
        catch (OperationCanceledException operationCanceledException) {
            return null;
        }
        try {
            resourcesInScope = GitScopeUtil.getRelatedChanges(part, selectedResources);
        }
        catch (InterruptedException interruptedException) {
            return null;
        }
        return new DiscardChangesOperation(resourcesInScope, revision);
    }

    protected IResource[] gatherResourceToOperateOn(ExecutionEvent event) throws ExecutionException {
        return this.getSelectedResources(event);
    }

    protected String gatherRevision(ExecutionEvent event) throws ExecutionException {
        return null;
    }
}

