/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.commit;

import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.UIIcons;
import org.eclipse.egit.ui.internal.commit.RepositoryCommit;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.notes.Note;
import org.eclipse.jgit.notes.NoteMap;
import org.eclipse.jgit.util.IO;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class RepositoryCommitNote
extends PlatformObject
implements IWorkbenchAdapter {
    private RepositoryCommit commit;
    private Ref ref;
    private Note note;

    public RepositoryCommitNote(RepositoryCommit commit, Ref ref, Note note) {
        Assert.isNotNull((Object)((Object)commit), (String)"Commit cannot be null");
        Assert.isNotNull((Object)ref, (String)"Ref cannot be null");
        Assert.isNotNull((Object)note, (String)"Note cannot be null");
        this.commit = commit;
        this.ref = ref;
        this.note = note;
    }

    public String getNoteText() {
        try {
            ObjectLoader loader = this.commit.getRepository().open((AnyObjectId)this.note.getData(), 3);
            byte[] contents = loader.isLarge() ? IO.readWholeStream((InputStream)loader.openStream(), (int)((int)loader.getSize())).array() : loader.getCachedBytes();
            return new String(contents);
        }
        catch (IOException e) {
            Activator.logError("Error loading note text", e);
            return "";
        }
    }

    public Object getAdapter(Class adapter) {
        if (RepositoryCommit.class == adapter) {
            return this.commit;
        }
        if (Repository.class == adapter) {
            return this.commit.getRepository();
        }
        return super.getAdapter(adapter);
    }

    public Object[] getChildren(Object o) {
        return new Object[0];
    }

    public ImageDescriptor getImageDescriptor(Object object) {
        return UIIcons.NOTE;
    }

    public String getLabel(Object o) {
        return NoteMap.shortenRefName((String)this.ref.getName());
    }

    public Object getParent(Object o) {
        return this.commit;
    }
}

