/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.decorators;

import java.io.IOException;
import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.UIText;
import org.eclipse.egit.ui.internal.decorators.GitDocument;
import org.eclipse.egit.ui.internal.trace.GitTraceLocation;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.ide.ResourceUtil;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.quickdiff.IQuickDiffReferenceProvider;

public class GitQuickDiffProvider
implements IQuickDiffReferenceProvider {
    private String id;
    private GitDocument document;
    private IResource resource;
    static Map<Repository, String> baseline = new WeakHashMap<Repository, String>();

    public GitQuickDiffProvider() {
        if (GitTraceLocation.QUICKDIFF.isActive()) {
            GitTraceLocation.getTrace().traceEntry(GitTraceLocation.QUICKDIFF.getLocation());
        }
    }

    public void dispose() {
        if (GitTraceLocation.QUICKDIFF.isActive()) {
            GitTraceLocation.getTrace().traceEntry(GitTraceLocation.QUICKDIFF.getLocation());
        }
        if (this.document != null) {
            this.document.dispose();
        }
    }

    public String getId() {
        return this.id;
    }

    public IDocument getReference(IProgressMonitor monitor) throws CoreException {
        if (GitTraceLocation.QUICKDIFF.isActive()) {
            GitTraceLocation.getTrace().trace(GitTraceLocation.QUICKDIFF.getLocation(), "(GitQuickDiffProvider) file: " + this.resource);
        }
        if (this.resource == null) {
            return null;
        }
        RepositoryProvider provider = RepositoryProvider.getProvider((IProject)this.resource.getProject());
        if (provider != null) {
            try {
                this.document = GitDocument.create(this.resource);
            }
            catch (IOException e) {
                Activator.error(UIText.QuickDiff_failedLoading, e);
            }
            return this.document;
        }
        return null;
    }

    public boolean isEnabled() {
        return this.resource != null && RepositoryProvider.getProvider((IProject)this.resource.getProject(), (String)"org.eclipse.egit.core.GitProvider") != null;
    }

    public void setActiveEditor(ITextEditor editor) {
        if (GitTraceLocation.QUICKDIFF.isActive()) {
            GitTraceLocation.getTrace().traceEntry(GitTraceLocation.QUICKDIFF.getLocation(), (Object)editor.getTitle());
        }
        IEditorInput editorInput = editor.getEditorInput();
        this.resource = ResourceUtil.getResource((IEditorInput)editorInput);
    }

    public void setId(String id) {
        this.id = id;
    }

    public static void setBaselineReference(Repository repository, String baseline) throws IOException {
        GitQuickDiffProvider.baseline.put(repository, baseline);
        GitDocument.refreshRelevant(repository);
    }
}

