/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.history;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.UIText;
import org.eclipse.egit.ui.UIUtils;
import org.eclipse.egit.ui.internal.actions.BooleanPrefAction;
import org.eclipse.egit.ui.internal.history.CommitNavigationListener;
import org.eclipse.egit.ui.internal.history.FileDiff;
import org.eclipse.egit.ui.internal.history.FormatJob;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.preference.IPersistentPreferenceStore;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.DefaultTextDoubleClickStrategy;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextDoubleClickStrategy;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jgit.events.ListenerHandle;
import org.eclipse.jgit.events.RefsChangedEvent;
import org.eclipse.jgit.events.RefsChangedListener;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revplot.PlotCommit;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.progress.IWorkbenchSiteProgressService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CommitMessageViewer
extends TextViewer
implements ISelectionChangedListener {
    private static final Color SYS_LINKCOLOR = PlatformUI.getWorkbench().getDisplay().getSystemColor(9);
    private static final Color SYS_DARKGRAY = PlatformUI.getWorkbench().getDisplay().getSystemColor(16);
    private static final Color SYS_HUNKHEADER_COLOR = PlatformUI.getWorkbench().getDisplay().getSystemColor(9);
    private static final Color SYS_LINES_ADDED_COLOR = PlatformUI.getWorkbench().getDisplay().getSystemColor(6);
    private static final Color SYS_LINES_REMOVED_COLOR = PlatformUI.getWorkbench().getDisplay().getSystemColor(4);
    private static final Cursor SYS_LINK_CURSOR = PlatformUI.getWorkbench().getDisplay().getSystemCursor(21);
    private final Cursor sys_normalCursor;
    private final ListenerList navListeners = new ListenerList();
    private final List<FileDiff> currentDiffs = new ArrayList<FileDiff>();
    private final IPropertyChangeListener listener;
    private Repository db;
    private PlotCommit<?> commit;
    private boolean fill;
    private FormatJob formatJob;
    private final IWorkbenchPartSite partSite;
    private List<Ref> allRefs;
    private ListenerHandle refsChangedListener;

    CommitMessageViewer(Composite parent, final IPageSite site, IWorkbenchPartSite partSite) {
        super(parent, 776);
        this.partSite = partSite;
        final StyledText t = this.getTextWidget();
        t.setFont(UIUtils.getFont("org.eclipse.egit.ui.CommitMessageFont"));
        this.sys_normalCursor = t.getCursor();
        t.addListener(5, new Listener(){

            public void handleEvent(Event e) {
                if (CommitMessageViewer.this.getStyleRange(e.x, e.y) instanceof ObjectLink) {
                    t.setCursor(SYS_LINK_CURSOR);
                } else {
                    t.setCursor(CommitMessageViewer.this.sys_normalCursor);
                }
            }
        });
        t.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                if (e.button != 1) {
                    return;
                }
                StyleRange r = CommitMessageViewer.this.getStyleRange(e.x, e.y);
                if (r instanceof ObjectLink) {
                    RevCommit c = ((ObjectLink)r).targetCommit;
                    Object[] objectArray = CommitMessageViewer.this.navListeners.getListeners();
                    int n = objectArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object l = objectArray[n2];
                        ((CommitNavigationListener)l).showCommit(c);
                        ++n2;
                    }
                }
            }
        });
        this.setTextDoubleClickStrategy((ITextDoubleClickStrategy)new DefaultTextDoubleClickStrategy(), "__dftl_partition_content_type");
        this.activatePlugins();
        this.listener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (event.getProperty().equals("resourcehistory_show_comment_wrap")) {
                    CommitMessageViewer.this.setWrap((Boolean)event.getNewValue());
                    return;
                }
                if (event.getProperty().equals("resourcehistory_fill_comment_paragraph")) {
                    CommitMessageViewer.this.setFill((Boolean)event.getNewValue());
                    return;
                }
                if (event.getProperty().equals("HistoryView_ShowTagSequence")) {
                    CommitMessageViewer.this.format();
                    return;
                }
            }
        };
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        store.addPropertyChangeListener(this.listener);
        this.fill = store.getBoolean("resourcehistory_fill_comment_paragraph");
        this.setWrap(store.getBoolean("resourcehistory_show_comment_wrap"));
        Action selectAll = new Action(){

            public void run() {
                CommitMessageViewer.this.doOperation(7);
            }

            public boolean isEnabled() {
                return CommitMessageViewer.this.canDoOperation(7);
            }
        };
        Action copy = new Action(){

            public void run() {
                CommitMessageViewer.this.doOperation(4);
            }

            public boolean isEnabled() {
                return CommitMessageViewer.this.canDoOperation(4);
            }
        };
        this.getControl().addFocusListener(new FocusListener((IAction)selectAll, (IAction)copy){
            private final /* synthetic */ IAction val$selectAll;
            private final /* synthetic */ IAction val$copy;
            {
                this.val$selectAll = iAction;
                this.val$copy = iAction2;
            }

            public void focusLost(FocusEvent e) {
                site.getActionBars().setGlobalActionHandler(ActionFactory.SELECT_ALL.getId(), null);
                site.getActionBars().setGlobalActionHandler(ActionFactory.COPY.getId(), null);
                site.getActionBars().updateActionBars();
            }

            public void focusGained(FocusEvent e) {
                site.getActionBars().setGlobalActionHandler(ActionFactory.SELECT_ALL.getId(), this.val$selectAll);
                site.getActionBars().setGlobalActionHandler(ActionFactory.COPY.getId(), this.val$copy);
                site.getActionBars().updateActionBars();
            }
        });
        MenuManager mgr = new MenuManager();
        Control c = this.getControl();
        c.setMenu(mgr.createContextMenu(c));
        IPersistentPreferenceStore pstore = (IPersistentPreferenceStore)store;
        BooleanPrefAction showTagSequence = new BooleanPrefAction(pstore, "HistoryView_ShowTagSequence", UIText.ResourceHistory_ShowTagSequence){

            protected void apply(boolean value) {
            }
        };
        mgr.add((IAction)showTagSequence);
        BooleanPrefAction wrapComments = new BooleanPrefAction(pstore, "resourcehistory_show_comment_wrap", UIText.ResourceHistory_toggleCommentWrap){

            protected void apply(boolean value) {
            }
        };
        mgr.add((IAction)wrapComments);
        BooleanPrefAction fillParagraphs = new BooleanPrefAction(pstore, "resourcehistory_fill_comment_paragraph", UIText.ResourceHistory_toggleCommentFill){

            protected void apply(boolean value) {
            }
        };
        mgr.add((IAction)fillParagraphs);
    }

    void addDoneListenerToFormatJob() {
        this.formatJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                if (!event.getResult().isOK()) {
                    return;
                }
                final StyledText text = CommitMessageViewer.this.getTextWidget();
                if (text == null || text.isDisposed()) {
                    return;
                }
                final FormatJob job = (FormatJob)event.getJob();
                text.getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        if (text.isDisposed()) {
                            return;
                        }
                        CommitMessageViewer.this.setDocument((IDocument)new Document(job.getFormatResult().getCommitInfo()));
                        text.setStyleRanges(job.getFormatResult().getStyleRange());
                    }
                });
            }
        });
    }

    protected void handleDispose() {
        if (this.formatJob != null) {
            this.formatJob.cancel();
            this.formatJob = null;
        }
        Activator.getDefault().getPreferenceStore().removePropertyChangeListener(this.listener);
        if (this.refsChangedListener != null) {
            this.refsChangedListener.remove();
        }
        this.refsChangedListener = null;
        super.handleDispose();
    }

    void addCommitNavigationListener(CommitNavigationListener l) {
        this.navListeners.add((Object)l);
    }

    void removeCommitNavigationListener(CommitNavigationListener l) {
        this.navListeners.remove((Object)l);
    }

    public void setInput(Object input) {
        if (input == this.commit) {
            return;
        }
        this.currentDiffs.clear();
        this.commit = (PlotCommit)input;
        this.allRefs = this.getBranches();
        if (this.refsChangedListener != null) {
            this.refsChangedListener.remove();
        }
        this.refsChangedListener = this.db.getListenerList().addRefsChangedListener(new RefsChangedListener(){

            public void onRefsChanged(RefsChangedEvent event) {
                CommitMessageViewer.this.allRefs = CommitMessageViewer.this.getBranches();
            }
        });
        this.format();
    }

    public Object getInput() {
        return this.commit;
    }

    void setRepository(Repository repository) {
        this.db = repository;
    }

    private List<Ref> getBranches() {
        ArrayList<Ref> ref = new ArrayList<Ref>();
        try {
            ref.addAll(this.db.getRefDatabase().getRefs("refs/heads/").values());
            ref.addAll(this.db.getRefDatabase().getRefs("refs/remotes/").values());
        }
        catch (IOException e) {
            Activator.logError(e.getMessage(), e);
        }
        return ref;
    }

    private Repository getRepository() {
        if (this.db == null) {
            throw new IllegalStateException("Repository has not been set");
        }
        return this.db;
    }

    private void format() {
        if (this.commit == null) {
            this.setDocument((IDocument)new Document(""));
            return;
        }
        if (this.formatJob != null && this.formatJob.getState() != 0) {
            this.formatJob.cancel();
        }
        this.scheduleFormatJob();
    }

    private void scheduleFormatJob() {
        IWorkbenchSiteProgressService siteService = (IWorkbenchSiteProgressService)this.partSite.getAdapter(IWorkbenchSiteProgressService.class);
        if (siteService == null) {
            return;
        }
        FormatJob.FormatRequest formatRequest = new FormatJob.FormatRequest(this.getRepository(), this.commit, this.fill, this.currentDiffs, SYS_LINKCOLOR, SYS_DARKGRAY, SYS_HUNKHEADER_COLOR, SYS_LINES_ADDED_COLOR, SYS_LINES_REMOVED_COLOR, this.allRefs);
        this.formatJob = new FormatJob(formatRequest);
        this.addDoneListenerToFormatJob();
        siteService.schedule((Job)this.formatJob, 0L, true);
    }

    private void setWrap(boolean wrap) {
        this.getTextWidget().setWordWrap(wrap);
    }

    private void setFill(boolean fill) {
        this.fill = fill;
        this.format();
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.currentDiffs.clear();
        ISelection selection = event.getSelection();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection sel = (IStructuredSelection)selection;
            for (Object obj : sel.toList()) {
                if (!(obj instanceof FileDiff)) continue;
                this.currentDiffs.add((FileDiff)((Object)obj));
            }
        }
        this.format();
    }

    private StyleRange getStyleRange(int x, int y) {
        int offset;
        StyledText t = this.getTextWidget();
        try {
            offset = t.getOffsetAtLocation(new Point(x, y));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
        if (offset < t.getCharCount()) {
            return t.getStyleRangeAtOffset(offset);
        }
        return null;
    }

    static final class ObjectLink
    extends StyleRange {
        RevCommit targetCommit;

        ObjectLink() {
        }

        public boolean similarTo(StyleRange style) {
            if (!(style instanceof ObjectLink)) {
                return false;
            }
            if (this.targetCommit != ((ObjectLink)style).targetCommit) {
                return false;
            }
            return super.similarTo(style);
        }

        public boolean equals(Object object) {
            return super.equals(object) && this.targetCommit.equals((AnyObjectId)((ObjectLink)((Object)object)).targetCommit);
        }

        public int hashCode() {
            return super.hashCode() ^ this.targetCommit.hashCode();
        }
    }
}

