/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.history;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.egit.core.op.CreatePatchOperation;
import org.eclipse.egit.core.project.RepositoryMapping;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.UIIcons;
import org.eclipse.egit.ui.UIText;
import org.eclipse.egit.ui.internal.history.LocationPage;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.treewalk.filter.PathFilter;
import org.eclipse.jgit.treewalk.filter.PathFilterGroup;
import org.eclipse.jgit.treewalk.filter.TreeFilter;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GitCreatePatchWizard
extends Wizard {
    private RevCommit commit;
    private Repository db;
    private Collection<? extends IResource> resources;
    private LocationPage locationPage;
    private OptionsPage optionsPage;
    private static final int INITIAL_WIDTH = 300;
    private static final int INITIAL_HEIGHT = 150;
    private static final String FORMAT_KEY = "GitCreatePatchWizard.OptionsPage.format";
    private static final String CONTEXT_LINES_KEY = "GitCreatePatchWizard.OptionsPage.contextLines";

    public static void run(Shell shell, RevCommit commit, Repository db, Collection<? extends IResource> resources) {
        String title = UIText.GitCreatePatchWizard_CreatePatchTitle;
        GitCreatePatchWizard wizard = new GitCreatePatchWizard(commit, db, resources);
        wizard.setWindowTitle(title);
        WizardDialog dialog = new WizardDialog(shell, (IWizard)wizard);
        dialog.setMinimumPageSize(300, 150);
        dialog.setHelpAvailable(false);
        dialog.open();
    }

    public GitCreatePatchWizard(RevCommit commit, Repository db, Collection<? extends IResource> resources) {
        this.commit = commit;
        this.db = db;
        this.resources = resources;
        this.setDialogSettings(GitCreatePatchWizard.getOrCreateSection(Activator.getDefault().getDialogSettings(), "GitCreatePatchWizard"));
    }

    private static IDialogSettings getOrCreateSection(IDialogSettings settings, String sectionName) {
        IDialogSettings section = settings.getSection(sectionName);
        if (section == null) {
            section = settings.addNewSection(sectionName);
        }
        return section;
    }

    public void addPages() {
        String pageTitle = UIText.GitCreatePatchWizard_SelectLocationTitle;
        String pageDescription = UIText.GitCreatePatchWizard_SelectLocationDescription;
        this.locationPage = new LocationPage(pageTitle, pageTitle, UIIcons.WIZBAN_CREATE_PATCH);
        this.locationPage.setDescription(pageDescription);
        this.addPage((IWizardPage)this.locationPage);
        pageTitle = UIText.GitCreatePatchWizard_SelectOptionsTitle;
        pageDescription = UIText.GitCreatePatchWizard_SelectOptionsDescription;
        this.optionsPage = new OptionsPage(pageTitle, pageTitle, UIIcons.WIZBAN_CREATE_PATCH);
        this.optionsPage.setDescription(pageDescription);
        this.addPage((IWizardPage)this.optionsPage);
    }

    public boolean performFinish() {
        final CreatePatchOperation operation = new CreatePatchOperation(this.db, this.commit);
        operation.setHeaderFormat(this.optionsPage.getSelectedHeaderFormat());
        operation.setContextLines(Integer.parseInt(this.optionsPage.contextLines.getText()));
        operation.setPathFilter(this.createPathFilter(this.resources));
        final File file = this.locationPage.getFile();
        if (file != null && !this.validateFile(file)) {
            return false;
        }
        try {
            this.getContainer().run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException {
                    try {
                        operation.execute(monitor);
                        String content = operation.getPatchContent();
                        if (file != null) {
                            GitCreatePatchWizard.this.writeToFile(file, content);
                            IFile[] files = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocationURI(file.toURI());
                            int i = 0;
                            while (i < files.length) {
                                files[i].refreshLocal(0, monitor);
                                ++i;
                            }
                        } else {
                            GitCreatePatchWizard.this.copyToClipboard(content);
                        }
                    }
                    catch (IOException e) {
                        throw new InvocationTargetException(e);
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
            });
        }
        catch (InvocationTargetException e) {
            ((WizardPage)this.getContainer().getCurrentPage()).setErrorMessage(e.getMessage() == null ? e.getMessage() : UIText.GitCreatePatchWizard_InternalError);
            Activator.logError("Patch file was not written", e);
            return false;
        }
        catch (InterruptedException e) {
            Activator.logError("Patch file was not written", e);
            return false;
        }
        this.getDialogSettings().put(FORMAT_KEY, this.optionsPage.getSelectedHeaderFormat().name());
        this.getDialogSettings().put(CONTEXT_LINES_KEY, this.optionsPage.contextLines.getText());
        return true;
    }

    private void copyToClipboard(final String content) {
        this.getShell().getDisplay().syncExec(new Runnable(){

            public void run() {
                TextTransfer plainTextTransfer = TextTransfer.getInstance();
                Clipboard clipboard = new Clipboard(GitCreatePatchWizard.this.getShell().getDisplay());
                clipboard.setContents((Object[])new String[]{content}, new Transfer[]{plainTextTransfer});
                clipboard.dispose();
            }
        });
    }

    private TreeFilter createPathFilter(Collection<? extends IResource> rs) {
        if (rs == null || rs.isEmpty()) {
            return null;
        }
        ArrayList<PathFilter> filters = new ArrayList<PathFilter>();
        for (IResource iResource : rs) {
            RepositoryMapping rm = RepositoryMapping.getMapping((IResource)iResource);
            String repoRelativePath = rm.getRepoRelativePath(iResource);
            if (repoRelativePath == null) continue;
            if (repoRelativePath.equals("")) {
                return TreeFilter.ALL;
            }
            filters.add(PathFilter.create((String)repoRelativePath));
        }
        if (filters.size() == 0) {
            return null;
        }
        if (filters.size() == 1) {
            return (TreeFilter)filters.get(0);
        }
        return PathFilterGroup.create(filters);
    }

    private void writeToFile(File file, String content) throws IOException {
        BufferedWriter output = new BufferedWriter(new FileWriter(file));
        try {
            output.write(content);
        }
        finally {
            ((Writer)output).close();
        }
    }

    private boolean validateFile(File file) {
        if (file == null) {
            return false;
        }
        if (!file.exists()) {
            return true;
        }
        if (!file.canWrite()) {
            String title = UIText.GitCreatePatchWizard_ReadOnlyTitle;
            String msg = UIText.GitCreatePatchWizard_ReadOnlyMsg;
            MessageDialog dialog = new MessageDialog(this.getShell(), title, null, msg, 1, new String[]{IDialogConstants.OK_LABEL}, 0);
            dialog.open();
            return false;
        }
        String title = UIText.GitCreatePatchWizard_OverwriteTitle;
        String msg = UIText.GitCreatePatchWizard_OverwriteMsg;
        MessageDialog dialog = new MessageDialog(this.getShell(), title, null, msg, 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.CANCEL_LABEL}, 0);
        dialog.open();
        return dialog.getReturnCode() == 0;
    }

    Repository getRepository() {
        return this.db;
    }

    RevCommit getCommit() {
        return this.commit;
    }

    public class OptionsPage
    extends WizardPage {
        private Label formatLabel;
        private ComboViewer formatCombo;
        private Text contextLines;
        private Label contextLinesLabel;

        protected OptionsPage(String pageName, String title, ImageDescriptor titleImage) {
            super(pageName, title, titleImage);
        }

        public void createControl(Composite parent) {
            Composite composite = new Composite(parent, 0);
            GridLayout gridLayout = new GridLayout(2, false);
            composite.setLayout((Layout)gridLayout);
            composite.setLayoutData((Object)new GridData(768));
            GridData gd = new GridData(32);
            gd.horizontalSpan = 2;
            this.formatLabel = new Label(composite, 0);
            this.formatLabel.setText(UIText.GitCreatePatchWizard_Format);
            this.formatCombo = new ComboViewer(composite, 12);
            this.formatCombo.getCombo().setLayoutData((Object)new GridData(4, -1, true, false));
            this.formatCombo.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
            this.formatCombo.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

                public String getText(Object element) {
                    return ((CreatePatchOperation.DiffHeaderFormat)element).getDescription();
                }
            });
            this.formatCombo.setInput((Object)CreatePatchOperation.DiffHeaderFormat.values());
            this.formatCombo.setFilters(new ViewerFilter[]{new ViewerFilter(){

                public boolean select(Viewer viewer, Object parentElement, Object element) {
                    return GitCreatePatchWizard.this.commit != null || !((CreatePatchOperation.DiffHeaderFormat)element).isCommitRequired();
                }
            }});
            String formatName = this.getDialogSettings().get(GitCreatePatchWizard.FORMAT_KEY);
            CreatePatchOperation.DiffHeaderFormat selection = CreatePatchOperation.DiffHeaderFormat.NONE;
            if (formatName != null) {
                try {
                    selection = CreatePatchOperation.DiffHeaderFormat.valueOf((String)formatName);
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
            this.formatCombo.setSelection((ISelection)new StructuredSelection((Object)selection));
            this.contextLinesLabel = new Label(composite, 0);
            this.contextLinesLabel.setText(UIText.GitCreatePatchWizard_LinesOfContext);
            String contextLineSetting = this.getDialogSettings().get(GitCreatePatchWizard.CONTEXT_LINES_KEY);
            if (contextLineSetting == null) {
                contextLineSetting = String.valueOf(3);
            }
            this.contextLines = new Text(composite, 133120);
            this.contextLines.setText(contextLineSetting);
            this.validatePage();
            this.contextLines.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    OptionsPage.this.validatePage();
                }
            });
            GridDataFactory.swtDefaults().hint(30, -1).applyTo((Control)this.contextLines);
            Dialog.applyDialogFont((Control)composite);
            this.setControl((Control)composite);
        }

        private void validatePage() {
            boolean pageValid = true;
            pageValid = this.validateContextLines();
            if (pageValid) {
                this.setMessage(null);
                this.setErrorMessage(null);
            }
            this.setPageComplete(pageValid);
        }

        private boolean validateContextLines() {
            char[] charArray;
            String text = this.contextLines.getText();
            if (text == null || text.trim().length() == 0) {
                this.setErrorMessage(UIText.GitCreatePatchWizard_ContextMustBePositiveInt);
                return false;
            }
            text = text.trim();
            char[] cArray = charArray = text.toCharArray();
            int n = charArray.length;
            int n2 = 0;
            while (n2 < n) {
                char c = cArray[n2];
                if (!Character.isDigit(c)) {
                    this.setErrorMessage(UIText.GitCreatePatchWizard_ContextMustBePositiveInt);
                    return false;
                }
                ++n2;
            }
            return true;
        }

        CreatePatchOperation.DiffHeaderFormat getSelectedHeaderFormat() {
            IStructuredSelection selection = (IStructuredSelection)this.formatCombo.getSelection();
            return (CreatePatchOperation.DiffHeaderFormat)selection.getFirstElement();
        }
    }
}

