/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.history.command;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.egit.ui.UIText;
import org.eclipse.egit.ui.internal.dialogs.BranchRenameDialog;
import org.eclipse.egit.ui.internal.dialogs.BranchSelectionDialog;
import org.eclipse.egit.ui.internal.history.GitHistoryPage;
import org.eclipse.egit.ui.internal.history.HistoryPageInput;
import org.eclipse.egit.ui.internal.history.command.AbstractHistoryCommandHandler;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revplot.PlotCommit;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RenameBranchOnCommitHandler
extends AbstractHistoryCommandHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        Ref branchToRename;
        GitHistoryPage page = this.getPage();
        Repository repository = this.getRepository(page);
        if (repository == null) {
            return null;
        }
        List<Ref> branchesOfCommit = this.getBranchesOfCommit(page);
        if (branchesOfCommit.isEmpty()) {
            return null;
        }
        Shell shell = this.getPart(event).getSite().getShell();
        if (branchesOfCommit.size() > 1) {
            BranchSelectionDialog<Ref> dlg = new BranchSelectionDialog<Ref>(shell, branchesOfCommit, UIText.RenameBranchOnCommitHandler_SelectBranchDialogTitle, UIText.RenameBranchOnCommitHandler_SelectBranchDialogMessage, 4);
            if (dlg.open() != 0) {
                return null;
            }
            branchToRename = dlg.getSelectedNode();
        } else {
            branchToRename = branchesOfCommit.get(0);
        }
        new BranchRenameDialog(shell, repository, branchToRename).open();
        return null;
    }

    private List<Ref> getBranchesOfCommit(GitHistoryPage page) {
        ArrayList<Ref> branchesOfCommit = new ArrayList<Ref>();
        IStructuredSelection selection = this.getSelection(page);
        if (selection.isEmpty()) {
            return branchesOfCommit;
        }
        PlotCommit commit = (PlotCommit)selection.getFirstElement();
        int refCount = commit.getRefCount();
        int i = 0;
        while (i < refCount) {
            Ref ref = commit.getRef(i);
            String refName = ref.getName();
            if (refName.startsWith("refs/heads/") || refName.startsWith("refs/remotes/")) {
                branchesOfCommit.add(ref);
            }
            ++i;
        }
        return branchesOfCommit;
    }

    private Repository getRepository(GitHistoryPage page) {
        if (page == null) {
            return null;
        }
        HistoryPageInput input = page.getInputInternal();
        if (input == null) {
            return null;
        }
        return input.getRepository();
    }

    public boolean isEnabled() {
        GitHistoryPage page = this.getPage();
        return this.getRepository(page) != null && !this.getBranchesOfCommit(page).isEmpty();
    }
}

