/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.staging;

import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.UIIcons;
import org.eclipse.egit.ui.internal.decorators.DecorationResult;
import org.eclipse.egit.ui.internal.decorators.GitLightweightDecorator;
import org.eclipse.egit.ui.internal.staging.StagingEntry;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.BaseLabelProvider;
import org.eclipse.jface.viewers.DecorationOverlayIcon;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;

public class StagingViewLabelProvider
extends BaseLabelProvider
implements ITableLabelProvider,
DelegatingStyledCellLabelProvider.IStyledLabelProvider {
    private Image DEFAULT = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FILE");
    private final Image SUBMODULE = UIIcons.REPOSITORY.createImage();
    private ResourceManager resourceManager = new LocalResourceManager(JFaceResources.getResources());
    private final GitLightweightDecorator.DecorationHelper decorationHelper = new GitLightweightDecorator.DecorationHelper(Activator.getDefault().getPreferenceStore());
    private boolean fileNameMode = false;

    public StagingViewLabelProvider setFileNameMode(boolean enable) {
        this.fileNameMode = enable;
        return this;
    }

    public Image getColumnImage(Object element, int columnIndex) {
        if (columnIndex == 0) {
            return this.getImage(element);
        }
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        if (columnIndex == 0) {
            return this.getStyledText(element).toString();
        }
        return "";
    }

    public void dispose() {
        this.SUBMODULE.dispose();
        this.resourceManager.dispose();
        super.dispose();
    }

    private Image getEditorImage(StagingEntry diff) {
        if (diff.isSubmodule()) {
            return this.SUBMODULE;
        }
        Image image = this.DEFAULT;
        String name = new Path(diff.getPath()).lastSegment();
        if (name != null) {
            ImageDescriptor descriptor = PlatformUI.getWorkbench().getEditorRegistry().getImageDescriptor(name);
            image = (Image)this.resourceManager.get((DeviceResourceDescriptor)descriptor);
        }
        return image;
    }

    private Image getDecoratedImage(Image base, ImageDescriptor decorator) {
        DecorationOverlayIcon decorated = new DecorationOverlayIcon(base, decorator, 3);
        return (Image)this.resourceManager.get((DeviceResourceDescriptor)decorated);
    }

    public StyledString getStyledText(Object element) {
        StagingEntry c = (StagingEntry)element;
        DecorationResult decoration = new DecorationResult();
        this.decorationHelper.decorate(decoration, c);
        StyledString styled = new StyledString();
        String prefix = decoration.getPrefix();
        String suffix = decoration.getSuffix();
        if (prefix != null) {
            styled.append(prefix, StyledString.DECORATIONS_STYLER);
        }
        if (this.fileNameMode) {
            IPath parsed = Path.fromOSString((String)c.getPath());
            if (parsed.segmentCount() > 1) {
                styled.append(parsed.lastSegment());
                if (suffix != null) {
                    styled.append(suffix, StyledString.DECORATIONS_STYLER);
                }
                styled.append(' ');
                styled.append('-', StyledString.QUALIFIER_STYLER);
                styled.append(' ');
                styled.append(parsed.removeLastSegments(1).toString(), StyledString.QUALIFIER_STYLER);
            } else {
                styled.append(c.getPath());
                if (suffix != null) {
                    styled.append(suffix, StyledString.DECORATIONS_STYLER);
                }
            }
        } else {
            styled.append(c.getPath());
            if (suffix != null) {
                styled.append(suffix, StyledString.DECORATIONS_STYLER);
            }
        }
        return styled;
    }

    public Image getImage(Object element) {
        StagingEntry c = (StagingEntry)element;
        DecorationResult decoration = new DecorationResult();
        this.decorationHelper.decorate(decoration, c);
        return this.getDecoratedImage(this.getEditorImage(c), decoration.getOverlay());
    }
}

