/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.synchronize.compare;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.compare.ISharedDocumentAdapter;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.egit.core.project.RepositoryMapping;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.UIText;
import org.eclipse.jgit.events.IndexChangedEvent;
import org.eclipse.jgit.events.RepositoryEvent;
import org.eclipse.jgit.util.FileUtils;
import org.eclipse.team.internal.ui.synchronize.EditableSharedDocumentAdapter;
import org.eclipse.team.internal.ui.synchronize.LocalResourceTypedElement;

public class LocalNonWorkspaceTypedElement
extends LocalResourceTypedElement {
    private final IPath path;
    private boolean exists;
    private boolean fDirty = false;
    private boolean useSharedDocument = true;
    private EditableSharedDocumentAdapter sharedDocumentAdapter;
    private EditableSharedDocumentAdapter.ISharedDocumentAdapterListener sharedDocumentListener;
    private static final IWorkspaceRoot ROOT = ResourcesPlugin.getWorkspace().getRoot();

    public LocalNonWorkspaceTypedElement(IPath path) {
        super((IResource)ROOT.getFile(path));
        this.path = path;
        this.exists = path.toFile().exists();
    }

    public InputStream getContents() throws CoreException {
        try {
            return new FileInputStream(this.path.toFile());
        }
        catch (FileNotFoundException e) {
            Activator.error(e.getMessage(), e);
            return null;
        }
    }

    public boolean isEditable() {
        IResource resource = this.getResource();
        return resource.getType() == 1 && this.exists;
    }

    public void update() {
        this.exists = this.path.toFile().exists();
    }

    public boolean exists() {
        return this.exists;
    }

    public boolean isSharedDocumentsEnable() {
        return this.useSharedDocument && this.getResource().getType() == 1 && this.exists;
    }

    public void enableSharedDocument(boolean enablement) {
        this.useSharedDocument = enablement;
    }

    public void setContent(byte[] contents) {
        this.fDirty = true;
        super.setContent(contents);
    }

    public void commit(IProgressMonitor monitor) throws CoreException {
        if (this.isDirty()) {
            if (this.isConnected()) {
                super.commit(monitor);
            } else {
                FileOutputStream out = null;
                File file = this.path.toFile();
                try {
                    try {
                        if (!file.exists()) {
                            FileUtils.createNewFile((File)file);
                        }
                        out = new FileOutputStream(file);
                        out.write(this.getContent());
                        this.fDirty = false;
                    }
                    catch (IOException e) {
                        throw new CoreException((IStatus)new Status(4, Activator.getPluginId(), UIText.LocalNonWorkspaceTypedElement_errorWritingContents, (Throwable)e));
                    }
                }
                catch (Throwable throwable) {
                    this.fireContentChanged();
                    RepositoryMapping mapping = RepositoryMapping.getMapping((IPath)this.path);
                    if (mapping != null) {
                        mapping.getRepository().fireEvent((RepositoryEvent)new IndexChangedEvent());
                    }
                    if (out != null) {
                        try {
                            out.close();
                        }
                        catch (IOException iOException) {}
                    }
                    throw throwable;
                }
                this.fireContentChanged();
                RepositoryMapping mapping = RepositoryMapping.getMapping((IPath)this.path);
                if (mapping != null) {
                    mapping.getRepository().fireEvent((RepositoryEvent)new IndexChangedEvent());
                }
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    public boolean isDirty() {
        return this.fDirty || this.sharedDocumentAdapter != null && this.sharedDocumentAdapter.hasBufferedContents();
    }

    public Object getAdapter(Class adapter) {
        if (adapter == ISharedDocumentAdapter.class) {
            if (this.isSharedDocumentsEnable()) {
                return this.getSharedDocumentAdapter();
            }
            return null;
        }
        return Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }

    public void setSharedDocumentListener(EditableSharedDocumentAdapter.ISharedDocumentAdapterListener sharedDocumentListener) {
        this.sharedDocumentListener = sharedDocumentListener;
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.path.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        LocalNonWorkspaceTypedElement other = (LocalNonWorkspaceTypedElement)((Object)obj);
        return this.path.equals((Object)other.path);
    }

    private synchronized ISharedDocumentAdapter getSharedDocumentAdapter() {
        if (this.sharedDocumentAdapter == null) {
            this.sharedDocumentAdapter = new EditableSharedDocumentAdapter(new EditableSharedDocumentAdapter.ISharedDocumentAdapterListener(){

                public void handleDocumentConnected() {
                    if (LocalNonWorkspaceTypedElement.this.sharedDocumentListener != null) {
                        LocalNonWorkspaceTypedElement.this.sharedDocumentListener.handleDocumentConnected();
                    }
                }

                public void handleDocumentFlushed() {
                    LocalNonWorkspaceTypedElement.this.fireContentChanged();
                    if (LocalNonWorkspaceTypedElement.this.sharedDocumentListener != null) {
                        LocalNonWorkspaceTypedElement.this.sharedDocumentListener.handleDocumentFlushed();
                    }
                }

                public void handleDocumentDeleted() {
                    LocalNonWorkspaceTypedElement.this.update();
                    if (LocalNonWorkspaceTypedElement.this.sharedDocumentListener != null) {
                        LocalNonWorkspaceTypedElement.this.sharedDocumentListener.handleDocumentDeleted();
                    }
                }

                public void handleDocumentSaved() {
                    if (LocalNonWorkspaceTypedElement.this.sharedDocumentListener != null) {
                        LocalNonWorkspaceTypedElement.this.sharedDocumentListener.handleDocumentSaved();
                    }
                }

                public void handleDocumentDisconnected() {
                    if (LocalNonWorkspaceTypedElement.this.sharedDocumentListener != null) {
                        LocalNonWorkspaceTypedElement.this.sharedDocumentListener.handleDocumentDisconnected();
                    }
                }
            });
        }
        return this.sharedDocumentAdapter;
    }
}

