/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.synchronize.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.egit.core.synchronize.GitCommitsModelCache;
import org.eclipse.egit.ui.internal.synchronize.model.GitModelBlob;
import org.eclipse.egit.ui.internal.synchronize.model.GitModelObject;
import org.eclipse.egit.ui.internal.synchronize.model.GitModelObjectContainer;
import org.eclipse.egit.ui.internal.synchronize.model.GitModelRepository;
import org.eclipse.egit.ui.internal.synchronize.model.GitModelTree;
import org.eclipse.egit.ui.internal.synchronize.model.HasProjects;
import org.eclipse.jgit.lib.Repository;

public class GitModelCommit
extends GitModelObjectContainer
implements HasProjects {
    private final GitCommitsModelCache.Commit commit;
    private final Repository repo;
    private final IProject[] projects;
    private final Map<String, GitModelObject> cachedTreeMap = new HashMap<String, GitModelObject>();

    public GitModelCommit(GitModelRepository parent, Repository repo, GitCommitsModelCache.Commit commit, IProject[] projects) {
        super(parent);
        this.repo = repo;
        this.commit = commit;
        this.projects = projects;
    }

    public IPath getLocation() {
        return new Path(this.repo.getWorkTree().getAbsolutePath());
    }

    public IProject[] getProjects() {
        return this.projects;
    }

    public int getKind() {
        return this.commit.getDirection() | 3;
    }

    public int repositoryHashCode() {
        return this.repo.getWorkTree().hashCode();
    }

    public String getName() {
        return this.commit.getShortMessage();
    }

    public GitModelObject[] getChildren() {
        ArrayList<GitModelObject> result = new ArrayList<GitModelObject>();
        if (this.commit.getChildren() != null) {
            for (Map.Entry cacheEntry : this.commit.getChildren().entrySet()) {
                GitModelObject nested = this.addChild((GitCommitsModelCache.Change)cacheEntry.getValue(), (String)cacheEntry.getKey());
                if (nested == null) continue;
                result.add(nested);
            }
        }
        return result.toArray(new GitModelObject[result.size()]);
    }

    public GitCommitsModelCache.Commit getCachedCommitObj() {
        return this.commit;
    }

    public void dispose() {
        for (GitModelObject value : this.cachedTreeMap.values()) {
            value.dispose();
        }
        this.cachedTreeMap.clear();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        GitModelCommit objCommit = (GitModelCommit)obj;
        return objCommit.commit.getId().equals((Object)this.commit.getId());
    }

    public int hashCode() {
        return this.commit.hashCode();
    }

    public String toString() {
        return "ModelCommit[" + this.commit.getId() + "]";
    }

    private GitModelObject addChild(GitCommitsModelCache.Change change, String nestedPath) {
        GitModelObject firstObject = null;
        IPath tmpLocation = this.getLocation();
        String[] segments = nestedPath.split("/");
        GitModelObjectContainer tmpPartent = this;
        Map<String, GitModelObject> tmpCache = this.cachedTreeMap;
        int i = 0;
        while (i < segments.length) {
            String segment = segments[i];
            tmpLocation = tmpLocation.append(segment);
            if (i < segments.length - 1) {
                GitModelTree tree = (GitModelTree)tmpCache.get(segment);
                if (tree == null) {
                    tree = new GitModelTree(tmpPartent, tmpLocation, change.getKind());
                    tmpCache.put(segment, tree);
                }
                tmpPartent = tree;
                tmpCache = tree.cachedTreeMap;
                if (i == 0) {
                    firstObject = tmpPartent;
                }
            } else {
                GitModelBlob blob = new GitModelBlob(tmpPartent, this.repo, change, tmpLocation);
                tmpCache.put(segment, blob);
                if (i == 0) {
                    firstObject = blob;
                }
            }
            ++i;
        }
        return firstObject;
    }
}

