/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.spi.common.commit;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.cdo.common.commit.CDOChangeSetData;
import org.eclipse.emf.cdo.common.commit.CDOChangeSetDataProvider;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.revision.CDOIDAndVersion;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.revision.CDORevisionKey;
import org.eclipse.emf.cdo.common.revision.CDORevisionProvider;
import org.eclipse.emf.cdo.common.revision.delta.CDORevisionDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDORevisionDeltaProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CDOChangeSetDataRevisionProvider
implements CDORevisionProvider,
CDOChangeSetDataProvider {
    private static final CDOIDAndVersion DETACHED = new CDOIDAndVersion(){

        public CDOID getID() {
            return CDOID.NULL;
        }

        public int getVersion() {
            return Integer.MIN_VALUE;
        }

        public String toString() {
            return "DETACHED";
        }
    };
    private CDORevisionProvider delegate;
    private CDOChangeSetData changeSetData;
    private CDORevisionProvider revisionCallback;
    private CDORevisionDeltaProvider revisionDeltaCallback;
    private Map<CDOID, CDOIDAndVersion> cachedRevisions;

    public CDOChangeSetDataRevisionProvider(CDORevisionProvider delegate, CDOChangeSetData changeSetData, CDORevisionProvider revisionCallback, CDORevisionDeltaProvider revisionDeltaCallback) {
        this.delegate = delegate;
        this.changeSetData = changeSetData;
        this.revisionCallback = revisionCallback;
        this.revisionDeltaCallback = revisionDeltaCallback;
    }

    public CDOChangeSetDataRevisionProvider(CDORevisionProvider delegate, CDOChangeSetData changeSetData) {
        this(delegate, changeSetData, null, null);
    }

    @Override
    public CDOChangeSetData getChangeSetData() {
        return this.changeSetData;
    }

    @Override
    public synchronized CDORevision getRevision(CDOID id) {
        CDOIDAndVersion key;
        if (this.cachedRevisions == null) {
            this.cachedRevisions = this.cacheRevisions();
        }
        if ((key = this.cachedRevisions.get(id)) == DETACHED) {
            return null;
        }
        if (key instanceof CDORevision) {
            return (CDORevision)key;
        }
        if (key instanceof CDORevisionDelta) {
            CDORevisionDelta revisionDelta = (CDORevisionDelta)key;
            return this.applyDelta(revisionDelta);
        }
        if (key instanceof CDORevisionKey) {
            CDORevisionDelta revisionDelta = this.revisionDeltaCallback.getRevisionDelta(id);
            return this.applyDelta(revisionDelta);
        }
        if (key != null) {
            CDORevision revision = this.revisionCallback.getRevision(id);
            this.cachedRevisions.put(id, revision);
            return revision;
        }
        return this.delegate.getRevision(id);
    }

    private Map<CDOID, CDOIDAndVersion> cacheRevisions() {
        HashMap<CDOID, CDOIDAndVersion> cache = new HashMap<CDOID, CDOIDAndVersion>();
        for (CDOIDAndVersion cDOIDAndVersion : this.changeSetData.getNewObjects()) {
            if (this.revisionCallback == null && !(cDOIDAndVersion instanceof CDORevision)) {
                throw new IllegalStateException("No callback installed to lazily obtain revision " + cDOIDAndVersion);
            }
            cache.put(cDOIDAndVersion.getID(), cDOIDAndVersion);
        }
        for (CDORevisionKey cDORevisionKey : this.changeSetData.getChangedObjects()) {
            if (this.revisionDeltaCallback == null && !(cDORevisionKey instanceof CDORevisionDelta)) {
                throw new IllegalStateException("No callback installed to lazily obtain revision delta " + cDORevisionKey);
            }
            cache.put(cDORevisionKey.getID(), cDORevisionKey);
        }
        for (CDOIDAndVersion cDOIDAndVersion : this.changeSetData.getDetachedObjects()) {
            cache.put(cDOIDAndVersion.getID(), DETACHED);
        }
        return cache;
    }

    private CDORevision applyDelta(CDORevisionDelta revisionDelta) {
        CDOID id = revisionDelta.getID();
        CDORevision changedObject = this.delegate.getRevision(id).copy();
        revisionDelta.apply(changedObject);
        this.cachedRevisions.put(id, changedObject);
        return changedObject;
    }
}

