/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.net4j;

import org.eclipse.emf.cdo.common.revision.CDORevisionUtil;
import org.eclipse.emf.cdo.common.util.CDOTimeProvider;
import org.eclipse.emf.cdo.common.util.NotAuthenticatedException;
import org.eclipse.emf.cdo.internal.common.model.CDOPackageRegistryImpl;
import org.eclipse.emf.cdo.internal.net4j.CDONet4jSessionConfigurationImpl;
import org.eclipse.emf.cdo.internal.net4j.protocol.CDOClientProtocol;
import org.eclipse.emf.cdo.net4j.CDONet4jSession;
import org.eclipse.emf.cdo.net4j.CDOSession;
import org.eclipse.emf.cdo.spi.common.branch.CDOBranchUtil;
import org.eclipse.emf.cdo.spi.common.branch.InternalCDOBranchManager;
import org.eclipse.emf.cdo.spi.common.commit.CDOCommitInfoUtil;
import org.eclipse.emf.cdo.spi.common.commit.InternalCDOCommitInfoManager;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageRegistry;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageUnit;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevisionManager;
import org.eclipse.emf.internal.cdo.session.CDOSessionImpl;
import org.eclipse.emf.internal.cdo.session.DelegatingSessionProtocol;
import org.eclipse.emf.spi.cdo.CDOSessionProtocol;
import org.eclipse.emf.spi.cdo.InternalCDOSession;
import org.eclipse.net4j.connector.IConnector;
import org.eclipse.net4j.signal.ISignalProtocol;
import org.eclipse.net4j.util.io.IStreamWrapper;

public class CDONet4jSessionImpl
extends CDOSessionImpl
implements CDOSession {
    private IStreamWrapper streamWrapper;
    private IConnector connector;
    private String repositoryName;
    private long signalTimeout = 10000L;

    public IStreamWrapper getStreamWrapper() {
        return this.streamWrapper;
    }

    public void setStreamWrapper(IStreamWrapper streamWrapper) {
        this.streamWrapper = streamWrapper;
    }

    public IConnector getConnector() {
        return this.connector;
    }

    public void setConnector(IConnector connector) {
        this.connector = connector;
    }

    public String getRepositoryName() {
        return this.repositoryName;
    }

    public void setRepositoryName(String repositoryName) {
        this.repositoryName = repositoryName;
    }

    public long getSignalTimeout() {
        return this.signalTimeout;
    }

    public void setSignalTimeout(long signalTimeout) {
        this.signalTimeout = signalTimeout;
        CDOClientProtocol clientProtocol = this.getClientProtocol();
        if (clientProtocol != null) {
            clientProtocol.setTimeout(this.signalTimeout);
        }
    }

    public OptionsImpl options() {
        return (OptionsImpl)super.options();
    }

    protected OptionsImpl createOptions() {
        return new OptionsImpl();
    }

    protected void doActivate() throws Exception {
        CDOSessionProtocol.OpenSessionResult result = this.openSession();
        if (result == null) {
            throw new NotAuthenticatedException();
        }
        super.doActivate();
        InternalCDOPackageRegistry packageRegistry = this.getPackageRegistry();
        if (packageRegistry == null) {
            packageRegistry = new CDOPackageRegistryImpl();
            this.setPackageRegistry(packageRegistry);
        }
        packageRegistry.setPackageProcessor((InternalCDOPackageRegistry.PackageProcessor)this);
        packageRegistry.setPackageLoader((InternalCDOPackageRegistry.PackageLoader)this);
        packageRegistry.activate();
        InternalCDORevisionManager revisionManager = this.getRevisionManager();
        if (revisionManager == null) {
            revisionManager = (InternalCDORevisionManager)CDORevisionUtil.createRevisionManager();
            this.setRevisionManager(revisionManager);
        }
        revisionManager.setSupportingAudits(this.getRepositoryInfo().isSupportingAudits());
        revisionManager.setSupportingBranches(this.getRepositoryInfo().isSupportingBranches());
        revisionManager.setRevisionLoader((InternalCDORevisionManager.RevisionLoader)this.getSessionProtocol());
        revisionManager.setRevisionLocker((InternalCDORevisionManager.RevisionLocker)this);
        revisionManager.activate();
        InternalCDOBranchManager branchManager = this.getBranchManager();
        if (branchManager == null) {
            branchManager = CDOBranchUtil.createBranchManager();
            this.setBranchManager(branchManager);
        }
        branchManager.setBranchLoader((InternalCDOBranchManager.BranchLoader)this.getSessionProtocol());
        branchManager.setTimeProvider((CDOTimeProvider)this.getRepositoryInfo());
        branchManager.initMainBranch(this.isMainBranchLocal(), this.getRepositoryInfo().getCreationTime());
        branchManager.activate();
        InternalCDOCommitInfoManager commitInfoManager = this.getCommitInfoManager();
        if (commitInfoManager == null) {
            commitInfoManager = CDOCommitInfoUtil.createCommitInfoManager();
            this.setCommitInfoManager(commitInfoManager);
        }
        commitInfoManager.setCommitInfoLoader((InternalCDOCommitInfoManager.CommitInfoLoader)this.getSessionProtocol());
        commitInfoManager.activate();
        for (InternalCDOPackageUnit packageUnit : result.getPackageUnits()) {
            this.getPackageRegistry().putPackageUnit(packageUnit);
        }
        this.getRepositoryInfo().getTimeStamp(true);
    }

    private CDOClientProtocol createProtocol() {
        CDOClientProtocol protocol = new CDOClientProtocol();
        protocol.setTimeout(this.signalTimeout);
        protocol.setInfraStructure(this);
        if (this.streamWrapper != null) {
            protocol.setStreamWrapper(this.streamWrapper);
        }
        protocol.open(this.connector);
        return protocol;
    }

    private CDOClientProtocol getClientProtocol() {
        CDOSessionProtocol protocol = this.getSessionProtocol();
        CDOClientProtocol clientProtocol = protocol instanceof DelegatingSessionProtocol ? (CDOClientProtocol)((DelegatingSessionProtocol)protocol).getDelegate() : (CDOClientProtocol)protocol;
        return clientProtocol;
    }

    protected CDOSessionProtocol.OpenSessionResult openSession() {
        CDOClientProtocol protocol = this.createProtocol();
        this.setSessionProtocol(protocol);
        this.hookSessionProtocol();
        CDOSessionProtocol.OpenSessionResult result = protocol.openSession(this.repositoryName, this.options().isPassiveUpdateEnabled(), this.options().getPassiveUpdateMode(), this.options().getLockNotificationMode());
        if (result == null) {
            return null;
        }
        this.setSessionID(result.getSessionID());
        this.setUserID(result.getUserID());
        this.setLastUpdateTime(result.getLastUpdateTime());
        this.setRepositoryInfo(new CDONet4jSessionConfigurationImpl.RepositoryInfo(this.repositoryName, result, (InternalCDOSession)this));
        return result;
    }

    protected void doDeactivate() throws Exception {
        super.doDeactivate();
        this.getCommitInfoManager().deactivate();
        this.getRevisionManager().deactivate();
        this.getBranchManager().deactivate();
        this.getPackageRegistry().deactivate();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class OptionsImpl
    extends CDOSessionImpl.OptionsImpl
    implements CDOSession.Options {
        private int commitTimeout;
        private int progressInterval;

        public OptionsImpl() {
            super((CDOSessionImpl)CDONet4jSessionImpl.this);
            this.commitTimeout = 10;
            this.progressInterval = 1;
        }

        public CDONet4jSession getContainer() {
            return (CDONet4jSession)super.getContainer();
        }

        @Override
        public ISignalProtocol<CDONet4jSession> getNet4jProtocol() {
            CDOSessionProtocol protocol = CDONet4jSessionImpl.this.getSessionProtocol();
            if (protocol instanceof DelegatingSessionProtocol) {
                protocol = ((DelegatingSessionProtocol)protocol).getDelegate();
            }
            ISignalProtocol signalProtocol = (ISignalProtocol)protocol;
            return signalProtocol;
        }

        @Override
        public ISignalProtocol<CDOSession> getProtocol() {
            ISignalProtocol<CDONet4jSession> net4jProtocol = this.getNet4jProtocol();
            return net4jProtocol;
        }

        @Override
        public int getCommitTimeout() {
            return this.commitTimeout;
        }

        @Override
        public synchronized void setCommitTimeout(int commitTimeout) {
            this.commitTimeout = commitTimeout;
        }

        @Override
        public int getProgressInterval() {
            return this.progressInterval;
        }

        @Override
        public synchronized void setProgressInterval(int progressInterval) {
            this.progressInterval = progressInterval;
        }
    }
}

