/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import javax.sql.DataSource;
import org.eclipse.emf.cdo.common.CDOCommonRepository;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.revision.CDOAllRevisionsProvider;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.revision.CDORevisionHandler;
import org.eclipse.emf.cdo.server.ISession;
import org.eclipse.emf.cdo.server.IStore;
import org.eclipse.emf.cdo.server.IStoreAccessor;
import org.eclipse.emf.cdo.server.ITransaction;
import org.eclipse.emf.cdo.server.IView;
import org.eclipse.emf.cdo.server.StoreThreadLocal;
import org.eclipse.emf.cdo.server.db.IDBStore;
import org.eclipse.emf.cdo.server.db.IIDHandler;
import org.eclipse.emf.cdo.server.db.IMetaDataManager;
import org.eclipse.emf.cdo.server.db.mapping.IMappingStrategy;
import org.eclipse.emf.cdo.server.internal.db.CDODBSchema;
import org.eclipse.emf.cdo.server.internal.db.DBStoreAccessor;
import org.eclipse.emf.cdo.server.internal.db.DurableLockingManager;
import org.eclipse.emf.cdo.server.internal.db.LongIDHandler;
import org.eclipse.emf.cdo.server.internal.db.MetaDataManager;
import org.eclipse.emf.cdo.server.internal.db.UUIDHandler;
import org.eclipse.emf.cdo.server.internal.db.bundle.OM;
import org.eclipse.emf.cdo.server.internal.db.messages.Messages;
import org.eclipse.emf.cdo.spi.server.InternalRepository;
import org.eclipse.emf.cdo.spi.server.LongIDStoreAccessor;
import org.eclipse.emf.cdo.spi.server.Store;
import org.eclipse.emf.cdo.spi.server.StoreAccessorPool;
import org.eclipse.net4j.db.DBException;
import org.eclipse.net4j.db.DBUtil;
import org.eclipse.net4j.db.IDBAdapter;
import org.eclipse.net4j.db.IDBConnectionProvider;
import org.eclipse.net4j.db.ddl.IDBField;
import org.eclipse.net4j.db.ddl.IDBSchema;
import org.eclipse.net4j.db.ddl.IDBTable;
import org.eclipse.net4j.spi.db.DBSchema;
import org.eclipse.net4j.util.ReflectUtil;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;
import org.eclipse.net4j.util.om.monitor.ProgressDistributor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DBStore
extends Store
implements IDBStore,
CDOAllRevisionsProvider {
    public static final String TYPE = "db";
    private static final String PROP_REPOSITORY_CREATED = "org.eclipse.emf.cdo.server.db.repositoryCreated";
    private static final String PROP_REPOSITORY_STOPPED = "org.eclipse.emf.cdo.server.db.repositoryStopped";
    private static final String PROP_NEXT_LOCAL_CDOID = "org.eclipse.emf.cdo.server.db.nextLocalCDOID";
    private static final String PROP_LAST_CDOID = "org.eclipse.emf.cdo.server.db.lastCDOID";
    private static final String PROP_LAST_BRANCHID = "org.eclipse.emf.cdo.server.db.lastBranchID";
    private static final String PROP_LAST_LOCAL_BRANCHID = "org.eclipse.emf.cdo.server.db.lastLocalBranchID";
    private static final String PROP_LAST_COMMITTIME = "org.eclipse.emf.cdo.server.db.lastCommitTime";
    private static final String PROP_LAST_NONLOCAL_COMMITTIME = "org.eclipse.emf.cdo.server.db.lastNonLocalCommitTime";
    private static final String PROP_GRACEFULLY_SHUT_DOWN = "org.eclipse.emf.cdo.server.db.gracefullyShutDown";
    private long creationTime;
    private boolean firstTime;
    private Map<String, String> properties;
    private IIDHandler idHandler;
    private IMetaDataManager metaDataManager = new MetaDataManager(this);
    private DurableLockingManager durableLockingManager = new DurableLockingManager(this);
    private IMappingStrategy mappingStrategy;
    private IDBSchema dbSchema;
    private IDBAdapter dbAdapter;
    private IDBConnectionProvider dbConnectionProvider;
    @ReflectUtil.ExcludeFromDump
    private transient ProgressDistributor accessorWriteDistributor = new ProgressDistributor.Geometric(){

        public String toString() {
            String result = "accessorWriteDistributor";
            if (DBStore.this.getRepository() != null) {
                result = String.valueOf(result) + ": " + DBStore.this.getRepository().getName();
            }
            return result;
        }
    };
    @ReflectUtil.ExcludeFromDump
    private transient StoreAccessorPool readerPool = new StoreAccessorPool((IStore)this, null);
    @ReflectUtil.ExcludeFromDump
    private transient StoreAccessorPool writerPool = new StoreAccessorPool((IStore)this, null);
    @ReflectUtil.ExcludeFromDump
    private transient Timer connectionKeepAliveTimer;

    public DBStore() {
        super(TYPE, null, DBStore.set((Object[])new IStore.ChangeFormat[]{IStore.ChangeFormat.REVISION, IStore.ChangeFormat.DELTA}), DBStore.set((Object[])new IStore.RevisionTemporality[]{IStore.RevisionTemporality.AUDITING, IStore.RevisionTemporality.NONE}), DBStore.set((Object[])new IStore.RevisionParallelism[]{IStore.RevisionParallelism.NONE, IStore.RevisionParallelism.BRANCHING}));
    }

    @Override
    public IMappingStrategy getMappingStrategy() {
        return this.mappingStrategy;
    }

    public void setMappingStrategy(IMappingStrategy mappingStrategy) {
        this.mappingStrategy = mappingStrategy;
        mappingStrategy.setStore(this);
    }

    @Override
    public IDBAdapter getDBAdapter() {
        return this.dbAdapter;
    }

    public void setDBAdapter(IDBAdapter dbAdapter) {
        this.dbAdapter = dbAdapter;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    @Override
    public IIDHandler getIDHandler() {
        return this.idHandler;
    }

    public Connection getConnection() {
        Connection connection = this.dbConnectionProvider.getConnection();
        if (connection == null) {
            throw new DBException("No connection from connection provider: " + this.dbConnectionProvider);
        }
        try {
            connection.setAutoCommit(false);
        }
        catch (SQLException ex) {
            throw new DBException((Throwable)ex, "SET AUTO COMMIT = false");
        }
        return connection;
    }

    public void setDbConnectionProvider(IDBConnectionProvider dbConnectionProvider) {
        this.dbConnectionProvider = dbConnectionProvider;
    }

    public void setDataSource(DataSource dataSource) {
        this.dbConnectionProvider = DBUtil.createConnectionProvider((DataSource)dataSource);
    }

    @Override
    public IMetaDataManager getMetaDataManager() {
        return this.metaDataManager;
    }

    public DurableLockingManager getDurableLockingManager() {
        return this.durableLockingManager;
    }

    public Timer getConnectionKeepAliveTimer() {
        return this.connectionKeepAliveTimer;
    }

    public Set<IStore.ChangeFormat> getSupportedChangeFormats() {
        if (this.mappingStrategy.hasDeltaSupport()) {
            return DBStore.set((Object[])new IStore.ChangeFormat[]{IStore.ChangeFormat.DELTA});
        }
        return DBStore.set((Object[])new IStore.ChangeFormat[]{IStore.ChangeFormat.REVISION});
    }

    public ProgressDistributor getAccessorWriteDistributor() {
        return this.accessorWriteDistributor;
    }

    @Override
    public IDBSchema getDBSchema() {
        return this.dbSchema;
    }

    public Map<String, String> getPersistentProperties(Set<String> names) {
        HashMap<String, String> hashMap;
        Connection connection = null;
        PreparedStatement selectStmt = null;
        String sql = null;
        try {
            boolean allProperties;
            connection = this.getConnection();
            HashMap<String, String> result = new HashMap<String, String>();
            boolean bl = allProperties = names == null || names.isEmpty();
            if (allProperties) {
                sql = CDODBSchema.SQL_SELECT_ALL_PROPERTIES;
                selectStmt = connection.prepareStatement(sql);
                ResultSet resultSet = null;
                try {
                    resultSet = selectStmt.executeQuery();
                    while (resultSet.next()) {
                        String key = resultSet.getString(1);
                        String value = resultSet.getString(2);
                        result.put(key, value);
                    }
                }
                finally {
                    DBUtil.close((ResultSet)resultSet);
                }
            } else {
                sql = CDODBSchema.SQL_SELECT_PROPERTIES;
                selectStmt = connection.prepareStatement(sql);
                for (String name : names) {
                    selectStmt.setString(1, name);
                    ResultSet resultSet = null;
                    try {
                        resultSet = selectStmt.executeQuery();
                        if (!resultSet.next()) continue;
                        String value = resultSet.getString(1);
                        result.put(name, value);
                    }
                    finally {
                        DBUtil.close((ResultSet)resultSet);
                    }
                }
            }
            hashMap = result;
        }
        catch (SQLException ex) {
            try {
                throw new DBException((Throwable)ex, sql);
            }
            catch (Throwable throwable) {
                DBUtil.close(selectStmt);
                DBUtil.close((Connection)connection);
                throw throwable;
            }
        }
        DBUtil.close((Statement)selectStmt);
        DBUtil.close((Connection)connection);
        return hashMap;
    }

    public void setPersistentProperties(Map<String, String> properties) {
        Connection connection = null;
        PreparedStatement deleteStmt = null;
        PreparedStatement insertStmt = null;
        String sql = null;
        try {
            try {
                connection = this.getConnection();
                deleteStmt = connection.prepareStatement(CDODBSchema.SQL_DELETE_PROPERTIES);
                insertStmt = connection.prepareStatement(CDODBSchema.SQL_INSERT_PROPERTIES);
                for (Map.Entry<String, String> entry : properties.entrySet()) {
                    String name = entry.getKey();
                    String value = entry.getValue();
                    sql = CDODBSchema.SQL_DELETE_PROPERTIES;
                    deleteStmt.setString(1, name);
                    deleteStmt.executeUpdate();
                    sql = CDODBSchema.SQL_INSERT_PROPERTIES;
                    insertStmt.setString(1, name);
                    insertStmt.setString(2, value);
                    insertStmt.executeUpdate();
                }
                sql = null;
                connection.commit();
            }
            catch (SQLException ex) {
                throw new DBException((Throwable)ex, sql);
            }
        }
        catch (Throwable throwable) {
            DBUtil.close(insertStmt);
            DBUtil.close(deleteStmt);
            DBUtil.close((Connection)connection);
            throw throwable;
        }
        DBUtil.close((Statement)insertStmt);
        DBUtil.close((Statement)deleteStmt);
        DBUtil.close((Connection)connection);
    }

    public void removePersistentProperties(Set<String> names) {
        Connection connection = null;
        PreparedStatement deleteStmt = null;
        try {
            try {
                connection = this.getConnection();
                deleteStmt = connection.prepareStatement(CDODBSchema.SQL_DELETE_PROPERTIES);
                for (String name : names) {
                    deleteStmt.setString(1, name);
                    deleteStmt.executeUpdate();
                }
                connection.commit();
            }
            catch (SQLException ex) {
                throw new DBException((Throwable)ex, CDODBSchema.SQL_DELETE_PROPERTIES);
            }
        }
        catch (Throwable throwable) {
            DBUtil.close(deleteStmt);
            DBUtil.close((Connection)connection);
            throw throwable;
        }
        DBUtil.close((Statement)deleteStmt);
        DBUtil.close((Connection)connection);
    }

    @Override
    public DBStoreAccessor getReader(ISession session) {
        return (DBStoreAccessor)super.getReader(session);
    }

    @Override
    public DBStoreAccessor getWriter(ITransaction transaction) {
        return (DBStoreAccessor)super.getWriter(transaction);
    }

    protected StoreAccessorPool getReaderPool(ISession session, boolean forReleasing) {
        return this.readerPool;
    }

    protected StoreAccessorPool getWriterPool(IView view, boolean forReleasing) {
        return this.writerPool;
    }

    protected DBStoreAccessor createReader(ISession session) throws DBException {
        return new DBStoreAccessor(this, session);
    }

    protected DBStoreAccessor createWriter(ITransaction transaction) throws DBException {
        return new DBStoreAccessor(this, transaction);
    }

    public Map<CDOBranch, List<CDORevision>> getAllRevisions() {
        final HashMap<CDOBranch, List<CDORevision>> result = new HashMap<CDOBranch, List<CDORevision>>();
        DBStoreAccessor accessor = this.getReader(null);
        StoreThreadLocal.setAccessor((IStoreAccessor)accessor);
        try {
            accessor.handleRevisions(null, null, 0L, true, (CDORevisionHandler)new CDORevisionHandler.Filtered.Undetached(new CDORevisionHandler(){

                public boolean handleRevision(CDORevision revision) {
                    CDOBranch branch = revision.getBranch();
                    ArrayList<CDORevision> list = (ArrayList<CDORevision>)result.get(branch);
                    if (list == null) {
                        list = new ArrayList<CDORevision>();
                        result.put(branch, list);
                    }
                    list.add(revision);
                    return true;
                }
            }));
        }
        finally {
            StoreThreadLocal.release();
        }
        return result;
    }

    public CDOID createObjectID(String val) {
        return this.idHandler.createCDOID(val);
    }

    public boolean isLocal(CDOID id) {
        return this.idHandler.isLocalCDOID(id);
    }

    public CDOID getNextCDOID(LongIDStoreAccessor accessor, CDORevision revision) {
        return this.idHandler.getNextCDOID(revision);
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public void setCreationTime(long creationTime) {
        this.creationTime = creationTime;
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(PROP_REPOSITORY_CREATED, Long.toString(creationTime));
        this.setPersistentProperties(map);
    }

    public boolean isFirstStart() {
        return this.firstTime;
    }

    protected void doBeforeActivate() throws Exception {
        super.doBeforeActivate();
        this.checkNull(this.mappingStrategy, Messages.getString("DBStore.2"));
        this.checkNull(this.dbAdapter, Messages.getString("DBStore.1"));
        this.checkNull(this.dbConnectionProvider, Messages.getString("DBStore.0"));
    }

    protected void doActivate() throws Exception {
        super.doActivate();
        this.idHandler = this.getRepository().getIDGenerationLocation() == CDOCommonRepository.IDGenerationLocation.CLIENT ? new UUIDHandler(this) : new LongIDHandler(this);
        this.setObjectIDTypes(this.idHandler.getObjectIDTypes());
        this.connectionKeepAliveTimer = new Timer("Connection-Keep-Alive-" + this);
        Set createdTables = null;
        Connection connection = this.getConnection();
        try {
            if (this.isDropAllDataOnActivate()) {
                OM.LOG.info("Dropping all tables from repository " + this.getRepository().getName() + "...");
                DBUtil.dropAllTables((Connection)connection, null);
                connection.commit();
            }
            createdTables = CDODBSchema.INSTANCE.create(this.dbAdapter, connection);
            connection.commit();
        }
        finally {
            DBUtil.close((Connection)connection);
        }
        this.dbSchema = this.createSchema();
        LifecycleUtil.activate((Object)this.idHandler);
        LifecycleUtil.activate((Object)this.metaDataManager);
        LifecycleUtil.activate((Object)((Object)this.durableLockingManager));
        LifecycleUtil.activate((Object)this.mappingStrategy);
        this.setRevisionTemporality(this.mappingStrategy.hasAuditSupport() ? IStore.RevisionTemporality.AUDITING : IStore.RevisionTemporality.NONE);
        this.setRevisionParallelism(this.mappingStrategy.hasBranchingSupport() ? IStore.RevisionParallelism.BRANCHING : IStore.RevisionParallelism.NONE);
        if (this.isFirstStart(createdTables)) {
            this.firstStart();
        } else {
            this.reStart();
        }
    }

    protected void doDeactivate() throws Exception {
        LifecycleUtil.deactivate((Object)this.mappingStrategy);
        LifecycleUtil.deactivate((Object)((Object)this.durableLockingManager));
        LifecycleUtil.deactivate((Object)this.metaDataManager);
        LifecycleUtil.deactivate((Object)this.idHandler);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(PROP_GRACEFULLY_SHUT_DOWN, Boolean.TRUE.toString());
        map.put(PROP_REPOSITORY_STOPPED, Long.toString(this.getRepository().getTimeStamp()));
        if (this.getRepository().getIDGenerationLocation() == CDOCommonRepository.IDGenerationLocation.STORE) {
            map.put(PROP_NEXT_LOCAL_CDOID, Store.idToString((CDOID)this.idHandler.getNextLocalObjectID()));
            map.put(PROP_LAST_CDOID, Store.idToString((CDOID)this.idHandler.getLastObjectID()));
        }
        map.put(PROP_LAST_BRANCHID, Integer.toString(this.getLastBranchID()));
        map.put(PROP_LAST_LOCAL_BRANCHID, Integer.toString(this.getLastLocalBranchID()));
        map.put(PROP_LAST_COMMITTIME, Long.toString(this.getLastCommitTime()));
        map.put(PROP_LAST_NONLOCAL_COMMITTIME, Long.toString(this.getLastNonLocalCommitTime()));
        this.setPersistentProperties(map);
        if (this.readerPool != null) {
            this.readerPool.dispose();
        }
        if (this.writerPool != null) {
            this.writerPool.dispose();
        }
        this.connectionKeepAliveTimer.cancel();
        this.connectionKeepAliveTimer = null;
        super.doDeactivate();
    }

    protected boolean isFirstStart(Set<IDBTable> createdTables) {
        if (createdTables.contains(CDODBSchema.PROPERTIES)) {
            return true;
        }
        HashSet<String> names = new HashSet<String>();
        names.add(PROP_REPOSITORY_CREATED);
        Map<String, String> map = this.getPersistentProperties(names);
        return map.get(PROP_REPOSITORY_CREATED) == null;
    }

    protected void firstStart() {
        InternalRepository repository = this.getRepository();
        this.setCreationTime(repository.getTimeStamp());
        this.firstTime = true;
    }

    protected void reStart() {
        HashSet<String> names = new HashSet<String>();
        names.add(PROP_REPOSITORY_CREATED);
        names.add(PROP_GRACEFULLY_SHUT_DOWN);
        Map<String, String> map = this.getPersistentProperties(names);
        this.creationTime = Long.valueOf(map.get(PROP_REPOSITORY_CREATED));
        if (map.containsKey(PROP_GRACEFULLY_SHUT_DOWN)) {
            boolean generatingIDs;
            names.clear();
            InternalRepository repository = this.getRepository();
            boolean bl = generatingIDs = repository.getIDGenerationLocation() == CDOCommonRepository.IDGenerationLocation.STORE;
            if (generatingIDs) {
                names.add(PROP_NEXT_LOCAL_CDOID);
                names.add(PROP_LAST_CDOID);
            }
            names.add(PROP_LAST_BRANCHID);
            names.add(PROP_LAST_LOCAL_BRANCHID);
            names.add(PROP_LAST_COMMITTIME);
            names.add(PROP_LAST_NONLOCAL_COMMITTIME);
            map = this.getPersistentProperties(names);
            if (generatingIDs) {
                this.idHandler.setNextLocalObjectID(Store.stringToID((String)map.get(PROP_NEXT_LOCAL_CDOID)));
                this.idHandler.setLastObjectID(Store.stringToID((String)map.get(PROP_LAST_CDOID)));
            }
            this.setLastBranchID(Integer.valueOf(map.get(PROP_LAST_BRANCHID)));
            this.setLastLocalBranchID(Integer.valueOf(map.get(PROP_LAST_LOCAL_BRANCHID)));
            this.setLastCommitTime(Long.valueOf(map.get(PROP_LAST_COMMITTIME)));
            this.setLastNonLocalCommitTime(Long.valueOf(map.get(PROP_LAST_NONLOCAL_COMMITTIME)));
        } else {
            this.repairAfterCrash();
        }
        this.removePersistentProperties(Collections.singleton(PROP_GRACEFULLY_SHUT_DOWN));
    }

    protected void repairAfterCrash() {
        String name = this.getRepository().getName();
        OM.LOG.warn(MessageFormat.format(Messages.getString("DBStore.9"), name));
        Connection connection = this.getConnection();
        try {
            try {
                connection.setAutoCommit(false);
                connection.setReadOnly(true);
                this.mappingStrategy.repairAfterCrash(this.dbAdapter, connection);
                boolean storeIDs = this.getRepository().getIDGenerationLocation() == CDOCommonRepository.IDGenerationLocation.STORE;
                CDOID lastObjectID = storeIDs ? this.idHandler.getLastObjectID() : CDOID.NULL;
                CDOID nextLocalObjectID = storeIDs ? this.idHandler.getNextLocalObjectID() : CDOID.NULL;
                int branchID = DBUtil.selectMaximumInt((Connection)connection, (IDBField)CDODBSchema.BRANCHES_ID, (String[])new String[0]);
                this.setLastBranchID(branchID > 0 ? branchID : 0);
                int localBranchID = DBUtil.selectMinimumInt((Connection)connection, (IDBField)CDODBSchema.BRANCHES_ID, (String[])new String[0]);
                this.setLastLocalBranchID(localBranchID < 0 ? localBranchID : 0);
                long lastCommitTime = DBUtil.selectMaximumLong((Connection)connection, (IDBField)CDODBSchema.COMMIT_INFOS_TIMESTAMP, (String[])new String[0]);
                this.setLastCommitTime(lastCommitTime);
                long lastNonLocalCommitTime = DBUtil.selectMaximumLong((Connection)connection, (IDBField)CDODBSchema.COMMIT_INFOS_TIMESTAMP, (String[])new String[]{"0<=" + CDODBSchema.COMMIT_INFOS_BRANCH});
                this.setLastNonLocalCommitTime(lastNonLocalCommitTime);
                if (storeIDs) {
                    OM.LOG.info(MessageFormat.format(Messages.getString("DBStore.10"), name, lastObjectID, nextLocalObjectID, this.getLastBranchID(), this.getLastCommitTime(), this.getLastNonLocalCommitTime()));
                } else {
                    OM.LOG.info(MessageFormat.format(Messages.getString("DBStore.10b"), name, this.getLastBranchID(), this.getLastCommitTime(), this.getLastNonLocalCommitTime()));
                }
            }
            catch (SQLException e) {
                OM.LOG.error(MessageFormat.format(Messages.getString("DBStore.11"), name), (Throwable)e);
                throw new DBException((Throwable)e);
            }
        }
        finally {
            DBUtil.close((Connection)connection);
        }
    }

    protected IDBSchema createSchema() {
        String name = this.getRepository().getName();
        return new DBSchema(name);
    }
}

