/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.db.mapping;

import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.cdo.common.model.CDOModelUtil;
import org.eclipse.emf.cdo.etypes.EtypesPackage;
import org.eclipse.emf.cdo.server.db.IIDHandler;
import org.eclipse.emf.cdo.server.db.mapping.IMappingStrategy;
import org.eclipse.emf.cdo.server.db.mapping.ITypeMapping;
import org.eclipse.emf.cdo.server.internal.db.DBAnnotation;
import org.eclipse.emf.cdo.server.internal.db.bundle.OM;
import org.eclipse.emf.cdo.server.internal.db.mapping.CoreTypeMappings;
import org.eclipse.emf.cdo.server.internal.db.mapping.TypeMappingUtil;
import org.eclipse.emf.cdo.server.internal.db.messages.Messages;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.net4j.db.DBType;
import org.eclipse.net4j.db.IDBAdapter;
import org.eclipse.net4j.util.collection.Pair;
import org.eclipse.net4j.util.container.ContainerEvent;
import org.eclipse.net4j.util.container.IContainerDelta;
import org.eclipse.net4j.util.container.IManagedContainer;
import org.eclipse.net4j.util.container.IPluginContainer;
import org.eclipse.net4j.util.event.IEvent;
import org.eclipse.net4j.util.event.IListener;
import org.eclipse.net4j.util.factory.IFactory;
import org.eclipse.net4j.util.factory.IFactoryKey;
import org.eclipse.net4j.util.om.trace.ContextTracer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeMappingRegistry
implements ITypeMapping.Registry,
ITypeMapping.Provider {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG, TypeMappingRegistry.class);
    private Map<EClassifier, DBType> classifierDefaultMapping;
    private Map<Pair<EClassifier, DBType>, ITypeMapping.Descriptor> typeMappingByTypes;
    private Map<String, ITypeMapping.Descriptor> typeMappingsById;
    private Set<DBType> defaultFeatureMapDBTypes;
    private RegistryPopulator populator = new RegistryPopulator();

    public TypeMappingRegistry() {
        this.init();
    }

    public void init() {
        this.populator.disconnect();
        this.defaultFeatureMapDBTypes = new HashSet<DBType>();
        this.typeMappingsById = new HashMap<String, ITypeMapping.Descriptor>();
        this.typeMappingByTypes = new HashMap<Pair<EClassifier, DBType>, ITypeMapping.Descriptor>();
        this.classifierDefaultMapping = new HashMap<EClassifier, DBType>();
        this.registerCoreTypeMappings();
        this.populator.connect();
    }

    private void registerCoreTypeMappings() {
        IManagedContainer container = this.getContainer();
        container.registerFactory((IFactory)CoreTypeMappings.TMBigDecimal.FACTORY);
        container.registerFactory((IFactory)CoreTypeMappings.TMBigDecimal.FACTORY_LONG_VARCHAR);
        container.registerFactory((IFactory)CoreTypeMappings.TMBigInteger.FACTORY);
        container.registerFactory((IFactory)CoreTypeMappings.TMBigInteger.FACTORY_LONG_VARCHAR);
        container.registerFactory((IFactory)CoreTypeMappings.TMBoolean.FACTORY);
        container.registerFactory((IFactory)CoreTypeMappings.TMBoolean.FACTORY_SMALLINT);
        container.registerFactory((IFactory)CoreTypeMappings.TMBoolean.FACTORY_OBJECT);
        container.registerFactory((IFactory)CoreTypeMappings.TMBoolean.FACTORY_OBJECT_SMALLINT);
        container.registerFactory((IFactory)CoreTypeMappings.TMByte.FACTORY);
        container.registerFactory((IFactory)CoreTypeMappings.TMByte.FACTORY_OBJECT);
        container.registerFactory((IFactory)CoreTypeMappings.TMBytes.FACTORY);
        container.registerFactory((IFactory)CoreTypeMappings.TMBytesVarbinary.FACTORY);
        container.registerFactory((IFactory)CoreTypeMappings.TMCharacter.FACTORY);
        container.registerFactory((IFactory)CoreTypeMappings.TMCharacter.FACTORY_OBJECT);
        container.registerFactory((IFactory)CoreTypeMappings.TMCustom.FACTORY_VARCHAR);
        container.registerFactory((IFactory)CoreTypeMappings.TMCustom.FACTORY_CLOB);
        container.registerFactory((IFactory)CoreTypeMappings.TMCustom.FACTORY_LONG_VARCHAR);
        container.registerFactory((IFactory)CoreTypeMappings.TMDate2Date.FACTORY);
        container.registerFactory((IFactory)CoreTypeMappings.TMDate2Time.FACTORY);
        container.registerFactory((IFactory)CoreTypeMappings.TMDate2Timestamp.FACTORY);
        container.registerFactory((IFactory)CoreTypeMappings.TMDouble.FACTORY);
        container.registerFactory((IFactory)CoreTypeMappings.TMDouble.FACTORY_OBJECT);
        container.registerFactory((IFactory)CoreTypeMappings.TMEnum.FACTORY);
        container.registerFactory((IFactory)CoreTypeMappings.TMFloat.FACTORY);
        container.registerFactory((IFactory)CoreTypeMappings.TMFloat.FACTORY_OBJECT);
        container.registerFactory((IFactory)CoreTypeMappings.TMInteger.FACTORY);
        container.registerFactory((IFactory)CoreTypeMappings.TMInteger.FACTORY_OBJECT);
        container.registerFactory((IFactory)CoreTypeMappings.TMLong.FACTORY);
        container.registerFactory((IFactory)CoreTypeMappings.TMLong.FACTORY_OBJECT);
        container.registerFactory((IFactory)CoreTypeMappings.TMShort.FACTORY);
        container.registerFactory((IFactory)CoreTypeMappings.TMShort.FACTORY_OBJECT);
        container.registerFactory((IFactory)CoreTypeMappings.TMString.FACTORY_VARCHAR);
        container.registerFactory((IFactory)CoreTypeMappings.TMString.FACTORY_CLOB);
        container.registerFactory((IFactory)CoreTypeMappings.TMString.FACTORY_LONG_VARCHAR);
        container.registerFactory((IFactory)CoreTypeMappings.TMBlob.FACTORY_VARCHAR);
        container.registerFactory((IFactory)CoreTypeMappings.TMBlob.FACTORY_LONG_VARCHAR);
        container.registerFactory((IFactory)CoreTypeMappings.TMClob.FACTORY_VARCHAR);
        container.registerFactory((IFactory)CoreTypeMappings.TMClob.FACTORY_LONG_VARCHAR);
        this.classifierDefaultMapping.put((EClassifier)EcorePackage.eINSTANCE.getEDataType(), DBType.VARCHAR);
        this.classifierDefaultMapping.put((EClassifier)EcorePackage.eINSTANCE.getEBigDecimal(), DBType.VARCHAR);
        this.classifierDefaultMapping.put((EClassifier)EcorePackage.eINSTANCE.getEBigInteger(), DBType.VARCHAR);
        this.classifierDefaultMapping.put((EClassifier)EcorePackage.eINSTANCE.getEBoolean(), DBType.BOOLEAN);
        this.classifierDefaultMapping.put((EClassifier)EcorePackage.eINSTANCE.getEBooleanObject(), DBType.BOOLEAN);
        this.classifierDefaultMapping.put((EClassifier)EcorePackage.eINSTANCE.getEByte(), DBType.SMALLINT);
        this.classifierDefaultMapping.put((EClassifier)EcorePackage.eINSTANCE.getEByteObject(), DBType.SMALLINT);
        this.classifierDefaultMapping.put((EClassifier)EcorePackage.eINSTANCE.getEByteArray(), DBType.BLOB);
        this.classifierDefaultMapping.put((EClassifier)EcorePackage.eINSTANCE.getEChar(), DBType.CHAR);
        this.classifierDefaultMapping.put((EClassifier)EcorePackage.eINSTANCE.getECharacterObject(), DBType.CHAR);
        this.classifierDefaultMapping.put((EClassifier)EcorePackage.eINSTANCE.getEDate(), DBType.TIMESTAMP);
        this.classifierDefaultMapping.put((EClassifier)EcorePackage.eINSTANCE.getEDouble(), DBType.DOUBLE);
        this.classifierDefaultMapping.put((EClassifier)EcorePackage.eINSTANCE.getEDoubleObject(), DBType.DOUBLE);
        this.classifierDefaultMapping.put((EClassifier)EcorePackage.eINSTANCE.getEEnum(), DBType.INTEGER);
        this.classifierDefaultMapping.put((EClassifier)EcorePackage.eINSTANCE.getEFloat(), DBType.FLOAT);
        this.classifierDefaultMapping.put((EClassifier)EcorePackage.eINSTANCE.getEFloatObject(), DBType.FLOAT);
        this.classifierDefaultMapping.put((EClassifier)EcorePackage.eINSTANCE.getEInt(), DBType.INTEGER);
        this.classifierDefaultMapping.put((EClassifier)EcorePackage.eINSTANCE.getEIntegerObject(), DBType.INTEGER);
        this.classifierDefaultMapping.put((EClassifier)EcorePackage.eINSTANCE.getELong(), DBType.BIGINT);
        this.classifierDefaultMapping.put((EClassifier)EcorePackage.eINSTANCE.getELongObject(), DBType.BIGINT);
        this.classifierDefaultMapping.put((EClassifier)EcorePackage.eINSTANCE.getEShort(), DBType.SMALLINT);
        this.classifierDefaultMapping.put((EClassifier)EcorePackage.eINSTANCE.getEShortObject(), DBType.SMALLINT);
        this.classifierDefaultMapping.put((EClassifier)EcorePackage.eINSTANCE.getEString(), DBType.VARCHAR);
        this.classifierDefaultMapping.put((EClassifier)EtypesPackage.eINSTANCE.getBlob(), DBType.VARCHAR);
        this.classifierDefaultMapping.put((EClassifier)EtypesPackage.eINSTANCE.getClob(), DBType.VARCHAR);
    }

    protected IManagedContainer getContainer() {
        return IPluginContainer.INSTANCE;
    }

    @Override
    public void registerTypeMapping(ITypeMapping.Descriptor descriptor) {
        DBType dbType;
        EClassifier eClassifier;
        Pair sourceTargetPair;
        if (TRACER.isEnabled()) {
            TRACER.format("Registering {0}", new Object[]{descriptor});
        }
        if (this.typeMappingByTypes.containsKey(sourceTargetPair = new Pair((Object)(eClassifier = descriptor.getEClassifier()), (Object)(dbType = descriptor.getDBType())))) {
            OM.LOG.error(Messages.getString("TypeMappingRegistry.4"));
            return;
        }
        if (this.typeMappingsById.containsKey(descriptor.getID())) {
            OM.LOG.error(MessageFormat.format(Messages.getString("TypeMappingRegistry.5"), descriptor.getID()));
            return;
        }
        this.typeMappingsById.put(descriptor.getID(), descriptor);
        if (!this.classifierDefaultMapping.containsKey(eClassifier)) {
            this.classifierDefaultMapping.put(eClassifier, dbType);
        }
        this.defaultFeatureMapDBTypes.add(dbType);
        this.typeMappingByTypes.put((Pair<EClassifier, DBType>)sourceTargetPair, descriptor);
    }

    @Override
    public ITypeMapping createTypeMapping(IMappingStrategy mappingStrategy, EStructuralFeature feature) {
        ITypeMapping typeMapping = null;
        if (feature instanceof EReference) {
            IIDHandler idHandler = mappingStrategy.getStore().getIDHandler();
            typeMapping = idHandler.getObjectTypeMapping();
            typeMapping.setDBType(idHandler.getDBType());
        } else {
            IDBAdapter dbAdapter = mappingStrategy.getStore().getDBAdapter();
            DBType dbType = this.getDBType(feature, dbAdapter);
            ITypeMapping.Descriptor descriptor = null;
            String typeMappingID = DBAnnotation.TYPE_MAPPING.getValue((EModelElement)feature);
            if (typeMappingID != null && (descriptor = this.typeMappingsById.get(typeMappingID)) == null) {
                OM.LOG.warn(MessageFormat.format(Messages.getString("TypeMappingRegistry.2"), typeMappingID, feature.toString()));
            }
            if (descriptor == null) {
                descriptor = this.getMappingByType(feature, dbType);
            }
            if (descriptor == null) {
                EClassifier type = this.getEType(feature);
                throw new IllegalStateException(MessageFormat.format(Messages.getString("TypeMappingRegistry.1"), String.valueOf(feature.getEContainingClass().getName()) + "." + feature.getName(), String.valueOf(type.getEPackage().getName()) + "." + type.getName(), dbType.getKeyword()));
            }
            IFactory factory = this.getContainer().getFactory("org.eclipse.emf.cdo.server.db.typeMappings", descriptor.getFactoryType());
            typeMapping = (ITypeMapping)factory.create(null);
            typeMapping.setDBType(dbType);
        }
        typeMapping.setMappingStrategy(mappingStrategy);
        typeMapping.setFeature(feature);
        return typeMapping;
    }

    private EClassifier getEType(EStructuralFeature feature) {
        EClassifier classifier = feature.getEType();
        if (classifier instanceof EEnum) {
            return EcorePackage.eINSTANCE.getEEnum();
        }
        if (classifier instanceof EClass) {
            return EcorePackage.eINSTANCE.getEClass();
        }
        EPackage ePackage = classifier.getEPackage();
        if (CDOModelUtil.isCorePackage((EPackage)ePackage)) {
            return classifier;
        }
        if (CDOModelUtil.isTypesPackage((EPackage)ePackage)) {
            return classifier;
        }
        return EcorePackage.eINSTANCE.getEDataType();
    }

    private DBType getDBType(EStructuralFeature feature, IDBAdapter dbAdapter) {
        String typeKeyword = DBAnnotation.COLUMN_TYPE.getValue((EModelElement)feature);
        if (typeKeyword != null) {
            DBType dbType = DBType.getTypeByKeyword((String)typeKeyword);
            if (dbType == null) {
                throw new IllegalArgumentException("Unsupported columnType (" + typeKeyword + ") annotation of feature " + feature.getName());
            }
            return dbType;
        }
        return this.getDefaultDBType(this.getEType(feature), dbAdapter);
    }

    private DBType getDefaultDBType(EClassifier type, IDBAdapter dbAdapter) {
        DBType result = this.classifierDefaultMapping.get(type);
        if (result == null) {
            result = DBType.VARCHAR;
        }
        return dbAdapter.adaptType(result);
    }

    private ITypeMapping.Descriptor getMappingByType(EStructuralFeature feature, DBType dbType) {
        ITypeMapping.Descriptor descriptor = this.typeMappingByTypes.get(new Pair((Object)feature.getEType(), (Object)dbType));
        if (descriptor == null && (descriptor = this.typeMappingByTypes.get(new Pair((Object)this.getEType(feature), (Object)dbType))) == null) {
            return null;
        }
        return descriptor;
    }

    @Override
    public Collection<DBType> getDefaultFeatureMapDBTypes() {
        return this.defaultFeatureMapDBTypes;
    }

    private class RegistryPopulator
    implements IListener {
        private IManagedContainer container;

        public RegistryPopulator() {
            this.container = TypeMappingRegistry.this.getContainer();
        }

        public void connect() {
            this.populateTypeMappingRegistry();
            this.container.getFactoryRegistry().addListener((IListener)this);
        }

        public void disconnect() {
            this.container.getFactoryRegistry().removeListener((IListener)this);
        }

        private void populateTypeMappingRegistry() {
            Set factoryTypes = this.container.getFactoryTypes("org.eclipse.emf.cdo.server.db.typeMappings");
            for (String factoryType : factoryTypes) {
                this.registerFactoryType(factoryType);
            }
        }

        private void registerFactoryType(String factoryType) {
            try {
                ITypeMapping.Descriptor desc = TypeMappingUtil.descriptorFromFactoryType(factoryType);
                TypeMappingRegistry.this.registerTypeMapping(desc);
            }
            catch (TypeMappingUtil.FactoryTypeParserException ex) {
                OM.LOG.warn((Throwable)ex);
            }
        }

        public void notifyEvent(IEvent event) {
            if (event instanceof ContainerEvent) {
                ContainerEvent ev = (ContainerEvent)event;
                IContainerDelta[] iContainerDeltaArray = ev.getDeltas();
                int n = iContainerDeltaArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IContainerDelta delta = iContainerDeltaArray[n2];
                    IFactoryKey key = (IFactoryKey)((Map.Entry)delta.getElement()).getKey();
                    if (key.getProductGroup().equals("org.eclipse.emf.cdo.server.db.typeMappings")) {
                        if (delta.getKind() == IContainerDelta.Kind.ADDED) {
                            String factoryType = ((IFactoryKey)((Map.Entry)delta.getElement()).getKey()).getType();
                            this.registerFactoryType(factoryType);
                        } else {
                            OM.LOG.warn(Messages.getString("TypeMappingRegistry.3"));
                        }
                    }
                    ++n2;
                }
            }
        }
    }
}

