/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.db.mapping.horizontal;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Map;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.branch.CDOBranchVersion;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.revision.CDOList;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.revision.delta.CDOAddFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOClearFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOContainerFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOFeatureDeltaVisitor;
import org.eclipse.emf.cdo.common.revision.delta.CDOListFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOMoveFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDORemoveFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOSetFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOUnsetFeatureDelta;
import org.eclipse.emf.cdo.eresource.EresourcePackage;
import org.eclipse.emf.cdo.server.IStoreAccessor;
import org.eclipse.emf.cdo.server.db.IDBStoreAccessor;
import org.eclipse.emf.cdo.server.db.IIDHandler;
import org.eclipse.emf.cdo.server.db.IPreparedStatementCache;
import org.eclipse.emf.cdo.server.db.mapping.IClassMappingAuditSupport;
import org.eclipse.emf.cdo.server.db.mapping.IClassMappingDeltaSupport;
import org.eclipse.emf.cdo.server.db.mapping.IListMappingDeltaSupport;
import org.eclipse.emf.cdo.server.db.mapping.ITypeMapping;
import org.eclipse.emf.cdo.server.internal.db.bundle.OM;
import org.eclipse.emf.cdo.server.internal.db.mapping.horizontal.AbstractHorizontalClassMapping;
import org.eclipse.emf.cdo.server.internal.db.mapping.horizontal.AbstractHorizontalMappingStrategy;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevisionDelta;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.net4j.db.DBException;
import org.eclipse.net4j.db.DBUtil;
import org.eclipse.net4j.util.ImplementationError;
import org.eclipse.net4j.util.om.monitor.OMMonitor;
import org.eclipse.net4j.util.om.trace.ContextTracer;

public class HorizontalAuditClassMapping
extends AbstractHorizontalClassMapping
implements IClassMappingAuditSupport,
IClassMappingDeltaSupport {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG, HorizontalAuditClassMapping.class);
    private String sqlInsertAttributes;
    private String sqlSelectCurrentAttributes;
    private String sqlSelectAllObjectIDs;
    private String sqlSelectAttributesByTime;
    private String sqlSelectAttributesByVersion;
    private String sqlReviseAttributes;
    private String sqlRawDeleteAttributes;
    private ThreadLocal<FeatureDeltaWriter> deltaWriter = new ThreadLocal<FeatureDeltaWriter>(){

        @Override
        protected FeatureDeltaWriter initialValue() {
            return new FeatureDeltaWriter();
        }
    };

    public HorizontalAuditClassMapping(AbstractHorizontalMappingStrategy mappingStrategy, EClass eClass) {
        super(mappingStrategy, eClass);
        this.initSQLStrings();
    }

    private void initSQLStrings() {
        Map<EStructuralFeature, String> unsettableFields = this.getUnsettableFields();
        Map<EStructuralFeature, String> listSizeFields = this.getListSizeFields();
        StringBuilder builder = new StringBuilder();
        builder.append("SELECT ");
        builder.append("cdo_version");
        builder.append(", ");
        builder.append("cdo_created");
        builder.append(", ");
        builder.append("cdo_revised");
        builder.append(", ");
        builder.append("cdo_resource");
        builder.append(", ");
        builder.append("cdo_container");
        builder.append(", ");
        builder.append("cdo_feature");
        for (ITypeMapping singleMapping : this.getValueMappings()) {
            builder.append(", ");
            builder.append(singleMapping.getField());
        }
        if (unsettableFields != null) {
            for (String fieldName : unsettableFields.values()) {
                builder.append(", ");
                builder.append(fieldName);
            }
        }
        if (listSizeFields != null) {
            for (String fieldName : listSizeFields.values()) {
                builder.append(", ");
                builder.append(fieldName);
            }
        }
        builder.append(" FROM ");
        builder.append(this.getTable());
        builder.append(" WHERE ");
        builder.append("cdo_id");
        builder.append("=? AND (");
        String sqlSelectAttributesPrefix = builder.toString();
        builder.append("cdo_revised");
        builder.append("=0)");
        this.sqlSelectCurrentAttributes = builder.toString();
        builder = new StringBuilder(sqlSelectAttributesPrefix);
        builder.append("cdo_created");
        builder.append("<=? AND (");
        builder.append("cdo_revised");
        builder.append("=0 OR ");
        builder.append("cdo_revised");
        builder.append(">=?))");
        this.sqlSelectAttributesByTime = builder.toString();
        builder = new StringBuilder(sqlSelectAttributesPrefix);
        builder.append("ABS(");
        builder.append("cdo_version");
        builder.append(")=?)");
        this.sqlSelectAttributesByVersion = builder.toString();
        builder = new StringBuilder();
        builder.append("INSERT INTO ");
        builder.append(this.getTable());
        builder.append("(");
        builder.append("cdo_id");
        builder.append(", ");
        builder.append("cdo_version");
        builder.append(", ");
        builder.append("cdo_created");
        builder.append(", ");
        builder.append("cdo_revised");
        builder.append(", ");
        builder.append("cdo_resource");
        builder.append(", ");
        builder.append("cdo_container");
        builder.append(", ");
        builder.append("cdo_feature");
        for (ITypeMapping singleMapping : this.getValueMappings()) {
            builder.append(", ");
            builder.append(singleMapping.getField());
        }
        if (unsettableFields != null) {
            for (String fieldName : unsettableFields.values()) {
                builder.append(", ");
                builder.append(fieldName);
            }
        }
        if (listSizeFields != null) {
            for (String fieldName : listSizeFields.values()) {
                builder.append(", ");
                builder.append(fieldName);
            }
        }
        builder.append(") VALUES (?, ?, ?, ?, ?, ?, ?");
        int i = 0;
        while (i < this.getValueMappings().size()) {
            builder.append(", ?");
            ++i;
        }
        if (unsettableFields != null) {
            i = 0;
            while (i < unsettableFields.size()) {
                builder.append(", ?");
                ++i;
            }
        }
        if (listSizeFields != null) {
            i = 0;
            while (i < listSizeFields.size()) {
                builder.append(", ?");
                ++i;
            }
        }
        builder.append(")");
        this.sqlInsertAttributes = builder.toString();
        builder = new StringBuilder("UPDATE ");
        builder.append(this.getTable());
        builder.append(" SET ");
        builder.append("cdo_revised");
        builder.append("=? WHERE ");
        builder.append("cdo_id");
        builder.append("=? AND ");
        builder.append("cdo_revised");
        builder.append("=0");
        this.sqlReviseAttributes = builder.toString();
        builder = new StringBuilder("SELECT ");
        builder.append("cdo_id");
        builder.append(" FROM ");
        builder.append(this.getTable());
        builder.append(" WHERE ");
        builder.append("cdo_revised");
        builder.append("=0");
        this.sqlSelectAllObjectIDs = builder.toString();
        builder = new StringBuilder("DELETE FROM ");
        builder.append(this.getTable());
        builder.append(" WHERE ");
        builder.append("cdo_id");
        builder.append("=? AND ");
        builder.append("cdo_version");
        builder.append("=?");
        this.sqlRawDeleteAttributes = builder.toString();
    }

    public boolean readRevision(IDBStoreAccessor accessor, InternalCDORevision revision, int listChunk) {
        IIDHandler idHandler = this.getMappingStrategy().getStore().getIDHandler();
        IPreparedStatementCache statementCache = accessor.getStatementCache();
        PreparedStatement stmt = null;
        try {
            long timeStamp = revision.getTimeStamp();
            if (timeStamp != 0L) {
                stmt = statementCache.getPreparedStatement(this.sqlSelectAttributesByTime, IPreparedStatementCache.ReuseProbability.MEDIUM);
                idHandler.setCDOID(stmt, 1, revision.getID());
                stmt.setLong(2, timeStamp);
                stmt.setLong(3, timeStamp);
            } else {
                stmt = statementCache.getPreparedStatement(this.sqlSelectCurrentAttributes, IPreparedStatementCache.ReuseProbability.HIGH);
                idHandler.setCDOID(stmt, 1, revision.getID());
            }
            boolean success = this.readValuesFromStatement(stmt, revision, accessor);
            if (success && revision.getVersion() >= 1) {
                this.readLists(accessor, revision, listChunk);
            }
            boolean bl = success;
            statementCache.releasePreparedStatement(stmt);
            return bl;
        }
        catch (SQLException ex) {
            try {
                throw new DBException((Throwable)ex);
            }
            catch (Throwable throwable) {
                statementCache.releasePreparedStatement(stmt);
                throw throwable;
            }
        }
    }

    public boolean readRevisionByVersion(IDBStoreAccessor accessor, InternalCDORevision revision, int listChunk) {
        IIDHandler idHandler = this.getMappingStrategy().getStore().getIDHandler();
        IPreparedStatementCache statementCache = accessor.getStatementCache();
        PreparedStatement stmt = null;
        try {
            stmt = statementCache.getPreparedStatement(this.sqlSelectAttributesByVersion, IPreparedStatementCache.ReuseProbability.HIGH);
            idHandler.setCDOID(stmt, 1, revision.getID());
            stmt.setInt(2, revision.getVersion());
            boolean success = this.readValuesFromStatement(stmt, revision, accessor);
            if (success) {
                this.readLists(accessor, revision, listChunk);
            }
            boolean bl = success;
            statementCache.releasePreparedStatement(stmt);
            return bl;
        }
        catch (SQLException ex) {
            try {
                throw new DBException((Throwable)ex);
            }
            catch (Throwable throwable) {
                statementCache.releasePreparedStatement(stmt);
                throw throwable;
            }
        }
    }

    public PreparedStatement createResourceQueryStatement(IDBStoreAccessor accessor, CDOID folderId, String name, boolean exactMatch, CDOBranchPoint branchPoint) {
        EAttribute nameFeature = EresourcePackage.eINSTANCE.getCDOResourceNode_Name();
        long timeStamp = branchPoint.getTimeStamp();
        ITypeMapping nameValueMapping = this.getValueMapping((EStructuralFeature)nameFeature);
        if (nameValueMapping == null) {
            throw new ImplementationError(nameFeature + " not found in ClassMapping " + this);
        }
        StringBuilder builder = new StringBuilder();
        builder.append("SELECT ");
        builder.append("cdo_id");
        builder.append(" FROM ");
        builder.append(this.getTable());
        builder.append(" WHERE ");
        builder.append("cdo_version");
        builder.append(">0 AND ");
        builder.append("cdo_container");
        builder.append("=? AND ");
        builder.append(nameValueMapping.getField());
        if (name == null) {
            builder.append(" IS NULL");
        } else {
            builder.append(exactMatch ? "=? " : " LIKE ? ");
        }
        builder.append(" AND (");
        if (timeStamp == 0L) {
            builder.append("cdo_revised");
            builder.append("=0)");
        } else {
            builder.append("cdo_created");
            builder.append("<=? AND (");
            builder.append("cdo_revised");
            builder.append("=0 OR ");
            builder.append("cdo_revised");
            builder.append(">=?))");
        }
        IIDHandler idHandler = this.getMappingStrategy().getStore().getIDHandler();
        IPreparedStatementCache statementCache = accessor.getStatementCache();
        PreparedStatement stmt = null;
        try {
            int column = 1;
            stmt = statementCache.getPreparedStatement(builder.toString(), IPreparedStatementCache.ReuseProbability.MEDIUM);
            idHandler.setCDOID(stmt, column++, folderId);
            if (name != null) {
                String queryName = exactMatch ? name : String.valueOf(name) + "%";
                nameValueMapping.setValue(stmt, column++, queryName);
            }
            if (timeStamp != 0L) {
                stmt.setLong(column++, timeStamp);
                stmt.setLong(column++, timeStamp);
            }
            if (TRACER.isEnabled()) {
                TRACER.format("Created Resource Query: {0}", new Object[]{stmt.toString()});
            }
            return stmt;
        }
        catch (SQLException ex) {
            statementCache.releasePreparedStatement(stmt);
            throw new DBException((Throwable)ex);
        }
    }

    public PreparedStatement createObjectIDStatement(IDBStoreAccessor accessor) {
        if (TRACER.isEnabled()) {
            TRACER.format("Created ObjectID Statement : {0}", new Object[]{this.sqlSelectAllObjectIDs});
        }
        IPreparedStatementCache statementCache = accessor.getStatementCache();
        return statementCache.getPreparedStatement(this.sqlSelectAllObjectIDs, IPreparedStatementCache.ReuseProbability.HIGH);
    }

    protected final void writeValues(IDBStoreAccessor accessor, InternalCDORevision revision) {
        IIDHandler idHandler = this.getMappingStrategy().getStore().getIDHandler();
        IPreparedStatementCache statementCache = accessor.getStatementCache();
        PreparedStatement stmt = null;
        try {
            try {
                int column = 1;
                stmt = statementCache.getPreparedStatement(this.sqlInsertAttributes, IPreparedStatementCache.ReuseProbability.HIGH);
                idHandler.setCDOID(stmt, column++, revision.getID());
                stmt.setInt(column++, revision.getVersion());
                stmt.setLong(column++, revision.getTimeStamp());
                stmt.setLong(column++, revision.getRevised());
                idHandler.setCDOID(stmt, column++, revision.getResourceID());
                idHandler.setCDOID(stmt, column++, (CDOID)revision.getContainerID());
                stmt.setInt(column++, revision.getContainingFeatureID());
                int isSetCol = column + this.getValueMappings().size();
                for (ITypeMapping mapping : this.getValueMappings()) {
                    EStructuralFeature feature = mapping.getFeature();
                    if (feature.isUnsettable()) {
                        if (revision.getValue(feature) == null) {
                            stmt.setBoolean(isSetCol++, false);
                            mapping.setDefaultValue(stmt, column++);
                            continue;
                        }
                        stmt.setBoolean(isSetCol++, true);
                    }
                    mapping.setValueFromRevision(stmt, column++, revision);
                }
                Map<EStructuralFeature, String> listSizeFields = this.getListSizeFields();
                if (listSizeFields != null) {
                    column = isSetCol;
                    for (EStructuralFeature feature : listSizeFields.keySet()) {
                        CDOList list = revision.getList(feature);
                        stmt.setInt(column++, list.size());
                    }
                }
                DBUtil.update((PreparedStatement)stmt, (boolean)true);
            }
            catch (SQLException e) {
                throw new DBException((Throwable)e);
            }
        }
        catch (Throwable throwable) {
            statementCache.releasePreparedStatement(stmt);
            throw throwable;
        }
        statementCache.releasePreparedStatement(stmt);
    }

    protected void detachAttributes(IDBStoreAccessor accessor, CDOID id, int version, CDOBranch branch, long timeStamp, OMMonitor mon) {
        IIDHandler idHandler = this.getMappingStrategy().getStore().getIDHandler();
        IPreparedStatementCache statementCache = accessor.getStatementCache();
        PreparedStatement stmt = null;
        try {
            try {
                stmt = statementCache.getPreparedStatement(this.sqlInsertAttributes, IPreparedStatementCache.ReuseProbability.HIGH);
                int column = 1;
                idHandler.setCDOID(stmt, column++, id);
                stmt.setInt(column++, -version);
                stmt.setLong(column++, timeStamp);
                stmt.setLong(column++, 0L);
                idHandler.setCDOID(stmt, column++, CDOID.NULL);
                idHandler.setCDOID(stmt, column++, CDOID.NULL);
                stmt.setInt(column++, 0);
                int isSetCol = column + this.getValueMappings().size();
                for (ITypeMapping mapping : this.getValueMappings()) {
                    EStructuralFeature feature = mapping.getFeature();
                    if (feature.isUnsettable()) {
                        stmt.setBoolean(isSetCol++, false);
                    }
                    mapping.setDefaultValue(stmt, column++);
                }
                Map<EStructuralFeature, String> listSizeFields = this.getListSizeFields();
                if (listSizeFields != null) {
                    column = isSetCol;
                    int i = 0;
                    while (i < listSizeFields.size()) {
                        stmt.setInt(column++, 0);
                        ++i;
                    }
                }
                DBUtil.update((PreparedStatement)stmt, (boolean)true);
            }
            catch (SQLException e) {
                throw new DBException((Throwable)e);
            }
        }
        catch (Throwable throwable) {
            statementCache.releasePreparedStatement(stmt);
            throw throwable;
        }
        statementCache.releasePreparedStatement(stmt);
    }

    protected void rawDeleteAttributes(IDBStoreAccessor accessor, CDOID id, CDOBranch branch, int version, OMMonitor fork) {
        IPreparedStatementCache statementCache = accessor.getStatementCache();
        PreparedStatement stmt = null;
        try {
            try {
                stmt = statementCache.getPreparedStatement(this.sqlRawDeleteAttributes, IPreparedStatementCache.ReuseProbability.HIGH);
                this.getMappingStrategy().getStore().getIDHandler().setCDOID(stmt, 1, id);
                stmt.setInt(2, version);
                DBUtil.update((PreparedStatement)stmt, (boolean)false);
            }
            catch (SQLException e) {
                throw new DBException((Throwable)e);
            }
        }
        catch (Throwable throwable) {
            statementCache.releasePreparedStatement(stmt);
            throw throwable;
        }
        statementCache.releasePreparedStatement(stmt);
    }

    protected void reviseOldRevision(IDBStoreAccessor accessor, CDOID id, CDOBranch branch, long revised) {
        IIDHandler idHandler = this.getMappingStrategy().getStore().getIDHandler();
        IPreparedStatementCache statementCache = accessor.getStatementCache();
        PreparedStatement stmt = null;
        try {
            try {
                stmt = statementCache.getPreparedStatement(this.sqlReviseAttributes, IPreparedStatementCache.ReuseProbability.HIGH);
                stmt.setLong(1, revised);
                idHandler.setCDOID(stmt, 2, id);
                DBUtil.update((PreparedStatement)stmt, (boolean)true);
            }
            catch (SQLException e) {
                throw new DBException((Throwable)e);
            }
        }
        catch (Throwable throwable) {
            statementCache.releasePreparedStatement(stmt);
            throw throwable;
        }
        statementCache.releasePreparedStatement(stmt);
    }

    public void writeRevisionDelta(IDBStoreAccessor accessor, InternalCDORevisionDelta delta, long created, OMMonitor monitor) {
        OMMonitor.Async async = null;
        monitor.begin();
        try {
            try {
                async = monitor.forkAsync();
                FeatureDeltaWriter writer = this.deltaWriter.get();
                writer.process(accessor, delta, created);
            }
            finally {
                if (async != null) {
                    async.stop();
                }
            }
        }
        finally {
            monitor.done();
        }
    }

    protected String getListXRefsWhere(IStoreAccessor.QueryXRefsContext context) {
        if (context.getBranch().getID() != 0) {
            throw new IllegalArgumentException("Non-audit mode does not support branch specification");
        }
        StringBuilder builder = new StringBuilder();
        long timeStamp = context.getTimeStamp();
        if (timeStamp == 0L) {
            builder.append("cdo_revised");
            builder.append("=0");
        } else {
            builder.append("cdo_created");
            builder.append("<=");
            builder.append(timeStamp);
            builder.append(" AND (");
            builder.append("cdo_revised");
            builder.append("=0 OR ");
            builder.append("cdo_revised");
            builder.append(">=");
            builder.append(timeStamp);
            builder.append(")");
        }
        return builder.toString();
    }

    private class FeatureDeltaWriter
    implements CDOFeatureDeltaVisitor {
        private IDBStoreAccessor accessor;
        private long created;
        private CDOID id;
        private int oldVersion;
        private InternalCDORevision newRevision;
        private int branchId;

        private FeatureDeltaWriter() {
        }

        public void process(IDBStoreAccessor accessor, InternalCDORevisionDelta delta, long created) {
            this.accessor = accessor;
            this.created = created;
            this.id = delta.getID();
            this.branchId = delta.getBranch().getID();
            this.oldVersion = delta.getVersion();
            if (TRACER.isEnabled()) {
                TRACER.format("FeatureDeltaWriter: old version: {0}, new version: {1}", new Object[]{this.oldVersion, this.oldVersion + 1});
            }
            InternalCDORevision originalRevision = (InternalCDORevision)accessor.getStore().getRepository().getRevisionManager().getRevisionByVersion(this.id, (CDOBranchVersion)delta, 0, true);
            this.newRevision = originalRevision.copy();
            this.newRevision.setVersion(this.oldVersion + 1);
            this.newRevision.setBranchPoint(delta.getBranch().getPoint(created));
            delta.accept((CDOFeatureDeltaVisitor)this);
            long revised = this.newRevision.getTimeStamp() - 1L;
            HorizontalAuditClassMapping.this.reviseOldRevision(accessor, this.id, delta.getBranch(), revised);
            HorizontalAuditClassMapping.this.writeValues(accessor, this.newRevision);
        }

        public void visit(CDOMoveFeatureDelta delta) {
            throw new ImplementationError("Should not be called");
        }

        public void visit(CDOAddFeatureDelta delta) {
            throw new ImplementationError("Should not be called");
        }

        public void visit(CDORemoveFeatureDelta delta) {
            throw new ImplementationError("Should not be called");
        }

        public void visit(CDOSetFeatureDelta delta) {
            delta.apply((CDORevision)this.newRevision);
        }

        public void visit(CDOUnsetFeatureDelta delta) {
            delta.apply((CDORevision)this.newRevision);
        }

        public void visit(CDOListFeatureDelta delta) {
            delta.apply((CDORevision)this.newRevision);
            IListMappingDeltaSupport listMapping = (IListMappingDeltaSupport)((Object)HorizontalAuditClassMapping.this.getListMapping(delta.getFeature()));
            listMapping.processDelta(this.accessor, this.id, this.branchId, this.oldVersion, this.oldVersion + 1, this.created, delta);
        }

        public void visit(CDOClearFeatureDelta delta) {
            throw new ImplementationError("Should not be called");
        }

        public void visit(CDOContainerFeatureDelta delta) {
            delta.apply((CDORevision)this.newRevision);
        }
    }
}

