/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.db.mapping.horizontal;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.revision.CDOList;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.revision.delta.CDOAddFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOClearFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOContainerFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOFeatureDeltaVisitor;
import org.eclipse.emf.cdo.common.revision.delta.CDOListFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOMoveFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDORemoveFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDORevisionDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOSetFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOUnsetFeatureDelta;
import org.eclipse.emf.cdo.eresource.EresourcePackage;
import org.eclipse.emf.cdo.server.IStoreAccessor;
import org.eclipse.emf.cdo.server.db.IDBStoreAccessor;
import org.eclipse.emf.cdo.server.db.IIDHandler;
import org.eclipse.emf.cdo.server.db.IPreparedStatementCache;
import org.eclipse.emf.cdo.server.db.mapping.IClassMappingDeltaSupport;
import org.eclipse.emf.cdo.server.db.mapping.IListMappingDeltaSupport;
import org.eclipse.emf.cdo.server.db.mapping.ITypeMapping;
import org.eclipse.emf.cdo.server.internal.db.bundle.OM;
import org.eclipse.emf.cdo.server.internal.db.mapping.horizontal.AbstractHorizontalClassMapping;
import org.eclipse.emf.cdo.server.internal.db.mapping.horizontal.AbstractHorizontalMappingStrategy;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevisionDelta;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.net4j.db.DBException;
import org.eclipse.net4j.db.DBUtil;
import org.eclipse.net4j.util.ImplementationError;
import org.eclipse.net4j.util.collection.Pair;
import org.eclipse.net4j.util.om.monitor.OMMonitor;
import org.eclipse.net4j.util.om.trace.ContextTracer;

public class HorizontalNonAuditClassMapping
extends AbstractHorizontalClassMapping
implements IClassMappingDeltaSupport {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG, HorizontalNonAuditClassMapping.class);
    private String sqlSelectAllObjectIDs;
    private String sqlSelectCurrentAttributes;
    private String sqlInsertAttributes;
    private String sqlUpdateAffix;
    private String sqlUpdatePrefix;
    private String sqlUpdateContainerPart;
    private ThreadLocal<FeatureDeltaWriter> deltaWriter = new ThreadLocal<FeatureDeltaWriter>(){

        @Override
        protected FeatureDeltaWriter initialValue() {
            return new FeatureDeltaWriter();
        }
    };

    public HorizontalNonAuditClassMapping(AbstractHorizontalMappingStrategy mappingStrategy, EClass eClass) {
        super(mappingStrategy, eClass);
        this.initSQLStrings();
    }

    private void initSQLStrings() {
        Map<EStructuralFeature, String> unsettableFields = this.getUnsettableFields();
        Map<EStructuralFeature, String> listSizeFields = this.getListSizeFields();
        StringBuilder builder = new StringBuilder();
        builder.append("SELECT ");
        builder.append("cdo_version");
        builder.append(", ");
        builder.append("cdo_created");
        builder.append(", ");
        builder.append("cdo_revised");
        builder.append(", ");
        builder.append("cdo_resource");
        builder.append(", ");
        builder.append("cdo_container");
        builder.append(", ");
        builder.append("cdo_feature");
        for (ITypeMapping singleMapping : this.getValueMappings()) {
            builder.append(", ");
            builder.append(singleMapping.getField());
        }
        if (unsettableFields != null) {
            for (String fieldName : unsettableFields.values()) {
                builder.append(", ");
                builder.append(fieldName);
            }
        }
        if (listSizeFields != null) {
            for (String fieldName : listSizeFields.values()) {
                builder.append(", ");
                builder.append(fieldName);
            }
        }
        builder.append(" FROM ");
        builder.append(this.getTable());
        builder.append(" WHERE ");
        builder.append("cdo_id");
        builder.append("=?");
        this.sqlSelectCurrentAttributes = builder.toString();
        builder = new StringBuilder();
        builder.append("INSERT INTO ");
        builder.append(this.getTable());
        builder.append("(");
        builder.append("cdo_id");
        builder.append(", ");
        builder.append("cdo_version");
        builder.append(", ");
        builder.append("cdo_created");
        builder.append(", ");
        builder.append("cdo_revised");
        builder.append(", ");
        builder.append("cdo_resource");
        builder.append(", ");
        builder.append("cdo_container");
        builder.append(", ");
        builder.append("cdo_feature");
        for (ITypeMapping singleMapping : this.getValueMappings()) {
            builder.append(", ");
            builder.append(singleMapping.getField());
        }
        if (unsettableFields != null) {
            for (String fieldName : unsettableFields.values()) {
                builder.append(", ");
                builder.append(fieldName);
            }
        }
        if (listSizeFields != null) {
            for (String fieldName : listSizeFields.values()) {
                builder.append(", ");
                builder.append(fieldName);
            }
        }
        builder.append(") VALUES (?, ?, ?, ?, ?, ?, ?");
        int i = 0;
        while (i < this.getValueMappings().size()) {
            builder.append(", ?");
            ++i;
        }
        if (unsettableFields != null) {
            i = 0;
            while (i < unsettableFields.size()) {
                builder.append(", ?");
                ++i;
            }
        }
        if (listSizeFields != null) {
            i = 0;
            while (i < listSizeFields.size()) {
                builder.append(", ?");
                ++i;
            }
        }
        builder.append(")");
        this.sqlInsertAttributes = builder.toString();
        builder = new StringBuilder("SELECT ");
        builder.append("cdo_id");
        builder.append(" FROM ");
        builder.append(this.getTable());
        this.sqlSelectAllObjectIDs = builder.toString();
        builder = new StringBuilder("UPDATE ");
        builder.append(this.getTable());
        builder.append(" SET ");
        builder.append("cdo_version");
        builder.append("=? ,");
        builder.append("cdo_created");
        builder.append("=? ");
        this.sqlUpdatePrefix = builder.toString();
        builder = new StringBuilder(", ");
        builder.append("cdo_resource");
        builder.append("=? ,");
        builder.append("cdo_container");
        builder.append("=? ,");
        builder.append("cdo_feature");
        builder.append("=? ");
        this.sqlUpdateContainerPart = builder.toString();
        builder = new StringBuilder(" WHERE ");
        builder.append("cdo_id");
        builder.append("=? ");
        this.sqlUpdateAffix = builder.toString();
    }

    protected void writeValues(IDBStoreAccessor accessor, InternalCDORevision revision) {
        IIDHandler idHandler = this.getMappingStrategy().getStore().getIDHandler();
        IPreparedStatementCache statementCache = accessor.getStatementCache();
        PreparedStatement stmt = null;
        try {
            try {
                int column = 1;
                stmt = statementCache.getPreparedStatement(this.sqlInsertAttributes, IPreparedStatementCache.ReuseProbability.HIGH);
                idHandler.setCDOID(stmt, column++, revision.getID());
                stmt.setInt(column++, revision.getVersion());
                stmt.setLong(column++, revision.getTimeStamp());
                stmt.setLong(column++, revision.getRevised());
                idHandler.setCDOID(stmt, column++, revision.getResourceID());
                idHandler.setCDOID(stmt, column++, (CDOID)revision.getContainerID());
                stmt.setInt(column++, revision.getContainingFeatureID());
                int isSetCol = column + this.getValueMappings().size();
                for (ITypeMapping mapping : this.getValueMappings()) {
                    EStructuralFeature feature = mapping.getFeature();
                    if (feature.isUnsettable()) {
                        if (revision.getValue(feature) == null) {
                            stmt.setBoolean(isSetCol++, false);
                            mapping.setDefaultValue(stmt, column++);
                            continue;
                        }
                        stmt.setBoolean(isSetCol++, true);
                    }
                    mapping.setValueFromRevision(stmt, column++, revision);
                }
                Map<EStructuralFeature, String> listSizeFields = this.getListSizeFields();
                if (listSizeFields != null) {
                    column = isSetCol;
                    for (EStructuralFeature feature : listSizeFields.keySet()) {
                        CDOList list = revision.getList(feature);
                        stmt.setInt(column++, list.size());
                    }
                }
                DBUtil.update((PreparedStatement)stmt, (boolean)true);
            }
            catch (SQLException e) {
                throw new DBException((Throwable)e);
            }
        }
        catch (Throwable throwable) {
            statementCache.releasePreparedStatement(stmt);
            throw throwable;
        }
        statementCache.releasePreparedStatement(stmt);
    }

    public PreparedStatement createObjectIDStatement(IDBStoreAccessor accessor) {
        if (TRACER.isEnabled()) {
            TRACER.format("Created ObjectID Statement : {0}", new Object[]{this.sqlSelectAllObjectIDs});
        }
        IPreparedStatementCache statementCache = accessor.getStatementCache();
        return statementCache.getPreparedStatement(this.sqlSelectAllObjectIDs, IPreparedStatementCache.ReuseProbability.HIGH);
    }

    public PreparedStatement createResourceQueryStatement(IDBStoreAccessor accessor, CDOID folderId, String name, boolean exactMatch, CDOBranchPoint branchPoint) {
        long timeStamp = branchPoint.getTimeStamp();
        if (timeStamp != 0L) {
            throw new IllegalArgumentException("Non-audit store does not support explicit timeStamp in resource query");
        }
        EAttribute nameFeature = EresourcePackage.eINSTANCE.getCDOResourceNode_Name();
        ITypeMapping nameValueMapping = this.getValueMapping((EStructuralFeature)nameFeature);
        if (nameValueMapping == null) {
            throw new ImplementationError(nameFeature + " not found in ClassMapping " + this);
        }
        StringBuilder builder = new StringBuilder();
        builder.append("SELECT ");
        builder.append("cdo_id");
        builder.append(" FROM ");
        builder.append(this.getTable());
        builder.append(" WHERE ");
        builder.append("cdo_version");
        builder.append(">0 AND ");
        builder.append("cdo_container");
        builder.append("=? AND ");
        builder.append(nameValueMapping.getField());
        if (name == null) {
            builder.append(" IS NULL");
        } else {
            builder.append(exactMatch ? "=? " : " LIKE ? ");
        }
        IIDHandler idHandler = this.getMappingStrategy().getStore().getIDHandler();
        IPreparedStatementCache statementCache = accessor.getStatementCache();
        PreparedStatement stmt = null;
        try {
            int column = 1;
            stmt = statementCache.getPreparedStatement(builder.toString(), IPreparedStatementCache.ReuseProbability.MEDIUM);
            idHandler.setCDOID(stmt, column++, folderId);
            if (name != null) {
                String queryName = exactMatch ? name : String.valueOf(name) + "%";
                nameValueMapping.setValue(stmt, column++, queryName);
            }
            if (TRACER.isEnabled()) {
                TRACER.format("Created Resource Query: {0}", new Object[]{stmt.toString()});
            }
            return stmt;
        }
        catch (SQLException ex) {
            statementCache.releasePreparedStatement(stmt);
            throw new DBException((Throwable)ex);
        }
    }

    public boolean readRevision(IDBStoreAccessor accessor, InternalCDORevision revision, int listChunk) {
        long timeStamp = revision.getTimeStamp();
        if (timeStamp != 0L) {
            throw new UnsupportedOperationException("Mapping strategy does not support audits");
        }
        IIDHandler idHandler = this.getMappingStrategy().getStore().getIDHandler();
        IPreparedStatementCache statementCache = accessor.getStatementCache();
        PreparedStatement stmt = null;
        try {
            stmt = statementCache.getPreparedStatement(this.sqlSelectCurrentAttributes, IPreparedStatementCache.ReuseProbability.HIGH);
            idHandler.setCDOID(stmt, 1, revision.getID());
            boolean success = this.readValuesFromStatement(stmt, revision, accessor);
            if (success) {
                this.readLists(accessor, revision, listChunk);
            }
            boolean bl = success;
            statementCache.releasePreparedStatement(stmt);
            return bl;
        }
        catch (SQLException ex) {
            try {
                throw new DBException((Throwable)ex);
            }
            catch (Throwable throwable) {
                statementCache.releasePreparedStatement(stmt);
                throw throwable;
            }
        }
    }

    protected void detachAttributes(IDBStoreAccessor accessor, CDOID id, int version, CDOBranch branch, long timeStamp, OMMonitor mon) {
        IIDHandler idHandler = this.getMappingStrategy().getStore().getIDHandler();
        IPreparedStatementCache statementCache = accessor.getStatementCache();
        PreparedStatement stmt = null;
        try {
            try {
                stmt = statementCache.getPreparedStatement(String.valueOf(this.sqlUpdatePrefix) + this.sqlUpdateAffix, IPreparedStatementCache.ReuseProbability.HIGH);
                stmt.setInt(1, -version);
                stmt.setLong(2, timeStamp);
                idHandler.setCDOID(stmt, 3, id);
                DBUtil.update((PreparedStatement)stmt, (boolean)true);
            }
            catch (SQLException e) {
                throw new DBException((Throwable)e);
            }
        }
        catch (Throwable throwable) {
            statementCache.releasePreparedStatement(stmt);
            throw throwable;
        }
        statementCache.releasePreparedStatement(stmt);
    }

    protected void rawDeleteAttributes(IDBStoreAccessor accessor, CDOID id, CDOBranch branch, int version, OMMonitor fork) {
    }

    public void writeRevisionDelta(IDBStoreAccessor accessor, InternalCDORevisionDelta delta, long created, OMMonitor monitor) {
        OMMonitor.Async async = null;
        monitor.begin();
        try {
            try {
                async = monitor.forkAsync();
                FeatureDeltaWriter writer = this.deltaWriter.get();
                writer.process(accessor, (CDORevisionDelta)delta, created);
            }
            finally {
                if (async != null) {
                    async.stop();
                }
            }
        }
        finally {
            monitor.done();
        }
    }

    protected void reviseOldRevision(IDBStoreAccessor accessor, CDOID id, CDOBranch branch, long timeStamp) {
    }

    protected String getListXRefsWhere(IStoreAccessor.QueryXRefsContext context) {
        if (0L != context.getTimeStamp()) {
            throw new IllegalArgumentException("Non-audit mode does not support timestamp specification");
        }
        if (!context.getBranch().isMainBranch()) {
            throw new IllegalArgumentException("Non-audit mode does not support branch specification");
        }
        return "cdo_revised=0";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class FeatureDeltaWriter
    implements CDOFeatureDeltaVisitor {
        private CDOID id;
        private int oldVersion;
        private long created;
        private IDBStoreAccessor accessor;
        private boolean updateContainer;
        private List<Pair<ITypeMapping, Object>> attributeChanges = new ArrayList<Pair<ITypeMapping, Object>>();
        private List<Pair<EStructuralFeature, Integer>> listSizeChanges = new ArrayList<Pair<EStructuralFeature, Integer>>();
        private int newContainingFeatureID;
        private CDOID newContainerID;
        private CDOID newResourceID;
        private int branchId;
        private int newVersion;
        private InternalCDORevision tempRevision;

        protected void reset() {
            this.attributeChanges.clear();
            this.listSizeChanges.clear();
            this.updateContainer = false;
        }

        public void process(IDBStoreAccessor a, CDORevisionDelta d, long c) {
            this.id = d.getID();
            this.branchId = d.getBranch().getID();
            this.oldVersion = d.getVersion();
            this.newVersion = this.oldVersion + 1;
            this.created = c;
            this.accessor = a;
            this.tempRevision = (InternalCDORevision)this.accessor.getTransaction().getRevision(this.id).copy();
            d.accept((CDOFeatureDeltaVisitor)this);
            this.updateAttributes();
            this.reset();
        }

        public void visit(CDOMoveFeatureDelta delta) {
            throw new ImplementationError("Should not be called");
        }

        public void visit(CDOSetFeatureDelta delta) {
            if (delta.getFeature().isMany()) {
                throw new ImplementationError("Should not be called");
            }
            ITypeMapping am = HorizontalNonAuditClassMapping.this.getValueMapping(delta.getFeature());
            if (am == null) {
                throw new IllegalArgumentException("AttributeMapping for " + delta.getFeature() + " is null!");
            }
            this.attributeChanges.add((Pair<ITypeMapping, Object>)new Pair((Object)am, delta.getValue()));
        }

        public void visit(CDOUnsetFeatureDelta delta) {
            ITypeMapping tm = HorizontalNonAuditClassMapping.this.getValueMapping(delta.getFeature());
            this.attributeChanges.add((Pair<ITypeMapping, Object>)new Pair((Object)tm, null));
        }

        public void visit(CDOListFeatureDelta delta) {
            EStructuralFeature feature = delta.getFeature();
            IListMappingDeltaSupport listMapping = (IListMappingDeltaSupport)((Object)HorizontalNonAuditClassMapping.this.getListMapping(feature));
            listMapping.processDelta(this.accessor, this.id, this.branchId, this.oldVersion, this.oldVersion + 1, this.created, delta);
            int oldSize = this.tempRevision.getList(feature).size();
            delta.apply((CDORevision)this.tempRevision);
            int newSize = this.tempRevision.getList(feature).size();
            if (oldSize != newSize) {
                this.listSizeChanges.add((Pair<EStructuralFeature, Integer>)new Pair((Object)feature, (Object)newSize));
            }
        }

        public void visit(CDOClearFeatureDelta delta) {
            throw new ImplementationError("Should not be called");
        }

        public void visit(CDOAddFeatureDelta delta) {
            throw new ImplementationError("Should not be called");
        }

        public void visit(CDORemoveFeatureDelta delta) {
            throw new ImplementationError("Should not be called");
        }

        public void visit(CDOContainerFeatureDelta delta) {
            this.newContainingFeatureID = delta.getContainerFeatureID();
            this.newContainerID = (CDOID)delta.getContainerID();
            this.newResourceID = delta.getResourceID();
            this.updateContainer = true;
        }

        private void updateAttributes() {
            IIDHandler idHandler = HorizontalNonAuditClassMapping.this.getMappingStrategy().getStore().getIDHandler();
            IPreparedStatementCache statementCache = this.accessor.getStatementCache();
            PreparedStatement stmt = null;
            try {
                try {
                    int column = 1;
                    stmt = statementCache.getPreparedStatement(this.buildUpdateStatement(), IPreparedStatementCache.ReuseProbability.MEDIUM);
                    stmt.setInt(column++, this.newVersion);
                    stmt.setLong(column++, this.created);
                    if (this.updateContainer) {
                        idHandler.setCDOID(stmt, column++, this.newResourceID, this.created);
                        idHandler.setCDOID(stmt, column++, this.newContainerID, this.created);
                        stmt.setInt(column++, this.newContainingFeatureID);
                    }
                    column = this.setUpdateAttributeValues(this.attributeChanges, stmt, column);
                    column = this.setUpdateListSizeChanges(this.listSizeChanges, stmt, column);
                    idHandler.setCDOID(stmt, column++, this.id);
                    DBUtil.update((PreparedStatement)stmt, (boolean)true);
                }
                catch (SQLException e) {
                    throw new DBException((Throwable)e);
                }
            }
            catch (Throwable throwable) {
                statementCache.releasePreparedStatement(stmt);
                throw throwable;
            }
            statementCache.releasePreparedStatement(stmt);
        }

        private String buildUpdateStatement() {
            StringBuilder builder = new StringBuilder(HorizontalNonAuditClassMapping.this.sqlUpdatePrefix);
            if (this.updateContainer) {
                builder.append(HorizontalNonAuditClassMapping.this.sqlUpdateContainerPart);
            }
            for (Pair<ITypeMapping, Object> pair : this.attributeChanges) {
                builder.append(", ");
                ITypeMapping typeMapping = (ITypeMapping)pair.getElement1();
                builder.append(typeMapping.getField());
                builder.append("=?");
                if (!typeMapping.getFeature().isUnsettable()) continue;
                builder.append(", ");
                builder.append(HorizontalNonAuditClassMapping.this.getUnsettableFields().get(typeMapping.getFeature()));
                builder.append("=?");
            }
            for (Pair<ITypeMapping, Object> pair : this.listSizeChanges) {
                builder.append(", ");
                EStructuralFeature feature = (EStructuralFeature)pair.getElement1();
                builder.append(HorizontalNonAuditClassMapping.this.getListSizeFields().get(feature));
                builder.append("=?");
            }
            builder.append(HorizontalNonAuditClassMapping.this.sqlUpdateAffix);
            return builder.toString();
        }

        private int setUpdateAttributeValues(List<Pair<ITypeMapping, Object>> attributeChanges, PreparedStatement stmt, int col) throws SQLException {
            for (Pair<ITypeMapping, Object> change : attributeChanges) {
                ITypeMapping typeMapping = (ITypeMapping)change.getElement1();
                Object value = change.getElement2();
                if (typeMapping.getFeature().isUnsettable()) {
                    if (value == null) {
                        typeMapping.setDefaultValue(stmt, col++);
                        stmt.setBoolean(col++, false);
                        continue;
                    }
                    typeMapping.setValue(stmt, col++, value);
                    stmt.setBoolean(col++, true);
                    continue;
                }
                typeMapping.setValue(stmt, col++, change.getElement2());
            }
            return col;
        }

        private int setUpdateListSizeChanges(List<Pair<EStructuralFeature, Integer>> attributeChanges, PreparedStatement stmt, int col) throws SQLException {
            for (Pair<EStructuralFeature, Integer> change : this.listSizeChanges) {
                stmt.setInt(col++, (Integer)change.getElement2());
            }
            return col;
        }
    }
}

