/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.net4j.protocol;

import java.util.Set;
import org.eclipse.emf.cdo.common.CDOCommonSession;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.model.CDOPackageUnit;
import org.eclipse.emf.cdo.common.protocol.CDODataInput;
import org.eclipse.emf.cdo.common.protocol.CDODataOutput;
import org.eclipse.emf.cdo.common.util.NotAuthenticatedException;
import org.eclipse.emf.cdo.server.IRepositoryProvider;
import org.eclipse.emf.cdo.server.RepositoryNotFoundException;
import org.eclipse.emf.cdo.server.internal.net4j.bundle.OM;
import org.eclipse.emf.cdo.server.internal.net4j.protocol.CDOServerIndicationWithMonitoring;
import org.eclipse.emf.cdo.server.internal.net4j.protocol.CDOServerProtocol;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageUnit;
import org.eclipse.emf.cdo.spi.server.ISessionProtocol;
import org.eclipse.emf.cdo.spi.server.InternalRepository;
import org.eclipse.emf.cdo.spi.server.InternalSession;
import org.eclipse.emf.cdo.spi.server.InternalSessionManager;
import org.eclipse.net4j.util.om.monitor.OMMonitor;
import org.eclipse.net4j.util.om.trace.ContextTracer;

public class OpenSessionIndication
extends CDOServerIndicationWithMonitoring {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG_PROTOCOL, OpenSessionIndication.class);
    private String repositoryName;
    private boolean passiveUpdateEnabled;
    private CDOCommonSession.Options.PassiveUpdateMode passiveUpdateMode;
    private CDOCommonSession.Options.LockNotificationMode lockNotificationMode;
    private InternalRepository repository;
    private InternalSession session;

    public OpenSessionIndication(CDOServerProtocol protocol) {
        super(protocol, (short)1);
    }

    protected InternalRepository getRepository() {
        return this.repository;
    }

    protected InternalSession getSession() {
        return this.session;
    }

    protected void indicating(CDODataInput in, OMMonitor monitor) throws Exception {
        this.repositoryName = in.readString();
        if (TRACER.isEnabled()) {
            TRACER.format("Read repositoryName: {0}", new Object[]{this.repositoryName});
        }
        this.passiveUpdateEnabled = in.readBoolean();
        if (TRACER.isEnabled()) {
            TRACER.format("Read passiveUpdateEnabled: {0}", new Object[]{this.passiveUpdateEnabled});
        }
        this.passiveUpdateMode = (CDOCommonSession.Options.PassiveUpdateMode)in.readEnum(CDOCommonSession.Options.PassiveUpdateMode.class);
        if (TRACER.isEnabled()) {
            TRACER.format("Read passiveUpdateMode: {0}", new Object[]{this.passiveUpdateMode});
        }
        this.lockNotificationMode = (CDOCommonSession.Options.LockNotificationMode)in.readEnum(CDOCommonSession.Options.LockNotificationMode.class);
        if (TRACER.isEnabled()) {
            TRACER.format("Read lockNotificationMode: {0}", new Object[]{this.lockNotificationMode});
        }
    }

    protected void responding(CDODataOutput out, OMMonitor monitor) throws Exception {
        monitor.begin();
        OMMonitor.Async async = monitor.forkAsync();
        try {
            CDOServerProtocol protocol = this.getProtocol();
            IRepositoryProvider repositoryProvider = protocol.getRepositoryProvider();
            this.repository = (InternalRepository)repositoryProvider.getRepository(this.repositoryName);
            if (this.repository == null) {
                throw new RepositoryNotFoundException(this.repositoryName);
            }
            try {
                InternalSessionManager sessionManager = this.repository.getSessionManager();
                this.session = sessionManager.openSession((ISessionProtocol)protocol);
            }
            catch (NotAuthenticatedException ex) {
                out.writeInt(0);
                async.stop();
                monitor.done();
                return;
            }
            this.session.setPassiveUpdateEnabled(this.passiveUpdateEnabled);
            this.session.setPassiveUpdateMode(this.passiveUpdateMode);
            this.session.setLockNotificationMode(this.lockNotificationMode);
            protocol.setInfraStructure(this.session);
            if (TRACER.isEnabled()) {
                TRACER.format("Writing sessionID: {0}", new Object[]{this.session.getSessionID()});
            }
            out.writeInt(this.session.getSessionID());
            if (TRACER.isEnabled()) {
                TRACER.format("Writing userID: {0}", new Object[]{this.session.getUserID()});
            }
            out.writeString(this.session.getUserID());
            if (TRACER.isEnabled()) {
                TRACER.format("Writing repositoryUUID: {0}", new Object[]{this.repository.getUUID()});
            }
            out.writeString(this.repository.getUUID());
            out.writeEnum((Enum)this.repository.getType());
            out.writeEnum((Enum)this.repository.getState());
            out.writeString(this.repository.getStoreType());
            Set objectIDTypes = this.repository.getObjectIDTypes();
            int types = objectIDTypes.size();
            out.writeInt(types);
            for (CDOID.ObjectType objectIDType : objectIDTypes) {
                out.writeEnum((Enum)objectIDType);
            }
            out.writeLong(this.repository.getCreationTime());
            out.writeLong(this.repository.getLastCommitTimeStamp());
            out.writeCDOID(this.repository.getRootResourceID());
            out.writeBoolean(this.repository.isSupportingAudits());
            out.writeBoolean(this.repository.isSupportingBranches());
            out.writeBoolean(this.repository.isSupportingEcore());
            out.writeBoolean(this.repository.isEnsuringReferentialIntegrity());
            out.writeEnum((Enum)this.repository.getIDGenerationLocation());
            InternalCDOPackageUnit[] packageUnits = this.repository.getPackageRegistry().getPackageUnits();
            out.writeCDOPackageUnits((CDOPackageUnit[])packageUnits);
        }
        finally {
            async.stop();
            monitor.done();
        }
    }
}

