/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.net4j.protocol;

import java.io.IOException;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.lock.IDurableLockingManager;
import org.eclipse.emf.cdo.common.protocol.CDODataInput;
import org.eclipse.emf.cdo.common.protocol.CDODataOutput;
import org.eclipse.emf.cdo.server.ISession;
import org.eclipse.emf.cdo.server.internal.net4j.protocol.CDOServerProtocol;
import org.eclipse.emf.cdo.server.internal.net4j.protocol.CDOServerReadIndication;
import org.eclipse.emf.cdo.spi.server.InternalLockManager;
import org.eclipse.emf.cdo.spi.server.InternalSession;
import org.eclipse.emf.cdo.spi.server.InternalView;

public class OpenViewIndication
extends CDOServerReadIndication {
    private InternalView newView;
    private String message;

    public OpenViewIndication(CDOServerProtocol protocol) {
        super(protocol, (short)3);
    }

    protected void indicating(CDODataInput in) throws IOException {
        InternalSession session = this.getSession();
        int viewID = in.readInt();
        boolean readOnly = in.readBoolean();
        if (in.readBoolean()) {
            CDOBranchPoint branchPoint = in.readCDOBranchPoint();
            this.newView = readOnly ? session.openView(viewID, branchPoint) : session.openTransaction(viewID, branchPoint);
        } else {
            InternalLockManager lockManager = this.getRepository().getLockingManager();
            try {
                String durableLockingID = in.readString();
                this.newView = (InternalView)lockManager.openView((ISession)session, viewID, readOnly, durableLockingID);
            }
            catch (IDurableLockingManager.LockAreaNotFoundException durableLockingID) {
            }
            catch (IllegalStateException ex) {
                this.message = ex.getMessage();
            }
        }
    }

    protected void responding(CDODataOutput out) throws IOException {
        if (this.newView != null) {
            out.writeBoolean(true);
            out.writeCDOBranchPoint((CDOBranchPoint)this.newView);
        } else {
            out.writeBoolean(false);
            out.writeString(this.message);
        }
    }
}

