/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.objectivity.db;

import com.objy.db.DatabaseNotFoundException;
import com.objy.db.DatabaseOpenException;
import com.objy.db.ObjyRuntimeException;
import com.objy.db.app.Connection;
import com.objy.db.app.Session;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.emf.cdo.server.internal.objectivity.bundle.OM;
import org.eclipse.emf.cdo.server.internal.objectivity.clustering.ObjyPlacementManager;
import org.eclipse.emf.cdo.server.internal.objectivity.clustering.ObjyPlacementManagerImpl;
import org.eclipse.emf.cdo.server.internal.objectivity.db.ObjySession;
import org.eclipse.emf.cdo.server.objectivity.IObjectivityStoreConfig;
import org.eclipse.net4j.util.om.trace.ContextTracer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjyConnection {
    public static final ObjyConnection INSTANCE = new ObjyConnection();
    protected Connection connection = null;
    protected boolean isConnected = false;
    protected String fdName = "";
    private static final ContextTracer TRACER_DEBUG = new ContextTracer(OM.DEBUG, ObjyConnection.class);
    private static final String SESSION_POOL_NAME_READ = "ReadSP";
    private static final String SESSION_POOL_NAME_WRITE = "WriteSP";
    protected ConcurrentHashMap<String, ObjySession> readPool;
    protected ConcurrentHashMap<String, ObjySession> writePool;
    private ObjyPlacementManager defaultPlacementManager = null;
    private Object syncObject = new Object();
    private ReentrantLock lock = new ReentrantLock();
    private int sessionMinCacheSize = 600;
    private int sessionMaxCacheSize = 1000;
    private final int minInactiveSessions = 5;
    private int sessionCount = 0;
    private String logDirPath = null;
    private int logOption = 0;

    public ObjyConnection() {
        this.readPool = new ConcurrentHashMap(5);
        this.writePool = new ConcurrentHashMap(5);
    }

    public synchronized void connect(IObjectivityStoreConfig storeConfig) {
        this.fdName = storeConfig.getFdName();
        this.logDirPath = storeConfig.getLogPath();
        this.logOption = storeConfig.getLogOption();
        this.connect();
    }

    public synchronized void connect(String fdName, int logOption) {
        this.fdName = fdName;
        this.logOption = logOption;
        this.connect();
    }

    private void connect() {
        if (TRACER_DEBUG.isEnabled()) {
            TRACER_DEBUG.trace(" SessionMinCacheSize: " + this.sessionMinCacheSize);
            TRACER_DEBUG.trace(" SessionMaxCacheSize: " + this.sessionMaxCacheSize);
        }
        if (!this.isConnected) {
            try {
                if (Connection.current() == null) {
                    if (this.logOption != 0) {
                        Connection.setLoggingOptions((int)this.logOption, (boolean)true, (boolean)true, (String)this.logDirPath, (String)"MainLog.txt");
                    }
                    if (TRACER_DEBUG.isEnabled()) {
                        TRACER_DEBUG.trace(" creating new Connection");
                    }
                    this.connection = Connection.open((String)this.fdName, (int)2);
                    this.connection.useContextClassLoader(true);
                } else {
                    this.connection.addToMainLog("ObjyConnection.connect()", "...reopen connection to the FD.");
                    this.connection.setOpenMode(2);
                    this.connection.reopen();
                    this.connection.loadSchemaClasses(true);
                }
                this.isConnected = true;
            }
            catch (DatabaseOpenException e) {
                e.printStackTrace();
            }
            catch (DatabaseNotFoundException e) {
                e.printStackTrace();
            }
        }
    }

    public String getSessionPoolNameRead() {
        return SESSION_POOL_NAME_READ;
    }

    public String getSessionPoolNameWrite() {
        return SESSION_POOL_NAME_WRITE;
    }

    public ObjySession getWriteSessionFromPool(String sessionName) {
        return this.getSessionFromPool(sessionName);
    }

    public ObjySession getReadSessionFromPool(String sessionName) {
        return this.getSessionFromPool(sessionName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ObjySession getSessionFromPool(String sessionName) {
        Object object = this.syncObject;
        synchronized (object) {
            ObjySession session = this.readPool.get(sessionName);
            if (session == null) {
                if (this.sessionCount >= 5) {
                    for (ObjySession objySession : this.readPool.values()) {
                        if (!objySession.isAvailable()) continue;
                        objySession.setName(sessionName);
                        session = objySession;
                        break;
                    }
                }
                if (session == null) {
                    session = new ObjySession(sessionName, this.readPool, this);
                    ++this.sessionCount;
                    this.readPool.put(sessionName, session);
                }
            }
            session.join();
            session.setAvailable(false);
            return session;
        }
    }

    public void disconnect() {
        if (!this.isConnected) {
            return;
        }
        this.lock.lock();
        if (TRACER_DEBUG.isEnabled()) {
            TRACER_DEBUG.trace("ObjyConnection.disconnect() -- Start. " + this.toString());
        }
        this.cleanupSessionPool(this.readPool);
        this.cleanupSessionPool(this.writePool);
        this.sessionCount = 0;
        Vector sessions = this.connection.sessions();
        for (Session aSession : sessions) {
            if (TRACER_DEBUG.isEnabled()) {
                TRACER_DEBUG.trace("Session: " + aSession + " - open state: " + aSession.isOpen());
            }
            if (!aSession.isOpen()) continue;
            try {
                try {
                    aSession.join();
                    aSession.abort();
                }
                catch (ObjyRuntimeException ex) {
                    ex.printStackTrace();
                    aSession.terminate();
                    continue;
                }
            }
            catch (Throwable throwable) {
                aSession.terminate();
                throw throwable;
            }
            aSession.terminate();
        }
        if (TRACER_DEBUG.isEnabled()) {
            TRACER_DEBUG.trace("ObjyConnection.disconnect() -- END. ");
        }
        this.lock.unlock();
    }

    public void registerClass(String name) {
        this.connection.registerClass(name);
    }

    public ObjyPlacementManager getDefaultPlacementManager() {
        if (this.defaultPlacementManager == null) {
            this.defaultPlacementManager = new ObjyPlacementManagerImpl();
        }
        return this.defaultPlacementManager;
    }

    protected void cleanupSessionPool(ConcurrentHashMap<String, ObjySession> pool) {
        for (ObjySession objySession : pool.values()) {
            try {
                try {
                    if (objySession.isOpen()) {
                        objySession.join();
                        objySession.abort();
                    }
                }
                catch (ObjyRuntimeException ex) {
                    ex.printStackTrace();
                    try {
                        objySession.terminate();
                    }
                    catch (ObjyRuntimeException ex2) {
                        ex2.printStackTrace();
                    }
                    continue;
                }
            }
            catch (Throwable throwable) {
                try {
                    objySession.terminate();
                }
                catch (ObjyRuntimeException ex) {
                    ex.printStackTrace();
                }
                throw throwable;
            }
            try {
                objySession.terminate();
            }
            catch (ObjyRuntimeException ex) {
                ex.printStackTrace();
            }
        }
        pool.clear();
    }

    public void setSessionMinCacheSize(int sessionMinCacheSize) {
        if (sessionMinCacheSize > this.sessionMinCacheSize) {
            this.sessionMinCacheSize = sessionMinCacheSize;
        }
    }

    public void setSessionMaxCacheSize(int sessionMaxCacheSize) {
        if (sessionMaxCacheSize > this.sessionMaxCacheSize) {
            this.sessionMaxCacheSize = sessionMaxCacheSize;
        }
    }

    public int getMinSessionCacheSize() {
        return this.sessionMinCacheSize;
    }

    public int getMaxSessionCacheSize() {
        return this.sessionMaxCacheSize;
    }
}

