/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.objectivity.db;

import com.objy.db.app.Session;
import com.objy.db.app.ooId;
import com.objy.db.app.ooObj;
import com.objy.db.util.ooMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.cdo.server.internal.objectivity.schema.ObjyProperty;
import org.eclipse.emf.cdo.server.internal.objectivity.utils.ObjyDb;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjyPropertyMapHandler {
    protected ooId propertyMapId;

    public ObjyPropertyMapHandler(String repositoryName) {
        this.propertyMapId = ObjyDb.getOrCreatePropertyMap(repositoryName);
    }

    public static ooId create(ooId scopeContOid) {
        ooMap map = new ooMap();
        ooObj clusterObject = ooObj.create_ooObj((ooId)scopeContOid);
        clusterObject.cluster((Object)map);
        return map.getOid();
    }

    public void setPropertyValues(Map<String, String> properties) {
        ooMap propertyMap = this.getMap();
        String key = null;
        String value = null;
        ObjyProperty property = null;
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            key = entry.getKey();
            value = entry.getValue();
            if (propertyMap.isMember(key)) {
                property = (ObjyProperty)((Object)propertyMap.lookup(key));
                property.setValue(value);
                continue;
            }
            property = new ObjyProperty(key, value);
            propertyMap.add((Object)property, key);
        }
    }

    public void removePropertyValues(Set<String> names) {
        ooMap propertyMap = this.getMap();
        ObjyProperty property = null;
        for (String key : names) {
            if (!propertyMap.isMember(key)) continue;
            property = (ObjyProperty)((Object)propertyMap.lookup(key));
            propertyMap.remove(key);
            property.delete();
        }
    }

    public Map<String, String> getPropertyValues(Set<String> names) {
        HashMap<String, String> properties = new HashMap<String, String>();
        ooMap propertyMap = this.getMap();
        ObjyProperty property = null;
        for (String key : names) {
            if (!propertyMap.isMember(key)) continue;
            property = (ObjyProperty)((Object)propertyMap.lookup(key));
            properties.put(property.getKey(), property.getValue());
        }
        return properties;
    }

    private ooMap getMap() {
        ooMap map = null;
        map = (ooMap)Session.getCurrent().getFD().objectFrom(this.propertyMapId);
        return map;
    }
}

