/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.objectivity.schema;

import com.objy.as.app.Class_Object;
import com.objy.as.app.Numeric_Value;
import com.objy.as.app.VArray_Object;
import com.objy.db.app.ooId;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ObjyArrayList<T> {
    static final String sizeName = "elementCount";
    static final String arrayName = "curr";
    protected Class_Object classObject;
    private VArray_Object vArray;
    protected transient long cacheSize;
    transient long position;

    public static void initObject(Class_Object classObject) {
        classObject.nset_numeric(sizeName, new Numeric_Value(0));
    }

    public ObjyArrayList(Class_Object classObject) {
        this.classObject = classObject;
        this.cacheSize = -1L;
    }

    public ooId getID() {
        return this.classObject.objectID();
    }

    public void clear() {
        this.getVArray().resize(0L);
        this.cacheSize = 0L;
        this.saveSize();
    }

    private void shiftRight(int index) {
        this.shiftRight(index, 1);
    }

    private void shiftRight(int index, int sizeToShift) {
        long size = this.cachedSize();
        long i = size - 1L;
        while (i >= (long)index) {
            this.setValue(i + (long)sizeToShift, this.getValue(i));
            --i;
        }
        this.cacheSize += (long)sizeToShift;
        this.saveSize();
    }

    private void shiftLeft(int index) {
        long size = this.cachedSize();
        long i = index;
        while (i < size - 1L) {
            this.setValue(i, this.getValue(i + 1L));
            ++i;
        }
        --this.cacheSize;
        this.saveSize();
    }

    protected void grow(int item) {
        this.getVArray().resize(this.getVArraySize() + (long)Math.max(item + 10, 10));
    }

    private void prepareToInsert(int numberToAdd) {
        long size = this.cachedSize();
        this.update();
        if (size + (long)numberToAdd > this.getVArraySize()) {
            this.grow(numberToAdd);
        }
    }

    protected long getVArraySize() {
        return this.getVArray().size();
    }

    protected void update() {
        this.getVArray().update();
    }

    protected VArray_Object getVArray() {
        if (this.vArray == null) {
            this.vArray = this.classObject.nget_varray(arrayName);
        }
        return this.vArray;
    }

    public void add(int index, T newValue) {
        this.prepareToInsert(1);
        this.shiftRight(index);
        this.basicSet(index, newValue);
    }

    public void addAll(int index, Object[] newValue) {
        this.prepareToInsert(newValue.length);
        this.shiftRight(index, newValue.length);
        int i = 0;
        while (i < newValue.length) {
            Object value = newValue[i];
            this.basicSet(index + i, value);
            ++i;
        }
    }

    public void remove(int index) {
        this.shiftLeft(index);
    }

    public void add(T newValue) {
        long size = this.cachedSize();
        this.prepareToInsert(1);
        this.setValue(size, newValue);
        ++this.cacheSize;
        this.saveSize();
    }

    public void set(long index, T newValue) {
        this.basicSet(index, newValue);
    }

    public void move(long newPosition, long oldPosition) {
        if (oldPosition == newPosition) {
            return;
        }
        T value = this.getValue(oldPosition);
        this.remove((int)oldPosition);
        this.shiftRight((int)newPosition);
        this.set(newPosition, value);
    }

    protected void basicSet(long index, T newValue) {
        if (index >= this.cachedSize()) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.update();
        this.setValue(index, newValue);
    }

    public T get(long index) {
        if (index >= this.size()) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return this.getValue(index);
    }

    protected abstract void setValue(long var1, T var3);

    protected abstract T getValue(long var1);

    protected void saveSize() {
        this.classObject.nset_numeric(sizeName, new Numeric_Value(this.cacheSize));
        this.resetCachedSize();
    }

    protected void resetCachedSize() {
        this.cacheSize = -1L;
    }

    protected long cachedSize() {
        if (this.cacheSize == -1L) {
            this.cacheSize = this.classObject.nget_numeric(sizeName).longValue();
        }
        return this.cacheSize;
    }

    public long size() {
        return this.cachedSize();
    }
}

