/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.objectivity.schema;

import com.objy.as.app.Class_Object;
import com.objy.as.app.Numeric_Value;
import com.objy.as.app.Proposed_Class;
import com.objy.as.app.d_Access_Kind;
import com.objy.as.app.d_Module;
import com.objy.as.app.ooBaseType;
import org.eclipse.emf.cdo.server.internal.objectivity.bundle.OM;
import org.eclipse.emf.cdo.server.internal.objectivity.db.ObjySchema;
import org.eclipse.emf.cdo.server.internal.objectivity.schema.ObjyArrayList;
import org.eclipse.net4j.util.om.trace.ContextTracer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjyArrayListLong
extends ObjyArrayList<Long> {
    private static final ContextTracer TRACER_DEBUG = new ContextTracer(OM.DEBUG, ObjyArrayListLong.class);
    public static String ArrayName = "ObjyArrayListLong";

    public static void buildSchema() {
        d_Module top_mod = ObjySchema.getTopModule();
        if (top_mod.resolve_class(ArrayName) == null) {
            if (TRACER_DEBUG.isEnabled()) {
                TRACER_DEBUG.trace("Schema not found for ooArrayListId. Adding ooArrayListId");
            }
            boolean inProcess = top_mod.proposed_classes().hasNext();
            Proposed_Class A = top_mod.propose_new_class(ArrayName);
            A.add_base_class(-1, d_Access_Kind.d_PUBLIC, "ooObj");
            A.add_basic_attribute(-1, d_Access_Kind.d_PUBLIC, "elementCount", 1L, ooBaseType.ooINT32);
            A.add_varray_attribute(-1, d_Access_Kind.d_PUBLIC, "curr", 1L, ooBaseType.ooINT64);
            if (!inProcess) {
                top_mod.activate_proposals(true, true);
            }
            if (TRACER_DEBUG.isEnabled()) {
                TRACER_DEBUG.trace("SCHEMA changed : ooArrayListId added");
            }
        }
    }

    public ObjyArrayListLong(Class_Object classObject) {
        super(classObject);
    }

    @Override
    protected void setValue(long index, Long newValue) {
        this.getVArray().set_numeric(index, new Numeric_Value(newValue.longValue()));
    }

    @Override
    protected Long getValue(long index) {
        return this.getVArray().get_numeric(index).longValue();
    }
}

