/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.objectivity.schema;

import com.objy.as.app.Class_Object;
import com.objy.as.app.Numeric_Value;
import com.objy.as.app.Proposed_Class;
import com.objy.as.app.String_Value;
import com.objy.as.app.VArray_Object;
import com.objy.as.app.d_Access_Kind;
import com.objy.as.app.d_Class;
import com.objy.as.app.d_Module;
import com.objy.as.app.ooBaseType;
import com.objy.db.app.ooId;
import com.objy.db.app.ooObj;
import org.eclipse.emf.cdo.server.internal.objectivity.bundle.OM;
import org.eclipse.emf.cdo.server.internal.objectivity.db.ObjyClass;
import org.eclipse.emf.cdo.server.internal.objectivity.db.ObjySchema;
import org.eclipse.emf.cdo.server.internal.objectivity.mapper.ITypeMapper;
import org.eclipse.net4j.util.om.trace.ContextTracer;

public class ObjyArrayListString {
    private static final ContextTracer TRACER_DEBUG = new ContextTracer(OM.DEBUG, ObjyArrayListString.class);
    public static String ClassName = "ObjyArrayListString";
    private static String embeddedClassName = "oo_StringElement";
    private static String embeddedAttributeName = "value";
    private static String embeddedAttributeNull = "isNull";
    private static String FixedArrayClassName = "ObjyFixedStringArray";
    private static String FixedElementsName = "elements";
    private static final long FixedElementsSize = 10L;
    protected Class_Object classObject;
    private VArray_Object vArray;
    transient long cacheSize = -1L;
    transient long position;

    public static void buildSchema() {
        d_Module top_mod = ObjySchema.getTopModule();
        if (top_mod.resolve_class(ClassName) == null) {
            if (TRACER_DEBUG.isEnabled()) {
                TRACER_DEBUG.trace("Schema not found for ooArrayListString. Adding ooArrayListString");
            }
            boolean inProcess = top_mod.proposed_classes().hasNext();
            Proposed_Class embeddedClass = top_mod.propose_new_class(embeddedClassName);
            embeddedClass.add_embedded_class_attribute(-1, d_Access_Kind.d_PUBLIC, embeddedAttributeName, 1L, "ooUtf8String");
            embeddedClass.add_basic_attribute(-1, d_Access_Kind.d_PUBLIC, embeddedAttributeNull, 1L, ooBaseType.ooBOOLEAN);
            Proposed_Class fixedArrayClass = top_mod.propose_new_class(FixedArrayClassName);
            fixedArrayClass.add_base_class(-1, d_Access_Kind.d_PUBLIC, "ooObj");
            fixedArrayClass.add_embedded_class_attribute(-1, d_Access_Kind.d_PUBLIC, FixedElementsName, 10L, embeddedClassName);
            Proposed_Class StringArrayClass = top_mod.propose_new_class(ClassName);
            StringArrayClass.add_base_class(-1, d_Access_Kind.d_PUBLIC, "ooObj");
            StringArrayClass.add_basic_attribute(-1, d_Access_Kind.d_PUBLIC, "elementCount", 1L, ooBaseType.ooINT32);
            StringArrayClass.add_varray_attribute(-1, d_Access_Kind.d_PUBLIC, "curr", 1L, false, FixedArrayClassName);
            if (!inProcess) {
                top_mod.activate_proposals(true, true);
            }
            if (TRACER_DEBUG.isEnabled()) {
                TRACER_DEBUG.trace("SCHEMA changed : ooArrayListString added");
            }
        }
    }

    public static void initObject(Class_Object classObject) {
        classObject.nset_numeric("elementCount", new Numeric_Value(0));
    }

    public ObjyArrayListString(Class_Object classObject) {
        this.classObject = classObject;
    }

    protected void setValue(long index, String newValue) {
        long chunkItem = index / 10L;
        long chunkIndex = index % 10L;
        Class_Object chunkObject = this.getVArray().get_class_obj(chunkItem);
        Class_Object embeddedElement = chunkObject.nget_class_obj(FixedElementsName, chunkIndex);
        embeddedElement.set_numeric(1, newValue == null ? ITypeMapper.numericTrue : ITypeMapper.numericFalse);
        String_Value value = embeddedElement.nget_string(embeddedAttributeName);
        value.update();
        if (newValue == null) {
            newValue = "";
        }
        value.set(newValue);
    }

    protected String getValue(long index) {
        long chunkItem = index / 10L;
        long chunkIndex = index % 10L;
        Class_Object chunkObject = this.getVArray().get_class_obj(chunkItem);
        Class_Object embeddedElement = chunkObject.nget_class_obj(FixedElementsName, chunkIndex);
        String_Value value = embeddedElement.nget_string(embeddedAttributeName);
        Numeric_Value isNull = embeddedElement.get_numeric(1);
        return isNull == ITypeMapper.numericTrue ? null : value.toString();
    }

    public String[] getAll(int index, int chunkSize) {
        int size = (int)this.cachedSize();
        if (chunkSize != -1) {
            size = Math.min(size, chunkSize);
        }
        String[] strings = new String[size];
        Class_Object currentChunkObject = null;
        long currentChunkItem = -1L;
        int i = 0;
        while (i < size) {
            long chunkItem = (long)(i + index) / 10L;
            long chunkIndex = (long)(i + index) % 10L;
            if (currentChunkItem != chunkItem) {
                currentChunkItem = chunkItem;
                currentChunkObject = this.getVArray().get_class_obj(currentChunkItem);
            }
            Class_Object embeddedElement = currentChunkObject.nget_class_obj(FixedElementsName, chunkIndex);
            String_Value value = embeddedElement.nget_string(embeddedAttributeName);
            Numeric_Value isNull = embeddedElement.get_numeric(1);
            strings[i] = isNull == ITypeMapper.numericTrue ? null : value.toString();
            ++i;
        }
        return strings;
    }

    public void clear() {
        int i = 0;
        while ((long)i < this.getVArray().size()) {
            ooId oid = this.getVArray().get_ooId((long)i);
            ooObj.create_ooObj((ooId)oid).delete();
            ++i;
        }
        this.getVArray().resize(0L);
        this.cacheSize = 0L;
        this.saveSize();
    }

    private void shiftRight(int index) {
        this.shiftRight(index, 1);
    }

    private void shiftRight(int index, int sizeToShift) {
        long size = this.cachedSize();
        long i = size - 1L;
        while (i >= (long)index) {
            this.setValue(i + (long)sizeToShift, this.getValue(i));
            --i;
        }
        this.cacheSize += (long)sizeToShift;
    }

    private void shiftLeft(int index) {
        long size = this.cachedSize();
        long i = index;
        while (i < size - 1L) {
            this.setValue(i, this.getValue(i + 1L));
            ++i;
        }
        --this.cacheSize;
        this.saveSize();
    }

    private void grow(int numToAdd) {
        long arraySize = this.cachedSize();
        long numChunks = (long)(numToAdd + (int)arraySize) / 10L + 1L;
        long newChunks = numChunks - arraySize;
        if (newChunks > 0L) {
            this.getVArray().resize(numChunks);
            ObjyClass chunkClass = ObjySchema.getObjyClass(FixedArrayClassName);
            int i = 0;
            while ((long)i < newChunks) {
                Class_Object newChunk = Class_Object.new_persistent_object((d_Class)chunkClass.getASClass(), (ooId)this.classObject.objectID(), (boolean)false);
                this.getVArray().set_ooId(arraySize + (long)i, newChunk.objectID());
                ++i;
            }
            this.cacheSize = -1L;
        }
    }

    private void prepareToInsert(int numberToAdd) {
        long size = this.cachedSize();
        this.getVArray().update();
        if (size + (long)numberToAdd > this.getVArray().size()) {
            this.grow(numberToAdd);
        }
    }

    protected VArray_Object getVArray() {
        if (this.vArray == null) {
            this.vArray = this.classObject.nget_varray("curr");
        }
        return this.vArray;
    }

    public void add(int index, String newValue) {
        this.prepareToInsert(1);
        this.shiftRight(index);
        this.basicSet(index, newValue);
        this.saveSize();
    }

    public void addAll(int index, Object[] newValue) {
        this.prepareToInsert(newValue.length);
        this.shiftRight(index, newValue.length);
        int i = 0;
        while (i < newValue.length) {
            this.basicSet(index + i, (String)newValue[i]);
            ++i;
        }
        this.saveSize();
    }

    public void remove(int index) {
        this.shiftLeft(index);
    }

    public void add(String newValue) {
        long size = this.cachedSize();
        this.prepareToInsert(1);
        this.setValue(size, newValue);
        ++this.cacheSize;
        this.saveSize();
    }

    public void set(long index, String newValue) {
        this.basicSet(index, newValue);
        this.cacheSize = -1L;
    }

    protected void basicSet(long index, String newValue) {
        if (index >= this.cachedSize()) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.getVArray().update();
        this.setValue(index, newValue);
    }

    public String get(long index) {
        if (index >= this.size()) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return this.getValue(index);
    }

    private void saveSize() {
        this.classObject.nset_numeric("elementCount", new Numeric_Value(this.cacheSize));
        this.cacheSize = -1L;
    }

    public long cachedSize() {
        if (this.cacheSize == -1L) {
            this.cacheSize = this.classObject.nget_numeric("elementCount").longValue();
        }
        return this.cacheSize;
    }

    public long size() {
        return this.classObject.nget_numeric("elementCount").longValue();
    }
}

