/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.objectivity.schema;

import com.objy.db.app.Iterator;
import com.objy.db.app.ooId;
import com.objy.db.app.ooObj;
import com.objy.db.util.ooMap;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.lock.CDOLockUtil;
import org.eclipse.emf.cdo.common.lock.IDurableLockingManager;
import org.eclipse.emf.cdo.server.internal.objectivity.schema.ObjyBranch;
import org.eclipse.emf.cdo.server.internal.objectivity.schema.ObjyLockArea;
import org.eclipse.emf.cdo.spi.common.branch.InternalCDOBranchManager;

public class ObjyLockAreaManager
extends ooObj {
    private ooMap lockAreasMap;

    private ObjyLockAreaManager() {
    }

    protected void createMap(ooObj clusterObject) {
        this.lockAreasMap = new ooMap();
        clusterObject.cluster((Object)this.lockAreasMap);
    }

    public static ObjyLockAreaManager create(ooId scopeContOid) {
        ObjyLockAreaManager manager = new ObjyLockAreaManager();
        ooObj clusterObject = ooObj.create_ooObj((ooId)scopeContOid);
        clusterObject.cluster((Object)manager);
        manager.createMap(manager);
        return manager;
    }

    public void getLockAreas(InternalCDOBranchManager branchManager, String userIDPrefix, IDurableLockingManager.LockArea.Handler handler) {
        this.fetch();
        Iterator itr = this.lockAreasMap.elements();
        while (itr.hasNext()) {
            ObjyLockArea objyLockArea = (ObjyLockArea)((Object)itr.next());
            String userID = objyLockArea.getUserID();
            if (userID == null || !userID.startsWith(userIDPrefix) || handler.handleLockArea(this.makeLockArea(branchManager, objyLockArea))) continue;
            return;
        }
    }

    private IDurableLockingManager.LockArea makeLockArea(InternalCDOBranchManager branchManager, ObjyLockArea objyLockArea) {
        ObjyBranch objyBranch = objyLockArea.getBranch();
        CDOBranchPoint branchPoint = branchManager.getBranch(objyBranch.getBranchId()).getPoint(objyLockArea.getTimeStamp());
        return CDOLockUtil.createLockArea((String)objyLockArea.getDurableLockingID(), (String)objyLockArea.getUserID(), (CDOBranchPoint)branchPoint, (boolean)objyLockArea.isReadOnly(), objyLockArea.getLocks());
    }
}

