/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.ui.ide;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.cdo.CDOObject;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.branch.CDOBranchCreatedEvent;
import org.eclipse.emf.cdo.eresource.CDOResource;
import org.eclipse.emf.cdo.team.IRepositoryManager;
import org.eclipse.emf.cdo.team.IRepositoryProject;
import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.emf.cdo.ui.CDOEditorInput;
import org.eclipse.emf.cdo.ui.CDOEditorUtil;
import org.eclipse.emf.cdo.ui.CDOEventHandler;
import org.eclipse.emf.cdo.ui.ide.CommonNavigatorUtils;
import org.eclipse.emf.cdo.ui.ide.Node;
import org.eclipse.emf.cdo.ui.internal.ide.actions.RemoveResourceActionDelegate;
import org.eclipse.emf.cdo.ui.internal.ide.bundle.OM;
import org.eclipse.emf.cdo.ui.internal.ide.messages.Messages;
import org.eclipse.emf.cdo.util.CDOUtil;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.cdo.view.CDOViewInvalidationEvent;
import org.eclipse.emf.cdo.view.CDOViewTargetChangedEvent;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.EMFEditPlugin;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.internal.cdo.view.CDOStateMachine;
import org.eclipse.emf.spi.cdo.InternalCDOObject;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.net4j.util.container.ContainerEventAdapter;
import org.eclipse.net4j.util.container.IContainer;
import org.eclipse.net4j.util.event.IEvent;
import org.eclipse.net4j.util.event.IListener;
import org.eclipse.net4j.util.ui.StructuredContentProvider;
import org.eclipse.net4j.util.ui.UIUtil;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RepositoryContentProvider
extends StructuredContentProvider<IWorkspaceRoot>
implements ITreeContentProvider {
    private static final Object[] EMPTY = new Object[0];
    private ComposedAdapterFactory adapterFactory;
    private Map<IRepositoryProject, RepositoryInfo> infos = new HashMap<IRepositoryProject, RepositoryInfo>();
    private Map<IRepositoryProject, RepositoryCDOEventHandler> eventHandlers = new HashMap<IRepositoryProject, RepositoryCDOEventHandler>();
    private boolean sessionsNodeHidden;
    private boolean packagesNodeHidden;
    private boolean resourcesNodeHidden;
    private IListener repositoryManagerListener = new ContainerEventAdapter<IRepositoryProject>(){

        protected void onAdded(IContainer<IRepositoryProject> container, IRepositoryProject element) {
            this.refreshViewer(element);
        }

        protected void onRemoved(IContainer<IRepositoryProject> container, IRepositoryProject element) {
            this.refreshViewer(element);
        }

        private void refreshViewer(IRepositoryProject element) {
            RepositoryContentProvider.this.getViewer().refresh((Object)element.getProject());
        }
    };

    public RepositoryContentProvider() {
        this.adapterFactory = RepositoryContentProvider.createAdapterFactory();
        IRepositoryManager.INSTANCE.addListener(this.repositoryManagerListener);
    }

    public void dispose() {
        IRepositoryManager.INSTANCE.removeListener(this.repositoryManagerListener);
        this.adapterFactory.dispose();
        super.dispose();
    }

    public boolean isSessionsNodeHidden() {
        return this.sessionsNodeHidden;
    }

    public void setSessionsNodeHidden(boolean sessionNodesHidden) {
        this.sessionsNodeHidden = sessionNodesHidden;
    }

    public boolean isPackagesNodeHidden() {
        return this.packagesNodeHidden;
    }

    public void setPackagesNodeHidden(boolean packageNodesHidden) {
        this.packagesNodeHidden = packageNodesHidden;
    }

    public boolean isResourcesNodeHidden() {
        return this.resourcesNodeHidden;
    }

    public void setResourcesNodeHidden(boolean resourceNodesHidden) {
        this.resourcesNodeHidden = resourceNodesHidden;
    }

    public Object[] getChildren(Object parentElement) {
        try {
            return this.doGetChildren(parentElement);
        }
        catch (Exception e) {
            OM.LOG.error((Throwable)e);
            return CommonNavigatorUtils.createMessageProviderChild(Messages.getString("RepositoryContentProvider_0"), CommonNavigatorUtils.MessageType.ERROR);
        }
    }

    private Object[] doGetChildren(Object parentElement) {
        Notifier notifier;
        ITreeItemContentProvider adapter;
        IProject project;
        IRepositoryProject repositoryProject;
        if (parentElement instanceof IProject && (repositoryProject = IRepositoryManager.INSTANCE.getElement(project = (IProject)parentElement)) != null) {
            return this.getChildren(repositoryProject);
        }
        if (parentElement instanceof Node) {
            Node node = (Node)((Object)parentElement);
            return node.getChildren();
        }
        if (parentElement instanceof Notifier && (adapter = (ITreeItemContentProvider)this.adapterFactory.adapt(notifier = (Notifier)parentElement, ITreeItemContentProvider.class)) != null) {
            return adapter.getChildren((Object)notifier).toArray();
        }
        return EMPTY;
    }

    public Object[] getElements(Object parentElement) {
        return this.getChildren(parentElement);
    }

    public Object getParent(Object element) {
        Notifier notifier;
        ITreeItemContentProvider adapter;
        if (element instanceof Node) {
            Node node = (Node)((Object)element);
            return node.getParent();
        }
        if (element instanceof Notifier && (adapter = (ITreeItemContentProvider)this.adapterFactory.adapt(notifier = (Notifier)element, ITreeItemContentProvider.class)) != null) {
            return adapter.getParent((Object)notifier);
        }
        return null;
    }

    private Object[] getChildren(IRepositoryProject repositoryProject) {
        ArrayList<Object> children = new ArrayList<Object>();
        RepositoryInfo info = this.getRepositoryInfo(repositoryProject);
        children.add((Object)info.getMainBranch());
        if (!this.isPackagesNodeHidden()) {
            children.add((Object)info.getPackages());
        }
        if (!this.isResourcesNodeHidden()) {
            children.add((Object)info.getResources());
        }
        if (!this.isSessionsNodeHidden()) {
            children.add((Object)info.getSessions());
        }
        if (this.isPackagesNodeHidden()) {
            this.addChildren(children, info.getPackages());
        }
        if (this.isResourcesNodeHidden()) {
            this.addChildren(children, info.getResources());
        }
        if (this.isSessionsNodeHidden()) {
            this.addChildren(children, info.getSessions());
        }
        return children.toArray(new Object[children.size()]);
    }

    private void addChildren(List<Object> result, Node node) {
        Object[] children;
        Object[] objectArray = children = node.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Object child = objectArray[n2];
            result.add(child);
            ++n2;
        }
    }

    private RepositoryInfo getRepositoryInfo(IRepositoryProject repositoryProject) {
        RepositoryInfo info = this.infos.get(repositoryProject);
        if (info == null) {
            info = new RepositoryInfo(repositoryProject);
            this.infos.put(repositoryProject, info);
            this.wireUpViewerRefresher(repositoryProject, info);
            this.prepareViewerEventHandlers();
        }
        return info;
    }

    private void prepareViewerEventHandlers() {
        this.getViewer().addDoubleClickListener((IDoubleClickListener)new MouseListener());
        this.getViewer().getControl().addKeyListener((KeyListener)new CDONavigatorKeyListener());
    }

    private void wireUpViewerRefresher(IRepositoryProject repositoryProject, RepositoryInfo info) {
        this.eventHandlers.put(repositoryProject, new RepositoryCDOEventHandler(info.getResources(), repositoryProject.getView(), (TreeViewer)this.getViewer()));
        repositoryProject.getView().getBranch().getBranchManager().addListener(new IListener(){

            public void notifyEvent(IEvent event) {
                if (event instanceof CDOBranchCreatedEvent) {
                    RepositoryContentProvider.this.refreshViewer(true);
                }
            }
        });
        repositoryProject.getView().addListener(new IListener(){

            public void notifyEvent(IEvent event) {
                if (event instanceof CDOViewInvalidationEvent || event instanceof CDOViewTargetChangedEvent) {
                    RepositoryContentProvider.this.refreshViewer(true);
                }
            }
        });
    }

    public static ComposedAdapterFactory createAdapterFactory() {
        ComposedAdapterFactory.Descriptor.Registry registry = EMFEditPlugin.getComposedAdapterFactoryDescriptorRegistry();
        ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory(registry);
        adapterFactory.addAdapterFactory((AdapterFactory)new ReflectiveItemProviderAdapterFactory());
        return adapterFactory;
    }

    public boolean hasChildren(Object parentElement) {
        Object[] children = this.getChildren(parentElement);
        return children != null && children.length != 0;
    }

    private final class CDONavigatorKeyListener
    extends KeyAdapter {
        public void keyPressed(KeyEvent e) {
            if (e.keyCode == 127) {
                RemoveResourceActionDelegate action = new RemoveResourceActionDelegate();
                action.selectionChanged(null, RepositoryContentProvider.this.getViewer().getSelection());
                action.run(null);
            }
        }
    }

    private static final class MouseListener
    implements IDoubleClickListener {
        public void doubleClick(DoubleClickEvent event) {
            Runnable runnable;
            Object selection = UIUtil.getElement((ISelection)event.getSelection());
            if (selection instanceof CDOResource) {
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                CDOTransaction view = ((CDOResource)selection).cdoView().getSession().openTransaction();
                try {
                    CDOEditorInput editorInput = CDOEditorUtil.createCDOEditorInput((CDOView)view, (String)((CDOResource)selection).getPath(), (boolean)true);
                    page.openEditor((IEditorInput)editorInput, CDOEditorUtil.getEditorID());
                }
                catch (PartInitException ex) {
                    OM.LOG.error((Throwable)ex);
                }
            }
            if (selection instanceof IAdaptable && (runnable = (Runnable)((IAdaptable)selection).getAdapter(Runnable.class)) != null) {
                UIUtil.getDisplay().asyncExec(runnable);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class RepositoryCDOEventHandler
    extends CDOEventHandler {
        private Node resourcesNode;

        public RepositoryCDOEventHandler(Node resourcesNode, CDOView view, TreeViewer treeViewer) {
            super(view, treeViewer);
            this.resourcesNode = resourcesNode;
        }

        protected void objectInvalidated(InternalCDOObject cdoObject) {
            if (CDOUtil.isLegacyObject((EObject)cdoObject)) {
                CDOStateMachine.INSTANCE.read(cdoObject);
            }
            if (cdoObject instanceof CDOResource && ((CDOResource)cdoObject).isRoot()) {
                RepositoryContentProvider.this.refreshViewer(true);
                return;
            }
            RepositoryContentProvider.this.refreshElement(cdoObject, true);
        }

        protected void viewInvalidated(Set<? extends CDOObject> dirtyObjects) {
            for (CDOObject cDOObject : dirtyObjects) {
                if (!(cDOObject instanceof CDOResource) || !((CDOResource)cDOObject).isRoot()) continue;
                RepositoryContentProvider.this.refreshElement((Object)this.resourcesNode, true);
                return;
            }
            super.viewInvalidated(dirtyObjects);
        }

        protected void viewConflict(CDOObject conflictingObject, boolean firstConflict) {
            RepositoryContentProvider.this.refreshElement(conflictingObject, true);
        }

        protected void viewClosed() {
            try {
                if (PlatformUI.isWorkbenchRunning()) {
                    this.resourcesNode.getRepositoryProject().getProject().close((IProgressMonitor)new NullProgressMonitor());
                }
            }
            catch (CoreException ex) {
                OM.LOG.error((Throwable)ex);
            }
        }

        protected void viewDirtyStateChanged() {
        }
    }

    private static final class RepositoryInfo {
        private Node.BranchNode mainBranch;
        private Node.PackagesNode packages;
        private Node.ResourcesNode resources;
        private Node.SessionsNode sessions;

        public RepositoryInfo(IRepositoryProject repositoryProject) {
            CDOBranch main = repositoryProject.getView().getSession().getBranchManager().getMainBranch();
            this.mainBranch = new Node.BranchNode(repositoryProject, main);
            this.packages = new Node.PackagesNode(repositoryProject);
            this.resources = new Node.ResourcesNode(repositoryProject);
            this.sessions = new Node.SessionsNode(repositoryProject);
        }

        public Node.BranchNode getMainBranch() {
            return this.mainBranch;
        }

        public Node.PackagesNode getPackages() {
            return this.packages;
        }

        public Node.ResourcesNode getResources() {
            return this.resources;
        }

        public Node.SessionsNode getSessions() {
            return this.sessions;
        }
    }
}

