/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ui.viewer.group;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.compare.ui.EMFCompareUIMessages;
import org.eclipse.emf.compare.ui.EMFCompareUIPlugin;
import org.eclipse.emf.compare.ui.viewer.group.IDifferenceGroupingFacility;

public final class DifferenceGroupingFacilityDescriptor {
    public static final String ID_PROPERTY = "id";
    public static final String NAME_PROPERTY = "name";
    public static final String CLASS_PROPERTY = "class";
    public static final String ICON_PROPERTY = "icon";
    public static final String GROUP_SEQUENCE = "group";
    private String id;
    private String name;
    private String classname;
    private IConfigurationElement element;
    private IDifferenceGroupingFacility extension;
    private Set<IDifferenceGroupingFacility.UIDifferenceGroup> groups = new HashSet<IDifferenceGroupingFacility.UIDifferenceGroup>();

    public DifferenceGroupingFacilityDescriptor(IConfigurationElement e) {
        this.element = e;
        this.id = e.getAttribute(ID_PROPERTY);
        this.name = e.getAttribute(NAME_PROPERTY);
        this.classname = e.getAttribute(CLASS_PROPERTY);
        IConfigurationElement[] iConfigurationElementArray = e.getChildren(GROUP_SEQUENCE);
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement g = iConfigurationElementArray[n2];
            this.addGroup(g);
            ++n2;
        }
        DifferenceGroupingFacilityDescriptor.checks(this);
    }

    public String getID() {
        return this.id;
    }

    public String getClassname() {
        return this.classname;
    }

    public String getName() {
        return this.name;
    }

    void addGroup(IConfigurationElement e) {
        if (!GROUP_SEQUENCE.equals(e.getName())) {
            throw new IllegalArgumentException("Configuration element name must be group");
        }
        String groupId = e.getAttribute(ID_PROPERTY);
        String groupName = e.getAttribute(NAME_PROPERTY);
        String groupIcon = e.getAttribute(ICON_PROPERTY);
        this.groups.add(new IDifferenceGroupingFacility.UIDifferenceGroup(groupId, groupName, groupIcon));
    }

    public IDifferenceGroupingFacility getExtension() {
        if (this.extension == null) {
            try {
                this.extension = (IDifferenceGroupingFacility)this.element.createExecutableExtension(CLASS_PROPERTY);
                this.extension.addGroups(this.groups);
            }
            catch (CoreException e) {
                EMFCompareUIPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.emf.compare.ui", e.getMessage(), (Throwable)e));
            }
        }
        return this.extension;
    }

    private static void checks(DifferenceGroupingFacilityDescriptor d) {
        if (d.element == null) {
            throw new IllegalArgumentException(EMFCompareUIMessages.getString("DifferenceFilterDescriptor.nullConfigurationElementException"));
        }
        if (DifferenceGroupingFacilityDescriptor.nullOrEmpty(d.getID())) {
            throw new IllegalArgumentException(EMFCompareUIMessages.getString("DifferenceFilterDescriptor.missingMandatoryPropertyException", ID_PROPERTY));
        }
        if (DifferenceGroupingFacilityDescriptor.nullOrEmpty(d.getName())) {
            throw new IllegalArgumentException(EMFCompareUIMessages.getString("DifferenceFilterDescriptor.missingMandatoryPropertyException", NAME_PROPERTY));
        }
        if (DifferenceGroupingFacilityDescriptor.nullOrEmpty(d.getClassname())) {
            throw new IllegalArgumentException(EMFCompareUIMessages.getString("DifferenceFilterDescriptor.missingMandatoryPropertyException", CLASS_PROPERTY));
        }
    }

    private static boolean nullOrEmpty(String s) {
        return s == null || s.length() == 0;
    }
}

