/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ui.viewer.structure;

import java.util.ArrayList;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareViewerPane;
import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.compare.diff.metamodel.AbstractDiffExtension;
import org.eclipse.emf.compare.diff.metamodel.ComparisonResourceSetSnapshot;
import org.eclipse.emf.compare.diff.metamodel.ComparisonResourceSnapshot;
import org.eclipse.emf.compare.diff.metamodel.ComparisonSnapshot;
import org.eclipse.emf.compare.diff.metamodel.DiffElement;
import org.eclipse.emf.compare.diff.metamodel.UpdateAttribute;
import org.eclipse.emf.compare.ui.CompareTextDialog;
import org.eclipse.emf.compare.ui.EMFCompareUIMessages;
import org.eclipse.emf.compare.ui.ICompareInputDetailsProvider;
import org.eclipse.emf.compare.ui.ModelCompareInput;
import org.eclipse.emf.compare.ui.export.ExportMenu;
import org.eclipse.emf.compare.ui.internal.ModelComparator;
import org.eclipse.emf.compare.ui.viewer.menus.ContextualMenuDescriptor;
import org.eclipse.emf.compare.ui.viewer.menus.ContextualMenuRegistry;
import org.eclipse.emf.compare.ui.viewer.menus.IContextualMenu;
import org.eclipse.emf.compare.ui.viewer.structure.ModelStructureContentProvider;
import org.eclipse.emf.compare.util.AdapterUtils;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;

public class ModelStructureMergeViewer
extends TreeViewer {
    protected CompareConfiguration configuration;
    protected ExportMenu exportMenu;
    protected CompareTextDialog textDialog;
    protected ComparisonSnapshot emfInput;
    boolean ignoreContentSelection;

    public ModelStructureMergeViewer(Composite parent, CompareConfiguration compareConfiguration) {
        super(parent);
        this.initialize(compareConfiguration);
        this.createToolItems();
    }

    public CompareConfiguration getCompareConfiguration() {
        return this.configuration;
    }

    public String getTitle() {
        return EMFCompareUIMessages.getString("ModelStructureMergeViewer.viewerTitle");
    }

    Widget find(Object element) {
        Widget widget = super.findItem(element);
        return widget;
    }

    protected ModelStructureContentProvider createContentProvider(CompareConfiguration compareConfiguration) {
        return new ModelStructureContentProvider(compareConfiguration);
    }

    protected ModelStructureLabelProvider createLabelProvider(CompareConfiguration compareConfiguration) {
        return new ModelStructureLabelProvider();
    }

    protected void createToolItems() {
        ToolBarManager tbm = CompareViewerPane.getToolBarManager((Composite)this.getControl().getParent());
        tbm.removeAll();
        if (this.exportMenu == null) {
            this.exportMenu = new ExportMenu((Control)tbm.getControl(), this);
        }
        tbm.add((IContributionItem)new Separator("IO"));
        tbm.appendToGroup("IO", (IAction)this.exportMenu);
        tbm.update(true);
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                CompareTextAction action = new CompareTextAction();
                action.setText(EMFCompareUIMessages.getString("CompareTextDialog_labelAction"));
                if (action.isEnabled()) {
                    manager.add((IAction)action);
                }
            }
        });
        Menu menu = menuMgr.createContextMenu((Control)this.getTree());
        this.getTree().setMenu(menu);
        IWorkbenchPart part = this.getCompareConfiguration().getContainer().getWorkbenchPart();
        if (part != null) {
            part.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this);
        }
        this.createContextualMenus();
    }

    protected void createContextualMenus() {
        for (ContextualMenuDescriptor desc : ContextualMenuRegistry.INSTANCE.getDescriptors()) {
            if (!desc.getTargetClass().isAssignableFrom(((Object)((Object)this)).getClass())) continue;
            IContextualMenu menu = desc.getExtension();
            menu.create(this.getCompareConfiguration(), (ISelectionProvider)this, this.getControl());
        }
    }

    protected UpdateAttribute getUpdateAttribute() {
        TreeItem item;
        TreeItem[] items = this.getTree().getSelection();
        if (items.length > 0 && (item = items[0]).getData() instanceof UpdateAttribute) {
            return (UpdateAttribute)item.getData();
        }
        return null;
    }

    protected void fireOpen(OpenEvent event) {
    }

    protected void fireSelectionChanged(SelectionChangedEvent event) {
    }

    protected void handleDispose(DisposeEvent event) {
        super.handleDispose(event);
        if (this.exportMenu != null) {
            this.exportMenu.dispose();
        }
    }

    protected void inputChanged(Object input, Object oldInput) {
        ComparisonResourceSnapshot snapshot;
        ModelComparator comparator = input instanceof ICompareInput ? ModelComparator.getComparator(this.configuration, (ICompareInput)input) : ModelComparator.getComparator(this.configuration);
        Object actualInput = input;
        if (input instanceof ComparisonResourceSnapshot) {
            snapshot = (ComparisonResourceSnapshot)input;
            actualInput = this.createModelCompareInput(comparator, (ComparisonSnapshot)snapshot);
            this.emfInput = snapshot;
        } else if (input instanceof ComparisonResourceSetSnapshot) {
            snapshot = (ComparisonResourceSetSnapshot)input;
            actualInput = this.createModelCompareInput(comparator, (ComparisonSnapshot)snapshot);
            this.emfInput = snapshot;
        }
        if (actualInput != input) {
            this.setInput(actualInput);
        } else {
            TreePath[] expandedPaths = this.getExpandedTreePaths();
            super.inputChanged(actualInput, oldInput);
            if (input != null) {
                this.setExpandedTreePaths(expandedPaths);
            }
        }
        this.updateToolItems();
    }

    protected ModelCompareInput createModelCompareInput(ICompareInputDetailsProvider provider, ComparisonSnapshot snapshot) {
        if (snapshot instanceof ComparisonResourceSetSnapshot) {
            return new ModelCompareInput(((ComparisonResourceSetSnapshot)snapshot).getMatchResourceSet(), ((ComparisonResourceSetSnapshot)snapshot).getDiffResourceSet(), provider);
        }
        return new ModelCompareInput(((ComparisonResourceSnapshot)snapshot).getMatch(), ((ComparisonResourceSnapshot)snapshot).getDiff(), provider);
    }

    protected void updateToolItems() {
        ModelComparator comparator = ModelComparator.getComparator(this.configuration);
        if (comparator != null) {
            this.exportMenu.enableSave(!comparator.isLeftRemote() && !comparator.isRightRemote());
        } else {
            this.exportMenu.enableSave(false);
        }
        CompareViewerPane.getToolBarManager((Composite)this.getControl().getParent()).update(true);
    }

    private void initialize(CompareConfiguration compareConfiguration) {
        this.configuration = compareConfiguration;
        this.setLabelProvider((IBaseLabelProvider)this.createLabelProvider(compareConfiguration));
        this.setUseHashlookup(true);
        this.setContentProvider((IContentProvider)this.createContentProvider(compareConfiguration));
        Tree tree = this.getTree();
        tree.setData("org.eclipse.compare.CompareUI.CompareViewerTitle", (Object)this.getTitle());
        tree.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                ArrayList<DiffElement> selectedElements = new ArrayList<DiffElement>(ModelStructureMergeViewer.this.getTree().getSelection().length);
                TreeItem[] treeItemArray = ModelStructureMergeViewer.this.getTree().getSelection();
                int n = treeItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TreeItem item = treeItemArray[n2];
                    if (item.getData() instanceof DiffElement) {
                        selectedElements.add((DiffElement)item.getData());
                    }
                    ++n2;
                }
                ModelStructureMergeViewer.this.ignoreContentSelection = true;
                ModelStructureMergeViewer.this.configuration.setProperty("structure.selection.changed", selectedElements);
            }
        });
        this.configuration.addPropertyChangeListener((IPropertyChangeListener)new ConfigurationPropertyListener());
        IWorkbenchPart part = this.configuration.getContainer().getWorkbenchPart();
        if (part != null) {
            part.getSite().setSelectionProvider((ISelectionProvider)this);
        }
        this.addPostSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ModelStructureMergeViewer.this.configuration.setProperty("structure.selection.changed", (Object)event.getSelection());
            }
        });
    }

    private class CompareTextAction
    extends Action {
        public boolean isEnabled() {
            UpdateAttribute element = ModelStructureMergeViewer.this.getUpdateAttribute();
            if (element != null) {
                return element.getAttribute().getEType().getInstanceClass().isAssignableFrom(String.class);
            }
            return false;
        }

        public void run() {
            super.run();
            UpdateAttribute element = ModelStructureMergeViewer.this.getUpdateAttribute();
            if (element != null) {
                if (ModelStructureMergeViewer.this.textDialog != null) {
                    ModelStructureMergeViewer.this.textDialog.setInput(element);
                    ModelStructureMergeViewer.this.textDialog.getShell().setActive();
                } else {
                    ModelStructureMergeViewer.this.textDialog = new CompareTextDialog(ModelStructureMergeViewer.this.getTree().getShell(), element, ModelStructureMergeViewer.this, ModelStructureMergeViewer.this.emfInput);
                    ModelStructureMergeViewer.this.textDialog.create();
                    ModelStructureMergeViewer.this.textDialog.getShell().addDisposeListener(new DisposeListener(){

                        public void widgetDisposed(DisposeEvent e) {
                            ((CompareTextAction)CompareTextAction.this).ModelStructureMergeViewer.this.textDialog = null;
                        }
                    });
                    ModelStructureMergeViewer.this.textDialog.setBlockOnOpen(false);
                    ModelStructureMergeViewer.this.textDialog.open();
                }
            }
        }
    }

    private class ConfigurationPropertyListener
    implements IPropertyChangeListener {
        public void propertyChange(PropertyChangeEvent event) {
            if (event.getProperty().equals("content.selection.changed")) {
                if (ModelStructureMergeViewer.this.ignoreContentSelection) {
                    ModelStructureMergeViewer.this.ignoreContentSelection = false;
                } else {
                    TreeItem item = (TreeItem)ModelStructureMergeViewer.this.find(event.getNewValue());
                    if (item == null) {
                        Object[] expandedElements = ModelStructureMergeViewer.this.getExpandedElements();
                        ModelStructureMergeViewer.this.expandAll();
                        item = (TreeItem)ModelStructureMergeViewer.this.find(event.getNewValue());
                        ModelStructureMergeViewer.this.setExpandedElements(expandedElements);
                    }
                    if (item != null) {
                        ModelStructureMergeViewer.this.setSelection((ISelection)new StructuredSelection(item.getData()), true);
                        ModelStructureMergeViewer.this.expandToLevel(item.getData(), 0);
                    }
                }
            } else if (event.getProperty().equals("content.input.changed")) {
                ModelStructureMergeViewer.this.setInput(event.getNewValue());
            }
        }
    }

    private class ModelStructureLabelProvider
    extends LabelProvider {
        AdapterFactoryLabelProvider adapterProvider = new AdapterFactoryLabelProvider(AdapterUtils.getAdapterFactory());

        public Image getImage(Object object) {
            Image image = null;
            if (object instanceof AbstractDiffExtension) {
                image = (Image)((AbstractDiffExtension)object).getImage();
            } else if (object instanceof IFile) {
                image = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FILE");
            }
            if (image == null) {
                image = this.adapterProvider.getImage(object);
            }
            return image;
        }

        public String getText(Object object) {
            String text = null;
            if (object instanceof AbstractDiffExtension) {
                text = ((AbstractDiffExtension)object).getText();
            } else if (object instanceof IFile) {
                text = ((IFile)object).getName();
            } else if (object instanceof Resource) {
                text = ((Resource)object).getURI().lastSegment();
            }
            if (text == null || "".equals(text)) {
                text = this.adapterProvider.getText(object);
            }
            return text;
        }
    }
}

