/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.infra.browser.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.facet.infra.browser.BrowserPlugin;
import org.eclipse.emf.facet.infra.browser.Messages;
import org.eclipse.emf.facet.infra.browser.core.InstancesForMetaclasses;
import org.eclipse.emf.facet.infra.browser.editors.BrowserConfiguration;
import org.eclipse.emf.facet.infra.browser.uicore.internal.customization.CustomizationEngine;
import org.eclipse.emf.facet.infra.common.core.internal.adapters.instances.MetaclassInstances;
import org.eclipse.emf.facet.infra.common.core.internal.utils.ModelUtils;
import org.eclipse.emf.facet.infra.facet.Facet;
import org.eclipse.emf.facet.infra.facet.core.adapters.instances.MetaclassInstancesAdapterFactoryWithFacet;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstancesForMetaclass {
    private final ArrayList<InstancesForMetaclass> subclasses = new ArrayList();
    private final EClass eClass;
    private final InstancesForMetaclasses instancesForMetaclasses;
    private final BrowserConfiguration browserConfiguration;
    private ArrayList<EObject> cachedElements = null;
    private int cachedElementsModCount = -1;
    private ArrayList<EObject> cachedDerivedElements = null;
    private int cachedDerivedElementsModCount = -1;
    private final Set<Resource> resources;
    private String classQualifiedName = null;
    private Object parent;

    public InstancesForMetaclass(EClass eClass, InstancesForMetaclasses instancesForMetaclasses, BrowserConfiguration browserConfiguration, Set<Resource> resources) {
        this.eClass = eClass;
        this.instancesForMetaclasses = instancesForMetaclasses;
        this.browserConfiguration = browserConfiguration;
        this.resources = resources;
    }

    public ArrayList<EObject> getElements() {
        if (this.cachedElements == null || this.cachedElementsModCount != this.browserConfiguration.getAppearanceConfiguration().getModCount()) {
            CustomizationEngine customizationEngine = this.browserConfiguration.getAppearanceConfiguration().getCustomizationEngine();
            MetaclassInstancesAdapterFactoryWithFacet.getInstance().setFacetContext(this.browserConfiguration.getAppearanceConfiguration().getFacetContext());
            ArrayList visibleElements = new ArrayList();
            for (Resource resource : this.resources) {
                MetaclassInstances instances = (MetaclassInstances)MetaclassInstancesAdapterFactoryWithFacet.getInstance().adapt((Notifier)resource, MetaclassInstances.class);
                Set elements = instances.getInstances(this.eClass, false);
                customizationEngine.filterVisible((Collection)elements, visibleElements);
            }
            this.cachedElements = visibleElements;
            this.cachedElementsModCount = this.browserConfiguration.getAppearanceConfiguration().getModCount();
        }
        return this.cachedElements;
    }

    public ArrayList<EObject> getDerivedElements() {
        if (this.cachedDerivedElements == null || this.cachedDerivedElementsModCount != this.browserConfiguration.getAppearanceConfiguration().getModCount()) {
            CustomizationEngine customizationEngine = this.browserConfiguration.getAppearanceConfiguration().getCustomizationEngine();
            MetaclassInstancesAdapterFactoryWithFacet.getInstance().setFacetContext(this.browserConfiguration.getAppearanceConfiguration().getFacetContext());
            ArrayList visibleElements = new ArrayList();
            for (Resource resource : this.resources) {
                MetaclassInstances instances = (MetaclassInstances)MetaclassInstancesAdapterFactoryWithFacet.getInstance().adapt((Notifier)resource, MetaclassInstances.class);
                Set elements = instances.getInstances(this.eClass, true);
                customizationEngine.filterVisible((Collection)elements, visibleElements);
            }
            this.cachedDerivedElements = visibleElements;
            this.cachedDerivedElementsModCount = this.browserConfiguration.getAppearanceConfiguration().getModCount();
        }
        return this.cachedDerivedElements;
    }

    public int size() {
        return this.getElements().size();
    }

    public int totalSize() {
        return this.getDerivedElements().size();
    }

    public EClass getEClass() {
        return this.eClass;
    }

    public String getClassQualifiedName() {
        if (this.classQualifiedName == null) {
            this.classQualifiedName = ModelUtils.getMetaclassQualifiedName((EClassifier)this.getEClass());
        }
        return this.classQualifiedName;
    }

    public void setParent(Object parent) {
        this.parent = parent;
    }

    public Object getParent() {
        return this.parent;
    }

    public void buildParentsSubclasses() {
        EList superTypes = this.eClass.getESuperTypes();
        for (EClass superclass : superTypes) {
            InstancesForMetaclass instancesForSuperclass = this.instancesForMetaclasses.getInstancesForMetaclass(superclass);
            if (instancesForSuperclass != null) {
                instancesForSuperclass.addSubclass(this);
                continue;
            }
            if (this.eClass instanceof Facet) continue;
            BrowserPlugin.logWarning(NLS.bind((String)Messages.InstancesForMetaclass_notFound, (Object)ModelUtils.getMetaclassQualifiedName((EClassifier)superclass)));
        }
    }

    public void clearSubclasses() {
        this.subclasses.clear();
    }

    public InstancesForMetaclass[] getSubclasses() {
        return this.subclasses.toArray(new InstancesForMetaclass[this.subclasses.size()]);
    }

    private void addSubclass(InstancesForMetaclass instancesForMetaclass) {
        this.subclasses.add(instancesForMetaclass);
    }

    public String toString() {
        return String.valueOf(this.getClassQualifiedName()) + " " + this.size();
    }
}

