/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.infra.browser.editors.table;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;

public class ColumnDescription {
    private final Type type;
    private EAttribute fAttribute = null;
    private EReference fReference = null;

    public ColumnDescription(Type type) {
        this.type = type;
    }

    public ColumnDescription(EAttribute attribute) {
        this.type = Type.ATTRIBUTE;
        this.fAttribute = attribute;
    }

    public ColumnDescription(EReference reference) {
        this.fReference = reference;
        this.type = Type.REFERENCE;
    }

    public ColumnDescription(EStructuralFeature feature) {
        if (feature instanceof EAttribute) {
            EAttribute attribute;
            this.fAttribute = attribute = (EAttribute)feature;
            this.type = Type.ATTRIBUTE;
        } else if (feature instanceof EReference) {
            EReference reference;
            this.fReference = reference = (EReference)feature;
            this.type = Type.REFERENCE;
        } else {
            throw new IllegalArgumentException();
        }
    }

    public Type getType() {
        return this.type;
    }

    public EAttribute getAttribute() {
        if (this.type != Type.ATTRIBUTE) {
            throw new IllegalStateException();
        }
        return this.fAttribute;
    }

    public EReference getReference() {
        if (this.type != Type.REFERENCE) {
            throw new IllegalStateException();
        }
        return this.fReference;
    }

    public EStructuralFeature getFeature() {
        if (this.type == Type.ATTRIBUTE) {
            return this.fAttribute;
        }
        if (this.type == Type.REFERENCE) {
            return this.fReference;
        }
        throw new IllegalStateException();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        DEFAULT_LABEL,
        METACLASS_NAME,
        ATTRIBUTE,
        REFERENCE,
        ECONTAINER,
        CONTEXT;

    }
}

