/**
 * Copyright (c) 2009 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Gregoire DUPE (Mia-Software) - initial API and implementation
 */
package org.eclipse.emf.facet.infra.query.core.internal;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.facet.infra.common.core.internal.protocol.IEmfFacetProtocolExtension;
import org.eclipse.emf.facet.infra.query.core.ModelQuerySetCatalog;

public class QueryProtocolExtension implements IEmfFacetProtocolExtension {

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.emf.facet.infra.common.core.IEmfFacetResourceFactoryExt#
	 * getSchemeSpecificPart()
	 */
	public String getSchemeSpecificPart() {
		return "query"; //$NON-NLS-1$
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * org.eclipse.emf.facet.infra.common.core.internal.IEmfFacetResourceFactoryExt
	 * #getURI (java.lang.String)
	 */
	public URI getURI(final String name) {
		return ModelQuerySetCatalog.getSingleton().getURI(name);
	}
}