/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.infra.query.core.java.internal;

import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.facet.infra.common.core.internal.builder.IEmfFacetBuilder;
import org.eclipse.emf.facet.infra.query.core.ModelQuerySetCatalog;
import org.eclipse.emf.facet.infra.query.core.internal.Activator;
import org.eclipse.emf.facet.infra.query.core.java.internal.JavaQueryImplMarkerChangeListener;
import org.eclipse.emf.facet.util.core.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaValidationQueryBuilder
implements IEmfFacetBuilder {
    public static final String FILE_EXTENSION = "java";

    public JavaValidationQueryBuilder() {
        JavaQueryImplMarkerChangeListener.getSingleton();
    }

    public IProject[] build(IncrementalProjectBuilder builder, int kind, Map<?, ?> args, IProgressMonitor monitor) throws CoreException {
        if (kind == 6) {
            this.fullBuild(builder);
        } else {
            IProject project = builder.getProject();
            IResourceDelta delta = builder.getDelta(project);
            if (delta == null) {
                this.fullBuild(builder);
            } else {
                this.incrementalBuild(builder, delta);
            }
        }
        return null;
    }

    private void incrementalBuild(IncrementalProjectBuilder builder, IResourceDelta resourceDelta) {
        try {
            final HashSet projectsToRevalidate = new HashSet();
            resourceDelta.accept(new IResourceDeltaVisitor(){

                public boolean visit(IResourceDelta delta) {
                    IResource resource = delta.getResource();
                    String fileExtension = resource.getFileExtension();
                    if (resource instanceof IFile && fileExtension != null && fileExtension.equals(JavaValidationQueryBuilder.FILE_EXTENSION)) {
                        projectsToRevalidate.add(resource.getProject());
                    }
                    return true;
                }
            });
            for (IProject project : projectsToRevalidate) {
                ModelQuerySetCatalog.getSingleton().revalidateAll(project);
            }
        }
        catch (CoreException e) {
            Logger.logError((Throwable)e, (String)("Failed to build: " + builder.getProject()), (Plugin)Activator.getDefault());
        }
    }

    private void fullBuild(IncrementalProjectBuilder builder) {
        try {
            final HashSet projectsToRevalidate = new HashSet();
            builder.getProject().accept(new IResourceVisitor(){

                public boolean visit(IResource resource) throws CoreException {
                    String fileExtension = resource.getFileExtension();
                    if (fileExtension != null && fileExtension.equals(JavaValidationQueryBuilder.FILE_EXTENSION)) {
                        projectsToRevalidate.add(resource.getProject());
                    }
                    return true;
                }
            });
            for (IProject project : projectsToRevalidate) {
                ModelQuerySetCatalog.getSingleton().revalidateAll(project);
            }
        }
        catch (CoreException e) {
            Status status = new Status(4, "org.eclipse.emf.facet.infra.query.core", "Failed to build: " + builder.getProject(), (Throwable)e);
            Activator.getDefault().getLog().log((IStatus)status);
        }
    }

    public void clean(IncrementalProjectBuilder builder, IProgressMonitor monitor) throws CoreException {
    }
}

