/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.infra.query.ui.dialogs;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.facet.infra.query.ModelQuery;
import org.eclipse.emf.facet.infra.query.ModelQuerySet;
import org.eclipse.emf.facet.infra.query.core.ModelQuerySetCatalog;
import org.eclipse.emf.facet.infra.query.ui.Activator;
import org.eclipse.emf.facet.infra.query.ui.ImageProvider;
import org.eclipse.emf.facet.infra.query.ui.Messages;
import org.eclipse.emf.facet.infra.query.ui.controls.QueryFilteredTree;
import org.eclipse.emf.facet.infra.query.ui.wizards.CreateQueryWizard;
import org.eclipse.emf.facet.util.core.Logger;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class QuerySelectionDialog
extends Dialog {
    private Collection<ModelQuerySet> fQuerySets;
    private final List<ViewerFilter> viewerFilters;
    private QueryFilteredTree filteredTree;
    private final boolean multiSelection;
    private List<ModelQuery> fSelectedQueries = new ArrayList<ModelQuery>();
    private final List<Runnable> listeners = new ArrayList<Runnable>();
    private final boolean allowEmptySelection;
    private Button checkboxEnableQuery;

    public QuerySelectionDialog(Shell parentShell, boolean multiSelection, Collection<ModelQuerySet> querySets, List<ViewerFilter> viewerFilters, boolean allowEmptySelection) {
        super(parentShell);
        this.multiSelection = multiSelection;
        this.fQuerySets = querySets == null ? ModelQuerySetCatalog.getSingleton().getAllModelQuerySets() : querySets;
        this.viewerFilters = viewerFilters;
        this.allowEmptySelection = allowEmptySelection;
    }

    public QuerySelectionDialog(Shell parentShell, boolean multiSelection, Collection<ModelQuerySet> querySets, List<ViewerFilter> viewerFilters) {
        this(parentShell, multiSelection, querySets, viewerFilters, false);
    }

    protected QueryFilteredTree getFilteredTree() {
        return this.filteredTree;
    }

    protected Button getCheckboxEnableQuery() {
        return this.checkboxEnableQuery;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        if (this.allowEmptySelection) {
            this.checkboxEnableQuery = new Button(composite, 32);
            this.checkboxEnableQuery.setText(Messages.QuerySelectionDialog_enableQuery);
            this.checkboxEnableQuery.setSelection(false);
            this.checkboxEnableQuery.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    boolean enabled = QuerySelectionDialog.this.getCheckboxEnableQuery().getSelection();
                    QuerySelectionDialog.this.setQuerySelectionEnabled(enabled);
                    if (!enabled) {
                        QuerySelectionDialog.this.select(null);
                    }
                }
            });
        }
        this.filteredTree = new QueryFilteredTree(composite, this.fQuerySets, this.viewerFilters, this.multiSelection);
        this.createContextMenu(this.filteredTree.getViewer());
        this.filteredTree.getViewer().addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                QuerySelectionDialog.this.okPressed();
            }
        });
        if (this.allowEmptySelection) {
            this.setQuerySelectionEnabled(false);
        }
        return composite;
    }

    protected void setQuerySelectionEnabled(boolean enabled) {
        this.getCheckboxEnableQuery().setSelection(enabled);
        this.filteredTree.getViewer().getTree().setEnabled(enabled);
        this.filteredTree.getFilterControl().setEnabled(enabled);
    }

    private void createContextMenu(final TreeViewer viewer) {
        MenuManager contextMenu = new MenuManager("#PopUp");
        contextMenu.setRemoveAllWhenShown(true);
        contextMenu.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                Object firstElement;
                IStructuredSelection structuredSelection;
                ISelection selection = viewer.getSelection();
                if (selection instanceof IStructuredSelection && (structuredSelection = (IStructuredSelection)selection).size() == 1 && (firstElement = structuredSelection.getFirstElement()) instanceof ModelQuerySet) {
                    ModelQuerySet modelQuerySet = (ModelQuerySet)firstElement;
                    manager.add((IAction)new OpenCreateQueryWizardAction(modelQuerySet));
                    return;
                }
                manager.add((IAction)new OpenCreateQueryWizardAction(null));
            }
        });
        Menu menu = contextMenu.createContextMenu(viewer.getControl());
        viewer.getControl().setMenu(menu);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Messages.QuerySelectionDialog_selectQuery);
        shell.setImage(ImageProvider.getInstance().getModelQuerySet());
    }

    protected boolean isResizable() {
        return true;
    }

    protected IDialogSettings getDialogBoundsSettings() {
        String sectionName = String.valueOf(((Object)((Object)this)).getClass().getName()) + ".settings";
        IDialogSettings settings = Activator.getDefault().getDialogSettings();
        IDialogSettings section = settings.getSection(sectionName);
        if (section == null) {
            section = settings.addNewSection(sectionName);
        }
        return section;
    }

    protected void okPressed() {
        ArrayList<ModelQuery> tempSelectedQueries = new ArrayList<ModelQuery>();
        ISelection selection = this.filteredTree.getViewer().getSelection();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            for (Object selectedElement : structuredSelection) {
                if (!(selectedElement instanceof ModelQuery)) continue;
                tempSelectedQueries.add((ModelQuery)selectedElement);
            }
        }
        this.fSelectedQueries = tempSelectedQueries;
        super.okPressed();
    }

    public List<ModelQuery> getSelectedQueries() {
        return Collections.unmodifiableList(this.fSelectedQueries);
    }

    public void pressOk() {
        this.okPressed();
    }

    public void pressCancel() {
        this.setReturnCode(1);
        this.close();
    }

    public boolean close() {
        boolean result = super.close();
        this.notifyListeners();
        return result;
    }

    public ModelQuery getFirstSelectedQuery() {
        ModelQuery selectedQuery = null;
        if (!this.filteredTree.isDisposed()) {
            IStructuredSelection selection = (IStructuredSelection)this.filteredTree.getViewer().getSelection();
            Object firstElement = selection.getFirstElement();
            if (firstElement instanceof ModelQuery) {
                selectedQuery = (ModelQuery)firstElement;
            }
        } else {
            List<ModelQuery> queries = this.getSelectedQueries();
            if (queries.size() > 0) {
                selectedQuery = queries.get(0);
            }
        }
        return selectedQuery;
    }

    public void select(ModelQuery query) {
        if (query != null) {
            this.setQuerySelectionEnabled(true);
            this.filteredTree.getViewer().setSelection((ISelection)new StructuredSelection((Object)query));
        } else {
            this.setQuerySelectionEnabled(false);
            this.filteredTree.getViewer().setSelection((ISelection)new StructuredSelection());
        }
    }

    private synchronized void notifyListeners() {
        for (Runnable listener : new ArrayList<Runnable>(this.listeners)) {
            listener.run();
        }
    }

    public synchronized void addListener(Runnable runnable) {
        this.listeners.add(runnable);
    }

    private class OpenCreateQueryWizardAction
    extends Action {
        private final ModelQuerySet modelQuerySet;

        public OpenCreateQueryWizardAction(ModelQuerySet modelQuerySet) {
            this.modelQuerySet = modelQuerySet;
            this.setText(Messages.QuerySelectionDialog_createQuery);
        }

        public void run() {
            final CreateQueryWizard createQueryWizard = new CreateQueryWizard(this.modelQuerySet, null, null, null);
            WizardDialog wizardDialog = new WizardDialog(null, (IWizard)createQueryWizard);
            if (wizardDialog.open() == 0) {
                Job refreshJob = new Job(Messages.QuerySelectionDialog_refreshQuerySetsJob){

                    protected IStatus run(IProgressMonitor monitor) {
                        try {
                            ResourcesPlugin.getWorkspace().build(6, monitor);
                        }
                        catch (CoreException e) {
                            Logger.logError((Throwable)e, (Plugin)Activator.getDefault());
                        }
                        ArrayList oldQuerySets = new ArrayList(QuerySelectionDialog.this.fQuerySets);
                        final ArrayList<ModelQuerySet> newQuerySets = new ArrayList<ModelQuerySet>();
                        for (ModelQuerySet oldQuerySet : oldQuerySets) {
                            ModelQuerySet querySet = ModelQuerySetCatalog.getSingleton().getModelQuerySet(oldQuerySet.getName());
                            if (querySet == null) continue;
                            newQuerySets.add(querySet);
                        }
                        QuerySelectionDialog.this.fQuerySets = newQuerySets;
                        Display.getDefault().asyncExec(new Runnable(){

                            public void run() {
                                QuerySelectionDialog.this.filteredTree.setInput(newQuerySets);
                                ModelQuery createdModelQuery = createQueryWizard.getCreatedModelQuery();
                                ModelQuerySet querySet = ModelQuerySetCatalog.getSingleton().getModelQuerySet(createdModelQuery.getModelQuerySet().getName());
                                ModelQuery query = querySet.getQuery(createdModelQuery.getName());
                                QuerySelectionDialog.this.filteredTree.getViewer().setSelection((ISelection)new StructuredSelection((Object)query), true);
                            }
                        });
                        return Status.OK_STATUS;
                    }
                };
                refreshJob.setPriority(50);
                refreshJob.schedule();
            }
        }
    }
}

