/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.infra.query.ui.wizards;

import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.facet.infra.query.ModelQuery;
import org.eclipse.emf.facet.infra.query.ModelQuerySet;
import org.eclipse.emf.facet.infra.query.QueryFactory;
import org.eclipse.emf.facet.infra.query.QueryPackage;
import org.eclipse.emf.facet.infra.query.core.ModelQuerySetCatalog;
import org.eclipse.emf.facet.infra.query.ui.Activator;
import org.eclipse.emf.facet.infra.query.ui.wizards.CreateQueryWizardPage;
import org.eclipse.emf.facet.infra.query.ui.wizards.NewQueryClassWizardPage;
import org.eclipse.emf.facet.util.core.Logger;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;

@Deprecated
public class CreateQueryWizard
extends Wizard {
    private final ModelQuerySet modelQuerySet;
    private final EClass eClass;
    private CreateQueryWizardPage createQueryWizardPage;
    private NewQueryClassWizardPage newQueryClassWizardPage;
    private ModelQuery modelQuery;
    private final Resource resourceToEdit;
    private final EditingDomain editingDomain;

    public CreateQueryWizard(ModelQuerySet modelQuerySet, EClass eClass, Resource resourceToEdit, EditingDomain editingDomain) {
        this.modelQuerySet = modelQuerySet;
        this.eClass = eClass;
        this.resourceToEdit = resourceToEdit;
        this.editingDomain = editingDomain;
        this.setHelpAvailable(false);
    }

    public void addPages() {
        this.createQueryWizardPage = new CreateQueryWizardPage(this.modelQuerySet, this.eClass);
        this.newQueryClassWizardPage = new NewQueryClassWizardPage(null);
        this.addPage((IWizardPage)this.createQueryWizardPage);
        this.addPage(this.newQueryClassWizardPage);
    }

    public IWizardPage getNextPage(IWizardPage page) {
        if (page == this.createQueryWizardPage) {
            this.createQuery();
            ModelQuerySet querySet = this.createQueryWizardPage.getQuerySet();
            if (querySet != null) {
                this.newQueryClassWizardPage.init(querySet, this.modelQuery);
            }
            return this.newQueryClassWizardPage;
        }
        return null;
    }

    private void createQuery() {
        this.modelQuery = QueryFactory.eINSTANCE.createJavaModelQuery();
        this.modelQuery.setName(this.createQueryWizardPage.getQueryName());
        this.modelQuery.setDescription(this.createQueryWizardPage.getQueryDescription());
        this.modelQuery.getScope().addAll(this.createQueryWizardPage.getScope());
        this.modelQuery.setReturnType(this.createQueryWizardPage.getReturnType());
        this.modelQuery.setLowerBound(0);
        if (this.createQueryWizardPage.isReturnTypeMultiValued()) {
            this.modelQuery.setUpperBound(-1);
        } else {
            this.modelQuery.setUpperBound(1);
        }
    }

    public boolean performFinish() {
        try {
            this.createQuery();
            this.newQueryClassWizardPage.apply(this.modelQuery);
            ModelQuerySet catalogQuerySet = this.createQueryWizardPage.getQuerySet();
            String querySetName = catalogQuerySet.getName();
            if (this.resourceToEdit != null) {
                ModelQuerySet querySet = (ModelQuerySet)this.resourceToEdit.getContents().get(0);
                CompoundCommand compoundCommand = new CompoundCommand();
                Command cmd = AddCommand.create((EditingDomain)this.editingDomain, (Object)querySet, (Object)QueryPackage.Literals.MODEL_QUERY_SET__QUERIES, (Object)this.modelQuery);
                compoundCommand.append(cmd);
                this.configureQuerySet(querySet, compoundCommand);
                this.editingDomain.getCommandStack().execute((Command)compoundCommand);
            } else {
                URI uri = ModelQuerySetCatalog.getSingleton().getURI(querySetName);
                ResourceSetImpl resourceSet = new ResourceSetImpl();
                Resource resource = resourceSet.createResource(uri);
                resource.load(Collections.emptyMap());
                ModelQuerySet querySet = (ModelQuerySet)resource.getContents().get(0);
                querySet.getQueries().add((Object)this.modelQuery);
                this.configureQuerySet(querySet);
                resource.save(Collections.emptyMap());
            }
        }
        catch (Exception e) {
            Logger.logError((Throwable)e, (Plugin)Activator.getDefault());
            return false;
        }
        return true;
    }

    private void configureQuerySet(ModelQuerySet querySet) {
        EPackage returnTypePackage = this.modelQuery.getReturnType().getEPackage();
        querySet.getAssociatedMetamodels().add((Object)returnTypePackage);
        EList scope = this.modelQuery.getScope();
        for (EClass scopeElement : scope) {
            querySet.getAssociatedMetamodels().add((Object)scopeElement.getEPackage());
        }
    }

    private void configureQuerySet(ModelQuerySet querySet, CompoundCommand compoundCommand) {
        ArrayList<EPackage> packagesToAdd = new ArrayList<EPackage>();
        EPackage returnTypePackage = this.modelQuery.getReturnType().getEPackage();
        if (!querySet.getAssociatedMetamodels().contains((Object)returnTypePackage)) {
            packagesToAdd.add(returnTypePackage);
        }
        EList scope = this.modelQuery.getScope();
        for (EClass scopeElement : scope) {
            EPackage scopePackage = scopeElement.getEPackage();
            if (querySet.getAssociatedMetamodels().contains((Object)scopePackage) || packagesToAdd.contains(scopePackage)) continue;
            packagesToAdd.add(scopePackage);
        }
        if (!packagesToAdd.isEmpty()) {
            Command cmd = AddCommand.create((EditingDomain)this.editingDomain, (Object)querySet, (Object)QueryPackage.Literals.MODEL_QUERY_SET__ASSOCIATED_METAMODELS, packagesToAdd);
            if (cmd.canExecute()) {
                compoundCommand.append(cmd);
            } else {
                Logger.logWarning((String)("Couldn't automatically add EPackages to QuerySet: " + packagesToAdd), (Plugin)Activator.getDefault());
            }
        }
    }

    public ModelQuery getCreatedModelQuery() {
        return this.modelQuery;
    }
}

