/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.infra.query.ui.wizards;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.jar.Manifest;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.facet.infra.common.core.internal.utils.ProjectUtils;
import org.eclipse.emf.facet.infra.query.JavaModelQuery;
import org.eclipse.emf.facet.infra.query.ModelQuery;
import org.eclipse.emf.facet.infra.query.ModelQuerySet;
import org.eclipse.emf.facet.infra.query.QueryPackage;
import org.eclipse.emf.facet.infra.query.core.ModelQuerySetCatalog;
import org.eclipse.emf.facet.infra.query.core.internal.utils.QueryUtils;
import org.eclipse.emf.facet.infra.query.core.java.IJavaModelQuery;
import org.eclipse.emf.facet.infra.query.ui.Activator;
import org.eclipse.emf.facet.infra.query.ui.Messages;
import org.eclipse.emf.facet.infra.query.ui.extensions.IQueryAttributesWizardPage;
import org.eclipse.emf.facet.infra.query.ui.wizards.NewClassWizardPage;
import org.eclipse.emf.facet.util.core.Logger;
import org.eclipse.emf.facet.util.core.internal.exported.StringUtils;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.ManifestElement;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;

@Deprecated
public class NewQueryClassWizardPage
extends NewClassWizardPage
implements IQueryAttributesWizardPage {
    private final EditingDomain editingDomain;

    public NewQueryClassWizardPage(EditingDomain editingDomain) {
        this.editingDomain = editingDomain;
    }

    public void init(ModelQuerySet modelQuerySet, ModelQuery modelQuery) {
        IJavaProject javaProject = this.findJavaProject(modelQuerySet);
        ArrayList<String> interfaceList = new ArrayList<String>();
        interfaceList.add(IJavaModelQuery.class.getName());
        this.setSuperInterfaces(interfaceList, false);
        JavaModelQuery javaModelQuery = (JavaModelQuery)modelQuery;
        if (javaModelQuery != null) {
            String name;
            String packageName = "";
            String implementationClassName = javaModelQuery.getImplementationClassName();
            if (implementationClassName != null) {
                int lastDotPos = implementationClassName.lastIndexOf(46);
                String name2 = implementationClassName.substring(lastDotPos + 1);
                this.setTypeName(name2, true);
                if (lastDotPos != -1) {
                    packageName = implementationClassName.substring(0, lastDotPos);
                }
            } else {
                packageName = ProjectUtils.packageName((String)javaProject.getProject().getName());
            }
            this.selectPackage(javaProject, packageName);
            if ((implementationClassName == null || implementationClassName.trim().length() == 0) && (name = javaModelQuery.getName()) != null) {
                String javaName = StringUtils.inferJavaClassName((String)name);
                this.setTypeName(javaName, true);
            }
        } else {
            String packageName = ProjectUtils.packageName((String)javaProject.getProject().getName());
            this.selectPackage(javaProject, packageName);
        }
        this.setModifiers(this.F_PUBLIC, false);
        this.setSuperClass("", false);
        this.setEnclosingTypeSelection(false, false);
        this.setAddComments(false, false);
    }

    private void selectPackage(IJavaProject javaProject, String packageName) {
        try {
            IPackageFragmentRoot[] iPackageFragmentRootArray = javaProject.getPackageFragmentRoots();
            int n = iPackageFragmentRootArray.length;
            int n2 = 0;
            while (n2 < n) {
                IPackageFragmentRoot packageFragmentRootToTest = iPackageFragmentRootArray[n2];
                if (packageFragmentRootToTest.getKind() == 1) {
                    IPackageFragmentRoot packageFragmentRoot = packageFragmentRootToTest;
                    this.setPackageFragmentRoot(packageFragmentRoot, false);
                    IPackageFragment packageFragment = packageFragmentRoot.getPackageFragment(packageName);
                    this.setPackageFragment(packageFragment, true);
                    break;
                }
                ++n2;
            }
        }
        catch (JavaModelException e1) {
            Logger.logError((Throwable)e1, (Plugin)Activator.getDefault());
        }
    }

    private IJavaProject findJavaProject(ModelQuerySet modelQuerySet) {
        Resource resource = modelQuerySet.eResource();
        URI uri = resource.getURI();
        if ("emffacet".equals(uri.scheme())) {
            uri = ModelQuerySetCatalog.getSingleton().getURI(modelQuerySet.getName());
        }
        if (uri.isPlatformResource()) {
            String projectName = uri.segment(1);
            IWorkspace ws = ResourcesPlugin.getWorkspace();
            IProject project = ws.getRoot().getProject(projectName);
            return JavaCore.create((IProject)project);
        }
        return null;
    }

    public void apply(ModelQuery modelQuery) {
        try {
            ICompilationUnit javaClass = this.createJavaClass(modelQuery);
            IProject project = javaClass.getCorrespondingResource().getProject();
            this.setupProject(project, modelQuery);
            JavaModelQuery javaModelQuery = (JavaModelQuery)modelQuery;
            String implementationClassName = javaClass.getAllTypes()[0].getFullyQualifiedName();
            if (this.editingDomain != null) {
                Command command = SetCommand.create((EditingDomain)this.editingDomain, (Object)javaModelQuery, (Object)QueryPackage.Literals.JAVA_MODEL_QUERY__IMPLEMENTATION_CLASS_NAME, (Object)implementationClassName);
                this.editingDomain.getCommandStack().execute(command);
            } else {
                javaModelQuery.setImplementationClassName(implementationClassName);
            }
            IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            IDE.openEditor((IWorkbenchPage)activePage, (IFile)((IFile)javaClass.getResource()));
        }
        catch (Exception e) {
            Logger.logError((Throwable)e, (Plugin)Activator.getDefault());
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.NewClassCreationWizard_failedToCreateJavaClass, (String)Messages.NewClassCreationWizard_failedToCreateJavaModelQueryClass);
        }
    }

    private void setupProject(IProject project, ModelQuery modelQuery) {
        try {
            String[] requiredBundles = this.findRequiredBundles(modelQuery);
            ArrayList<String> missingRequiredBundles = new ArrayList<String>();
            String[] stringArray = requiredBundles;
            int n = requiredBundles.length;
            int n2 = 0;
            while (n2 < n) {
                String requiredBundle = stringArray[n2];
                missingRequiredBundles.add(requiredBundle);
                ++n2;
            }
            missingRequiredBundles.add("org.eclipse.emf.facet.infra.query.core");
            IFile manifestResource = (IFile)project.findMember((IPath)new Path("/META-INF/MANIFEST.MF"));
            manifestResource.refreshLocal(1, (IProgressMonitor)new NullProgressMonitor());
            InputStream contents = manifestResource.getContents();
            Manifest manifest = new Manifest(contents);
            String requires = manifest.getMainAttributes().getValue("Require-Bundle");
            if (requires != null) {
                ManifestElement[] manifestElements;
                ManifestElement[] manifestElementArray = manifestElements = ManifestElement.parseHeader((String)"Require-Bundle", (String)requires);
                int n3 = manifestElements.length;
                int n4 = 0;
                while (n4 < n3) {
                    ManifestElement manifestElement = manifestElementArray[n4];
                    missingRequiredBundles.remove(manifestElement.getValue());
                    ++n4;
                }
            }
            StringBuilder newRequires = new StringBuilder();
            if (requires != null) {
                newRequires.append(requires);
            }
            int i = 0;
            while (i < missingRequiredBundles.size()) {
                String missingRequiredBundle = (String)missingRequiredBundles.get(i);
                if (i != 0 || requires != null) {
                    newRequires.append(",");
                }
                newRequires.append(missingRequiredBundle);
                ++i;
            }
            manifest.getMainAttributes().putValue("Require-Bundle", newRequires.toString());
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            manifest.write(outputStream);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(outputStream.toByteArray());
            manifestResource.setContents((InputStream)byteArrayInputStream, true, true, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (Exception e) {
            Logger.logError((Throwable)e, (Plugin)Activator.getDefault());
        }
    }

    private String[] findRequiredBundles(ModelQuery modelQuery) {
        EList scope;
        HashSet<String> requiredBundles = new HashSet<String>();
        HashSet<EPackage> requiredEPackages = new HashSet<EPackage>();
        if (modelQuery.getReturnType() != null) {
            requiredEPackages.add(modelQuery.getReturnType().getEPackage());
        }
        if ((scope = modelQuery.getScope()) != null) {
            for (EClass scopeElement : scope) {
                requiredEPackages.add(scopeElement.getEPackage());
            }
        }
        Map genModelLocationMap = EcorePlugin.getEPackageNsURIToGenModelLocationMap();
        for (EPackage ePackage : requiredEPackages) {
            try {
                URI genModelURI = (URI)genModelLocationMap.get(ePackage.getNsURI());
                if (genModelURI != null) {
                    ResourceSetImpl resourceSet = new ResourceSetImpl();
                    Resource resource = resourceSet.createResource(genModelURI);
                    resource.load(Collections.emptyMap());
                    GenModel genModel = (GenModel)resource.getContents().get(0);
                    String modelPluginID = genModel.getModelPluginID();
                    if (modelPluginID == null) continue;
                    requiredBundles.add(modelPluginID);
                    continue;
                }
                Logger.logWarning((String)("Couldn't add the metamodel implementation plug-in to the dependencies automatically because the corresponding genmodel couldn't be found: " + ePackage.getNsURI()), (Plugin)Activator.getDefault());
            }
            catch (Exception e) {
                Logger.logError((Throwable)e, (Plugin)Activator.getDefault());
            }
        }
        return requiredBundles.toArray(new String[requiredBundles.size()]);
    }

    private ICompilationUnit createJavaClass(ModelQuery modelQuery) throws JavaModelException {
        IPackageFragmentRoot root = this.getPackageFragmentRoot();
        IPackageFragment packageFragment = this.getPackageFragment();
        if (packageFragment == null) {
            packageFragment = root.getPackageFragment("");
        }
        String packageName = packageFragment.getElementName();
        if (!packageFragment.exists()) {
            packageFragment = root.createPackageFragment(packageName, true, (IProgressMonitor)new NullProgressMonitor());
        }
        String typeName = this.getTypeName();
        StringBuilder contents = new StringBuilder();
        this.createJavaClassContents(contents, typeName, packageName, modelQuery);
        String cuName = this.getCompilationUnitName(typeName);
        ICompilationUnit compilationUnit = packageFragment.createCompilationUnit(cuName, contents.toString(), false, (IProgressMonitor)new NullProgressMonitor());
        return compilationUnit;
    }

    private void createJavaClassContents(StringBuilder contents, String name, String packageName, ModelQuery modelQuery) {
        String shortScopeType;
        String scopeType;
        String shortReturnType;
        String returnType;
        if (packageName.length() > 0) {
            contents.append("package ");
            contents.append(packageName);
            contents.append(";\n");
        }
        boolean importCollection = false;
        EClassifier returnTypeClass = modelQuery.getReturnType();
        if (returnTypeClass != null) {
            returnType = returnTypeClass.getInstanceClassName();
            returnType = QueryUtils.objectType((String)returnType);
            int lastDotPos = returnType.lastIndexOf(46);
            if (modelQuery.getUpperBound() != 1) {
                importCollection = true;
                shortReturnType = "Collection<" + returnType.substring(lastDotPos + 1) + ">";
            } else {
                shortReturnType = returnType.substring(lastDotPos + 1);
            }
        } else {
            returnType = "java.lang.Object";
            shortReturnType = "Object";
        }
        EList scope = modelQuery.getScope();
        if (scope != null && scope.size() == 1) {
            EClass scopeClass = (EClass)scope.get(0);
            scopeType = scopeClass.getInstanceClassName();
            scopeType = QueryUtils.objectType((String)scopeType);
            shortScopeType = scopeType.substring(scopeType.lastIndexOf(46) + 1);
        } else {
            scopeType = "org.eclipse.emf.ecore.EObject";
            shortScopeType = "EObject";
        }
        if (importCollection) {
            contents.append("import java.util.Collection;\n");
        }
        if (this.mustImport(returnType)) {
            contents.append("import " + returnType + ";\n");
        }
        if (!returnType.equals(scopeType) && this.mustImport(scopeType)) {
            contents.append("import " + scopeType + ";\n");
        }
        contents.append("import org.eclipse.emf.facet.infra.query.core.exception.ModelQueryExecutionException;\n");
        contents.append("import org.eclipse.emf.facet.infra.query.core.java.IJavaModelQuery;\n");
        contents.append("import org.eclipse.emf.facet.infra.query.core.java.ParameterValueList;\n");
        contents.append("\n");
        String description = modelQuery.getDescription();
        if (description != null && description.trim().length() > 0) {
            contents.append("/** " + description + " */\n");
        }
        contents.append("public class " + name + " implements IJavaModelQuery<" + shortScopeType + ", " + shortReturnType + "> {\n");
        contents.append("\tpublic " + shortReturnType + " evaluate(final " + shortScopeType + " context, final ParameterValueList parameterValues)\n");
        contents.append("\t\t\tthrows ModelQueryExecutionException {\n");
        contents.append("\t\t// TODO Auto-generated method stub\n");
        contents.append("\t\treturn null;\n");
        contents.append("\t}\n");
        contents.append("}\n");
    }

    private boolean mustImport(String type) {
        return type.contains(".") && !type.startsWith("java.lang.");
    }
}

