/*******************************************************************************
 * Copyright (c) 2010 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Gregoire Dupe (Mia-Software)
 *     Nicolas Bros (Mia-Software)
 *******************************************************************************/
package org.eclipse.emf.facet.query.java.ui.internal.wizard;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.facet.efacet.FacetSet;
import org.eclipse.emf.facet.query.java.core.internal.exceptions.ClassAlreadyExistsException;
import org.eclipse.emf.facet.query.java.core.internal.exceptions.ResourceURIExpectedException;
import org.eclipse.emf.facet.query.java.ui.internal.Activator;
import org.eclipse.emf.facet.query.java.ui.internal.Messages;
import org.eclipse.emf.facet.query.java.ui.internal.wizard.page.NewQueryClassWizardPage;
import org.eclipse.emf.facet.query.java.ui.internal.wizard.page.SelectOrCreateJavaClassWizardPage;
import org.eclipse.emf.facet.util.core.Logger;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.window.Window;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;

public class SelectOrCreateJavaClassWizard extends Wizard {

	private final FacetSet facetSet;
	private final String facetName;

	private EClassifier eType = null;
	private int upperBound = 0;
	private EClassifier scope = null;

	private NewQueryClassWizardPage newQueryClassWizardPage;
	private boolean createFileOnFinish = true;
	private WizardDialog dialog;
	private SelectOrCreateJavaClassWizardPage selectOrCreatePage;
	private boolean userChoice = false;

	public SelectOrCreateJavaClassWizard(final FacetSet facetSet, final String facetName, final boolean createFileOnFinish)
			throws ClassAlreadyExistsException, ResourceURIExpectedException, JavaModelException {
		this.facetSet = facetSet;
		this.facetName = facetName;
		this.createFileOnFinish = createFileOnFinish;
		setWindowTitle(Messages.Choose_an_operation);
		this.dialog = new WizardDialog(getShell(), this);

		// check that the resource is from a platform URI
		Resource resource = facetSet.eResource();
		URI uri = resource.getURI();
		if (!uri.isPlatformResource()) {
			throw new ResourceURIExpectedException();
		}
		// check that the class doesn't already exist
		String projectName = uri.segment(1);
		IWorkspace ws = ResourcesPlugin.getWorkspace();
		IProject project = ws.getRoot().getProject(projectName);
		IJavaProject javaProject = JavaCore.create(project);
		String implementationClassName = this.facetName + "Query"; //$NON-NLS-1$
		if (javaProject.findType(implementationClassName) != null) {
			throw new ClassAlreadyExistsException();
		}
	}

	@Override
	public void addPages() {
		this.selectOrCreatePage = new SelectOrCreateJavaClassWizardPage();
		addPage(this.selectOrCreatePage);
		this.newQueryClassWizardPage = new NewQueryClassWizardPage();
		addPage(this.newQueryClassWizardPage);
		this.newQueryClassWizardPage.init(this.facetSet, this.facetName, this.eType);
	}

	public void createJavaClass() {
		this.newQueryClassWizardPage.apply(this.eType, this.upperBound, this.scope);
	}

	@Override
	public boolean canFinish() {
		if (getContainer().getCurrentPage() == this.selectOrCreatePage) {
			return this.selectOrCreatePage.canFinish();
		}
		return getContainer().getCurrentPage().isPageComplete();
	}

	public boolean isSelectExistingJavaClass() {
		return this.userChoice;
	}

	@Override
	public boolean performFinish() {
		try {
			if (this.createFileOnFinish && getContainer().getCurrentPage() == this.newQueryClassWizardPage) {
				createJavaClass();
			} else {
				this.userChoice = !(getContainer().getCurrentPage() == this.newQueryClassWizardPage);
			}
		} catch (Exception e) {
			Logger.logError(e, Activator.getDefault());
			return false;
		}
		return true;
	}

	public void setEType(final EClassifier eType) {
		this.eType = eType;
	}

	public void setUpperBound(final int upperBound) {
		this.upperBound = upperBound;
	}

	public void setScope(final EClassifier scope) {
		this.scope = scope;
	}

	public int open() {
		if (this.dialog != null) {
			return this.dialog.open();
		}
		return Window.CANCEL;
	}

	public String getImplementationClassName() {
		return this.newQueryClassWizardPage.getPackageFragment().getElementName() + "." + this.newQueryClassWizardPage.getTypeName(); //$NON-NLS-1$
	}
}
